/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.ResourceFactory;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.vocabulary.DC;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import org.mindswap.pellet.EconnectedKB;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.FileUtils;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.URIUtils;

public class OWLParser {
    public static final List SKIP_PROPS = Arrays.asList(RDF.type, RDF.first, RDF.rest, OWL.imports, OWL.hasValue, OWL.allValuesFrom, OWL.someValuesFrom, OWL.minCardinality, OWL.maxCardinality, OWL.cardinality);
    public static final List SKIP_TYPES = Arrays.asList(RDF.List, OWL.Restriction, OWL.AllDifferent, OWL.Ontology);
    public static final Resource OWL_LinkProperty = ResourceFactory.createResource((String)(OWL.NAMESPACE + "LinkProperty"));
    public static final Property OWL_ForeignOntology = ResourceFactory.createProperty((String)(OWL.NAMESPACE + "foreignOntology"));
    public static final Resource OWL_ForeignIndividual = ResourceFactory.createResource((String)(OWL.NAMESPACE + "ForeignIndividual"));
    public static final Resource OWL_ForeignClass = ResourceFactory.createResource((String)(OWL.NAMESPACE + "ForeignClass"));
    public static final Resource OWL_ForeignObjectProperty = ResourceFactory.createResource((String)(OWL.NAMESPACE + "ForeignObjectProperty"));
    public static final Resource OWL_ForeignLinkProperty = ResourceFactory.createResource((String)(OWL.NAMESPACE + "ForeignLinkProperty"));
    public static final Resource OWL_ForeignDatatypeProperty = ResourceFactory.createResource((String)(OWL.NAMESPACE + "ForeignDatatypeProperty"));
    private Map lists = new HashMap();
    private Map restrictions = new HashMap();
    private KnowledgeBase kb = null;
    static final String[] TYPES = new String[]{"Class", "Individual", "Object Property", "Datatype Property", "Datatype"};
    static final int CLASS = 0;
    static final int INDIVIDUAL = 1;
    static final int OBJ_PROP = 2;
    static final int DT_PROP = 4;
    static final int ANT_PROP = 8;
    static final int ONT_PROP = 15;
    static final int DATATYPE = 16;
    static final int LINK_PROP = 18;
    private Map resourceTypes = new HashMap();
    private Map resourceLinkTypes;
    private Set typedResources = new HashSet();
    public static QNameProvider qnames = new QNameProvider();
    private List linkedOntologies;

    public OWLParser() {
        this.resourceLinkTypes = new HashMap();
    }

    private ATermList createList(Resource r) {
        if (r.equals(RDF.nil)) {
            return ATermUtils.EMPTY_LIST;
        }
        if (this.lists.containsKey(r)) {
            return (ATermList)this.lists.get(r);
        }
        if (!r.hasProperty(RDF.first)) {
            System.err.println("Invalid list structure: List " + r + " does not have a rdf:first property. Ignoring rest of the list.");
            return ATermUtils.EMPTY_LIST;
        }
        ATermAppl first = this.node2term(r.getProperty(RDF.first).getObject());
        Resource rest = (Resource)r.getProperty(RDF.rest).getObject();
        ATermList list = ATermUtils.makeList(first, this.createList(rest));
        this.lists.put(r, list);
        return list;
    }

    private boolean defineClass(ATermAppl c) {
        Integer type = (Integer)this.resourceTypes.get(c);
        type = type == null ? new Integer(0) : new Integer(type | 0);
        this.resourceTypes.put(c, type);
        if (this.kb.isClass(c)) {
            return true;
        }
        if (ATermUtils.isPrimitive(c)) {
            this.kb.addClass(c);
            return true;
        }
        return false;
    }

    private boolean defineForeignClass(ATermAppl c) {
        Integer type = (Integer)this.resourceLinkTypes.get(c);
        type = type == null ? new Integer(0) : new Integer(type | 0);
        this.resourceLinkTypes.put(c, type);
        if (this.kb.isClass(c)) {
            return true;
        }
        return ATermUtils.isPrimitive(c);
    }

    private boolean defineForeignObjectProperty(ATermAppl c) {
        Integer type = (Integer)this.resourceLinkTypes.get(c);
        type = type == null ? new Integer(2) : new Integer(type | 2);
        this.resourceLinkTypes.put(c, type);
        if (((EconnectedKB)this.kb).isObjectProperty(c)) {
            return true;
        }
        return ATermUtils.isPrimitive(c);
    }

    private boolean defineForeignLinkProperty(ATermAppl c) {
        Integer type = (Integer)this.resourceLinkTypes.get(c);
        type = type == null ? new Integer(2) : new Integer((int)(type | 0x12));
        this.resourceLinkTypes.put(c, type);
        if (((EconnectedKB)this.kb).isProperty(c)) {
            return true;
        }
        return ATermUtils.isPrimitive(c);
    }

    private boolean defineForeignDatatypeProperty(ATermAppl c) {
        Integer type = (Integer)this.resourceLinkTypes.get(c);
        type = type == null ? new Integer(4) : new Integer(type | 4);
        this.resourceLinkTypes.put(c, type);
        if (((EconnectedKB)this.kb).isDatatypeProperty(c)) {
            return true;
        }
        return ATermUtils.isPrimitive(c);
    }

    private boolean defineDatatype(ATermAppl datatypeURI) {
        Integer type = (Integer)this.resourceTypes.get(datatypeURI);
        type = type == null ? new Integer(16) : new Integer((int)(type | 0x10));
        this.resourceTypes.put(datatypeURI, type);
        if (this.kb.getDatatypeReasoner().isDefined(datatypeURI.getName())) {
            return true;
        }
        this.kb.getDatatypeReasoner().defineDatatype(datatypeURI.getName());
        return true;
    }

    private void defineProperties(ATermAppl p1, ATermAppl p2) {
        int type2;
        int type1 = this.kb.getPropertyType(p1);
        if (type1 != (type2 = this.kb.getPropertyType(p2))) {
            if (type1 == 0) {
                if (type2 == 1) {
                    this.defineObjectProperty(p1);
                } else if (type2 == 2) {
                    this.defineDatatypeProperty(p1);
                }
            } else if (type2 == 0) {
                if (type1 == 1) {
                    this.defineObjectProperty(p2);
                } else if (type1 == 2) {
                    this.defineDatatypeProperty(p2);
                }
            } else {
                System.err.println("Properties " + p1 + ", " + p2 + " are related but first is " + Role.TYPES[type1] + "Property and second is " + Role.TYPES[type2]);
            }
        } else if (type1 == 0) {
            this.defineProperty(p1);
            this.defineProperty(p2);
        }
    }

    private boolean defineObjectProperty(ATermAppl c) {
        Integer type = (Integer)this.resourceTypes.get(c);
        type = type == null ? new Integer(2) : new Integer(type | 2);
        this.resourceTypes.put(c, type);
        if (this.kb.isObjectProperty(c)) {
            return true;
        }
        if (ATermUtils.isPrimitive(c)) {
            this.kb.addObjectProperty(c);
            return true;
        }
        return false;
    }

    private boolean defineDatatypeProperty(ATermAppl c) {
        Integer type = (Integer)this.resourceTypes.get(c);
        type = type == null ? new Integer(4) : new Integer(type | 4);
        this.resourceTypes.put(c, type);
        if (this.kb.isDatatypeProperty(c)) {
            return true;
        }
        if (ATermUtils.isPrimitive(c)) {
            this.kb.addDatatypeProperty(c);
            return true;
        }
        return false;
    }

    private boolean defineAnnotationProperty(ATermAppl c) {
        Integer type = (Integer)this.resourceTypes.get(c);
        type = type == null ? new Integer(8) : new Integer(type | 8);
        this.resourceTypes.put(c, type);
        if (this.kb.isAnnotationProperty(c)) {
            return true;
        }
        if (ATermUtils.isPrimitive(c)) {
            this.kb.addAnnotationProperty(c);
            return true;
        }
        return false;
    }

    private boolean defineOntologyProperty(ATermAppl c) {
        Integer type = (Integer)this.resourceTypes.get(c);
        type = type == null ? new Integer(15) : new Integer((int)(type | 0xF));
        this.resourceTypes.put(c, type);
        if (this.kb.isOntologyProperty(c)) {
            return true;
        }
        if (ATermUtils.isPrimitive(c)) {
            this.kb.addOntologyProperty(c);
            return true;
        }
        return false;
    }

    private boolean defineProperty(ATermAppl c) {
        if (this.kb.isProperty(c)) {
            return true;
        }
        if (ATermUtils.isPrimitive(c)) {
            this.kb.addProperty(c);
            return true;
        }
        return false;
    }

    private boolean defineIndividual(ATermAppl c) {
        Integer type = (Integer)this.resourceTypes.get(c);
        type = type == null ? new Integer(1) : new Integer(type | 1);
        this.resourceTypes.put(c, type);
        if (this.kb.isIndividual(c)) {
            return true;
        }
        if (ATermUtils.isPrimitive(c)) {
            this.kb.addIndividual(c);
            return true;
        }
        return false;
    }

    private void processTypes(Model model) throws UnsupportedFeatureException {
        StmtIterator i = model.listStatements(null, RDF.type, (RDFNode)((Resource)null));
        while (i.hasNext()) {
            Statement stmt = i.nextStatement();
            Resource s = stmt.getSubject();
            Resource o = stmt.getResource();
            ATermAppl st = this.node2term((RDFNode)s);
            ATermAppl ot = this.node2term((RDFNode)o);
            String nameSpace = o.getNameSpace();
            String localName = o.getLocalName();
            if (nameSpace == null) {
                nameSpace = "";
            }
            if (SKIP_TYPES.contains(o)) continue;
            if (o.equals(RDF.Property)) {
                this.defineProperty(st);
                continue;
            }
            if (nameSpace.equals("http://www.w3.org/2000/01/rdf-schema#")) {
                if (localName.equals("Class")) {
                    this.defineClass(st);
                    this.typedResources.add(st);
                    continue;
                }
                if (!localName.equals("Datatype")) continue;
                this.defineDatatype(st);
                this.typedResources.add(st);
                continue;
            }
            if (nameSpace.equals("http://www.w3.org/2002/07/owl#")) {
                if (localName.equals("Class")) {
                    this.defineClass(st);
                    this.typedResources.add(st);
                    continue;
                }
                if (localName.equals("Thing")) {
                    this.defineIndividual(st);
                    this.typedResources.add(st);
                    continue;
                }
                if (localName.equals("ObjectProperty")) {
                    this.defineObjectProperty(st);
                    this.typedResources.add(st);
                    continue;
                }
                if (localName.equals("DatatypeProperty")) {
                    this.defineDatatypeProperty(st);
                    this.typedResources.add(st);
                    continue;
                }
                if (localName.equals("FunctionalProperty")) {
                    this.defineProperty(st);
                    this.kb.addFunctionalProperty(st);
                    continue;
                }
                if (localName.equals("InverseFunctionalProperty")) {
                    this.defineObjectProperty(st);
                    this.kb.addInverseFunctionalProperty(st);
                    continue;
                }
                if (localName.equals("TransitiveProperty")) {
                    this.defineObjectProperty(st);
                    this.kb.addTransitiveProperty(st);
                    if (!(this.kb instanceof EconnectedKB)) continue;
                    ((EconnectedKB)this.kb).getEconnExpressivity().setHasTransitivity(this.kb.getOntology());
                    continue;
                }
                if (localName.equals("SymmetricProperty")) {
                    this.defineObjectProperty(st);
                    this.kb.addSymmetricProperty(st);
                    continue;
                }
                if (localName.equals("AnnotationProperty")) {
                    this.kb.addAnnotationProperty(st);
                    continue;
                }
                if (localName.equals("DataRange")) {
                    Resource dataValuesR = s.getProperty(OWL.oneOf).getResource();
                    ATermList list = this.createList(dataValuesR);
                    if (s.isAnon()) {
                        this.kb.addDataRange("bNode" + s.toString(), list);
                        continue;
                    }
                    this.kb.addDataRange(s.toString(), list);
                    continue;
                }
                if (o.equals(OWL_LinkProperty)) {
                    if (!(this.kb instanceof EconnectedKB)) continue;
                    ((EconnectedKB)this.kb).addLinkProperty(st);
                    if (!KnowledgeBase.DEBUG) continue;
                    System.out.println("Added Link" + st + "To ontology" + this.kb.getOntology());
                    continue;
                }
                if (o.equals(OWL_ForeignIndividual)) {
                    if (!(this.kb instanceof EconnectedKB)) continue;
                    ((EconnectedKB)this.kb).addIndividual(st);
                    continue;
                }
                if (o.equals(OWL_ForeignClass)) {
                    this.defineForeignClass(st);
                    continue;
                }
                if (o.equals(OWL_ForeignObjectProperty)) {
                    this.defineForeignObjectProperty(st);
                    continue;
                }
                if (o.equals(OWL_ForeignDatatypeProperty)) {
                    this.defineForeignDatatypeProperty(st);
                    continue;
                }
                if (!o.equals(OWL_ForeignLinkProperty)) continue;
                this.defineForeignLinkProperty(st);
                continue;
            }
            this.defineIndividual(st);
            this.defineClass(ot);
            this.kb.addType(st, ot);
        }
    }

    private ATermAppl createRestriction(Resource s) throws UnsupportedFeatureException {
        ATermAppl aTerm = ATermUtils.BOTTOM;
        StmtIterator si = s.listProperties(OWL.onProperty);
        if (!si.hasNext()) {
            return aTerm;
        }
        Resource p = si.nextStatement().getResource();
        ATermAppl pt = this.node2term((RDFNode)p);
        if (si.hasNext()) {
            return aTerm;
        }
        if (s.hasProperty(OWL.hasValue)) {
            RDFNode o = s.getProperty(OWL.hasValue).getObject();
            ATermAppl ot = this.node2term(o);
            this.defineIndividual(ot);
            if (this.kb instanceof EconnectedKB) {
                ((EconnectedKB)this.kb).getEconnExpressivity().allNominals.add(ot);
            }
            ATermAppl nominal = ATermUtils.makeValue(ot);
            aTerm = ATermUtils.makeSomeValues(pt, nominal);
        } else if (s.hasProperty(OWL.allValuesFrom)) {
            Resource o = (Resource)s.getProperty(OWL.allValuesFrom).getObject();
            ATermAppl ot = this.node2term((RDFNode)o);
            aTerm = ATermUtils.makeAllValues(pt, ot);
        } else if (s.hasProperty(OWL.someValuesFrom)) {
            Resource o = (Resource)s.getProperty(OWL.someValuesFrom).getObject();
            ATermAppl ot = this.node2term((RDFNode)o);
            aTerm = ATermUtils.makeSomeValues(pt, ot);
        } else if (s.hasProperty(OWL.minCardinality)) {
            int cardinality = 0;
            try {
                cardinality = s.getProperty(OWL.minCardinality).getInt();
            }
            catch (Exception ex) {
                cardinality = Integer.parseInt(s.getProperty(OWL.minCardinality).getLiteral().getLexicalForm());
            }
            if (this.kb instanceof EconnectedKB) {
                ((EconnectedKB)this.kb).getNumberRestrictions().add(pt);
            }
            aTerm = ATermUtils.makeMin(pt, cardinality);
        } else if (s.hasProperty(OWL.maxCardinality)) {
            int cardinality = 0;
            try {
                cardinality = s.getProperty(OWL.maxCardinality).getInt();
            }
            catch (Exception ex) {
                cardinality = Integer.parseInt(s.getProperty(OWL.maxCardinality).getLiteral().getLexicalForm());
            }
            if (this.kb instanceof EconnectedKB) {
                ((EconnectedKB)this.kb).getNumberRestrictions().add(pt);
            }
            aTerm = ATermUtils.makeMax(pt, cardinality);
        } else if (s.hasProperty(OWL.cardinality)) {
            int cardinality = 0;
            try {
                cardinality = s.getProperty(OWL.cardinality).getInt();
            }
            catch (Exception ex) {
                cardinality = Integer.parseInt(s.getProperty(OWL.cardinality).getLiteral().getLexicalForm());
            }
            if (this.kb instanceof EconnectedKB) {
                ((EconnectedKB)this.kb).getNumberRestrictions().add(pt);
            }
            aTerm = ATermUtils.makeCard(pt, cardinality);
        }
        return aTerm;
    }

    public ATermAppl node2term(RDFNode node) {
        ATermAppl aTerm = null;
        if (node.equals(OWL.Thing)) {
            return ATermUtils.TOP;
        }
        if (node.equals(OWL.Nothing)) {
            return ATermUtils.BOTTOM;
        }
        if (node instanceof Literal) {
            Literal l = (Literal)node;
            String datatypeURI = l.getDatatypeURI();
            aTerm = datatypeURI != null ? ATermUtils.makeTypedLiteral(l.getString(), datatypeURI) : ATermUtils.makePlainLiteral(l.getString(), l.getLanguage());
        } else if (this.restrictions.containsKey(node)) {
            aTerm = (ATermAppl)this.restrictions.get(node);
        } else if (node instanceof Resource) {
            Resource r = (Resource)node;
            if (r.getModel() != null && r.hasProperty(OWL.onProperty)) {
                aTerm = this.createRestriction(r);
                this.restrictions.put(node, aTerm);
            } else if (r.isAnon()) {
                String bNode = "bNode" + r.toString();
                if (this.kb.getDatatypeReasoner().isDefined(bNode)) {
                    return ATermUtils.makeTermAppl(bNode);
                }
                if (r.hasProperty(OWL.intersectionOf)) {
                    ATermList list = this.createList(r.getProperty(OWL.intersectionOf).getResource());
                    aTerm = ATermUtils.makeAnd(list);
                } else if (r.hasProperty(OWL.unionOf)) {
                    ATermList list = this.createList(r.getProperty(OWL.unionOf).getResource());
                    aTerm = ATermUtils.makeOr(list);
                } else if (r.hasProperty(OWL.oneOf)) {
                    ATermList list = this.createList(r.getProperty(OWL.oneOf).getResource());
                    ATermList result = ATermUtils.EMPTY_LIST;
                    ATermList l = list;
                    while (!l.isEmpty()) {
                        ATermAppl c = (ATermAppl)l.getFirst();
                        ATermAppl nominal = ATermUtils.makeValue(c);
                        result = result.insert(nominal);
                        l = l.getNext();
                    }
                    aTerm = ATermUtils.makeOr(result);
                } else if (r.hasProperty(OWL.complementOf)) {
                    ATermAppl complement = this.node2term((RDFNode)r.getProperty(OWL.complementOf).getResource());
                    aTerm = ATermUtils.makeNot(complement);
                } else {
                    aTerm = ATermUtils.makeTermAppl(bNode);
                }
            } else {
                aTerm = PelletOptions.USE_LOCAL_NAME ? ATermUtils.makeTermAppl(URIUtils.getLocalName(r.getURI())) : (PelletOptions.USE_QNAME ? ATermUtils.makeTermAppl(qnames.shortForm(r.getURI())) : ATermUtils.makeTermAppl(r.getURI()));
            }
        }
        return aTerm;
    }

    private void processLinkTriples(Model model) throws UnsupportedFeatureException {
        StmtIterator i = model.listStatements();
        while (i.hasNext()) {
            Statement stmt = (Statement)i.next();
            Resource s = stmt.getSubject();
            Property p = stmt.getPredicate();
            RDFNode o = stmt.getObject();
            ATermAppl st = this.node2term((RDFNode)s);
            if (p.equals(RDF.type) || !p.equals(OWL_ForeignOntology)) continue;
            String foreignOnt = ((Resource)o).getURI();
            String ont = ((EconnectedKB)this.kb).getOntology();
            if (!(this.kb instanceof EconnectedKB)) continue;
            Role r = this.kb.getProperty(st);
            if (r != null) {
                r.setForeignOntology(foreignOnt);
                if (this.linkedOntologies.contains(foreignOnt)) continue;
                this.linkedOntologies.add(foreignOnt);
                continue;
            }
            if (this.resourceLinkTypes.containsKey(st)) {
                if (!((EconnectedKB)this.kb).getTBoxes().keySet().contains(foreignOnt)) {
                    ((EconnectedKB)this.kb).addOntology(foreignOnt);
                }
                ((EconnectedKB)this.kb).setOntology(foreignOnt);
                if (!((EconnectedKB)this.kb).isClass(st) && ATermUtils.isPrimitive(st) && (Integer)this.resourceLinkTypes.get(st) == 0) {
                    this.kb.addClass(st);
                    if (KnowledgeBase.DEBUG) {
                        System.out.println("Added Foreign Class" + st + "To ontology" + this.kb.getOntology());
                    }
                }
                if (!((EconnectedKB)this.kb).isProperty(st) && ATermUtils.isPrimitive(st)) {
                    if ((Integer)this.resourceLinkTypes.get(st) == 2) {
                        this.kb.addObjectProperty(st);
                        if (KnowledgeBase.DEBUG) {
                            System.out.println("Added Foreign Object Property" + st + "To ontology" + this.kb.getOntology());
                        }
                    }
                    if ((Integer)this.resourceLinkTypes.get(st) == 4) {
                        this.kb.addDatatypeProperty(st);
                        if (KnowledgeBase.DEBUG) {
                            System.out.println("Added Foreign Datatype Property" + st + "To ontology" + this.kb.getOntology());
                        }
                    }
                    if ((Integer)this.resourceLinkTypes.get(st) == 18) {
                        ((EconnectedKB)this.kb).addLinkProperty(st);
                        if (KnowledgeBase.DEBUG) {
                            System.out.println("Added Foreign Link Property" + st + "To ontology" + this.kb.getOntology());
                        }
                    }
                }
                ((EconnectedKB)this.kb).setOntology(ont);
                continue;
            }
            Individual aux = this.kb.getABox().getIndividual(st);
            aux.setOntology(foreignOnt);
            ((EconnectedKB)this.kb).getEconnExpressivity().setHasNominal(foreignOnt);
        }
    }

    private void processTriples(Model model) throws UnsupportedFeatureException {
        StmtIterator i = model.listStatements();
        while (i.hasNext()) {
            Statement stmt = (Statement)i.next();
            Resource s = stmt.getSubject();
            Property p = stmt.getPredicate();
            RDFNode o = stmt.getObject();
            String nameSpace = p.getNameSpace();
            String localName = p.getLocalName();
            if (nameSpace == null) {
                nameSpace = "";
            }
            ATermAppl st = this.node2term((RDFNode)s);
            ATermAppl pt = this.node2term((RDFNode)p);
            ATermAppl ot = this.node2term(o);
            if (SKIP_PROPS.contains(p)) continue;
            if (nameSpace.equals("http://www.w3.org/2000/01/rdf-schema#")) {
                if (localName.equals("subClassOf")) {
                    this.defineClass(st);
                    this.defineClass(ot);
                    this.kb.addSubClass(st, ot);
                    continue;
                }
                if (localName.equals("subPropertyOf")) {
                    this.defineProperties(st, ot);
                    this.kb.addSubProperty(st, ot);
                    continue;
                }
                if (localName.equals("domain")) {
                    this.defineProperty(st);
                    this.defineClass(ot);
                    this.kb.addDomain(st, ot);
                    continue;
                }
                if (!localName.equals("range")) continue;
                if (this.kb.isDatatype(ot)) {
                    this.defineDatatypeProperty(st);
                } else if (this.kb.isClass(ot)) {
                    this.defineObjectProperty(st);
                } else {
                    this.defineProperty(st);
                }
                if (this.kb.isDatatypeProperty(st)) {
                    this.defineDatatype(ot);
                } else if (this.kb.isObjectProperty(st)) {
                    this.defineClass(ot);
                }
                this.kb.addRange(st, ot);
                continue;
            }
            if (nameSpace.equals("http://www.w3.org/2002/07/owl#")) {
                Object result;
                ATermList list;
                if (localName.equals("onProperty")) {
                    this.defineProperty(pt);
                    continue;
                }
                if (localName.equals("intersectionOf")) {
                    list = this.createList((Resource)o);
                    this.defineClass(st);
                    ATermList l = list;
                    while (!l.isEmpty()) {
                        ATermAppl c = (ATermAppl)l.getFirst();
                        if (!this.resourceLinkTypes.containsKey(c)) {
                            this.defineClass(c);
                        }
                        l = l.getNext();
                    }
                    ATermAppl conjunction = ATermUtils.makeAnd(list);
                    this.kb.addSameClass(st, conjunction);
                    continue;
                }
                if (localName.equals("unionOf")) {
                    list = this.createList((Resource)o);
                    this.defineClass(st);
                    ATermList l = list;
                    while (!l.isEmpty()) {
                        ATermAppl c = (ATermAppl)l.getFirst();
                        if (!this.resourceLinkTypes.containsKey(c)) {
                            this.defineClass(c);
                        }
                        l = l.getNext();
                    }
                    ATermAppl disjunction = ATermUtils.makeOr(list);
                    this.kb.addSameClass(st, disjunction);
                    if (!(this.kb instanceof EconnectedKB)) continue;
                    ((EconnectedKB)this.kb).getEconnExpressivity().setHasUnion(this.kb.getOntology());
                    continue;
                }
                if (localName.equals("complementOf")) {
                    if (!this.resourceLinkTypes.containsKey(st)) {
                        this.defineClass(st);
                    }
                    if (!this.resourceLinkTypes.containsKey(st)) {
                        this.defineClass(ot);
                    }
                    if (this.kb instanceof EconnectedKB) {
                        ((EconnectedKB)this.kb).getEconnExpressivity().setHasNegation(this.kb.getOntology());
                    }
                    ATermAppl complement = ATermUtils.makeNot(ot);
                    this.kb.addSameClass(st, complement);
                    continue;
                }
                if (localName.equals("equivalentClass")) {
                    this.defineClass(st);
                    this.defineClass(ot);
                    this.kb.addSameClass(st, ot);
                    continue;
                }
                if (localName.equals("disjointWith")) {
                    this.defineClass(st);
                    this.defineClass(ot);
                    this.kb.addDisjointClass(st, ot);
                    if (!(this.kb instanceof EconnectedKB)) continue;
                    ((EconnectedKB)this.kb).getEconnExpressivity().setHasNegation(this.kb.getOntology());
                    continue;
                }
                if (localName.equals("equivalentProperty")) {
                    this.defineProperties(st, ot);
                    this.kb.addSameProperty(st, ot);
                    continue;
                }
                if (localName.equals("inverseOf")) {
                    if (this.kb instanceof EconnectedKB) {
                        Role r;
                        EconnectedKB econnKB = (EconnectedKB)this.kb;
                        if (!econnKB.isLinkProperty(st)) continue;
                        Role ro = this.kb.getProperty(st);
                        String ont = econnKB.getOntology();
                        String foreign = ro.getForeignOntology();
                        if (!econnKB.getTBoxes().keySet().contains(foreign)) {
                            econnKB.addOntology(foreign);
                        }
                        econnKB.setOntology(foreign);
                        if (!econnKB.getRBox().isRole(ot)) {
                            econnKB.addLinkProperty(ot);
                            if (KnowledgeBase.DEBUG) {
                                System.out.println("Added Link Property " + ot + " to ontology" + foreign);
                            }
                        }
                        if ((r = this.kb.getProperty(ot)) != null) {
                            r.setForeignOntology(ont);
                        }
                        econnKB.setOntology(ont);
                        econnKB.addInverseLink(ro, r);
                        continue;
                    }
                    this.defineObjectProperty(st);
                    this.defineObjectProperty(ot);
                    this.kb.addInverseProperty(st, ot);
                    continue;
                }
                if (localName.equals("sameAs")) {
                    this.defineIndividual(st);
                    this.defineIndividual(ot);
                    this.kb.addSame(st, ot);
                    continue;
                }
                if (localName.equals("differentFrom")) {
                    this.defineIndividual(st);
                    this.defineIndividual(ot);
                    this.kb.addDifferent(st, ot);
                    continue;
                }
                if (localName.equals("distinctMembers")) {
                    ATermList list2;
                    result = new ArrayList();
                    ATermList l = list2 = this.createList((Resource)o);
                    while (!l.isEmpty()) {
                        ATermAppl c = (ATermAppl)l.getFirst();
                        this.defineIndividual(c);
                        result.add(c);
                        l = l.getNext();
                    }
                    for (int k = 0; k < result.size(); ++k) {
                        for (int j = k + 1; j < result.size(); ++j) {
                            this.kb.addDifferent((ATermAppl)result.get(k), (ATermAppl)result.get(j));
                        }
                    }
                    continue;
                }
                if (!localName.equals("oneOf")) continue;
                result = ATermUtils.EMPTY_LIST;
                if (this.kb.isDatatype(st)) continue;
                this.defineClass(st);
                ATermAppl disjunction = null;
                ATermList list3 = this.createList((Resource)o);
                if (o.equals(RDF.nil) || list3 == null) {
                    disjunction = ATermUtils.BOTTOM;
                } else {
                    ATermList l = list3;
                    while (!l.isEmpty()) {
                        ATermAppl c = (ATermAppl)l.getFirst();
                        this.defineIndividual(c);
                        if (this.kb instanceof EconnectedKB) {
                            ((EconnectedKB)this.kb).getEconnExpressivity().allNominals.add(ot);
                        }
                        result = result.insert(ATermUtils.makeValue(c));
                        l = l.getNext();
                    }
                    disjunction = ATermUtils.makeOr((ATermList)result);
                }
                this.kb.addSameClass(st, disjunction);
                continue;
            }
            Role role = this.kb.getProperty(pt);
            int type = role == null ? 0 : role.getType();
            if (type == 3) continue;
            if (o instanceof Literal) {
                Literal jenaLiteral = (Literal)o;
                String datatypeURI = jenaLiteral.getDatatypeURI();
                ATermAppl literalValue = JenaUtils.makeLiteral(jenaLiteral);
                this.defineIndividual(st);
                this.defineDatatypeProperty(pt);
                if (datatypeURI != null) {
                    this.defineDatatype(ATermUtils.makeTermAppl(datatypeURI));
                }
                this.kb.addDataPropertyValue(pt, st, literalValue);
                continue;
            }
            this.defineIndividual(st);
            this.defineObjectProperty(pt);
            this.defineIndividual(ot);
            this.kb.addObjectPropertyValue(pt, st, ot);
        }
    }

    private void processUntypedResources() {
        Iterator<Object> i = this.restrictions.keySet().iterator();
        while (i.hasNext()) {
            Resource res = (Resource)i.next();
            if (res.hasProperty(OWL.onProperty)) {
                Resource prop = res.getProperty(OWL.onProperty).getResource();
                this.defineProperty(this.node2term((RDFNode)prop));
            }
            if (!res.hasProperty(OWL.hasValue) || !(res.getProperty(OWL.hasValue).getObject() instanceof Resource)) continue;
            Resource val = res.getProperty(OWL.hasValue).getResource();
            this.defineIndividual(this.node2term((RDFNode)val));
        }
        i = new ArrayList(this.kb.getProperties()).iterator();
        while (i.hasNext()) {
            ATermAppl r = (ATermAppl)i.next();
            if (this.kb.getPropertyType(r) != 0) continue;
            this.defineObjectProperty(r);
        }
    }

    private void processMultitypedResources() {
        Iterator i = this.resourceTypes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ATermAppl term = (ATermAppl)entry.getKey();
            int type = (Integer)entry.getValue();
            HashSet<String> types = new HashSet<String>();
            for (int bit = 0; bit < 8; ++bit) {
                if ((type & 1 << bit) != 1) continue;
                types.add(TYPES[bit]);
            }
            if (types.size() <= 1) continue;
            System.err.println("URI " + term.getName() + " has been defined/used as " + types);
        }
    }

    public void parse(String ont, EconnectedKB kb) {
        this.parse(ont, kb, new ModelReader());
    }

    public void parse(String ont, EconnectedKB kb, ModelReader reader) {
        this.linkedOntologies = new ArrayList();
        this.linkedOntologies.add(ont);
        for (int i = 0; i < this.linkedOntologies.size(); ++i) {
            String currOnt = (String)this.linkedOntologies.get(i);
            currOnt = FileUtils.toURI(currOnt);
            Model model = reader.read(currOnt);
            if (!kb.getTBoxes().keySet().contains(currOnt)) {
                kb.addOntology(currOnt);
            }
            kb.setOntology(currOnt);
            this.parse(model, (KnowledgeBase)kb);
        }
    }

    public void parse(Model model, KnowledgeBase kb) throws UnsupportedFeatureException {
        this.kb = kb;
        this.lists = new HashMap();
        this.restrictions = new HashMap();
        this.resourceTypes = new HashMap();
        this.typedResources = new HashSet();
        this.resourceLinkTypes = new HashMap();
        this.defineAnnotationProperty(this.node2term((RDFNode)RDFS.label));
        this.defineAnnotationProperty(this.node2term((RDFNode)RDFS.comment));
        this.defineAnnotationProperty(this.node2term((RDFNode)RDFS.seeAlso));
        this.defineAnnotationProperty(this.node2term((RDFNode)RDFS.isDefinedBy));
        this.defineAnnotationProperty(this.node2term((RDFNode)OWL.versionInfo));
        this.defineAnnotationProperty(this.node2term((RDFNode)DC.title));
        this.defineAnnotationProperty(this.node2term((RDFNode)DC.description));
        this.defineOntologyProperty(this.node2term((RDFNode)OWL.backwardCompatibleWith));
        this.defineOntologyProperty(this.node2term((RDFNode)OWL.priorVersion));
        this.defineOntologyProperty(this.node2term((RDFNode)OWL.incompatibleWith));
        Iterator i = kb.getDatatypeReasoner().getDatatypeURIs().iterator();
        while (i.hasNext()) {
            String datatypeURI = i.next().toString();
            this.resourceTypes.put(ATermUtils.makeTermAppl(datatypeURI), new Integer(16));
        }
        this.processTypes(model);
        if (kb instanceof EconnectedKB) {
            this.processLinkTriples(model);
        }
        this.processTriples(model);
        this.processUntypedResources();
    }
}

