/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.mindswap.pellet.jena.OWLSpeciesMessage;
import org.mindswap.pellet.output.ATermAbstractSyntaxRenderer;
import org.mindswap.pellet.output.OutputFormatter;

public class OWLSpeciesReport {
    public static final int NUM_CODES = 4;
    private int level = 0;
    private Set[] messages = new Set[4];

    public OWLSpeciesReport() {
        for (int i = 0; i < 4; ++i) {
            this.messages[i] = new TreeSet();
        }
    }

    public void addMessage(int code, OWLSpeciesMessage msg) {
        if (code < 0 || code > 4) {
            throw new IllegalArgumentException();
        }
        if (code > this.level) {
            this.level = Math.min(code, 2);
        }
        this.messages[code].add(msg);
    }

    public void addMessage(int code, String header, String msg) {
        this.addMessage(code, new OWLSpeciesMessage(header, msg, new ATermAppl[0]));
    }

    public void addMessage(int code, String header, String msg, ATermAppl term) {
        this.addMessage(code, new OWLSpeciesMessage(header, msg, new ATermAppl[]{term}));
    }

    public void addMessage(int code, String header, String msg, ATermAppl term1, ATermAppl term2) {
        this.addMessage(code, new OWLSpeciesMessage(header, msg, new ATermAppl[]{term1, term2}));
    }

    public void addMessage(int code, String header, String msg, ATermAppl[] terms) {
        this.addMessage(code, new OWLSpeciesMessage(header, msg, terms));
    }

    public int getLevel() {
        return this.level;
    }

    public void print() {
        this.print(new OutputFormatter());
    }

    public void print(OutputFormatter out) {
        ATermAbstractSyntaxRenderer renderer = new ATermAbstractSyntaxRenderer();
        renderer.setWriter(out);
        String[] headers = new String[]{"", "Non OWL-Lite features used:", "Non OWL-DL features used:", "Warnings:"};
        for (int i = 3; i > 0; --i) {
            Set set = this.messages[i];
            if (set.size() <= 0) continue;
            out.printBold(headers[i]).println();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                OWLSpeciesMessage msg = (OWLSpeciesMessage)iter.next();
                msg.print(renderer);
                out.println();
            }
        }
        out.flush();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.print(new OutputFormatter(sw, false));
        return sw.toString();
    }
}

