/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.lre.graph.Graph;
import com.lre.graph.UndirectedGraph;
import com.lre.graph.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.ResourceFactory;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.OWLSpecies;
import org.mindswap.pellet.jena.OWLSpeciesReport;
import org.mindswap.pellet.utils.ATermUtils;

public class OWLSpeciesValidator {
    public static final String[] LEVELS = new String[]{"Lite", "DL", "Full"};
    public static final int LITE = 0;
    public static final int DL = 1;
    public static final int FULL = 2;
    public static final int WARNING = 3;
    static final List RESTRICTION_PROPS = Arrays.asList(OWL.onProperty, OWL.hasValue, OWL.allValuesFrom, OWL.someValuesFrom, OWL.minCardinality, OWL.maxCardinality, OWL.cardinality);
    static final List RDFS_PROPS = Arrays.asList("subClassOf", "subPropertyOf", "domain", "range", "label", "comment", "isDefinedBy", "seeAlso");
    private Map lists = new HashMap();
    private Map restrictions = new HashMap();
    private Set classes = new HashSet();
    private Set mDataranges = new HashSet();
    private Map ontologies = new HashMap();
    private KnowledgeBase kb = null;
    public Model model = null;
    public boolean canOutputDL = false;
    public Model missingTriples = ModelFactory.createDefaultModel();
    private OWLSpeciesReport report;
    private boolean mCheckStructureSharing = false;
    private Set mVisitedNodes = new HashSet();
    private Set mUsedBnodes = new HashSet();
    private Graph mDisjointWithGraph = new Graph();
    private Graph mEquivalentClassGraph = new Graph();

    public OWLSpecies validate(Model model) {
        this.model = model;
        this.mUsedBnodes = new HashSet();
        this.mDisjointWithGraph = new Graph();
        this.mCheckStructureSharing = false;
        this.mEquivalentClassGraph = new Graph();
        this.mVisitedNodes = new HashSet();
        this.canOutputDL = true;
        this.kb = new KnowledgeBase();
        this.kb.addAnnotationProperty(this.node2term((RDFNode)RDFS.label));
        this.kb.addAnnotationProperty(this.node2term((RDFNode)RDFS.comment));
        this.kb.addAnnotationProperty(this.node2term((RDFNode)RDFS.seeAlso));
        this.kb.addAnnotationProperty(this.node2term((RDFNode)RDFS.isDefinedBy));
        this.kb.addAnnotationProperty(this.node2term((RDFNode)OWL.versionInfo));
        this.kb.addOntologyProperty(this.node2term((RDFNode)OWL.backwardCompatibleWith));
        this.kb.addOntologyProperty(this.node2term((RDFNode)OWL.priorVersion));
        this.kb.addOntologyProperty(this.node2term((RDFNode)OWL.incompatibleWith));
        this.lists = new HashMap();
        this.restrictions = new HashMap();
        this.missingTriples = ModelFactory.createDefaultModel();
        this.report = new OWLSpeciesReport();
        this.processTypes();
        this.processTriples();
        this.processRestrictions();
        this.canOutputDL &= this.missingTriples.size() > 0L;
        return new OWLSpecies(this.report, this.canOutputDL ? this.missingTriples : null);
    }

    private ATermList createList(Resource r) {
        if (r.equals(RDF.nil)) {
            return ATermUtils.EMPTY_LIST;
        }
        if (!r.hasProperty(RDF.first)) {
            this.report.addMessage(3, "Invalid List", "The list " + r + " does not have a rdf:first property");
            return ATermUtils.EMPTY_LIST;
        }
        if (!r.hasProperty(RDF.rest)) {
            this.report.addMessage(3, "Invalid List", "The list " + r + " does not have a rdf:rest property");
            return ATermUtils.EMPTY_LIST;
        }
        RDFNode first = r.getProperty(RDF.first).getObject();
        Resource rest = r.getProperty(RDF.rest).getResource();
        if (first instanceof Resource && ((Resource)first).isAnon() && this.mCheckStructureSharing) {
            if (this.mUsedBnodes.contains(first.toString())) {
                this.report.addMessage(2, "Structure Sharing", "The bNode " + first.toString() + " is used in multiple structures");
                this.canOutputDL = false;
                return ATermUtils.EMPTY_LIST;
            }
            this.mUsedBnodes.add(first.toString());
        }
        return ATermUtils.makeList(this.node2term(first), this.createList(rest));
    }

    private boolean check(Resource orig, Resource curr) {
        if (curr == null || curr.isAnon()) {
            if (curr != null && orig.equals(curr)) {
                return false;
            }
            StmtIterator sIter = (curr != null ? curr : orig).listProperties();
            while (sIter.hasNext()) {
                Statement stmt = sIter.nextStatement();
                Property pred = stmt.getPredicate();
                RDFNode obj = stmt.getObject();
                if (pred.equals(OWL.intersectionOf) || pred.equals(OWL.unionOf)) {
                    if (this.checkList(orig, (Resource)obj)) continue;
                    this.report.addMessage(2, "Cycle in Class Description", "Definition for " + stmt.getSubject().toString() + " is cyclic");
                    return false;
                }
                if (!orig.equals(obj)) continue;
                if (pred.equals(OWL.equivalentClass)) {
                    this.report.addMessage(2, "Cycle in Class Description", "Definition for " + stmt.getSubject().toString() + " is cyclic");
                } else {
                    this.report.addMessage(2, "Cycle in Class Description", "Definition for " + stmt.getSubject().toString() + " is cyclic");
                }
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean checkList(Resource orig, Resource theList) {
        ArrayList<Resource> v = new ArrayList<Resource>();
        Resource theFirst = theList.getProperty(RDF.first).getResource();
        Resource theRest = theList.getProperty(RDF.rest).getResource();
        v.add(theFirst);
        while (!theRest.equals(RDF.nil)) {
            theFirst = theRest.getProperty(RDF.first).getResource();
            theRest = theRest.getProperty(RDF.rest).getResource();
            v.add(theFirst);
        }
        for (int i = 0; i < v.size(); ++i) {
            Resource elem = (Resource)v.get(i);
            if (!elem.isAnon()) continue;
            if (orig.equals(elem)) {
                return false;
            }
            if (elem.hasProperty(OWL.intersectionOf)) {
                if (elem.getProperty(OWL.intersectionOf).getResource().equals(theList)) {
                    return false;
                }
                return this.checkList(orig, elem.getProperty(OWL.intersectionOf).getResource());
            }
            if (!elem.hasProperty(OWL.unionOf)) continue;
            if (elem.getProperty(OWL.unionOf).getResource().equals(theList)) {
                return false;
            }
            return this.checkList(orig, elem.getProperty(OWL.unionOf).getResource());
        }
        return true;
    }

    private void processTypes() throws UnsupportedFeatureException {
        Resource s;
        StmtIterator i = this.model.listStatements(null, RDF.first, (RDFNode)((Resource)null));
        block0: while (i.hasNext()) {
            Statement stmt = i.nextStatement();
            StmtIterator si = this.model.listStatements(null, null, (RDFNode)stmt.getSubject());
            while (si.hasNext()) {
                Statement aStmt = si.nextStatement();
                if (aStmt.getPredicate().equals(RDF.first) || aStmt.getPredicate().equals(RDF.rest)) continue;
                s = stmt.getSubject();
                if (aStmt.getPredicate().equals(OWL.intersectionOf) || aStmt.getPredicate().equals(OWL.unionOf)) {
                    this.mCheckStructureSharing = true;
                }
                this.lists.put(s, this.createList(s));
                this.mCheckStructureSharing = false;
                continue block0;
            }
        }
        i = this.model.listStatements(null, RDF.type, (RDFNode)((Resource)null));
        ArrayList<Statement> processLater = new ArrayList<Statement>();
        while (i.hasNext()) {
            String problem;
            String previousDefinition;
            Statement stmt = i.nextStatement();
            Resource s2 = stmt.getSubject();
            Resource o = stmt.getResource();
            ATermAppl st = this.node2term((RDFNode)s2);
            ATermAppl ot = this.node2term((RDFNode)o);
            if (s2.isAnon() && !this.check(s2, null)) {
                this.canOutputDL = false;
            }
            if (o.equals(OWL.Class)) {
                if (!this.isClass(st)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " property";
                    problem = " is defined both as a class and a" + previousDefinition;
                    this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, st);
                }
                this.addClass(st);
                continue;
            }
            if (o.equals(RDFS.Class)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals(RDFS.Datatype)) {
                if (!this.kb.getDatatypeReasoner().isDefined(s2.toString())) {
                    this.kb.getDatatypeReasoner().defineDatatype(s2.toString());
                }
                this.printDebug("datatype(" + s2 + ")");
                continue;
            }
            if (o.equals(OWL.Thing)) {
                if (!this.isIndividual(st)) {
                    previousDefinition = this.isClass(st) ? "class" : "property";
                    problem = " is defined both as an individual and a " + previousDefinition;
                    this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, st);
                }
                if (!this.kb.getABox().isNode(st)) {
                    this.kb.getABox().addIndividual(st);
                }
                this.kb.getABox().addType(st, ATermUtils.TOP);
                continue;
            }
            if (o.equals(RDF.List)) continue;
            if (o.equals(OWL.Restriction)) {
                this.restrictions.put(s2, st);
                continue;
            }
            if (o.equals(OWL.AllDifferent)) continue;
            if (o.equals(OWL.ObjectProperty)) {
                if (!this.isProperty(st)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    problem = " is defined both as an onbject property and a" + previousDefinition;
                    this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, st);
                    continue;
                }
                this.kb.getABox().getRBox().addObjectRole(st);
                this.printDebug("object-property(" + st + ")");
                continue;
            }
            if (o.equals(OWL.DatatypeProperty)) {
                if (!this.isProperty(st)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    problem = " is defined both as a datatype property and a" + previousDefinition;
                    this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, st);
                }
                this.kb.getABox().getRBox().addDatatypeRole(st);
                this.printDebug("datatype-property(" + st + ")");
                continue;
            }
            if (o.equals(OWL.AnnotationProperty)) {
                if (!this.isProperty(st)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    problem = " is defined both as aa annotation property and a" + previousDefinition;
                    this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, st);
                }
                this.kb.getABox().getRBox().addAnnotationRole(st);
                this.printDebug("annotation-property(" + st + ")");
                continue;
            }
            if (o.equals(RDF.Property)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals(OWL.TransitiveProperty)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals(OWL.SymmetricProperty)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals(OWL.FunctionalProperty)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals(OWL.InverseFunctionalProperty)) {
                processLater.add(stmt);
                continue;
            }
            if (o.equals(OWL.Ontology)) {
                if (this.isOntology(s2)) continue;
                this.addOntology(s2);
                this.printDebug("(ontology " + s2 + ")");
                continue;
            }
            if (o.equals(OWL.DataRange)) {
                this.mDataranges.add(st);
                String dtName = s2.toString();
                this.kb.getDatatypeReasoner().defineDatatype(dtName);
                this.printDebug("(datarange " + dtName);
                continue;
            }
            if (this.isInvalidOWLTerm(o)) {
                this.report.addMessage(2, "Invalid OWL Term", "URI %1% does not belong to OWL namespace", ot);
                continue;
            }
            this.addType(st, ot);
            processLater.add(stmt);
        }
        for (int j = 0; j < processLater.size(); ++j) {
            String problem;
            String previousDefinition;
            Statement stmt = (Statement)processLater.get(j);
            s = stmt.getSubject();
            Resource o = stmt.getResource();
            ATermAppl st = this.node2term((RDFNode)s);
            ATermAppl obj = this.node2term((RDFNode)o);
            if (o.equals(RDFS.Class)) {
                if (s.hasProperty(RDF.type, (RDFNode)OWL.Restriction) || s.hasProperty(RDF.type, (RDFNode)OWL.Class)) continue;
                this.report.addMessage(2, "RDFS Vocabulary", "Using  rdfs:Class instead of owl:Class");
                this.classes.add(st);
                continue;
            }
            if (o.equals(OWL.FunctionalProperty)) {
                if (!this.isProperty(st)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    problem = st + " is defined both as a property and a" + previousDefinition;
                    this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, st);
                    continue;
                }
                if (!this.kb.getABox().getRBox().isRole(st)) {
                    this.kb.getABox().getRBox().addObjectRole(st);
                    this.report.addMessage(2, "Untyped Property", "%1% needs to be defined as an Object or Data property", st);
                    this.addMissingTriple(s, RDF.type, OWL.ObjectProperty);
                }
                this.kb.addFunctionalProperty(st);
                this.printDebug("functional(" + st + ")");
                continue;
            }
            if (o.equals(OWL.InverseFunctionalProperty)) {
                if (this.kb.isDatatypeProperty(st) || this.kb.isAnnotationProperty(st)) {
                    previousDefinition = this.kb.isDatatypeProperty(st) ? " datatype" : "n annotation";
                    problem = " is defined both as a" + previousDefinition + " property and as InverseFunctionalProperty";
                    this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, st);
                    continue;
                }
                if (!this.kb.getABox().getRBox().isRole(st)) {
                    this.kb.getABox().getRBox().addObjectRole(st);
                }
                this.kb.addInverseFunctionalProperty(st);
                this.printDebug("inv-functional(" + st + ")");
                continue;
            }
            if (o.equals(OWL.TransitiveProperty)) {
                if (this.kb.isDatatypeProperty(st) || this.kb.isAnnotationProperty(st)) {
                    previousDefinition = this.kb.isDatatypeProperty(st) ? " datatype" : "n annotation";
                    problem = " is defined both as a" + previousDefinition + " property and as a TransitiveProperty";
                    this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, st);
                    continue;
                }
                if (!this.kb.getABox().getRBox().isRole(st)) {
                    this.kb.getABox().getRBox().addObjectRole(st);
                }
                this.kb.addTransitiveProperty(st);
                this.printDebug("transitive-role(" + st + ")");
                continue;
            }
            if (o.equals(OWL.SymmetricProperty)) {
                if (this.kb.isDatatypeProperty(st) || this.kb.isAnnotationProperty(st)) {
                    previousDefinition = this.kb.isDatatypeProperty(st) ? " datatype" : "n annotation";
                    problem = " is defined both as a" + previousDefinition + " property and as a SymmetricProperty";
                    this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, st);
                    continue;
                }
                if (!this.kb.getABox().getRBox().isRole(st)) {
                    this.kb.getABox().getRBox().addObjectRole(st);
                }
                this.kb.addInverseProperty(st, st);
                this.printDebug("inverse-role(" + st + " " + st + ")");
                continue;
            }
            if (o.equals(RDF.Property)) {
                if (!this.isProperty(st)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    problem = " is defined both as a property and a" + previousDefinition;
                    this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, st);
                    continue;
                }
                if (this.kb.isProperty(st)) continue;
                this.report.addMessage(2, "RDF Vocabulary", "Using rdf:Property instead of owl:[Object|Data]Property for %1% ", st);
                this.addMissingTriple(s, RDF.type, OWL.ObjectProperty);
                this.kb.getABox().getRBox().addObjectRole(st);
                this.printDebug("plain-role(" + st + ")");
                continue;
            }
            this.isClass(obj, true);
        }
    }

    private void processRestrictions() {
        Iterator e = this.restrictions.keySet().iterator();
        while (e.hasNext()) {
            Resource prop;
            ATermAppl target;
            Object key = e.next();
            Resource res = (Resource)key;
            if (res.hasProperty(OWL.onProperty) && !this.kb.isProperty(target = this.node2term((RDFNode)(prop = res.getProperty(OWL.onProperty).getResource())))) {
                this.report.addMessage(2, "Untyped Property", "%1% needs to be defined as owl:[Object|Data]Property", target);
                this.isProperty(target, true, "object");
                this.addMissingTriple(prop, RDF.type, OWL.ObjectProperty);
                this.printDebug("(object-prop " + target + ")");
            }
            if (!res.hasProperty(OWL.hasValue) || !(res.getProperty(OWL.hasValue).getObject() instanceof Resource)) continue;
            Resource val = res.getProperty(OWL.hasValue).getResource();
            target = this.node2term((RDFNode)val);
            if (this.kb.getABox().isNode(target)) continue;
            this.report.addMessage(2, "Untyped Individual", "%1% needs to be defined as an individual", target);
            this.kb.getABox().addIndividual(target);
            this.addMissingTriple(val, RDF.type, OWL.Thing);
            this.printDebug("(individual " + target + ")");
        }
    }

    private ATermAppl createRestriction(Resource s) throws UnsupportedFeatureException {
        ATermAppl aTerm = ATermUtils.BOTTOM;
        Resource p = null;
        StmtIterator si = s.listProperties(OWL.onProperty);
        if (si.hasNext()) {
            p = si.nextStatement().getResource();
            if (si.hasNext()) {
                this.canOutputDL = false;
                this.report.addMessage(2, "Invalid Restriction", "A restriction has multiple owl:onProperty values");
            }
        } else {
            this.report.addMessage(2, "Invalid Restriction", "A restriction has no owl:onProperty values");
            return aTerm;
        }
        ATermAppl pt = this.node2term((RDFNode)p);
        if (!s.isAnon()) {
            this.report.addMessage(2, "Invalid Restriction", "A restriction has a URI " + ATermUtils.makeTermAppl(s.getURI()));
        } else if (s.hasProperty(OWL.hasValue)) {
            RDFNode o = s.getProperty(OWL.hasValue).getObject();
            ATermAppl ot = this.node2term(o);
            ATermAppl nominal = ATermUtils.makeValue(ot);
            aTerm = ATermUtils.makeSomeValues(pt, nominal);
            this.report.addMessage(1, "Value Restriction", "owl:hasValue construct is used %1%", aTerm);
        } else if (s.hasProperty(OWL.allValuesFrom)) {
            Resource o = (Resource)s.getProperty(OWL.allValuesFrom).getObject();
            ATermAppl ot = this.node2term((RDFNode)o);
            aTerm = ATermUtils.makeAllValues(pt, ot);
        } else if (s.hasProperty(OWL.someValuesFrom)) {
            Resource o = (Resource)s.getProperty(OWL.someValuesFrom).getObject();
            ATermAppl ot = this.node2term((RDFNode)o);
            aTerm = ATermUtils.makeSomeValues(pt, ot);
        } else if (s.hasProperty(OWL.minCardinality)) {
            int cardinality = 0;
            try {
                cardinality = s.getProperty(OWL.minCardinality).getInt();
            }
            catch (Exception ex) {
                RDFNode value = s.getProperty(OWL.minCardinality).getObject();
                try {
                    Literal num = (Literal)value;
                    cardinality = Integer.parseInt(num.getLexicalForm());
                    if (!this.kb.getDatatypeReasoner().isDefined(num.getDatatypeURI())) {
                        this.report.addMessage(2, "Invalid XSD Vocabulary", "Using wrong URI " + num.getDatatypeURI() + " for XMLSchema (" + "http://www.w3.org/2001/XMLSchema#" + ")");
                    }
                }
                catch (Exception ex2) {
                    this.report.addMessage(2, "Invalid Cardinality Restriction", "minCardinality restriction on %1% is not an integer: " + value, pt);
                }
            }
            if (cardinality < 0) {
                this.report.addMessage(2, "Invalid Cardinality Restriction", "minCardinality restriction on %1% is a negative integer: " + cardinality, pt);
            } else {
                aTerm = ATermUtils.makeMin(pt, cardinality);
                if (cardinality > 1) {
                    this.report.addMessage(1, "Cardinality Restriction", "minCardinality value is greater than 1 %1% ", aTerm);
                }
            }
        } else if (s.hasProperty(OWL.maxCardinality)) {
            int cardinality = 0;
            try {
                cardinality = s.getProperty(OWL.maxCardinality).getInt();
            }
            catch (Exception ex) {
                RDFNode value = s.getProperty(OWL.maxCardinality).getObject();
                try {
                    Literal num = (Literal)value;
                    cardinality = Integer.parseInt(num.getLexicalForm());
                    if (!this.kb.getDatatypeReasoner().isDefined(num.getDatatypeURI())) {
                        this.report.addMessage(2, "Invalid XSD Vocabulary", "Using wrong URI " + num.getDatatypeURI() + " for XMLSchema (" + "http://www.w3.org/2001/XMLSchema#" + ")");
                    }
                }
                catch (Exception ex2) {
                    this.report.addMessage(2, "Invalid Cardinality Restriction", "maxCardinality restriction on %1% is not an integer: " + value, pt);
                }
            }
            if (cardinality < 0) {
                this.report.addMessage(2, "Invalid Cardinality Restriction", "maxCardinality restriction on %1% is a negative integer: " + cardinality, pt);
            } else {
                aTerm = ATermUtils.makeMax(pt, cardinality);
                if (cardinality > 1) {
                    this.report.addMessage(1, "Cardinality Restriction", "maxCardinality value is greater than 1 %1% ", aTerm);
                }
            }
        } else if (s.hasProperty(OWL.cardinality)) {
            int cardinality = 0;
            try {
                cardinality = s.getProperty(OWL.cardinality).getInt();
            }
            catch (Exception ex) {
                RDFNode value = s.getProperty(OWL.cardinality).getObject();
                try {
                    Literal num = (Literal)value;
                    cardinality = Integer.parseInt(num.getLexicalForm());
                    if (!this.kb.getDatatypeReasoner().isDefined(num.getDatatypeURI())) {
                        this.report.addMessage(2, "Invalid XSD Vocabulary", "Using wrong URI " + num.getDatatypeURI() + " for XMLSchema (" + "http://www.w3.org/2001/XMLSchema#" + ")");
                    }
                }
                catch (Exception ex2) {
                    this.report.addMessage(2, "Invalid Cardinality Restriction", "cardinality restriction on %1% is not an integer: " + value, pt);
                }
            }
            if (cardinality < 0) {
                this.report.addMessage(2, "Invalid Cardinality Restriction", "cardinality restriction on %1% is a negative integer: " + cardinality, pt);
            } else {
                aTerm = ATermUtils.makeCard(pt, cardinality);
                if (cardinality > 1) {
                    this.report.addMessage(1, "Cardinality Restriction", "cardinality value is greater than 1 restriction(%1% cardinality(" + cardinality + "))", pt);
                }
            }
        } else {
            this.report.addMessage(2, "Invalid Cardinality Restriction", "Restriction does not have any of owl:allValuesFrom, owl:someValuesFrom, owl:hasValue or cardinality restrictions");
        }
        return aTerm;
    }

    protected ATermAppl node2term(RDFNode node) {
        ATermAppl aTerm = null;
        if (node.equals(OWL.Thing)) {
            return ATermUtils.TOP;
        }
        if (node.equals(OWL.Nothing)) {
            return ATermUtils.BOTTOM;
        }
        if (node instanceof Literal) {
            Literal l = (Literal)node;
            String datatypeURI = l.getDatatypeURI();
            aTerm = datatypeURI != null ? ATermUtils.makeTypedLiteral(l.getString(), datatypeURI) : ATermUtils.makePlainLiteral(l.getString(), l.getLanguage());
        } else if (node instanceof Resource) {
            Resource r = (Resource)node;
            if (r.getModel() != null && r.hasProperty(OWL.onProperty)) {
                aTerm = this.createRestriction(r);
            } else if (r.isAnon()) {
                if (r.hasProperty(OWL.intersectionOf)) {
                    ATermList list = (ATermList)this.lists.get(r.getProperty(OWL.intersectionOf).getResource());
                    aTerm = ATermUtils.makeAnd(list);
                } else if (r.hasProperty(OWL.unionOf)) {
                    ATermList list = (ATermList)this.lists.get(r.getProperty(OWL.unionOf).getResource());
                    aTerm = ATermUtils.makeOr(list);
                } else if (r.hasProperty(OWL.oneOf)) {
                    ATermList list = (ATermList)this.lists.get(r.getProperty(OWL.oneOf).getResource());
                    ATermList result = ATermUtils.EMPTY_LIST;
                    if (list != null) {
                        ATermList l = list;
                        while (!l.isEmpty()) {
                            ATermAppl c = (ATermAppl)l.getFirst();
                            ATermAppl nominal = ATermUtils.makeValue(c);
                            result = result.insert(nominal);
                            l = l.getNext();
                        }
                        aTerm = ATermUtils.makeOr(result);
                    } else {
                        aTerm = ATermUtils.BOTTOM;
                    }
                } else if (r.hasProperty(OWL.complementOf)) {
                    ATermAppl complement = this.node2term((RDFNode)r.getProperty(OWL.complementOf).getResource());
                    aTerm = ATermUtils.makeNot(complement);
                } else {
                    aTerm = ATermUtils.makeTermAppl("bNode" + r.toString());
                }
            } else {
                aTerm = ATermUtils.makeTermAppl(r.getURI());
            }
        }
        return aTerm;
    }

    private void addType(ATermAppl ind, ATermAppl c) {
        if (!this.isIndividual(ind)) {
            String previousDefinition = this.isClass(ind) ? "class" : "property";
            String problem = " is defined both as an individual and a " + previousDefinition;
            this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, ind);
        }
        if (!this.kb.getABox().isNode(ind)) {
            this.kb.getABox().addIndividual(ind);
        }
        this.kb.getABox().addType(ind, c);
        this.printDebug("type(" + ind + " " + c + ")");
    }

    private void addClass(ATermAppl c) {
        if (ATermUtils.isPrimitive(c)) {
            this.classes.add(c);
            this.printDebug("class(" + c + ")");
        }
    }

    private void addSubClass(ATerm c1, ATerm c2) {
        if (!((Object)c1).equals(c2)) {
            this.printDebug("sub(" + c1 + ", " + c2 + ")");
        }
    }

    private void addSameClass(ATermAppl c1, ATermAppl c2) {
        if (!c1.equals(c2)) {
            this.printDebug("same(" + c1 + ", " + c2 + ")");
        }
    }

    private boolean isInvalidOWLTerm(Resource r) {
        return !r.isAnon() && r.getURI().startsWith(OWL.getURI()) && !r.equals(OWL.AllDifferent) && !r.equals(OWL.allValuesFrom) && !r.equals(OWL.AnnotationProperty) && !r.equals(OWL.backwardCompatibleWith) && !r.equals(OWL.cardinality) && !r.equals(OWL.Class) && !r.equals(OWL.complementOf) && !r.equals(RDFS.Datatype) && !r.equals(OWL.DatatypeProperty) && !r.equals(OWL.DeprecatedClass) && !r.equals(OWL.DeprecatedProperty) && !r.equals(OWL.differentFrom) && !r.equals(OWL.disjointWith) && !r.equals(OWL.distinctMembers) && !r.equals(OWL.equivalentClass) && !r.equals(OWL.equivalentProperty) && !r.equals(OWL.FunctionalProperty) && !r.equals(OWL.hasValue) && !r.equals(OWL.imports) && !r.equals(OWL.incompatibleWith) && !r.equals(OWL.intersectionOf) && !r.equals(OWL.InverseFunctionalProperty) && !r.equals(OWL.inverseOf) && !r.equals(OWL.maxCardinality) && !r.equals(OWL.minCardinality) && !r.equals(OWL.Nothing) && !r.equals(OWL.ObjectProperty) && !r.equals(OWL.oneOf) && !r.equals(OWL.onProperty) && !r.equals(OWL.Ontology) && !r.equals(OWL.priorVersion) && !r.equals(OWL.Restriction) && !r.equals(OWL.sameAs) && !r.equals(OWL.someValuesFrom) && !r.equals(OWL.SymmetricProperty) && !r.equals(OWL.Thing) && !r.equals(OWL.TransitiveProperty) && !r.equals(OWL.unionOf) && !r.equals(OWL.versionInfo);
    }

    private void processTriples() throws UnsupportedFeatureException {
        this.mDisjointWithGraph = new Graph();
        StmtIterator i = this.model.listStatements();
        while (i.hasNext()) {
            String problem;
            Resource r;
            Object result;
            ATermAppl complement;
            String previousDefinition;
            ATermAppl disjunction;
            ATermList l;
            ATermList list;
            Statement stmt = (Statement)i.next();
            Resource s = stmt.getSubject();
            Property p = stmt.getPredicate();
            RDFNode o = stmt.getObject();
            if (o instanceof Resource && ((Resource)o).isAnon() && (p.equals(OWL.complementOf) || p.equals(RDF.type) || p.equals(OWL.someValuesFrom) || p.equals(OWL.allValuesFrom))) {
                if (this.mUsedBnodes.contains(o.toString())) {
                    this.canOutputDL = false;
                    this.report.addMessage(2, "Structure Sharing", "The bNode " + o.toString() + " is used in multiple structures");
                } else {
                    this.mUsedBnodes.add(o.toString());
                }
            }
            if (this.isInvalidOWLTerm((Resource)p)) {
                this.report.addMessage(2, "Invalid OWL Term", "Property %1% does not belong to OWL namespace", ATermUtils.makeTermAppl(p.toString()));
                String localName = p.getLocalName();
                if (!RDFS_PROPS.contains(localName)) continue;
                this.report.addMessage(3, "Invalid OWL Term", "Using rdfs:" + localName + " instead owl:" + localName);
                p = ResourceFactory.createProperty((String)RDFS.getURI(), (String)localName);
                this.canOutputDL = false;
            }
            ATermAppl st = this.node2term((RDFNode)s);
            ATermAppl pt = this.node2term((RDFNode)p);
            ATermAppl ot = this.node2term(o);
            if (p.equals(RDF.type)) continue;
            if (RESTRICTION_PROPS.contains(p)) {
                if (s.hasProperty(RDF.type, (RDFNode)OWL.Restriction)) continue;
                this.canOutputDL = false;
                this.report.addMessage(2, "Invalid Restriction", "The property " + p + " is used with a subject which is not a restriction");
                continue;
            }
            if (p.equals(OWL.intersectionOf)) {
                if (s.isAnon()) {
                    this.report.addMessage(1, "Anonymous Intersection Class", "owl:intersectionOf triples cannot have an anonymous subject in OWL Lite");
                }
                if ((list = (ATermList)this.lists.get(o)) == null) {
                    this.report.addMessage(2, "Invalid Intersection Class", "owl:intersectionOf should point to a rdf:List structure");
                    continue;
                }
                l = list;
                while (!l.isEmpty()) {
                    ATermAppl c = (ATermAppl)l.getFirst();
                    if (!this.isClass(c, true)) {
                        String previousDefinition2 = this.isIndividual(st) ? "n individual" : " property";
                        this.report.addMessage(2, "Invalid Intersection Class", "owl:intersectionOf includes %1% which is a" + previousDefinition2, c);
                    }
                    l = l.getNext();
                }
                ATermAppl conjunction = ATermUtils.makeAnd(list);
                this.addSameClass(st, conjunction);
                continue;
            }
            if (p.equals(OWL.unionOf)) {
                list = (ATermList)this.lists.get(o);
                if (list == null) {
                    this.report.addMessage(2, "Invalid Union Class", "owl:unionOf should point to a rdf:List structure");
                    continue;
                }
                l = list;
                while (!l.isEmpty()) {
                    ATermAppl c = (ATermAppl)l.getFirst();
                    if (!this.isClass(c, true)) {
                        String previousDefinition3 = this.isIndividual(st) ? "n individual" : " property";
                        this.report.addMessage(2, "Invalid Union Class", "owl:unionOf includes %1% which is a" + previousDefinition3, c);
                    }
                    l = l.getNext();
                }
                disjunction = ATermUtils.makeOr(list);
                this.report.addMessage(1, "Union Class", "owl:unionOf construct is used %1%", disjunction);
                this.addSameClass(st, disjunction);
                continue;
            }
            if (p.equals(OWL.complementOf)) {
                if (!this.isClass(st, true)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " property";
                    this.report.addMessage(2, "Invalid Complement Class", "owl:complementOf is used with %1% which is a" + previousDefinition, st);
                }
                if (!this.isClass(ot, true)) {
                    previousDefinition = this.isIndividual(ot) ? "n individual" : " property";
                    this.report.addMessage(2, "Invalid Complement Class", "owl:complementOf is used with %1% which is a" + previousDefinition, ot);
                }
                complement = ATermUtils.makeNot(ot);
                this.report.addMessage(1, "Complement Class", "owl:complementOf construct is used %1%", complement);
                this.addSameClass(st, complement);
                continue;
            }
            if (p.equals(RDFS.subClassOf)) {
                if (!this.isClass(st, true)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " property";
                    this.report.addMessage(2, "Invalid SubClass Axiom", "rdfs:subClassOf is used with %1% which is a" + previousDefinition, st);
                }
                if (!this.isClass(ot, true)) {
                    previousDefinition = this.isIndividual(ot) ? "n individual" : " property";
                    this.report.addMessage(2, "Invalid SubClass Axiom", "rdfs:subClassOf is used with %1% which is a" + previousDefinition, ot);
                }
                this.addSubClass(st, ot);
                continue;
            }
            if (p.equals(OWL.equivalentClass)) {
                if (!this.isClass(st, true)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " property";
                    this.report.addMessage(2, "Invalid EquivalentClass Axiom", "owl:equivalentClass is used with %1% which is a" + previousDefinition, st);
                }
                if (!this.isClass(ot, true)) {
                    previousDefinition = this.isIndividual(ot) ? "n individual" : " property";
                    this.report.addMessage(2, "Invalid EquivalentClass Axiom", "owl:equivalentClass is used with %1% which is a" + previousDefinition, ot);
                }
                this.addSameClass(st, ot);
                this.addToGraph(this.mEquivalentClassGraph, stmt);
                continue;
            }
            if (p.equals(OWL.disjointWith)) {
                if (!this.isClass(st, true)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " property";
                    this.report.addMessage(2, "Invalid DisjointClasses Axiom", "owl:disjointWith is used with %1% which is a" + previousDefinition, st);
                }
                if (!this.isClass(ot, true)) {
                    previousDefinition = this.isIndividual(ot) ? "n individual" : " property";
                    this.report.addMessage(2, "Invalid DisjointClasses Axiom", "owl:disjointWith is used with %1% which is a" + previousDefinition, ot);
                }
                complement = ATermUtils.makeNot(ot);
                this.addSubClass(st, complement);
                this.report.addMessage(1, "Disjoint Classes", "owl:disjointWith construct is used DisjointClasses(%1% %2%)", st, ot);
                this.addToGraph(this.mDisjointWithGraph, stmt);
                continue;
            }
            if (p.equals(OWL.equivalentProperty)) {
                if (!this.isProperty(st, true)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    this.report.addMessage(2, "Invalid EquivalentProperty Axiom", "owl:equivalentProperty is used with %1% which is a" + previousDefinition, st);
                }
                if (!this.isProperty(ot, true)) {
                    previousDefinition = this.isIndividual(ot) ? "n individual" : " class";
                    this.report.addMessage(2, "Invalid EquivalentProperty Axiom", "owl:equivalentProperty is used with %1% which is a" + previousDefinition, ot);
                }
                if (this.kb.isObjectProperty(st) && !this.kb.isObjectProperty(ot) || this.kb.isDatatypeProperty(st) && !this.kb.isDatatypeProperty(ot)) {
                    this.report.addMessage(2, "Invalid EquivalentProperty Axiom", "owl:equivalentProperty is used with %1% (a" + this.getDefinition(st) + ") and %2% (a" + this.getDefinition(ot) + ")", st, ot);
                    continue;
                }
                this.kb.getABox().getRBox().addSubRole(st, ot);
                this.printDebug("sub-role(" + st + " " + ot + ")");
                this.kb.getABox().getRBox().addSubRole(ot, st);
                this.printDebug("sub-role(" + ot + " " + st + ")");
                continue;
            }
            if (p.equals(RDFS.subPropertyOf)) {
                if (!this.isProperty(st, true)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    this.report.addMessage(2, "Invalid SubProperty Axiom", "rdfs:subPropertyOf is used with %1% which is a" + previousDefinition, st);
                }
                if (!this.isProperty(ot, true)) {
                    previousDefinition = this.isIndividual(ot) ? "n individual" : " class";
                    this.report.addMessage(2, "Invalid SubProperty Axiom", "rdfs:subPropertyOf is used with %1% which is a" + previousDefinition, ot);
                }
                if (this.kb.isObjectProperty(st) && !this.kb.isObjectProperty(ot) || this.kb.isDatatypeProperty(st) && !this.kb.isDatatypeProperty(ot)) {
                    this.report.addMessage(2, "Invalid SubProperty Axiom", "rdfs:subPropertyOf is used with %1% (" + this.getDefinition(st) + ") and %2% (" + this.getDefinition(ot) + ")", st, ot);
                    continue;
                }
                this.kb.getABox().getRBox().addSubRole(st, ot);
                this.printDebug("sub-role(" + st + " " + ot + ")");
                continue;
            }
            if (p.equals(OWL.inverseOf)) {
                if (!this.isProperty(st, true)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    this.report.addMessage(2, "Invalid InverseProperty Axiom", "owl:inverseOf is used with %1% which is a" + previousDefinition, st);
                }
                if (!this.isProperty(ot, true)) {
                    previousDefinition = this.isIndividual(ot) ? "n individual" : " class";
                    this.report.addMessage(2, "Invalid InverseProperty Axiom", "owl:inverseOf is used with %1% which is a" + previousDefinition, ot);
                }
                this.kb.addInverseProperty(st, ot);
                this.printDebug("inverse-role(" + st + " " + ot + ")");
                continue;
            }
            if (p.equals(OWL.sameAs)) {
                if (!this.isIndividual(st, true)) {
                    previousDefinition = this.isClass(st) ? "class" : "property";
                    this.report.addMessage(2, "Invalid SameAs Axiom", "owl:sameAs is used with %1% which is a" + previousDefinition, st);
                }
                if (!this.isIndividual(ot, true)) {
                    previousDefinition = this.isClass(st) ? "class" : "property";
                    this.report.addMessage(2, "Invalid SameAs Axiom", "owl:sameAs is used with %1% which is a" + previousDefinition, ot);
                }
                this.printDebug("same(" + st + " " + ot + ")");
                continue;
            }
            if (p.equals(OWL.differentFrom)) {
                if (!this.isIndividual(st, true)) {
                    previousDefinition = this.isClass(st) ? "class" : "property";
                    this.report.addMessage(2, "Invalid DifferentFrom Axiom", "owl:differentFrom is used with %1% which is a" + previousDefinition, st);
                }
                if (!this.isIndividual(ot, true)) {
                    previousDefinition = this.isClass(st) ? "class" : "property";
                    this.report.addMessage(2, "Invalid DifferentFrom Axiom", "owl:differentFrom is used with %1% which is a" + previousDefinition, ot);
                }
                this.printDebug("different(" + st + " " + ot + ")");
                continue;
            }
            if (p.equals(RDFS.domain)) {
                if (s.getNameSpace().equals(RDF.getURI()) || s.getNameSpace().equals(OWL.getURI())) {
                    this.report.addMessage(2, "Invalid Domain Restriction", "rdfs:domain is used on built-in property %1%", st);
                    continue;
                }
                if (!this.isProperty(st, true)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " class";
                    this.report.addMessage(2, "Invalid Domain Restriction", "rdfs:domain statement has a subject %1% which is a" + previousDefinition, st);
                }
                if (!this.isClass(ot, true)) {
                    previousDefinition = this.isIndividual(st) ? "n individual" : " property";
                    this.report.addMessage(2, "Invalid Domain Restriction", "rdfs:domain statement has an object %1% which is a" + previousDefinition, st);
                }
                this.printDebug("domain(" + st + " " + ot + ")");
                continue;
            }
            if (p.equals(RDFS.range)) {
                if (s.isAnon()) {
                    this.report.addMessage(2, "Invalid Range Restriction", "rdfs:range is used on an anonymous property");
                    continue;
                }
                if (s.getNameSpace().equals(RDF.getURI()) || s.getNameSpace().equals(OWL.getURI())) {
                    this.report.addMessage(2, "Invalid Range Restriction", "rdfs:range is used on built-in property %1%", st);
                    continue;
                }
                String sd = this.getDefinition(st);
                String od = this.getDefinition(ot);
                if (sd.equals("Untyped Resource")) {
                    if (od.equals("Datatype")) {
                        this.isProperty(st, true, "datatype");
                    } else if (od.equals("Class")) {
                        this.isProperty(st, true, "object");
                    } else if (od.equals("Untyped Resource")) {
                        this.isProperty(st, true, "object");
                        this.isClass(ot, true);
                    } else {
                        this.report.addMessage(2, "Untyped Resource", "%1% is used in an rdfs:range restriction", st, ot);
                    }
                } else if (od.equals("Untyped Resource")) {
                    if (sd.equals("ObjectProperty")) {
                        this.isClass(ot, true);
                    } else if (sd.equals("DatatypeProperty")) {
                        Resource r2 = (Resource)o;
                        this.kb.getDatatypeReasoner().defineDatatype(ot.toString());
                        ot = this.node2term((RDFNode)r2);
                        this.report.addMessage(2, "Unknown Datatype", r2 + " is an unknown datatype");
                        this.addMissingTriple(r2, RDF.type, RDFS.Datatype);
                    } else {
                        this.report.addMessage(2, "Untyped Property", "%1% has an rdfs:range restriction", st);
                    }
                }
                sd = this.getDefinition(st);
                od = this.getDefinition(ot);
                if (sd.equals("DatatypeProperty") && od.equals("Datatype") || sd.equals("ObjectProperty") && od.equals("Class")) {
                    this.kb.addRange(st, ot);
                    this.printDebug("range(" + st + " " + ot + ")");
                    continue;
                }
                this.report.addMessage(2, "Invalid Range Restriction", "%1% (" + sd + ") has rdfs:range %2% (" + od + ")", st, ot);
                continue;
            }
            if (p.equals(OWL.distinctMembers)) {
                result = new ArrayList();
                ATermList list2 = (ATermList)this.lists.get(o);
                if (list2 == null) {
                    this.report.addMessage(2, "Invalid List", "owl:distinctMembers must point to a list");
                    continue;
                }
                ATermList l2 = list2;
                while (!l2.isEmpty()) {
                    ATermAppl c = (ATermAppl)l2.getFirst();
                    if (!this.isIndividual(c, true)) {
                        String previousDefinition4 = this.isClass(st) ? "class" : "property";
                        this.report.addMessage(2, "Invalid AllDifferent Axiom", "owl:AllDifferent includes %1% which is a" + previousDefinition4, ot);
                    } else {
                        result.add(c);
                    }
                    l2 = l2.getNext();
                }
                for (int k = 0; k < result.size(); ++k) {
                    for (int j = k + 1; j < result.size(); ++j) {
                        this.kb.getABox().addDifferent((ATermAppl)result.get(k), (ATermAppl)result.get(j));
                        this.printDebug("different(" + result.get(k) + " " + result.get(j) + ")");
                    }
                }
                continue;
            }
            if (p.equals(OWL.oneOf)) {
                ATermAppl c;
                ATermList l3;
                result = ATermUtils.EMPTY_LIST;
                disjunction = null;
                if (this.isDatatype(st)) {
                    if (!o.equals(RDF.nil)) {
                        ATermList list3 = (ATermList)this.lists.get(o);
                        if (list3 == null) {
                            this.report.addMessage(2, "Invalid List", "owl:oneOf must point to a list");
                            continue;
                        }
                        l3 = list3;
                        while (!l3.isEmpty()) {
                            c = (ATermAppl)l3.getFirst();
                            if (!this.isLiteral(c)) {
                                String definition = this.getDefinition(c);
                                this.report.addMessage(2, "Invalid DataRange", "owl:oneOf list in a DataRange includes a " + definition + " %1%", c);
                            }
                            result = result.insert(ATermUtils.makeValue(c));
                            l3 = l3.getNext();
                        }
                    }
                    disjunction = ATermUtils.makeOr((ATermList)result);
                    this.report.addMessage(1, "Enumerated DataRange", "DataRange is defined %1%", disjunction);
                } else {
                    this.isClass(st, true);
                    if (!o.equals(RDF.nil)) {
                        ATermList list4 = (ATermList)this.lists.get(o);
                        if (list4 == null) {
                            this.report.addMessage(2, "Invalid List", "owl:oneOf must point to a list");
                            continue;
                        }
                        l3 = list4;
                        while (!l3.isEmpty()) {
                            c = (ATermAppl)l3.getFirst();
                            if (!this.isIndividual(c, true)) {
                                String previousDefinition5 = this.isClass(c) ? "class" : "property";
                                this.report.addMessage(2, "Invalid Enumerated Class", "owl:oneOf list includes %1% which is a" + previousDefinition5, c);
                            }
                            result = result.insert(ATermUtils.makeValue(c));
                            l3 = l3.getNext();
                        }
                    }
                    disjunction = ATermUtils.makeOr((ATermList)result);
                    this.report.addMessage(1, "Enumerated Class", "owl:oneOf construct is used %1%", disjunction);
                }
                this.addSameClass(st, disjunction);
                continue;
            }
            if (p.equals(OWL.imports)) {
                r = (Resource)o;
                if (!this.isOntology(r)) {
                    this.report.addMessage(2, "Untyped Ontology", s + " is importing " + o + " which is not specified as an owl:Ontology");
                    this.addMissingTriple(r, RDF.type, OWL.Ontology);
                }
                if (this.isOntology(s)) continue;
                this.report.addMessage(2, "Untyped Ontology", s + " has a value for owl:imports property but is not defined as an owl:Ontology");
                this.addMissingTriple(s, RDF.type, OWL.Ontology);
                continue;
            }
            if (p.equals(RDF.first)) {
                if (!s.equals(RDF.nil)) continue;
                this.canOutputDL = false;
                this.report.addMessage(2, "Invalid List Structure", "rdf:nil cannot have a rdf:first element.");
                continue;
            }
            if (p.equals(RDF.rest)) {
                if (!s.equals(RDF.nil)) continue;
                this.canOutputDL = false;
                this.report.addMessage(2, "Invalid List Structure", "rdf:nil cannot have a rdf:rest element.");
                continue;
            }
            if (this.kb.isOntologyProperty(pt)) {
                Map props;
                ArrayList<RDFNode> propList;
                r = (Resource)o;
                if (!this.isOntology(s)) {
                    this.addOntology(s);
                    this.report.addMessage(2, "Untyped Ontology", "An OntologyProperty " + p + " is used with a subject " + s + " that is not an Ontology");
                    this.addMissingTriple(s, RDF.type, OWL.Ontology);
                }
                if (!this.isOntology(r)) {
                    this.addOntology(r);
                    this.report.addMessage(2, "Untyped Ontology", "An OntologyProperty " + p + " is used with an object " + o + " that is not an Ontology");
                    this.addMissingTriple(r, RDF.type, OWL.Ontology);
                }
                if ((propList = (ArrayList<RDFNode>)(props = this.getOntologyDefinition(s)).get(p)) == null) {
                    propList = new ArrayList<RDFNode>();
                }
                propList.add(o);
                props.put(p, propList);
                continue;
            }
            if (this.kb.isAnnotationProperty(pt)) continue;
            String propType = "object";
            if (this.isLiteral(ot)) {
                propType = "datatype";
            }
            if (!this.isIndividual(st)) {
                propType = "annotation";
            }
            if (!this.isProperty(pt, true, propType)) {
                String previousDefinition6 = this.isIndividual(st) ? "n individual" : " class";
                String problem2 = " is used in predicate position but defined as a" + previousDefinition6;
                this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem2, pt);
                continue;
            }
            if (this.kb.isAnnotationProperty(pt)) continue;
            if (this.kb.isDatatypeProperty(pt)) {
                if (!this.isIndividual(st, true)) {
                    previousDefinition = this.isClass(st) ? "class" : "property";
                    problem = " is used as an individual but defined as a" + previousDefinition;
                    this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, pt);
                    continue;
                }
                if (!this.isLiteral(ot)) {
                    this.report.addMessage(2, "Multiple Types", "Resource %1% is defined as a DatatypeProperty but used with values that are OWL individuals", pt);
                    continue;
                }
                Literal jenaLiteral = (Literal)o;
                String datatypeURI = jenaLiteral.getDatatypeURI();
                ATermAppl literalValue = JenaUtils.makeLiteral(jenaLiteral);
                if (datatypeURI != null && !this.kb.getDatatypeReasoner().isDefined(datatypeURI)) {
                    this.kb.getDatatypeReasoner().defineDatatype(datatypeURI);
                    this.report.addMessage(2, "Unknown Datatype", datatypeURI + " is an unknown datatype");
                    this.addMissingTriple(ResourceFactory.createResource((String)datatypeURI), RDF.type, RDFS.Datatype);
                }
                this.kb.addDataPropertyValue(pt, st, literalValue);
                this.printDebug("edge(" + pt + " " + st + " " + literalValue + ")");
                continue;
            }
            if (!this.isIndividual(st, true)) {
                previousDefinition = this.isClass(st) ? "class" : "property";
                problem = " is used as an individual but defined as a" + previousDefinition;
                this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, pt);
                continue;
            }
            if (this.isLiteral(ot)) {
                this.report.addMessage(2, "Multiple Types", "Resource %1% is defined as an ObjectProperty but used with a literal value", pt);
                continue;
            }
            if (!this.isIndividual(ot, true)) {
                previousDefinition = this.isClass(st) ? "class" : "property";
                problem = " is used as an individual but defined as a" + previousDefinition;
                this.report.addMessage(2, "Multiple Types", "Resource %1% " + problem, pt);
                continue;
            }
            this.kb.addObjectPropertyValue(pt, st, ot);
            this.printDebug("edge(" + pt + " " + st + " " + ot + ")");
        }
        Enumeration enumeration = this.mEquivalentClassGraph.getVertexKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            if (this.mDisjointWithGraph.getVertex(key) != null && key.startsWith("anon")) {
                this.report.addMessage(2, "Structure Sharing", "owl:equivalentClass and owl:disjointWith descriptions share bNodes");
                this.canOutputDL = false;
                continue;
            }
            if (!key.startsWith("anon") || !this.mUsedBnodes.contains(key.substring(key.indexOf("anon") + 4))) continue;
            this.canOutputDL = false;
            this.report.addMessage(2, "Structure Sharing", "Structure sharing not permitted for " + key.substring(key.indexOf("anon") + 4) + " via owl:equivalentClass.");
        }
        this.doDisjointCheck();
    }

    private void addToGraph(Graph theGraph, Statement stmt) {
        Resource s = stmt.getSubject();
        Property p = stmt.getPredicate();
        RDFNode o = stmt.getObject();
        Vertex start = null;
        Vertex end = null;
        if (theGraph.getVertex((s.isAnon() ? "anon" : "") + s.toString()) == null) {
            start = new Vertex((s.isAnon() ? "anon" : "") + s.toString());
            theGraph.addVertex(start);
        } else {
            start = theGraph.getVertex((s.isAnon() ? "anon" : "") + s.toString());
        }
        if (theGraph.getVertex((o instanceof Resource && ((Resource)o).isAnon() ? "anon" : "") + o.toString()) == null) {
            end = new Vertex((o instanceof Resource && ((Resource)o).isAnon() ? "anon" : "") + o.toString());
            theGraph.addVertex(end);
        } else {
            end = theGraph.getVertex((o instanceof Resource && ((Resource)o).isAnon() ? "anon" : "") + o.toString());
        }
        theGraph.connect(start, end, p.toString());
    }

    private List splitGraph(Graph g, String edge) {
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        Enumeration e = g.getVertexKeys();
        HashSet<String> seen = new HashSet<String>();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if (seen.contains(key)) continue;
            Vertex aVert = g.getVertex(key);
            boolean inserted = false;
            for (int i = 0; i < graphs.size(); ++i) {
                Graph gg = (Graph)graphs.get(i);
                Enumeration enumeration = gg.getVertexKeys();
                while (enumeration.hasMoreElements()) {
                    String s = enumeration.nextElement().toString();
                    if (!aVert.hasNeighbor(gg.getVertex(s), edge)) continue;
                    inserted = true;
                    gg.addVertex(aVert);
                    break;
                }
                if (inserted) break;
            }
            if (!inserted) {
                List neighbors = this.collectNodes(aVert, true);
                Graph aGraph = new Graph();
                aGraph.addVertex(aVert);
                for (int i = 0; i < neighbors.size(); ++i) {
                    Vertex v = (Vertex)neighbors.get(i);
                    seen.add(v.getName());
                    aGraph.addVertex(v);
                }
                graphs.add(aGraph);
            }
            if (seen.size() != g.numVertices()) continue;
            break;
        }
        return graphs;
    }

    private void doDisjointCheck() {
        if (this.mDisjointWithGraph.numVertices() == 0) {
            return;
        }
        List allGraphs = this.splitGraph(this.mDisjointWithGraph, OWL.disjointWith.toString());
        for (int i = 0; i < allGraphs.size(); ++i) {
            if (this.checkGraph((Graph)allGraphs.get(i))) continue;
            return;
        }
    }

    private boolean checkGraph(Graph theGraph) {
        int j;
        Enumeration enumeration = theGraph.getVertexKeys();
        boolean invalid = false;
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            Vertex vert = theGraph.getVertex(key);
            if (!vert.getName().startsWith("anon")) {
                Enumeration e = theGraph.getVertexKeys();
                while (e.hasMoreElements()) {
                    String s = e.nextElement().toString();
                    Vertex vt = theGraph.getVertex(s);
                    if (vt.equals(vert) || vt.getName().startsWith("anon") || vert.hasNeighbor(vt, OWL.disjointWith.toString()) || vt.hasNeighbor(vert, OWL.disjointWith.toString())) continue;
                    this.report.addMessage(2, "Badly connected subgraph", "No connection exists between " + vt.getName() + " and " + vert.getName());
                    this.canOutputDL = false;
                    return false;
                }
                continue;
            }
            List allNodes = this.collectNodes(vert, false);
            allNodes.add(vert);
            for (int i = 0; i < allNodes.size(); ++i) {
                Vertex firstVert = (Vertex)allNodes.get(i);
                for (j = 0; j < allNodes.size(); ++j) {
                    Vertex secondVert = (Vertex)allNodes.get(j);
                    if (firstVert.equals(secondVert) || firstVert.hasNeighbor(secondVert, OWL.disjointWith.toString())) continue;
                    invalid = true;
                }
                if (invalid) break;
            }
            if (!invalid) continue;
            break;
        }
        if (invalid) {
            UndirectedGraph g = new UndirectedGraph();
            Enumeration anEnum = theGraph.getVertexKeys();
            while (anEnum.hasMoreElements()) {
                Vertex theVertex = theGraph.getVertex(anEnum.nextElement().toString());
                Vertex copy = null;
                if (g.getVertex(theVertex.getName()) != null) {
                    copy = g.getVertex(theVertex.getName());
                } else {
                    copy = new Vertex(theVertex.getName());
                    g.addVertex(copy);
                }
                Vector v = theVertex.listNeighbors();
                for (j = 0; j < v.size(); ++j) {
                    Vertex neighbor = (Vertex)v.get(j);
                    Vertex target = null;
                    if (g.getVertex(neighbor.getName()) != null) {
                        target = g.getVertex(neighbor.getName());
                    } else {
                        target = new Vertex(neighbor.getName());
                        g.addVertex(target);
                    }
                    g.connect(copy, target, OWL.disjointWith.toString());
                }
            }
            if (this.isConnected(g, OWL.disjointWith.toString())) {
                invalid = false;
            } else {
                this.report.addMessage(2, "Structure Sharing", "owl:disjointWith edges in the graph form undirected complete subgraphs which share bNodes");
                this.canOutputDL = false;
            }
        }
        Enumeration e = this.mDisjointWithGraph.getVertexKeys();
        while (e.hasMoreElements()) {
            String aKey = e.nextElement().toString();
            if (!aKey.startsWith("anon")) continue;
            if (this.mUsedBnodes.contains(aKey = aKey.substring(aKey.indexOf("anon") + 4))) {
                this.report.addMessage(2, "Structure sharing violation", "DisjointWith case!");
                this.canOutputDL = false;
                return false;
            }
            this.mUsedBnodes.add(aKey);
        }
        return invalid;
    }

    private boolean isConnected(Graph g, String theEdge) {
        Enumeration e = g.getVertexKeys();
        while (e.hasMoreElements()) {
            Vertex firstVert = g.getVertex(e.nextElement().toString());
            Enumeration enumeration = g.getVertexKeys();
            while (enumeration.hasMoreElements()) {
                Vertex secondVert = g.getVertex(enumeration.nextElement().toString());
                if (firstVert.equals(secondVert) || firstVert.hasNeighbor(secondVert, theEdge)) continue;
                return false;
            }
        }
        return true;
    }

    private List collectNodes(Vertex vert, boolean all) {
        this.mVisitedNodes = new HashSet();
        return this.collectNodesR(vert, all);
    }

    private List collectNodesR(Vertex vert, boolean all) {
        if (this.mVisitedNodes.contains(vert.getName())) {
            return new ArrayList();
        }
        this.mVisitedNodes.add(vert.getName());
        ArrayList nodes = new ArrayList();
        Vector neighbors = vert.listNeighbors();
        for (int i = 0; i < neighbors.size(); ++i) {
            List moreNodes;
            Vertex v = (Vertex)neighbors.get(i);
            if (!this.mVisitedNodes.contains(v.getName()) && (all || v.getName().startsWith("anon"))) {
                moreNodes = this.collectNodesR(v, all);
                if (!moreNodes.contains(v)) {
                    moreNodes.add(v);
                }
            } else {
                return nodes;
            }
            moreNodes.removeAll(nodes);
            nodes.addAll(moreNodes);
        }
        return nodes;
    }

    private void addMissingTriple(Resource s, Property p, Resource o) {
        if (s.isAnon() || p.isAnon() || o.isAnon()) {
            this.canOutputDL = false;
        } else {
            this.missingTriples.add(ResourceFactory.createStatement((Resource)s, (Property)p, (RDFNode)o));
        }
    }

    private void addMissingTriple(ATerm s, Property p, Resource o) {
        String st = ((Object)s).toString();
        if (st.startsWith("_anon")) {
            this.canOutputDL = false;
        } else {
            this.addMissingTriple(ResourceFactory.createResource((String)st), p, o);
        }
    }

    boolean isDefinedClass(ATerm c) {
        return ((Object)c).equals(ATermUtils.TOP) || ((Object)c).equals(ATermUtils.BOTTOM) || this.classes.contains(c) || this.isRestriction(c) || this.isComplexClass(c);
    }

    boolean isDefinedIndividual(ATerm i) {
        return this.kb.getABox().isNode(i);
    }

    String getDefinition(ATerm x) {
        if (this.isDatatype(x)) {
            return "Datatype";
        }
        if (this.isDefinedClass(x)) {
            return "Class";
        }
        if (this.isDefinedIndividual(x)) {
            return "Individual";
        }
        if (this.kb.isProperty(x)) {
            Role r = this.kb.getProperty(x);
            if (r.isDatatypeRole()) {
                return "DatatypeProperty";
            }
            if (r.isObjectRole()) {
                return "ObjectProperty";
            }
            if (r.isAnnotationRole()) {
                return "AnnotationProperty";
            }
            if (r.isOntologyRole()) {
                return "OntologyProperty";
            }
            return "Property";
        }
        return "Untyped Resource";
    }

    boolean isDatatype(ATerm c) {
        return ATermUtils.isDataRange((ATermAppl)c) || this.kb.getDatatypeReasoner().isDefined(((Object)c).toString());
    }

    boolean isRestriction(ATerm c) {
        return this.restrictions.containsKey(c);
    }

    boolean isClass(ATermAppl c) {
        return this.isClass(c, false);
    }

    boolean isClass(ATermAppl c, boolean assertTrue) {
        if (c.equals(ATermUtils.TOP) || c.equals(ATermUtils.BOTTOM)) {
            return true;
        }
        if (this.isDatatype(c)) {
            return false;
        }
        if (this.classes.contains(c) || this.isRestriction(c)) {
            return true;
        }
        if (this.isComplexClass(c)) {
            return true;
        }
        if (this.kb.getABox().isNode(c) || this.kb.isProperty(c)) {
            return false;
        }
        if (assertTrue) {
            this.report.addMessage(2, "Untyped Class", "Assuming %1% is a class", c);
            this.classes.add(c);
            this.addMissingTriple(c, RDF.type, OWL.Class);
        }
        return true;
    }

    boolean isComplexClass(ATerm c) {
        if (c instanceof ATermAppl) {
            ATermAppl a = (ATermAppl)c;
            AFun f = a.getAFun();
            if (ATermUtils.isDataRange(a)) {
                return false;
            }
            return f.equals(ATermUtils.ALLFUN) || f.equals(ATermUtils.SOMEFUN) || f.equals(ATermUtils.MAXFUN) || f.equals(ATermUtils.MINFUN) || f.equals(ATermUtils.ANDFUN) || f.equals(ATermUtils.ORFUN) || f.equals(ATermUtils.NOTFUN) || f.equals(ATermUtils.VALUEFUN);
        }
        return false;
    }

    boolean isLiteral(ATerm l) {
        return l instanceof ATermAppl && ((ATermAppl)l).getAFun().equals(ATermUtils.LITFUN);
    }

    boolean isIndividual(ATermAppl i) {
        return this.isIndividual(i, false);
    }

    boolean isIndividual(ATermAppl i, boolean assertTrue) {
        if (this.kb.getABox().isNode(i)) {
            return true;
        }
        if (this.classes.contains(i) || this.kb.isProperty(i) || this.isLiteral(i)) {
            return false;
        }
        if (assertTrue) {
            this.report.addMessage(2, "Untyped Individual", "Assuming %1% is an individual", i);
            this.kb.getABox().addIndividual(i);
            this.addMissingTriple(i, RDF.type, OWL.Thing);
        }
        return true;
    }

    boolean isProperty(ATermAppl p) {
        return this.isProperty(p, false, null);
    }

    boolean isProperty(ATermAppl p, boolean assertTrue) {
        return this.isProperty(p, assertTrue, "object");
    }

    boolean isProperty(ATermAppl p, boolean assertTrue, String type) {
        if (this.kb.isProperty(p)) {
            return true;
        }
        if (this.classes.contains(p) || this.kb.getABox().isNode(p)) {
            return false;
        }
        if (assertTrue) {
            if (type.equals("object")) {
                this.report.addMessage(2, "Untyped Property", "Assuming %1% is an object property", p);
                this.kb.addObjectProperty(p);
                this.addMissingTriple(p, RDF.type, OWL.ObjectProperty);
            } else if (type.equals("datatype")) {
                this.report.addMessage(2, "Untyped Property", "Assuming %1% is an datatype property", p);
                this.kb.addDatatypeProperty(p);
                this.addMissingTriple(p, RDF.type, OWL.DatatypeProperty);
            } else if (type.equals("annotation")) {
                this.report.addMessage(2, "Untyped Property", "Assuming %1% is an annotation property", p);
                this.kb.addAnnotationProperty(p);
                this.addMissingTriple(p, RDF.type, OWL.AnnotationProperty);
            } else {
                throw new InternalReasonerException("Invalid parameter for isProperty function");
            }
        }
        return true;
    }

    private Map getOntologyDefinition(Resource o) {
        if (!o.toString().endsWith("#")) {
            o = ResourceFactory.createResource((String)(o + "#"));
        }
        return (Map)this.ontologies.get(o);
    }

    private void addOntology(Resource o) {
        if (!o.toString().endsWith("#")) {
            o = ResourceFactory.createResource((String)(o + "#"));
        }
        this.ontologies.put(o, new HashMap());
    }

    boolean isOntology(Resource o) {
        if (!o.toString().endsWith("#")) {
            o = ResourceFactory.createResource((String)(o + "#"));
        }
        return this.ontologies.containsKey(o);
    }

    private void printDebug(String s) {
        if (OWLSpecies.DEBUG) {
            System.out.println(s);
        }
    }
}

