/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.ResourceFactory;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.jena.OWLTestVocabulary;

public class OWLTest {
    public static boolean DEBUG = false;
    public static int timeout = 10;
    public static final int NO_STATS = 0;
    public static final int SHORT_STATS = 1;
    public static final int LONG_STATS = 2;
    public static final int ALL_STATS = 3;
    public static int SHOW_STATS = 3;
    public static boolean USE_CACHE = false;
    public static String base = USE_CACHE ? "file://C/Mindswap/owl-test/" : "http://www.w3.org/2002/03owlt/editors-draft/draft/";
    public static boolean OUTPUT_DL = false;
    static final List TYPES = Arrays.asList(OWLTestVocabulary.NotOwlFeatureTest, OWLTestVocabulary.PositiveEntailmentTest, OWLTestVocabulary.NegativeEntailmentTest, OWLTestVocabulary.TrueTest, OWLTestVocabulary.OWLforOWLTest, OWLTestVocabulary.ConsistencyTest, OWLTestVocabulary.InconsistencyTest, OWLTestVocabulary.ImportEntailmentTest, OWLTestVocabulary.ImportLevelTest);
    static final List LEVELS = Arrays.asList(OWLTestVocabulary.Lite, OWLTestVocabulary.DL, OWLTestVocabulary.Full);
    static final List STATUS = Arrays.asList(OWLTestVocabulary.Approved, OWLTestVocabulary.Proposed, OWLTestVocabulary.ExtraCredit, OWLTestVocabulary.Obsoleted);
    int syntacticTestCount = 0;
    int syntacticTestPass = 0;
    public static final int TEST_PASS = 0;
    public static final int TEST_FAIL = 1;
    public static final int TEST_SKIP = 2;
    public static final List RESULTS = Arrays.asList("PASS", "FAIL", "SKIP");
    int[][][][] stats = new int[LEVELS.size()][STATUS.size()][TYPES.size()][RESULTS.size()];
    Vector results = new Vector();
    static int MAX_TEST_COUNT = Integer.MAX_VALUE;
    static String allTests = base + "Manifest.rdf";

    public static final void main(String[] args) {
        String manifestFile = allTests;
        for (int i = 0; i < args.length; ++i) {
            String stats;
            String arg = args[i];
            if (arg.equals("-timeout")) {
                timeout = Integer.parseInt(args[++i]);
                continue;
            }
            if (arg.equals("-manifest")) {
                if ((manifestFile = args[++i]).startsWith("http://")) continue;
                manifestFile = "http://www.w3.org/2002/03owlt/" + manifestFile;
                continue;
            }
            if (arg.equals("-cache")) {
                USE_CACHE = true;
                if ((base = args[++i]).startsWith("file://")) continue;
                base = new File(base).toURI().toString();
                continue;
            }
            if (arg.equals("-debug")) {
                ABox.DEBUG = true;
                OWLReasoner.DEBUG = true;
                continue;
            }
            if (arg.equals("-n")) {
                try {
                    MAX_TEST_COUNT = Integer.parseInt(args[++i]);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
                continue;
            }
            if (!arg.startsWith("-stats")) continue;
            if ((stats = args[++i].toLowerCase()).equals("no")) {
                SHOW_STATS = 0;
                continue;
            }
            if (stats.equals("short")) {
                SHOW_STATS = 1;
                continue;
            }
            if (stats.equals("long")) {
                SHOW_STATS = 2;
                continue;
            }
            if (!stats.equals("all")) continue;
            SHOW_STATS = 3;
        }
        System.out.println("Reading manifest file " + manifestFile);
        System.out.println();
        OWLTest owlTest = new OWLTest();
        long time = System.currentTimeMillis();
        owlTest.doTest(manifestFile);
        time = System.currentTimeMillis() - time;
        System.out.println("Total time: " + time);
    }

    public void doTest(String manifestFile) {
        try {
            Model model = ModelFactory.createDefaultModel();
            Model outputModel = ModelFactory.createDefaultModel();
            Resource system = ResourceFactory.createResource();
            Property label = ResourceFactory.createProperty((String)"http://www.w3.org/2000/01/rdf-schema#label");
            Property comment = ResourceFactory.createProperty((String)"http://www.w3.org/2000/01/rdf-schema#comment");
            Literal name = outputModel.createLiteral("Pellet");
            Literal description = outputModel.createLiteral("This was generated by the Pellet reasoner which can be found at http://www.mindswap.org/2003/pellet/");
            outputModel.add(ResourceFactory.createStatement((Resource)system, (Property)label, (RDFNode)name));
            outputModel.add(ResourceFactory.createStatement((Resource)system, (Property)comment, (RDFNode)description));
            model.read(manifestFile, "");
            int testCount = 1;
            StmtIterator i = model.listStatements(null, RDF.type, (RDFNode)((Resource)null));
            while (i.hasNext() && testCount <= MAX_TEST_COUNT) {
                Statement stmt = i.nextStatement();
                if (!TYPES.contains(stmt.getObject())) continue;
                Resource testCase = stmt.getSubject();
                Statement levelStmt = testCase.getProperty(OWLTestVocabulary.level);
                Statement statusStmt = testCase.getProperty(OWLTestVocabulary.status);
                Vector<String> levels = new Vector<String>();
                int level = 3;
                StmtIterator si = testCase.listProperties(OWLTestVocabulary.level);
                while (si.hasNext()) {
                    Statement s = si.nextStatement();
                    String levelName = s.getResource().getLocalName();
                    if (level <= LEVELS.indexOf(levelName)) continue;
                    levelStmt = s;
                    levels.add(levelName);
                }
                Resource testType = stmt.getResource();
                Resource testLevel = levelStmt.getResource();
                RDFNode testStatus = statusStmt.getObject();
                if (testStatus.equals(OWLTestVocabulary.Obsoleted) || testStatus.toString().startsWith("OBSOLETE")) continue;
                String fileName = testCase.toString();
                System.out.println("Test  : " + testCount++);
                System.out.println("Name  : " + testCase);
                System.out.print("Info  : ");
                System.out.print(testType.getLocalName() + " ");
                System.out.print(levels + " ");
                System.out.print(testStatus);
                System.out.println();
                Vector<Object> result = new Vector<Object>();
                result.add(new Integer(testCount - 1));
                result.add(fileName.substring(1 + fileName.substring(1, fileName.lastIndexOf("/") - 1).lastIndexOf("/")));
                result.add(testType.getLocalName());
                result.add(testLevel.getLocalName());
                result.add(testStatus);
                long time = System.currentTimeMillis();
                int testResult = 1;
                try {
                    testResult = this.doTestCase(testCase, testType);
                }
                catch (StackOverflowError e) {
                    testResult = 1;
                    System.err.println("Fail  : Stack overflow");
                    OWLTest.printStackTrace(e);
                }
                catch (OutOfMemoryError e) {
                    testResult = 1;
                    System.err.println("Fail  : Out of Memory");
                }
                time = System.currentTimeMillis() - time;
                Resource testRun = ResourceFactory.createResource();
                Property type = ResourceFactory.createProperty((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
                Property tcProp = ResourceFactory.createProperty((String)"http://www.w3.org/2002/03owlt/resultsOntology#test");
                Resource runtype = ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/resultsOntology#TestRun");
                Property systemProp = ResourceFactory.createProperty((String)"http://www.w3.org/2002/03owlt/resultsOntology#system");
                Resource resultType = null;
                if (testResult == 1) {
                    resultType = time >= (long)(timeout * 1000) ? ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/resultsOntology#IncompleteRun") : ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/resultsOntology#FailingRun");
                } else if (testResult == 0) {
                    resultType = ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/resultsOntology#PassingRun");
                } else if (testResult == 2) {
                    // empty if block
                }
                outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)type, (RDFNode)runtype));
                outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)tcProp, (RDFNode)testCase));
                outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)systemProp, (RDFNode)system));
                if (resultType != null) {
                    outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)type, (RDFNode)resultType));
                }
                Property timeProp = ResourceFactory.createProperty((String)"http://owl.mindswap.org/2003/ont/owlweb.rdf#testTime");
                Literal timeLiteral = model.createLiteral("" + time);
                outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)timeProp, (RDFNode)timeLiteral));
                result.add(new Long(time));
                result.add(RESULTS.get(testResult));
                this.results.add(result);
                int i1 = LEVELS.indexOf(testLevel);
                int i2 = STATUS.indexOf(testStatus);
                int i3 = TYPES.indexOf(testType);
                int i4 = testResult;
                int[] nArray = this.stats[i1][i2][i3];
                int n = i4;
                nArray[n] = nArray[n] + 1;
                System.out.println("Result: " + RESULTS.get(testResult));
                System.out.println("--------------------------------------------------------------------");
            }
            FileOutputStream output = new FileOutputStream("results.rdf");
            outputModel.write((OutputStream)output);
            output.close();
            this.printStatistics();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    void printStatistics() {
        Object[][] data;
        int s;
        ArrayList<Object[][]> dataArray = new ArrayList<Object[][]>();
        for (s = 0; s < STATUS.size() - 1; ++s) {
            data = new Object[LEVELS.size() * (TYPES.size() + 1) + 1][RESULTS.size()];
            for (int r = 0; r < 3; ++r) {
                int columnTotal = 0;
                for (int l = 0; l < LEVELS.size(); ++l) {
                    int total = 0;
                    for (int t = 0; t < TYPES.size(); ++t) {
                        int count = this.stats[l][s][t][r];
                        data[l * (OWLTest.TYPES.size() + 1) + t + 1][r] = new Integer(count);
                        total += count;
                    }
                    data[l * (OWLTest.TYPES.size() + 1)][r] = new Integer(total);
                    columnTotal += total;
                }
                data[OWLTest.LEVELS.size() * (OWLTest.TYPES.size() + 1)][r] = new Integer(columnTotal);
            }
            dataArray.add(data);
        }
        if (SHOW_STATS >= 2) {
            for (int i = 0; i < this.results.size(); ++i) {
                Vector result = (Vector)this.results.get(i);
                for (int j = 0; j < result.size(); ++j) {
                    System.out.print(result.get(j) + " ");
                }
                System.out.println();
            }
        }
        if (SHOW_STATS >= 1) {
            for (s = 0; s < STATUS.size() - 1; ++s) {
                data = (Object[][])dataArray.get(s);
                System.out.println(STATUS.get(s).toString());
                for (int c = 0; c < 3; ++c) {
                    System.out.print(data[data.length - 1][c] + " ");
                }
                System.out.println();
            }
        }
        if (SHOW_STATS >= 3) {
            this.showStatistics(dataArray);
        }
    }

    private void showStatistics(ArrayList dataArray) {
        Object[][] types = new String[LEVELS.size() * (TYPES.size() + 1) + 1][1];
        for (int l = 0; l < LEVELS.size(); ++l) {
            types[l * (OWLTest.TYPES.size() + 1)][0] = ((Resource)LEVELS.get(l)).getLocalName();
            for (int t = 0; t < TYPES.size(); ++t) {
                types[l * (OWLTest.TYPES.size() + 1) + t + 1][0] = "     " + ((Resource)TYPES.get(t)).getLocalName();
            }
            types[OWLTest.LEVELS.size() * (OWLTest.TYPES.size() + 1)][0] = "TOTAL";
        }
        JFrame info = new JFrame("Result");
        info.getContentPane().setLayout(new BoxLayout(info.getContentPane(), 1));
        Box mainPanel = Box.createHorizontalBox();
        final JTable table = new JTable(types, new String[]{"TYPE"});
        Box p1 = Box.createVerticalBox();
        p1.add(new JLabel(" "));
        p1.add(new JScrollPane(table));
        mainPanel.add(p1);
        final JTable[] tables = new JTable[STATUS.size()];
        for (int s = 0; s < STATUS.size() - 1; ++s) {
            Box p = Box.createVerticalBox();
            Object[][] data = (Object[][])dataArray.get(s);
            tables[s] = new JTable(data, RESULTS.toArray());
            JLabel label = new JLabel(STATUS.get(s).toString());
            label.setAlignmentX(0.5f);
            p.add(label);
            p.add(new JScrollPane(tables[s]));
            mainPanel.add(p);
        }
        Box optionsPanel = Box.createVerticalBox();
        final JCheckBox details = new JCheckBox("Show Details", true);
        details.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DEBUG) {
                    System.out.println(e);
                }
                int rowHeight = details.isSelected() ? table.getRowHeight(0) : 1;
                for (int l = 0; l < LEVELS.size(); ++l) {
                    for (int t = 0; t < TYPES.size(); ++t) {
                        table.setRowHeight(l * (TYPES.size() + 1) + t + 1, rowHeight);
                        tables[0].setRowHeight(l * (TYPES.size() + 1) + t + 1, rowHeight);
                        tables[1].setRowHeight(l * (TYPES.size() + 1) + t + 1, rowHeight);
                        tables[2].setRowHeight(l * (TYPES.size() + 1) + t + 1, rowHeight);
                    }
                }
            }
        });
        details.doClick();
        optionsPanel.add(details);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("No");
        columnNames.add("Name");
        columnNames.add("Type");
        columnNames.add("Level");
        columnNames.add("Status");
        columnNames.add("Time (ms)");
        columnNames.add("Result");
        JTable resultsTable = new JTable(this.results, columnNames);
        resultsTable.getColumnModel().getColumn(0).setPreferredWidth(15);
        resultsTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        resultsTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        resultsTable.getColumnModel().getColumn(3).setPreferredWidth(30);
        resultsTable.getColumnModel().getColumn(5).setPreferredWidth(30);
        resultsTable.getColumnModel().getColumn(6).setPreferredWidth(30);
        info.getContentPane().add(mainPanel);
        info.getContentPane().add(optionsPanel);
        info.getContentPane().add(new JScrollPane(resultsTable));
        info.setDefaultCloseOperation(3);
        info.setSize(800, 600);
        info.show();
    }

    String getFileName(String fileName) {
        if (USE_CACHE) {
            fileName = base + fileName.substring(1 + fileName.substring(1, fileName.lastIndexOf("/") - 1).lastIndexOf("/")) + ".rdf";
        }
        return fileName;
    }

    int doConsistencyTest(Resource testCase, boolean isConsistent) {
        String inputFile = null;
        try {
            String string = inputFile = testCase.hasProperty(OWLTestVocabulary.inputDocument) ? testCase.getProperty(OWLTestVocabulary.inputDocument).getObject().toString() : null;
            if (inputFile != null) {
                inputFile = this.getFileName(inputFile);
                System.out.println("Input : " + inputFile);
            }
            ModelReader reader = new ModelReader();
            Model model = reader.read(inputFile);
            OWLReasoner reasoner = new OWLReasoner();
            reasoner.getKB().setTimeout(timeout * 1000);
            reasoner.load(model);
            if (reasoner.isConsistent() != isConsistent) {
                System.err.println("Fail  : Consistency error");
                return 1;
            }
        }
        catch (UnsupportedFeatureException e) {
            System.err.println("Skip  : " + e.getMessage());
            return 2;
        }
        catch (TimeoutException e1) {
            System.err.println("Fail  : Timeout - Couldn't find answer after " + timeout + " seconds");
            return 1;
        }
        catch (Exception e) {
            System.err.println("Fail  : " + inputFile);
            OWLTest.printStackTrace(e);
            return 1;
        }
        return 0;
    }

    int doEntailmentTest(Resource testCase, boolean isEntailed) {
        String inputFile = null;
        try {
            inputFile = testCase.hasProperty(OWLTestVocabulary.premiseDocument) ? testCase.getProperty(OWLTestVocabulary.premiseDocument).getObject().toString() : null;
            String conclusionsFile = testCase.getProperty(OWLTestVocabulary.conclusionDocument).getObject().toString();
            if (inputFile != null) {
                inputFile = this.getFileName(inputFile);
                System.out.println("Input : " + inputFile);
            }
            conclusionsFile = this.getFileName(conclusionsFile);
            System.out.println("Conc. : " + conclusionsFile);
            ModelReader reader = new ModelReader();
            Model model = reader.read(inputFile);
            OWLReasoner reasoner = new OWLReasoner();
            reasoner.getKB().setTimeout(timeout * 1000);
            reasoner.load(model);
            if (!reasoner.isConsistent()) {
                System.err.println("Fail  : Premises file is not consistent!");
                return 1;
            }
            Model conclusions = reader.read(conclusionsFile);
            if (reasoner.isEntailed(conclusions) != isEntailed) {
                System.err.println("Fail  : Entailment error");
                return 1;
            }
        }
        catch (UnsupportedFeatureException e) {
            System.err.println("Skip  : " + e.getMessage());
            return 2;
        }
        catch (TimeoutException e1) {
            System.err.println("Fail  : Timeout - Couldn't find answer after " + timeout + " seconds");
            return 1;
        }
        catch (Exception e) {
            System.err.println("Fail  : " + inputFile);
            OWLTest.printStackTrace(e);
            return 1;
        }
        return 0;
    }

    int doNotOWLFeatureTest(Resource testCase) {
        String inputFile = null;
        try {
            inputFile = testCase.getProperty(OWLTestVocabulary.inputDocument).getObject().toString();
            inputFile = this.getFileName(inputFile);
            ModelReader reader = new ModelReader();
            Model model = reader.read(inputFile);
            OWLReasoner reasoner = new OWLReasoner();
            reasoner.load(model);
            String speciesInfo = reasoner.getSpecies().getReport().toString();
            if (speciesInfo.indexOf("Invalid OWL term") != -1) {
                return 0;
            }
        }
        catch (UnsupportedFeatureException e) {
            return 0;
        }
        catch (Exception e) {
            System.err.println("Fail  : " + inputFile);
            OWLTest.printStackTrace(e);
            return 1;
        }
        return 1;
    }

    int doImportLevelTest(Resource testCase) {
        String inputFile = null;
        try {
            inputFile = testCase.getProperty(OWLTestVocabulary.inputDocument).getObject().toString();
            inputFile = this.getFileName(inputFile);
            System.out.println("Input : " + inputFile);
            String testLevel = testCase.getProperty(OWLTestVocabulary.level).getResource().getLocalName();
            ModelReader reader = new ModelReader();
            Model model = reader.read(inputFile);
            OWLReasoner reasoner = new OWLReasoner();
            reasoner.load(model);
            if (reasoner.getLevel().equals(testLevel)) {
                return 0;
            }
        }
        catch (UnsupportedFeatureException e) {
            return 0;
        }
        catch (Exception e) {
            System.err.println("Fail  : " + inputFile);
            OWLTest.printStackTrace(e);
            return 1;
        }
        return 1;
    }

    int doTestCase(Resource testCase, Resource testType) {
        if (testType.equals(OWLTestVocabulary.PositiveEntailmentTest)) {
            return this.doEntailmentTest(testCase, true);
        }
        if (testType.equals(OWLTestVocabulary.NegativeEntailmentTest)) {
            return this.doEntailmentTest(testCase, false);
        }
        if (testType.equals(OWLTestVocabulary.ConsistencyTest)) {
            return this.doConsistencyTest(testCase, true);
        }
        if (testType.equals(OWLTestVocabulary.InconsistencyTest)) {
            return this.doConsistencyTest(testCase, false);
        }
        if (testType.equals(OWLTestVocabulary.ImportEntailmentTest)) {
            return this.doEntailmentTest(testCase, true);
        }
        if (testType.equals(OWLTestVocabulary.NotOwlFeatureTest)) {
            return this.doNotOWLFeatureTest(testCase);
        }
        if (testType.equals(OWLTestVocabulary.ImportLevelTest)) {
            return this.doImportLevelTest(testCase);
        }
        return 2;
    }

    public static void printStackTrace(Throwable e) {
        StackTraceElement[] ste = e.getStackTrace();
        System.err.println(e);
        if (ste.length > 25) {
            int i;
            for (i = 0; i < 15 && i < ste.length; ++i) {
                System.err.println("   " + ste[i]);
            }
            System.err.println("   ...");
            for (i = ste.length - 10; i < ste.length; ++i) {
                System.err.println("   " + ste[i]);
            }
        } else {
            for (int i = 0; i < ste.length; ++i) {
                System.err.println("   " + ste[i]);
            }
        }
    }
}

