/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.reasoner.BaseInfGraph;
import mx.com.hp.hpl.jena.reasoner.FGraph;
import mx.com.hp.hpl.jena.reasoner.Finder;
import mx.com.hp.hpl.jena.reasoner.InfGraph;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.StandardValidityReport;
import mx.com.hp.hpl.jena.reasoner.TriplePattern;
import mx.com.hp.hpl.jena.reasoner.ValidityReport;
import mx.com.hp.hpl.jena.reasoner.dig.TripleObjectFiller;
import mx.com.hp.hpl.jena.reasoner.dig.TripleSubjectFiller;
import mx.com.hp.hpl.jena.util.iterator.ClosableIterator;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.Filter;
import mx.com.hp.hpl.jena.util.iterator.Map1;
import mx.com.hp.hpl.jena.util.iterator.NullIterator;
import mx.com.hp.hpl.jena.util.iterator.SingletonIterator;
import mx.com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.WrappedIterator;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import mx.com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.jena.ATermToNodeMapper;
import org.mindswap.pellet.jena.DisjointMultiUnion;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.ModelExtractor;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.jena.PelletReasoner;
import org.mindswap.pellet.utils.SetUtils;

public class PelletInfGraph
extends BaseInfGraph
implements InfGraph {
    public static boolean DEBUG = false;
    private static final Set TBOX_PROPS = SetUtils.create(new Node[]{RDF.type.asNode(), RDFS.subClassOf.asNode(), RDFS.subPropertyOf.asNode(), OWL.equivalentClass.asNode(), OWL.equivalentProperty.asNode(), ReasonerVocabulary.directSubClassOf.asNode(), ReasonerVocabulary.directSubPropertyOf.asNode(), ReasonerVocabulary.directRDFType.asNode()});
    private OWLReasoner reasoner;
    private Graph deductionsGraph;
    private ATermToNodeMapper nodeMapper;
    private Filter keepOrdinaryTriples = new Filter(){

        public boolean accept(Object o) {
            Triple t = (Triple)o;
            Node p = t.getPredicate();
            boolean isDirect = p.equals((Object)ReasonerVocabulary.directRDFType.asNode()) || p.equals((Object)ReasonerVocabulary.directSubClassOf.asNode()) || p.equals((Object)ReasonerVocabulary.directSubPropertyOf.asNode());
            return !isDirect;
        }
    };

    public PelletInfGraph(Graph graph, PelletReasoner pellet) {
        super(graph, (Reasoner)pellet);
        this.reasoner = new OWLReasoner();
        this.nodeMapper = new ATermToNodeMapper();
        if (pellet.getSchema() != null) {
            DisjointMultiUnion union = new DisjointMultiUnion(graph);
            union.addGraph(pellet.getSchema());
            this.fdata = new FGraph((Graph)union);
        }
        this.rebind();
    }

    public ExtendedIterator findWithContinuation(TriplePattern pattern, Finder finder) {
        this.prepare();
        Node subject = pattern.getSubject().isVariable() ? Node.ANY : pattern.getSubject();
        Node predicate = pattern.getPredicate().isVariable() ? Node.ANY : pattern.getPredicate();
        Node object = pattern.getObject().isVariable() ? Node.ANY : pattern.getObject();
        ExtendedIterator i = this.findInABox(subject, predicate, object);
        if (i == null) {
            if (this.possibleInTBox(subject, predicate, object)) {
                this.classify();
                i = this.findInTBox(subject, predicate, object);
            } else {
                i = NullIterator.instance;
            }
        }
        if (finder != null) {
            i = i.andThen((ClosableIterator)finder.find(new TriplePattern(subject, predicate, object)));
        }
        return UniqueExtendedIterator.create((Iterator)i);
    }

    public Graph getSchemaGraph() {
        return ((PelletReasoner)this.getReasoner()).getSchema();
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public void prepare() {
        DisjointMultiUnion diff;
        if (this.isPrepared) {
            return;
        }
        if (DEBUG) {
            System.out.print("Preparing PelletInfGraph...");
        }
        KnowledgeBase kb = this.reasoner.getKB();
        if (DEBUG) {
            System.out.print("Computing changes...");
        }
        DisjointMultiUnion union = (DisjointMultiUnion)this.reasoner.getModel().getGraph();
        Graph rawGraph = this.getRawGraph();
        DisjointMultiUnion newUnion = new DisjointMultiUnion(rawGraph);
        DisjointMultiUnion disjointMultiUnion = diff = union.isStatementDeleted() ? null : newUnion.minus(union);
        if (diff != null) {
            if (DEBUG) {
                System.out.print("Loading diff...");
            }
            this.reasoner.load(diff);
        } else {
            if (DEBUG) {
                System.out.print("Reloading...");
            }
            this.reasoner.clear();
            this.reasoner.load(newUnion);
        }
        newUnion.releaseListeners();
        union.resetChanged();
        if (DEBUG) {
            System.out.print("Consistency...");
        }
        kb.isConsistent();
        this.deductionsGraph = null;
        if (DEBUG) {
            System.out.println("done.");
        }
        this.isPrepared = true;
    }

    public boolean isConsistent() {
        this.prepare();
        KnowledgeBase kb = this.reasoner.getKB();
        return kb.isConsistent();
    }

    public boolean isClassified() {
        return this.isPrepared && this.reasoner.getKB().isRealized();
    }

    public void classify() {
        this.prepare();
        KnowledgeBase kb = this.reasoner.getKB();
        if (this.deductionsGraph == null) {
            if (DEBUG) {
                System.out.print("Realizing PelletInfGraph...");
            }
            kb.realize();
            if (DEBUG) {
                System.out.print("Extract model...");
            }
            ModelExtractor extractor = this.reasoner.getModelExtractor();
            extractor.setVerbose(true);
            extractor.setIncludeDirects(true);
            Model extractedModel = extractor.extractModel();
            this.deductionsGraph = extractedModel.getGraph();
            if (DEBUG) {
                System.out.println("done.");
            }
        }
    }

    public Graph getDeductionsGraph() {
        this.classify();
        return this.deductionsGraph;
    }

    private boolean possibleInTBox(Node subject, Node predicate, Node object) {
        return !predicate.isURI() || TBOX_PROPS.contains(predicate);
    }

    private ExtendedIterator findInTBox(Node subject, Node predicate, Node object) {
        NullIterator i = NullIterator.instance;
        if (subject.isConcrete() && predicate.isURI() && object.isConcrete()) {
            KnowledgeBase kb = this.reasoner.getKB();
            String predURI = predicate.getURI();
            if (predURI.equals(OWL.disjointWith.getURI())) {
                if (kb.isDisjoint(JenaUtils.makeTerm(subject), JenaUtils.makeTerm(object))) {
                    i = new SingletonIterator((Object)new Triple(subject, predicate, object));
                }
            } else if (predURI.equals(OWL.complementOf.getURI())) {
                if (kb.isComplement(JenaUtils.makeTerm(subject), JenaUtils.makeTerm(object))) {
                    i = new SingletonIterator((Object)new Triple(subject, predicate, object));
                }
            } else {
                i = this.getDeductionsGraph().find(subject, predicate, object);
            }
        } else {
            i = this.getDeductionsGraph().find(subject, predicate, object);
        }
        if (!predicate.isURI()) {
            i = i.filterKeep(this.keepOrdinaryTriples);
        }
        return i;
    }

    private ExtendedIterator findInABox(Node subject, Node predicate, Node object) {
        Object iterator = NullIterator.instance;
        if (!predicate.isURI()) {
            return null;
        }
        ATermAppl s = JenaUtils.makeTerm(subject);
        ATermAppl p = JenaUtils.makeTerm(predicate);
        ATermAppl o = JenaUtils.makeTerm(object);
        String predURI = predicate.getURI();
        KnowledgeBase kb = this.reasoner.getKB();
        if (predURI.equals(RDF.type.getURI())) {
            if (!object.isConcrete() || !kb.isClass(o)) {
                iterator = null;
            } else if (subject.isConcrete()) {
                if (kb.isType(s, o)) {
                    iterator = new SingletonIterator((Object)new Triple(subject, predicate, object));
                }
            } else {
                List list = kb.retrieve(o);
                iterator = WrappedIterator.create(list.iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)new TripleSubjectFiller(predicate, object));
            }
            return iterator;
        }
        if (predURI.equals(OWL.sameAs.getURI())) {
            if (subject.isConcrete() && object.isConcrete() && kb.isSameAs(s, o)) {
                iterator = new SingletonIterator((Object)new Triple(subject, predicate, object));
            }
            return iterator;
        }
        if (predURI.equals(OWL.differentFrom.getURI())) {
            if (subject.isConcrete() && object.isConcrete() && kb.isDifferentFrom(s, o)) {
                iterator = new SingletonIterator((Object)new Triple(subject, predicate, object));
            }
            return iterator;
        }
        Role r = kb.getProperty(p);
        if (r == null || r.isAnnotationRole() || r.isOntologyRole()) {
            return null;
        }
        if (!subject.isConcrete() && !object.isConcrete()) {
            List candidates = kb.retrieveIndividualsWithProperty(p);
            Iterator i = candidates.iterator();
            while (i.hasNext()) {
                ATermAppl candidate = (ATermAppl)i.next();
                List list = kb.getPropertyValues(p, candidate);
                if (list.isEmpty()) continue;
                ExtendedIterator partial = WrappedIterator.create(list.iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)new TripleObjectFiller((Node)this.nodeMapper.map1(candidate), predicate));
                iterator = iterator.andThen((ClosableIterator)partial);
            }
        } else if (!subject.isConcrete()) {
            List list = kb.getIndividualsWithProperty(p, o);
            iterator = WrappedIterator.create(list.iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)new TripleSubjectFiller(predicate, object));
        } else if (!object.isConcrete()) {
            List list = kb.getPropertyValues(p, s);
            iterator = WrappedIterator.create(list.iterator()).mapWith((Map1)this.nodeMapper).mapWith((Map1)new TripleObjectFiller(subject, predicate));
        } else {
            iterator = kb.hasPropertyValue(s, p, o) ? new SingletonIterator((Object)new Triple(subject, predicate, object)) : NullIterator.instance;
        }
        return iterator;
    }

    protected boolean graphBaseContains(Triple pattern) {
        this.prepare();
        Node subject = pattern.getSubject().isVariable() ? Node.ANY : pattern.getSubject();
        Node predicate = pattern.getPredicate().isVariable() ? Node.ANY : pattern.getPredicate();
        Node object = pattern.getObject().isVariable() ? Node.ANY : pattern.getObject();
        Boolean contains = this.containedInTBox(subject, predicate, object);
        if (contains != null) {
            return contains;
        }
        contains = this.containedInABox(subject, predicate, object);
        if (contains != null) {
            return contains;
        }
        return this.getRawGraph().contains(pattern);
    }

    private Boolean containedInABox(Node subject, Node predicate, Node object) {
        if (!predicate.isURI()) {
            return null;
        }
        KnowledgeBase kb = this.reasoner.getKB();
        ATermAppl s = JenaUtils.makeTerm(subject);
        ATermAppl p = JenaUtils.makeTerm(predicate);
        ATermAppl o = JenaUtils.makeTerm(object);
        if (subject.isConcrete() && !kb.isIndividual(s)) {
            return null;
        }
        String predURI = predicate.getURI();
        if (predURI.equals(RDF.type.getURI())) {
            if (object.isConcrete() && !kb.isClass(o)) {
                return null;
            }
            if (subject.isConcrete()) {
                if (object.isConcrete()) {
                    return kb.isType(s, o) ? Boolean.TRUE : Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (object.isConcrete()) {
                return kb.hasIndividual(o) ? Boolean.TRUE : Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (object.isConcrete() && !kb.isIndividual(o)) {
            return null;
        }
        if (predURI.equals(OWL.sameAs.getURI())) {
            if (subject.isConcrete() && object.isConcrete()) {
                return kb.isSameAs(s, o) ? Boolean.TRUE : Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (predURI.equals(OWL.differentFrom.getURI())) {
            if (subject.isConcrete() && object.isConcrete()) {
                return kb.isDifferentFrom(s, o) ? Boolean.TRUE : Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        Role r = kb.getProperty(p);
        if (r == null || r.isAnnotationRole() || r.isOntologyRole()) {
            return null;
        }
        if (!subject.isConcrete() && !object.isConcrete()) {
            List candidates = kb.retrieveIndividualsWithProperty(p);
            return !candidates.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (!subject.isConcrete()) {
            ATermAppl invP = r.getInverse().getName();
            return kb.hasPropertyValue(o, invP, null) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (!object.isConcrete()) {
            return kb.hasPropertyValue(s, p, null) ? Boolean.TRUE : Boolean.FALSE;
        }
        return kb.hasPropertyValue(s, p, o) ? Boolean.TRUE : Boolean.FALSE;
    }

    private Boolean containedInTBox(Node subject, Node predicate, Node object) {
        if (!(subject.isURI() && predicate.isURI() && object.isURI())) {
            return null;
        }
        KnowledgeBase kb = this.reasoner.getKB();
        ATermAppl s = JenaUtils.makeTerm(subject);
        ATermAppl o = JenaUtils.makeTerm(object);
        String predURI = predicate.getURI();
        if (predURI.equals(RDF.type.getURI())) {
            if (object.equals((Object)OWL.Class.asNode()) || object.equals((Object)RDFS.Class.asNode())) {
                return kb.isClass(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)RDF.Property.asNode())) {
                return kb.isProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.ObjectProperty.asNode())) {
                return kb.isObjectProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.DatatypeProperty.asNode())) {
                return kb.isDatatypeProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.AnnotationProperty.asNode())) {
                return kb.isAnnotationProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.TransitiveProperty.asNode())) {
                return kb.isTransitiveProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.SymmetricProperty.asNode())) {
                return kb.isSymmetricProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.FunctionalProperty.asNode())) {
                return kb.isFunctionalProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (object.equals((Object)OWL.InverseFunctionalProperty.asNode())) {
                return kb.isInverseFunctionalProperty(s) ? Boolean.TRUE : Boolean.FALSE;
            }
            return null;
        }
        if (predURI.equals(RDFS.subClassOf.getURI())) {
            return kb.isSubClassOf(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(OWL.complementOf.getURI())) {
            return kb.isComplement(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(OWL.equivalentClass.getURI())) {
            return kb.isEquivalentClass(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(OWL.disjointWith.getURI())) {
            return kb.isDisjoint(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(OWL.equivalentProperty.getURI())) {
            return kb.isEquivalentProperty(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(RDFS.subPropertyOf.getURI())) {
            return kb.isSubPropertyOf(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(OWL.inverseOf.getURI())) {
            return kb.isInverse(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(RDFS.domain.getURI())) {
            return kb.hasDomain(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (predURI.equals(RDFS.range.getURI())) {
            return kb.hasRange(s, o) ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public OWLReasoner getOWLReasoner() {
        return this.reasoner;
    }

    public KnowledgeBase getKB() {
        return this.reasoner.getKB();
    }

    public void performAdd(Triple t) {
        this.fdata.getGraph().add(t);
        this.isPrepared = false;
    }

    public void performDelete(Triple t) {
        this.fdata.getGraph().delete(t);
        this.isPrepared = false;
    }

    public ValidityReport validate() {
        this.checkOpen();
        this.prepare();
        StandardValidityReport report = new StandardValidityReport();
        KnowledgeBase kb = this.reasoner.getKB();
        kb.setDoExplanation(true);
        boolean consistent = this.reasoner.isConsistent();
        kb.setDoExplanation(false);
        if (!consistent) {
            report.add(true, "KB is inconsistent!", kb.getExplanation());
        } else {
            Iterator i = kb.getClasses().iterator();
            while (i.hasNext()) {
                ATermAppl c = (ATermAppl)i.next();
                if (kb.isSatisfiable(c)) continue;
                String name = this.nodeMapper.map1(c).toString();
                report.add(false, "Unsatisfiable class", name);
            }
        }
        return report;
    }
}

