/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdql.Query;
import mx.com.hp.hpl.jena.rdql.QueryExecution;
import mx.com.hp.hpl.jena.rdql.QueryResults;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.jena.PelletInfGraph;

public class PelletQueryEngine
implements QueryExecution {
    private String query;
    private OWLReasoner reasoner;
    private Model source;
    private boolean initialized = false;

    public PelletQueryEngine(Query query) {
        this(query.toString(), query.getSource());
    }

    public PelletQueryEngine(String query, Model source) {
        this.query = query;
        this.source = source;
    }

    public void init() {
        if (!this.initialized) {
            Graph graph = this.source.getGraph();
            if (graph instanceof PelletInfGraph) {
                PelletInfGraph pelletInfGraph = (PelletInfGraph)this.source.getGraph();
                if (!pelletInfGraph.isPrepared()) {
                    pelletInfGraph.prepare();
                }
                this.reasoner = pelletInfGraph.getOWLReasoner();
            }
            if (this.reasoner == null) {
                this.reasoner = new OWLReasoner();
                this.reasoner.load(this.source);
            }
        }
        this.initialized = true;
    }

    public QueryResults exec() {
        this.init();
        QueryResults results = null;
        try {
            results = this.reasoner.runQuery(this.query);
        }
        catch (UnsupportedFeatureException e) {
            results = Query.exec((String)this.query, (Model)this.source);
        }
        return results;
    }

    public void abort() {
    }

    public void close() {
    }

    public static QueryResults exec(Query query) {
        return new PelletQueryEngine(query).exec();
    }
}

