/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdql.QueryResultsRewindable;
import mx.com.hp.hpl.jena.rdql.ResultBindingImpl;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.query.QueryResultBinding;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.QueryUtils;

public class PelletQueryResults
implements QueryResultsRewindable {
    private Model model;
    private List resultVars;
    private List varTerms;
    private QueryResults answers;
    private int index;
    private int size;

    public PelletQueryResults(QueryResults answers, Model model) {
        this.answers = answers;
        this.model = model;
        this.index = 0;
        this.size = answers.size();
        this.varTerms = answers.getResultVars();
    }

    public boolean hasNext() {
        return this.index < this.size;
    }

    public Object next() {
        QueryResultBinding binding = this.answers.get(this.index++);
        ResultBindingImpl result = new ResultBindingImpl();
        Iterator i = this.varTerms.iterator();
        while (i.hasNext()) {
            ATermAppl var = (ATermAppl)i.next();
            String varName = QueryUtils.getVarName(var);
            ATermAppl value = binding.getValue(var);
            RDFNode node = JenaUtils.makeRDFNode(value, this.model);
            result.add(varName, node);
        }
        return result;
    }

    public void close() {
    }

    public int getRowNumber() {
        return this.index;
    }

    public List getResultVars() {
        if (this.resultVars == null) {
            this.resultVars = new ArrayList(this.varTerms.size());
            Iterator i = this.varTerms.iterator();
            while (i.hasNext()) {
                ATermAppl var = (ATermAppl)i.next();
                String varName = QueryUtils.getVarName(var);
                this.resultVars.add(varName);
            }
        }
        return this.resultVars;
    }

    public List getAll() {
        ArrayList<Object> all = new ArrayList<Object>();
        while (this.hasNext()) {
            all.add(this.next());
        }
        this.close();
        return all;
    }

    public void rewind() {
        this.index = 0;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove from QueryResults");
    }
}

