/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.output.OutputFormatter;

public class TableData {
    List data;
    List colNames;
    int[] colWidths = null;
    String colSep = " | ";

    public TableData(List data, List colNames) {
        this.data = data;
        this.colNames = colNames;
        this.colWidths = new int[colNames.size()];
    }

    public TableData(List colNames) {
        this.data = new ArrayList();
        this.colNames = colNames;
        this.colWidths = new int[colNames.size()];
    }

    public void addRow(List row) {
        if (row.size() != this.colNames.size()) {
            throw new IllegalArgumentException("Row has " + row.size() + " elements but table has " + this.colNames.size() + " columns");
        }
        this.data.add(row);
    }

    public void print(OutputFormatter out) {
        this.print(out.getWriter(), out.isFormatHTML());
    }

    public void print(OutputStream writer) {
        this.print(new PrintWriter(writer), false);
    }

    public void print(Writer writer) {
        this.print(writer, false);
    }

    public void print(OutputStream writer, boolean formatHTML) {
        this.print(new PrintWriter(writer), formatHTML);
    }

    public void print(Writer writer, boolean formatHTML) {
        if (formatHTML) {
            this.printHTML(writer);
        } else {
            this.printText(writer);
        }
    }

    private void printHTML(Writer writer) {
        PrintWriter pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        pw.println("<table border=1>");
        pw.println("  <tr>");
        for (int col = 0; col < this.colNames.size(); ++col) {
            String s = (String)this.colNames.get(col);
            pw.print("    <th>");
            pw.print(s);
            pw.print("</th>");
            pw.println();
        }
        pw.println("  </tr>");
        Iterator i = this.data.iterator();
        while (i.hasNext()) {
            Collection rowData = (Collection)i.next();
            pw.println("  <tr>");
            Iterator j = rowData.iterator();
            int col = 0;
            while (j.hasNext()) {
                Object value = j.next();
                String s = value == null ? "<null>" : value.toString();
                pw.print("    <td>");
                pw.print(s);
                pw.print("</td>");
                pw.println();
                ++col;
            }
            pw.println("  </tr>");
        }
        pw.println("</table>");
        pw.flush();
    }

    private void printText(Writer writer) {
        PrintWriter pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.computeHeaderWidths();
        this.computeRowWidths();
        int lineWidth = this.computeLineWidth();
        int numCols = this.colNames.size();
        String[] row = new String[numCols];
        for (int col = 0; col < row.length; ++col) {
            row[col] = this.colNames.get(col).toString();
        }
        this.printRow(pw, row);
        for (int i = 0; i < lineWidth; ++i) {
            pw.print('=');
        }
        pw.println();
        Iterator i = this.data.iterator();
        while (i.hasNext()) {
            Collection rowData = (Collection)i.next();
            Iterator j = rowData.iterator();
            int col = 0;
            while (j.hasNext()) {
                Object value = j.next();
                row[col] = value == null ? "<null>" : value.toString();
                ++col;
            }
            this.printRow(pw, row);
        }
        pw.flush();
    }

    private void printRow(PrintWriter pw, String[] row) {
        for (int col = 0; col < row.length; ++col) {
            String s = row[col];
            int pad = this.colWidths[col];
            StringBuffer sbuff = new StringBuffer(120);
            if (col > 0) {
                sbuff.append(this.colSep);
            }
            sbuff.append(s);
            for (int j = 0; j < pad - s.length(); ++j) {
                sbuff.append(' ');
            }
            pw.print(sbuff);
        }
        pw.println();
    }

    private int computeLineWidth() {
        int numCols = this.colWidths.length;
        int lineWidth = 0;
        for (int i = 0; i < numCols; ++i) {
            lineWidth += this.colWidths[i];
        }
        return lineWidth += (numCols - 1) * this.colSep.length();
    }

    private void computeHeaderWidths() {
        Iterator k = this.colNames.iterator();
        int col = 0;
        while (k.hasNext()) {
            Object value = k.next();
            String str = value == null ? "<null>" : value.toString();
            this.colWidths[col] = str.length();
            ++col;
        }
    }

    private void computeRowWidths() {
        Iterator i = this.data.iterator();
        while (i.hasNext()) {
            Collection rowData = (Collection)i.next();
            Iterator j = rowData.iterator();
            int col = 0;
            while (j.hasNext()) {
                String str;
                Object value = j.next();
                String string = str = value == null ? "<null>" : value.toString();
                if (this.colWidths[col] < str.length()) {
                    this.colWidths[col] = str.length();
                }
                ++col;
            }
        }
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColCount() {
        return this.colNames.size();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.printText(sw);
        return sw.toString();
    }
}

