/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.output;

import aterm.ATermAppl;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mindswap.pellet.Taxonomy;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.utils.ATermUtils;

public class TaxonomyPrinter {
    static final String INDENT = "  ";
    private Taxonomy taxonomy;
    private OutputFormatter out;

    public void print(Taxonomy taxonomy) {
        this.print(taxonomy, new OutputFormatter());
    }

    public void print(Taxonomy taxonomy, OutputFormatter out) {
        this.taxonomy = taxonomy;
        this.out = out;
        out.println();
        this.printTree();
        out.println();
        out.flush();
    }

    private void printTree() {
        LinkedHashSet<ATermAppl> top = new LinkedHashSet<ATermAppl>();
        top.add(ATermUtils.TOP);
        top.addAll(this.taxonomy.getEquivalentClasses(ATermUtils.TOP));
        this.out.printHTML("<ul>");
        this.printTree(top, " ");
        this.out.printHTML("</ul>");
        LinkedHashSet<ATermAppl> bottom = new LinkedHashSet<ATermAppl>();
        bottom.add(ATermUtils.BOTTOM);
        bottom.addAll(this.taxonomy.getEquivalentClasses(ATermUtils.BOTTOM));
        if (bottom.size() > 1) {
            this.out.printHTML("<ul>");
            this.printNode(bottom, " ");
            this.out.printHTML("</ul>");
        }
    }

    private void printTree(Set set, String indent) {
        if (set.contains(ATermUtils.BOTTOM)) {
            return;
        }
        this.printNode(set, indent);
        this.out.printHTML("<ul>");
        ATermAppl c = (ATermAppl)set.iterator().next();
        Set subs = this.taxonomy.getSubClasses(c, true);
        Iterator j = subs.iterator();
        while (j.hasNext()) {
            Set eqs = (Set)j.next();
            if (eqs.contains(c)) continue;
            this.printTree(eqs, indent + "   ");
        }
        this.out.printHTML("</ul>");
    }

    private void printNode(Set set, String indent) {
        if (this.out.isFormatHTML()) {
            this.out.printHTML("<li>");
        } else {
            this.out.print(indent);
        }
        Iterator i = set.iterator();
        ATermAppl c = (ATermAppl)i.next();
        this.printURI(this.out, c);
        while (i.hasNext()) {
            this.out.print(" = ");
            this.printURI(this.out, (ATermAppl)i.next());
        }
        Set instances = this.taxonomy.getInstances(c, true);
        if (instances.size() > 0) {
            this.out.print(" - (");
            boolean printed = false;
            int anonCount = 0;
            Iterator ins = instances.iterator();
            int k = 0;
            while (ins.hasNext()) {
                ATermAppl x = (ATermAppl)ins.next();
                if (x.getName().startsWith("bNode")) {
                    ++anonCount;
                } else {
                    if (printed) {
                        this.out.print(", ");
                    } else {
                        printed = true;
                    }
                    this.printURI(this.out, x);
                }
                ++k;
            }
            if (anonCount > 0) {
                if (printed) {
                    this.out.print(", ");
                }
                this.out.print(anonCount + " Anonymous Individual");
                if (anonCount > 0) {
                    this.out.print("s");
                }
            }
            this.out.print(")");
        }
        if (this.out.isFormatHTML()) {
            this.out.printHTML("</li>");
        } else {
            this.out.println();
        }
    }

    private void printURI(OutputFormatter out, ATermAppl c) {
        String uri = c.getName();
        if (c.equals(ATermUtils.TOP)) {
            uri = "http://www.w3.org/2002/07/owl#Thing";
        } else if (c.equals(ATermUtils.BOTTOM)) {
            uri = "http://www.w3.org/2002/07/owl#Nothing";
        }
        out.printURI(uri);
    }
}

