/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import aterm.ATermAppl;
import aterm.ATermList;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.output.ATermVisitor;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLProperty;

public class ATermConverter
extends ATermBaseVisitor
implements ATermVisitor {
    private OWLOntology ont;
    private OWLDataFactory factory;
    private OWLObject obj;
    private Set set;

    public ATermConverter(OWLOntology ont) throws OWLException {
        this.ont = ont;
        this.factory = ont.getOWLDataFactory();
    }

    public OWLObject getResult() {
        return this.obj;
    }

    public void visitTerm(ATermAppl term) {
        try {
            URI uri = new URI(term.getName());
            this.obj = this.ont.getClass(uri);
            if (this.obj == null) {
                this.obj = this.ont.getObjectProperty(uri);
            }
            if (this.obj == null) {
                this.obj = this.ont.getDataProperty(uri);
            }
            if (this.obj == null) {
                this.obj = this.ont.getIndividual(uri);
            }
            if (this.obj == null) {
                this.obj = this.ont.getDatatype(uri);
            }
        }
        catch (Exception e) {
            throw new InternalReasonerException(e);
        }
    }

    public void visitAnd(ATermAppl term) {
        this.visitList((ATermList)term.getArgument(0));
        try {
            this.obj = this.factory.getOWLAnd(this.set);
        }
        catch (OWLException e) {
            throw new InternalReasonerException((Exception)((Object)e));
        }
    }

    public void visitOr(ATermAppl term) {
        this.visitList((ATermList)term.getArgument(0));
        try {
            this.obj = this.factory.getOWLOr(this.set);
        }
        catch (OWLException e) {
            throw new InternalReasonerException((Exception)((Object)e));
        }
    }

    public void visitNot(ATermAppl term) {
        this.visit((ATermAppl)term.getArgument(0));
        try {
            this.obj = this.factory.getOWLNot((OWLDescription)this.obj);
        }
        catch (OWLException e) {
            throw new InternalReasonerException((Exception)((Object)e));
        }
    }

    public void visitSome(ATermAppl term) {
        this.visitTerm((ATermAppl)term.getArgument(0));
        OWLProperty prop = (OWLProperty)this.obj;
        this.visit((ATermAppl)term.getArgument(1));
        try {
            if (prop instanceof OWLObjectProperty) {
                OWLDescription desc = (OWLDescription)this.obj;
                this.obj = this.factory.getOWLObjectSomeRestriction((OWLObjectProperty)prop, desc);
            } else {
                OWLDataType datatype = (OWLDataType)this.obj;
                this.obj = this.factory.getOWLDataSomeRestriction((OWLDataProperty)prop, (OWLDataRange)datatype);
            }
        }
        catch (OWLException e) {
            throw new InternalReasonerException((Exception)((Object)e));
        }
    }

    public void visitAll(ATermAppl term) {
        this.visitTerm((ATermAppl)term.getArgument(0));
        OWLProperty prop = (OWLProperty)this.obj;
        this.visit((ATermAppl)term.getArgument(1));
        try {
            if (prop instanceof OWLObjectProperty) {
                OWLDescription desc = (OWLDescription)this.obj;
                this.obj = this.factory.getOWLObjectAllRestriction((OWLObjectProperty)prop, desc);
            } else {
                OWLDataType datatype = (OWLDataType)this.obj;
                this.obj = this.factory.getOWLDataAllRestriction((OWLDataProperty)prop, (OWLDataRange)datatype);
            }
        }
        catch (OWLException e) {
            throw new InternalReasonerException((Exception)((Object)e));
        }
    }

    public void visitMin(ATermAppl term) {
        this.visitTerm((ATermAppl)term.getArgument(0));
        OWLProperty prop = (OWLProperty)this.obj;
        int cardinality = Integer.parseInt(((Object)term.getArgument(1)).toString());
        try {
            this.obj = prop instanceof OWLObjectProperty ? this.factory.getOWLObjectCardinalityAtLeastRestriction((OWLObjectProperty)prop, cardinality) : this.factory.getOWLDataCardinalityAtLeastRestriction((OWLDataProperty)prop, cardinality);
        }
        catch (OWLException e) {
            throw new InternalReasonerException((Exception)((Object)e));
        }
    }

    public void visitMax(ATermAppl term) {
        this.visitTerm((ATermAppl)term.getArgument(0));
        OWLProperty prop = (OWLProperty)this.obj;
        int cardinality = Integer.parseInt(((Object)term.getArgument(1)).toString());
        try {
            this.obj = prop instanceof OWLObjectProperty ? this.factory.getOWLObjectCardinalityAtMostRestriction((OWLObjectProperty)prop, cardinality) : this.factory.getOWLDataCardinalityAtMostRestriction((OWLDataProperty)prop, cardinality);
        }
        catch (OWLException e) {
            throw new InternalReasonerException((Exception)((Object)e));
        }
    }

    public void visitHasValue(ATermAppl term) {
        this.visitTerm((ATermAppl)term.getArgument(0));
        OWLProperty prop = (OWLProperty)this.obj;
        this.visit((ATermAppl)term.getArgument(1));
        try {
            if (prop instanceof OWLObjectProperty) {
                OWLIndividual ind = (OWLIndividual)this.obj;
                this.obj = this.factory.getOWLObjectValueRestriction((OWLObjectProperty)prop, ind);
            } else {
                OWLDataValue dataVal = (OWLDataValue)this.obj;
                this.obj = this.factory.getOWLDataValueRestriction((OWLDataProperty)prop, dataVal);
            }
        }
        catch (OWLException e) {
            throw new InternalReasonerException((Exception)((Object)e));
        }
    }

    public void visitValue(ATermAppl term) {
    }

    public void visitOneOf(ATermAppl term) {
        this.visitList((ATermList)term.getArgument(0));
        try {
            this.obj = this.factory.getOWLEnumeration(this.set);
        }
        catch (OWLException e) {
            throw new InternalReasonerException((Exception)((Object)e));
        }
    }

    public void visitLiteral(ATermAppl term) {
        try {
            String lexValue = ((ATermAppl)term.getArgument(0)).toString();
            String lang = ((ATermAppl)term.getArgument(1)).toString();
            URI dtypeURI = new URI(((ATermAppl)term.getArgument(2)).toString());
            this.obj = this.ont.getOWLDataFactory().getOWLConcreteData(dtypeURI, lang, (Object)lexValue);
        }
        catch (Exception e) {
            throw new InternalReasonerException(e);
        }
    }

    public void visitList(ATermList list) {
        HashSet<OWLObject> elements = new HashSet<OWLObject>();
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            this.visit(term);
            elements.add(this.obj);
            list = list.getNext();
        }
        this.set = elements;
    }

    public void visitSubClass(ATermAppl term) {
        try {
            ATermAppl sub = (ATermAppl)term.getArgument(0);
            ATermAppl sup = (ATermAppl)term.getArgument(1);
            this.visit(sub);
            OWLDescription subDesc = (OWLDescription)this.obj;
            this.visit(sup);
            OWLDescription supDesc = (OWLDescription)this.obj;
            this.obj = this.ont.getOWLDataFactory().getOWLSubClassAxiom(subDesc, supDesc);
        }
        catch (OWLException e) {
            throw new InternalReasonerException((Exception)((Object)e));
        }
    }
}

