/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.compose.MultiUnion;
import mx.com.hp.hpl.jena.ontology.OntModel;
import mx.com.hp.hpl.jena.ontology.OntModelSpec;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdql.Query;
import mx.com.hp.hpl.jena.rdql.QueryResults;
import mx.com.hp.hpl.jena.rdql.ResultBinding;
import org.mindswap.pellet.jena.NodeFormatter;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletQueryEngine;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.utils.FileUtils;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public class PelletQueryTest {
    public static void main(String[] args) throws Exception {
        PelletInfGraph.DEBUG = true;
        Timers timers = new Timers();
        String queryStr = args[0].trim();
        if (!queryStr.substring(0, 6).equalsIgnoreCase("SELECT")) {
            queryStr = FileUtils.readFile(new File(args[0]));
        }
        Query query = new Query(queryStr);
        int limit = args.length > 1 ? Integer.parseInt(args[1]) : Integer.MAX_VALUE;
        Timer timer = timers.startTimer("parsing");
        Model[] models = null;
        String in = query.getSourceURL();
        URL url = new URL(in);
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getPath());
            if (file.exists()) {
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    models = new Model[files.length > limit ? limit : files.length];
                    for (int j = 0; j < models.length; ++j) {
                        models[j] = ModelFactory.createDefaultModel();
                        String fileURI = files[j].toURI().toString();
                        System.out.println("Reading file " + fileURI);
                        models[j].read(fileURI);
                    }
                } else {
                    models = new Model[]{ModelFactory.createDefaultModel()};
                    models[0].read(file.toURI().toString());
                }
            }
        } else {
            models = new Model[]{ModelFactory.createDefaultModel()};
            models[0].read(in);
        }
        MultiUnion union = new MultiUnion();
        for (int j = 0; j < models.length; ++j) {
            union.addGraph(models[j].getGraph());
        }
        timer.stop();
        timer = timers.startTimer("prepare");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)ModelFactory.createModelForGraph((Graph)union));
        query.setSource((Model)model);
        model.prepare();
        timer.stop();
        timer = timers.startTimer("query");
        QueryResults results = PelletQueryEngine.exec(query);
        timer.stop();
        timer = timers.startTimer("format");
        NodeFormatter formatter = new NodeFormatter((Model)model);
        PelletQueryTest.addDefaultQNames(formatter.getQNames());
        List resultVars = query.getResultVars();
        ArrayList data = new ArrayList();
        while (results.hasNext()) {
            ResultBinding binding = (ResultBinding)results.next();
            ArrayList<String> formattedBinding = new ArrayList<String>();
            for (int i = 0; i < resultVars.size(); ++i) {
                String var = (String)resultVars.get(i);
                RDFNode result = (RDFNode)binding.get(var);
                formattedBinding.add(formatter.format(result));
            }
            if (data.contains(formattedBinding)) continue;
            data.add(formattedBinding);
        }
        TableData table = new TableData(data, resultVars);
        table.print(System.out);
        timer.stop();
        timers.mainTimer.stop();
        System.out.println();
        System.out.println("# of Files     : " + models.length);
        System.out.println("# of Results   : " + table.getRowCount());
        System.out.println();
        timers.print(true);
    }

    private static void addDefaultQNames(QNameProvider qnames) {
        qnames.setMapping("tce-service", "http://www.flacp.fujitsulabs.com/tce/ontologies/2004/03/service.owl#");
        qnames.setMapping("tce-object", "http://www.flacp.fujitsulabs.com/tce/ontologies/2004/03/object.owl#");
        String owls = "http://www.daml.org/services/owl-s/";
        String[] versions = new String[]{"0.9", "1.0", "1.1"};
        String[] add = new String[]{"-0.9", "-1.0", ""};
        String[] files = new String[]{"Service", "Profile", "Process", "Grounding"};
        for (int version = 0; version < versions.length; ++version) {
            for (int file = 0; file < files.length; ++file) {
                String prefix = files[file].toLowerCase() + add[version];
                String uri = owls + versions[version] + "/" + files[file] + ".owl#";
                qnames.setMapping(prefix, uri);
            }
        }
    }
}

