/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query;

import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryExec;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.impl.DistVarsQueryExec;
import org.mindswap.pellet.query.impl.JenaRDQLParser;
import org.mindswap.pellet.query.impl.NoDistVarsQueryExec;
import org.mindswap.pellet.query.impl.OptimizedQueryExec;
import org.mindswap.pellet.query.impl.SimpleQueryExec;
import org.mindswap.pellet.utils.Timer;

public class QueryEngine {
    public static boolean DEBUG = false;
    private static DistVarsQueryExec distVars = new DistVarsQueryExec();
    private static OptimizedQueryExec optimized = new OptimizedQueryExec();
    private static SimpleQueryExec simple = new SimpleQueryExec();
    private static NoDistVarsQueryExec noVars = new NoDistVarsQueryExec();
    private static QueryExec[] queryExecs = new QueryExec[]{distVars, optimized, simple, noVars};

    public static QueryResults exec(String queryStr, KnowledgeBase kb) {
        Timer t = kb.timers.startTimer("queryParse");
        JenaRDQLParser parser = new JenaRDQLParser();
        Query query = parser.parse(queryStr, kb);
        t.stop();
        return QueryEngine.exec(query);
    }

    public static QueryResults exec(Query query) {
        for (int i = 0; i < queryExecs.length; ++i) {
            if (!queryExecs[i].supports(query)) continue;
            return queryExecs[i].exec(query);
        }
        throw new InternalReasonerException("Cannot determine which query engine to use");
    }

    public static boolean execBoolean(Query query) {
        return noVars.execBoolean(query);
    }
}

