/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.DisjointMultiUnion;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryExec;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.QueryUtils;
import org.mindswap.pellet.query.impl.DistVarsQueryExec;
import org.mindswap.pellet.query.impl.OptimizedQueryExec;
import org.mindswap.pellet.query.impl.SimpleQueryExec;
import org.mindswap.pellet.utils.FileUtils;

public class RDQLTest {
    public static void main(String[] args) throws Exception {
        int j;
        String queryStr = args[0].trim();
        if (!queryStr.substring(0, 6).equalsIgnoreCase("SELECT")) {
            queryStr = FileUtils.readFile(new File(args[0]));
        }
        mx.com.hp.hpl.jena.rdql.Query query = new mx.com.hp.hpl.jena.rdql.Query(queryStr);
        int limit = 5;
        Model[] models = null;
        String in = query.getSourceURL();
        URL url = new URL(in);
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getPath());
            if (file.exists()) {
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    models = new Model[files.length > limit ? limit : models.length];
                    for (j = 0; j < models.length; ++j) {
                        models[j] = ModelFactory.createDefaultModel();
                        String fileURI = files[j].toURI().toString();
                        System.out.println("Reading file " + fileURI);
                        models[j].read(fileURI);
                    }
                } else {
                    models = new Model[]{ModelFactory.createDefaultModel()};
                    models[0].read(file.toURI().toString());
                }
            }
        } else {
            models = new Model[]{ModelFactory.createDefaultModel()};
            models[0].read(in);
        }
        OWLReasoner reasoner = new OWLReasoner();
        DisjointMultiUnion union = new DisjointMultiUnion();
        for (j = 0; j < models.length; ++j) {
            union.addGraph(models[j].getGraph());
        }
        reasoner.load(ModelFactory.createModelForGraph((Graph)union));
        KnowledgeBase kb = reasoner.getKB();
        List<String> cols = Arrays.asList("Name", "Supports", "Size", "Consistency", "Time");
        TableData table = new TableData(cols);
        Query newQuery = QueryUtils.parse(queryStr, kb);
        table.addRow(RDQLTest.testNewEngine(new DistVarsQueryExec(), newQuery));
        table.addRow(RDQLTest.testNewEngine(new OptimizedQueryExec(), newQuery));
        table.addRow(RDQLTest.testNewEngine(new SimpleQueryExec(), newQuery));
        System.out.println(queryStr);
        System.out.println();
        System.out.println(table);
    }

    public static List testNewEngine(QueryExec queryExec, Query q) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(RDQLTest.getClassName(queryExec));
        System.out.println("Running query with NEW " + queryExec.getClass().getName());
        boolean supports = queryExec.supports(q);
        System.out.println("Supports " + supports);
        QueryResults results = null;
        long time = -1L;
        int size = -1;
        long satCount = -1L;
        try {
            satCount = q.getKB().getABox().consistencyCount;
            long start = System.currentTimeMillis();
            results = queryExec.exec(q);
            time = System.currentTimeMillis() - start;
            satCount = q.getKB().getABox().consistencyCount - satCount;
            System.out.println("Size " + results.size());
            System.out.println(results);
            size = results.size();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        System.out.println("Time " + time);
        System.out.println();
        list.add(new Boolean(supports));
        list.add(new Integer(size));
        list.add(new Long(satCount));
        list.add(new Long(time));
        return list;
    }

    public static String getClassName(Object obj) {
        String name = obj.getClass().getName();
        int index = name.lastIndexOf(".");
        return name.substring(index + 1);
    }
}

