/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.RDFSLiteral;
import org.mindswap.pellet.datatypes.XSDDecimal;
import org.mindswap.pellet.datatypes.XSDString;

public class DConstraint {
    private ATerm var;
    private String op;
    private Object val;
    private Datatype type;
    boolean forced;

    public DConstraint(ATermAppl var, String op, Object val) {
        this.var = var;
        this.op = op;
        this.val = val;
        this.forced = false;
        if (this.op.equals(">")) {
            this.type = XSDDecimal.instance.deriveByRestriction("minExclusive", val.toString());
        } else if (op.equals("<")) {
            this.type = XSDDecimal.instance.deriveByRestriction("maxExclusive", val.toString());
        } else if (op.equals(">=")) {
            this.type = XSDDecimal.instance.deriveByRestriction("minInclusive", val.toString());
        } else if (op.equals("<=")) {
            this.type = XSDDecimal.instance.deriveByRestriction("maxInclusive", val.toString());
        } else if (op.equals("==")) {
            AtomicDatatype max = (AtomicDatatype)XSDDecimal.instance.deriveByRestriction("maxInclusive", val.toString());
            this.type = max.intersection((AtomicDatatype)XSDDecimal.instance.deriveByRestriction("minInclusive", val.toString()));
        } else if (op.equalsIgnoreCase("langEq")) {
            this.type = XSDString.instance.deriveByRestriction("xml:lang", val.toString().replaceAll("\"", ""));
            this.forced = true;
        } else {
            System.err.println("WARNING: Cannot handle the RDQL constraint ?" + var + " " + op + " " + val);
            this.type = RDFSLiteral.instance;
        }
    }

    public boolean isForced() {
        return this.forced;
    }

    public Datatype getDerivedDatatype() {
        return this.type;
    }

    public String getOp() {
        return this.op;
    }

    public Object getVal() {
        return this.val;
    }

    public ATerm getVar() {
        return this.var;
    }

    public void setOp(String string) {
        this.op = string;
    }

    public void setVal(Object object) {
        this.val = object;
    }

    public void setVar(ATerm term) {
        this.var = term;
    }

    public String toString() {
        return ((Object)this.var).toString() + " " + this.op + " " + this.val.toString();
    }
}

