/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermFactory;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.pure.PureFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.datatypes.StringValue;

public class ATermUtils {
    public static final String NOT = "not";
    public static final String AND = "and";
    public static final String OR = "or";
    public static final String SOME = "some";
    public static final String ALL = "all";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String CARD = "card";
    public static final String VALUE = "value";
    public static final String INV = "inv";
    public static final String SUB = "sub";
    public static final String SAME = "same";
    private static final ATermFactory factory = new PureFactory();
    public static final AFun LITFUN = factory.makeAFun("literal", 3, false);
    public static final AFun ANDFUN = factory.makeAFun("and", 1, false);
    public static final AFun ORFUN = factory.makeAFun("or", 1, false);
    public static final AFun SOMEFUN = factory.makeAFun("some", 2, false);
    public static final AFun ALLFUN = factory.makeAFun("all", 2, false);
    public static final AFun NOTFUN = factory.makeAFun("not", 1, false);
    public static final AFun MAXFUN = factory.makeAFun("max", 2, false);
    public static final AFun MINFUN = factory.makeAFun("min", 2, false);
    public static final AFun CARDFUN = factory.makeAFun("card", 2, false);
    public static final AFun VALUEFUN = factory.makeAFun("value", 1, false);
    public static final AFun INVFUN = factory.makeAFun("inv", 1, false);
    public static final AFun SUBFUN = factory.makeAFun("sub", 2, false);
    public static final AFun SAMEFUN = factory.makeAFun("same", 2, false);
    public static final AFun VARFUN = factory.makeAFun("var", 1, false);
    public static final AFun TYPEFUN = factory.makeAFun("type", 2, false);
    public static final AFun IPFUN = factory.makeAFun("iptriple", 3, false);
    public static final AFun DPFUN = factory.makeAFun("dptriple", 3, false);
    public static final ATermAppl EMPTY = ATermUtils.makeTermAppl("");
    public static final ATermList EMPTY_LIST = factory.makeList();
    public static final ATermAppl TOP = ATermUtils.makeTermAppl("_TOP_");
    public static final ATermAppl BOTTOM = ATermUtils.makeNot(TOP);
    public static final ATermInt ONE = factory.makeInt(1);
    public static StringComparator stringComparator = new StringComparator();
    public static ATermComparator comparator = new ATermComparator();

    public static ATermFactory getFactory() {
        return factory;
    }

    public static ATermAppl makeLiteral(Literal aboxLiteral) {
        ATermAppl literalValue;
        Object javaValue = aboxLiteral.getValue();
        if (javaValue instanceof StringValue) {
            StringValue strVal = (StringValue)javaValue;
            String lexicalValue = strVal.getValue();
            String lang = strVal.getLang();
            literalValue = lang.equals("") ? ATermUtils.makePlainLiteral(lexicalValue) : ATermUtils.makePlainLiteral(lexicalValue, lang);
        } else {
            String lexicalValue = javaValue.toString();
            Datatype datatype = aboxLiteral.getDatatype();
            DatatypeReasoner dtReasoner = aboxLiteral.getABox().getDatatypeReasoner();
            String datatypeURI = dtReasoner.getDatatypeURI(datatype);
            if (datatypeURI == null) {
                datatypeURI = dtReasoner.defineDatatype(datatype);
            }
            literalValue = ATermUtils.makeTypedLiteral(lexicalValue, datatypeURI);
        }
        return literalValue;
    }

    public static ATermAppl makePlainLiteral(String value) {
        return factory.makeAppl(LITFUN, ATermUtils.makeTermAppl(value), EMPTY, EMPTY);
    }

    public static ATermAppl makePlainLiteral(String value, String lang) {
        return factory.makeAppl(LITFUN, ATermUtils.makeTermAppl(value), ATermUtils.makeTermAppl(lang), EMPTY);
    }

    public static ATermAppl makeTypedLiteral(String value, String dt) {
        return factory.makeAppl(LITFUN, ATermUtils.makeTermAppl(value), EMPTY, ATermUtils.makeTermAppl(dt));
    }

    public static ATermAppl makeTermAppl(String name) {
        return factory.makeAppl(factory.makeAFun(name, 0, false));
    }

    public static ATermAppl makeTermAppl(AFun fun, ATerm[] args) {
        return factory.makeAppl(fun, args);
    }

    public static ATermAppl makeNot(ATerm c) {
        return factory.makeAppl(NOTFUN, c);
    }

    public static ATerm term(String str) {
        return factory.parse(str);
    }

    public static ATermList negate(ATermList list) {
        if (list.isEmpty()) {
            return list;
        }
        ATermAppl a = (ATermAppl)list.getFirst();
        a = ATermUtils.isNot(a) ? (ATermAppl)a.getArgument(0) : ATermUtils.makeNot(a);
        ATermList result = ATermUtils.makeList(a, ATermUtils.negate(list.getNext()));
        return result;
    }

    public static final ATermAppl negate(ATermAppl a) {
        return ATermUtils.isNot(a) ? (ATermAppl)a.getArgument(0) : ATermUtils.makeNot(a);
    }

    public static final ATermAppl makeVar(String name) {
        return factory.makeAppl(VARFUN, ATermUtils.makeTermAppl(name));
    }

    public static final ATermAppl makeVar(ATermAppl name) {
        return factory.makeAppl(VARFUN, name);
    }

    public static final ATermAppl makeValue(ATerm c) {
        return factory.makeAppl(VALUEFUN, c);
    }

    public static final ATermAppl makeInv(ATermAppl r) {
        return factory.makeAppl(INVFUN, r);
    }

    public static final ATermAppl makeSub(ATerm a, ATerm b) {
        return factory.makeAppl(SUBFUN, a, b);
    }

    public static final ATermAppl makeSame(ATerm a, ATerm b) {
        return factory.makeAppl(SAMEFUN, a, b);
    }

    public static final ATermAppl makeAnd(ATerm c1, ATerm c2) {
        return ATermUtils.makeAnd(ATermUtils.makeList(c2).insert(c1));
    }

    public static ATermAppl makeAnd(ATermList list) {
        if (list == null || list.isEmpty()) {
            return BOTTOM;
        }
        if (list.getNext().isEmpty()) {
            return (ATermAppl)list.getFirst();
        }
        return factory.makeAppl(ANDFUN, list);
    }

    public static final ATermAppl makeOr(ATermAppl c1, ATermAppl c2) {
        return ATermUtils.makeOr(ATermUtils.makeList(c2).insert(c1));
    }

    public static ATermAppl makeOr(ATermList list) {
        if (list == null || list.isEmpty()) {
            return BOTTOM;
        }
        if (list.getNext().isEmpty()) {
            return (ATermAppl)list.getFirst();
        }
        return factory.makeAppl(ORFUN, list);
    }

    public static final ATermAppl makeAllValues(ATerm r, ATerm c) {
        return factory.makeAppl(ALLFUN, r, c);
    }

    public static final ATermAppl makeSomeValues(ATerm r, ATerm c) {
        ATermUtils.assertTrue(c instanceof ATermAppl);
        return factory.makeAppl(SOMEFUN, r, c);
    }

    public static final ATermAppl makeDisplayCard(ATerm r, int n) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(CARDFUN, r, factory.makeInt(n));
    }

    public static final ATermAppl makeDisplayMax(ATerm r, int n) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(MAXFUN, r, factory.makeInt(n));
    }

    public static final ATermAppl makeDisplayMin(ATerm r, int n) {
        ATermUtils.assertTrue(n >= 0);
        return factory.makeAppl(MINFUN, r, factory.makeInt(n));
    }

    public static final ATermAppl makeCard(ATerm r, int n) {
        ATermAppl max = ATermUtils.makeMax(r, n);
        if (n == 0) {
            return max;
        }
        ATermAppl min = ATermUtils.makeMin(r, n);
        return ATermUtils.makeAnd(min, max);
    }

    public static final ATermAppl makeMax(ATerm r, int n) {
        ATermUtils.assertTrue(n >= 0);
        return ATermUtils.makeNot(ATermUtils.makeMin(r, n + 1));
    }

    public static final ATermAppl makeMin(ATerm r, int n) {
        if (n == 0) {
            return TOP;
        }
        ATermUtils.assertTrue(n > 0);
        return factory.makeAppl(MINFUN, r, factory.makeInt(n));
    }

    public static final ATermList makeList(ATerm singleton) {
        return factory.makeList(singleton, EMPTY_LIST);
    }

    public static final ATermList makeList(ATerm first, ATermList rest) {
        return factory.makeList(first, rest);
    }

    public static ATermList makeList(Collection set) {
        ATermList list = EMPTY_LIST;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            list = list.insert((ATerm)iter.next());
        }
        return list;
    }

    public static final ATermList makeList(ATerm[] aTerms) {
        return ATermUtils.makeList(aTerms, 0);
    }

    private static ATermList makeList(ATerm[] aTerms, int index) {
        if (index >= aTerms.length) {
            return EMPTY_LIST;
        }
        if (index == aTerms.length - 1) {
            return ATermUtils.makeList(aTerms[index]);
        }
        return ATermUtils.makeList(aTerms[index], ATermUtils.makeList(aTerms, index + 1));
    }

    public static final boolean member(ATerm a, ATermList list) {
        return list.indexOf(a, 0) != -1;
    }

    public static boolean isSet(ATermList list) {
        if (list.isEmpty()) {
            return true;
        }
        ATerm curr = list.getFirst();
        list = list.getNext();
        while (!list.isEmpty()) {
            ATerm next = list.getFirst();
            if (comparator.compare(curr, next) >= 0) {
                return false;
            }
            curr = next;
            list = list.getNext();
        }
        return true;
    }

    public static ATermList toSet(ATermList list) {
        if (ATermUtils.isSet(list)) {
            return list;
        }
        int size = list.getLength();
        ATerm[] a = ATermUtils.toArray(list);
        if (a == null || a.length < size) {
            a = new ATerm[Math.max(100, size)];
        }
        Arrays.sort(a, 0, size, comparator);
        ATermList set = ATermUtils.makeList(a[size - 1]);
        for (int i = size - 2; i >= 0; --i) {
            ATerm s = set.getFirst();
            if (((Object)s).equals(a[i])) continue;
            set = set.insert(a[i]);
        }
        return set;
    }

    public static String toString(ATermAppl term) {
        if (ATermUtils.isVar(term)) {
            return ((ATermAppl)term.getArgument(0)).getName();
        }
        if (ATermUtils.isLiteral(term)) {
            String value = ((ATermAppl)term.getArgument(0)).getName();
            String lang = ((ATermAppl)term.getArgument(1)).getName();
            String datatypeURI = ((ATermAppl)term.getArgument(2)).getName();
            StringBuffer sb = new StringBuffer();
            sb.append('\"').append(value).append('\"');
            if (!lang.equals("")) {
                sb.append('@').append(lang);
            } else if (!datatypeURI.equals("")) {
                sb.append("^^").append(datatypeURI);
            }
            return sb.toString();
        }
        return term.getName();
    }

    public static ATerm[] toArray(ATermList list) {
        ATerm[] a = new ATerm[list.getLength()];
        int i = 0;
        while (!list.isEmpty()) {
            a[i++] = list.getFirst();
            list = list.getNext();
        }
        return a;
    }

    public static final void assertTrue(boolean condition) {
        if (!condition) {
            throw new RuntimeException("assertion failed.");
        }
    }

    public static final boolean isPrimitive(ATermAppl c) {
        return c.getArity() == 0;
    }

    public static final boolean isBnode(ATermAppl name) {
        return name.getName().startsWith("bNode");
    }

    public static ATermAppl getNegatedPrimitive(ATermAppl a) {
        if (a.getAFun().equals(NOTFUN) && ATermUtils.isPrimitive((ATermAppl)a.getArgument(0))) {
            return (ATermAppl)a.getArgument(0);
        }
        return null;
    }

    public static Set listToSet(ATermList list) {
        HashSet<ATerm> set = new HashSet<ATerm>();
        while (!list.isEmpty()) {
            set.add(list.getFirst());
            list = list.getNext();
        }
        return set;
    }

    public static final boolean isAnd(ATermAppl a) {
        return a.getAFun().equals(ANDFUN);
    }

    public static final boolean isOr(ATermAppl a) {
        return a.getAFun().equals(ORFUN);
    }

    public static final boolean isAllValues(ATermAppl a) {
        return a.getAFun().equals(ALLFUN);
    }

    public static final boolean isSomeValues(ATermAppl a) {
        return a.getAFun().equals(SOMEFUN);
    }

    public static final boolean isHasValue(ATermAppl a) {
        return a.getAFun().equals(SOMEFUN) && ((ATermAppl)a.getArgument(1)).getAFun().equals(VALUEFUN);
    }

    public static final boolean isNominal(ATermAppl a) {
        return a.getAFun().equals(VALUEFUN);
    }

    public static final boolean isOneOf(ATermAppl a) {
        if (!a.getAFun().equals(ORFUN)) {
            return false;
        }
        ATermList list = (ATermList)a.getArgument(0);
        while (!list.isEmpty()) {
            if (!ATermUtils.isNominal((ATermAppl)list.getFirst())) {
                return false;
            }
            list = list.getNext();
        }
        return true;
    }

    public static final boolean isDataRange(ATermAppl a) {
        if (!a.getAFun().equals(ORFUN)) {
            return false;
        }
        ATermList list = (ATermList)a.getArgument(0);
        while (!list.isEmpty()) {
            ATermAppl term = (ATermAppl)list.getFirst();
            if (!ATermUtils.isNominal(term) || !ATermUtils.isLiteral((ATermAppl)term.getArgument(0))) {
                return false;
            }
            list = list.getNext();
        }
        return true;
    }

    public static final boolean isNot(ATermAppl a) {
        return a.getAFun().equals(NOTFUN);
    }

    public static final boolean isMax(ATermAppl a) {
        return a.getAFun().equals(MAXFUN);
    }

    public static final boolean isMin(ATermAppl a) {
        return a.getAFun().equals(MINFUN);
    }

    public static final boolean isLiteral(ATermAppl a) {
        return a.getAFun().equals(LITFUN);
    }

    public static final boolean isVar(ATermAppl a) {
        return a.getAFun().equals(VARFUN);
    }

    public static boolean isComplexClass(ATerm c) {
        if (c instanceof ATermAppl) {
            ATermAppl a = (ATermAppl)c;
            AFun f = a.getAFun();
            return f.equals(ALLFUN) || f.equals(SOMEFUN) || f.equals(MAXFUN) || f.equals(MINFUN) || f.equals(ANDFUN) || f.equals(ORFUN) || f.equals(NOTFUN) || f.equals(VALUEFUN);
        }
        return false;
    }

    public static ATerm nnf(ATerm term) {
        if (term instanceof ATermList) {
            return ATermUtils.nnf((ATermList)term);
        }
        if (term instanceof ATermAppl) {
            return ATermUtils.nnf((ATermAppl)term);
        }
        return null;
    }

    public static ATermList nnf(ATermList list) {
        ATermList newList = factory.makeList();
        while (!list.isEmpty()) {
            newList = newList.append(ATermUtils.nnf((ATermAppl)list.getFirst()));
            list = list.getNext();
        }
        return newList;
    }

    public static ATermAppl nnf(ATermAppl term) {
        ATermAppl newterm = null;
        AFun af = term.getAFun();
        if (af.equals(NOTFUN)) {
            ATermUtils.assertTrue(af.getArity() == 1);
            ATermAppl arg = (ATermAppl)term.getArgument(0);
            af = arg.getAFun();
            if (arg.getArity() == 0) {
                newterm = term;
            } else if (af.equals(NOTFUN)) {
                newterm = ATermUtils.nnf((ATermAppl)arg.getArgument(0));
            } else if (af.equals(VALUEFUN)) {
                newterm = term;
            } else if (af.equals(MAXFUN)) {
                ATermInt n = (ATermInt)arg.getArgument(1);
                newterm = ATermUtils.makeMin(arg.getArgument(0), n.getInt() + 1);
            } else if (af.equals(MINFUN)) {
                ATermInt n = (ATermInt)arg.getArgument(1);
                newterm = n.getInt() == 0 ? BOTTOM : ATermUtils.makeMax(arg.getArgument(0), n.getInt() - 1);
            } else {
                if (af.equals(ANDFUN)) {
                    return ATermUtils.makeOr(ATermUtils.nnf(ATermUtils.negate((ATermList)arg.getArgument(0))));
                }
                if (af.equals(ORFUN)) {
                    return ATermUtils.makeAnd(ATermUtils.nnf(ATermUtils.negate((ATermList)arg.getArgument(0))));
                }
                if (af.equals(SOMEFUN)) {
                    newterm = ATermUtils.makeAllValues(arg.getArgument(0), ATermUtils.nnf(ATermUtils.makeNot(arg.getArgument(1))));
                } else if (af.equals(ALLFUN)) {
                    newterm = ATermUtils.makeSomeValues(arg.getArgument(0), ATermUtils.nnf(ATermUtils.makeNot(arg.getArgument(1))));
                } else {
                    ATermUtils.assertTrue(false);
                }
            }
        } else {
            if (af.equals(MINFUN) || af.equals(MAXFUN)) {
                return term;
            }
            ATerm[] args = new ATerm[term.getArity()];
            for (int i = 0; i < term.getArity(); ++i) {
                args[i] = ATermUtils.nnf(term.getArgument(i));
            }
            newterm = factory.makeAppl(af, args);
        }
        ATermUtils.assertTrue(newterm != null);
        return newterm;
    }

    public static ATermList normalize(ATermList list) {
        ATermList newList = factory.makeList();
        while (!list.isEmpty()) {
            newList = newList.insert(ATermUtils.normalize((ATermAppl)list.getFirst()));
            list = list.getNext();
        }
        return ATermUtils.toSet(newList);
    }

    public static ATermAppl normalize(ATermAppl term) {
        ATerm arg2;
        ATermAppl norm = term;
        AFun fun = term.getAFun();
        ATerm arg1 = term.getArity() > 0 ? term.getArgument(0) : null;
        ATerm aTerm = arg2 = term.getArity() > 1 ? term.getArgument(1) : null;
        if (fun.equals(NOTFUN)) {
            norm = ATermUtils.simplify(ATermUtils.makeNot(ATermUtils.normalize((ATermAppl)arg1)));
        } else if (fun.equals(ANDFUN)) {
            norm = ATermUtils.simplify(ATermUtils.makeAnd(ATermUtils.normalize((ATermList)arg1)));
        } else if (fun.equals(ORFUN)) {
            ATermList neg = ATermUtils.negate((ATermList)arg1);
            ATermAppl and = ATermUtils.makeAnd(neg);
            ATermAppl notAnd = ATermUtils.makeNot(and);
            norm = ATermUtils.normalize(notAnd);
        } else if (fun.equals(ALLFUN)) {
            norm = ATermUtils.simplify(ATermUtils.makeAllValues(arg1, ATermUtils.normalize((ATermAppl)arg2)));
        } else if (fun.equals(SOMEFUN)) {
            norm = ATermUtils.normalize(ATermUtils.makeNot(ATermUtils.makeAllValues(arg1, ATermUtils.makeNot(arg2))));
        } else if (fun.equals(MAXFUN)) {
            norm = ATermUtils.makeNot(ATermUtils.makeMin(arg1, ((ATermInt)arg2).getInt() + 1));
        } else if (fun.equals(MINFUN)) {
            norm = ATermUtils.simplify(norm);
        }
        return norm;
    }

    public static ATermAppl simplify(ATermAppl term) {
        ATermInt n;
        ATerm arg2;
        ATermAppl simp = term;
        AFun fun = term.getAFun();
        ATerm arg1 = term.getArity() > 0 ? term.getArgument(0) : null;
        ATerm aTerm = arg2 = term.getArity() > 1 ? term.getArgument(1) : null;
        if (fun.equals(NOTFUN)) {
            ATermInt n2;
            ATermAppl arg = (ATermAppl)arg1;
            if (ATermUtils.isNot(arg)) {
                simp = ATermUtils.simplify((ATermAppl)arg.getArgument(0));
            } else if (ATermUtils.isMin(arg) && (n2 = (ATermInt)arg.getArgument(1)).getInt() == 0) {
                simp = BOTTOM;
            }
        } else if (fun.equals(ANDFUN)) {
            ATermList conjuncts = (ATermList)arg1;
            if (conjuncts.isEmpty()) {
                simp = TOP;
            } else {
                ATermList newConjuncts = EMPTY_LIST;
                while (!conjuncts.isEmpty()) {
                    ATermAppl conj = (ATermAppl)conjuncts.getFirst();
                    if (!conj.equals(TOP)) {
                        if (ATermUtils.isAnd(conj)) {
                            conjuncts = conjuncts.concat((ATermList)conj.getArgument(0));
                        } else {
                            newConjuncts = newConjuncts.append(conj);
                        }
                    }
                    conjuncts = conjuncts.getNext();
                }
                ATermList c = newConjuncts;
                while (!c.isEmpty()) {
                    ATermAppl neg;
                    ATermAppl conj = (ATermAppl)c.getFirst();
                    if (conj.equals(BOTTOM)) {
                        return BOTTOM;
                    }
                    if (ATermUtils.isNot(conj) && ATermUtils.member(neg = (ATermAppl)conj.getArgument(0), newConjuncts)) {
                        return BOTTOM;
                    }
                    c = c.getNext();
                }
                simp = newConjuncts.isEmpty() ? TOP : (newConjuncts.getLength() == 1 ? (ATermAppl)newConjuncts.getFirst() : ATermUtils.makeAnd(ATermUtils.toSet(newConjuncts)));
            }
        } else if (fun.equals(ALLFUN)) {
            if (((Object)arg2).equals(TOP)) {
                simp = TOP;
            }
        } else if (fun.equals(MINFUN) && (n = (ATermInt)arg2).getInt() == 0) {
            simp = TOP;
        }
        return simp;
    }

    public static Set findPrimitives(ATermAppl ter) {
        ATermList lis;
        ATermList args;
        HashSet<ATermAppl> result = new HashSet<ATermAppl>();
        if (ATermUtils.isAnd(ter) || ATermUtils.isOr(ter) || ATermUtils.isNot(ter)) {
            args = ter.getArguments();
            while (!args.isEmpty()) {
                if (args.getFirst() instanceof ATermAppl) {
                    result.addAll(ATermUtils.findPrimitives((ATermAppl)args.getFirst()));
                    args = args.getNext();
                }
                if (!(args.getFirst() instanceof ATermList)) continue;
                lis = (ATermList)args.getFirst();
                while (!lis.isEmpty()) {
                    result.addAll(ATermUtils.findPrimitives((ATermAppl)lis.getFirst()));
                    lis = lis.getNext();
                }
                args = args.getNext();
            }
        }
        if (ATermUtils.isAllValues(ter) || ATermUtils.isSomeValues(ter)) {
            args = ter.getArguments();
            if ((args = args.getNext()).getFirst() instanceof ATermAppl) {
                result.addAll(ATermUtils.findPrimitives((ATermAppl)args.getFirst()));
                args = args.getNext();
            }
            if (args.getFirst() instanceof ATermList) {
                lis = (ATermList)args.getFirst();
                while (!lis.isEmpty()) {
                    result.addAll(ATermUtils.findPrimitives((ATermAppl)lis.getFirst()));
                    lis = lis.getNext();
                }
                ATermList aTermList = args.getNext();
            }
        }
        if (ATermUtils.isPrimitive(ter)) {
            result.add(ter);
        }
        return result;
    }

    static class ATermComparator
    implements Comparator {
        ATermComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1.hashCode() > o2.hashCode()) {
                return 1;
            }
            if (o1.hashCode() == o2.hashCode()) {
                return 0;
            }
            return -1;
        }
    }

    static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

