/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.io.manchester;

import com.clarkparsia.explanation.io.manchester.BlockWriter;
import com.clarkparsia.explanation.io.manchester.DescriptionSorter;
import com.clarkparsia.explanation.io.manchester.Keyword;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLCardinalityRestriction;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstantAnnotation;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectAnnotation;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLPropertyExpression;
import org.semanticweb.owl.model.OWLQuantifiedRestriction;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUnaryPropertyAxiom;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomConstantObject;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLAtomIndividualObject;
import org.semanticweb.owl.model.SWRLBuiltInAtom;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.model.SWRLDataRangeAtom;
import org.semanticweb.owl.model.SWRLDataValuedPropertyAtom;
import org.semanticweb.owl.model.SWRLDifferentFromAtom;
import org.semanticweb.owl.model.SWRLObjectPropertyAtom;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.model.SWRLSameAsAtom;
import org.semanticweb.owl.vocab.SWRLBuiltInsVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManchesterSyntaxObjectRenderer
implements OWLObjectVisitor {
    private boolean wrapLines = true;
    private boolean smartIndent = true;
    protected BlockWriter writer;

    public ManchesterSyntaxObjectRenderer(BlockWriter writer) {
        this.writer = writer;
    }

    public boolean isSmartIndent() {
        return this.smartIndent;
    }

    public boolean isWrapLines() {
        return this.wrapLines;
    }

    public void setSmartIndent(boolean smartIndent) {
        this.smartIndent = smartIndent;
    }

    public void setWrapLines(boolean wrapLines) {
        this.wrapLines = wrapLines;
    }

    protected String shortForm(URI theURI) {
        String fragment = theURI.getFragment();
        if (fragment != null) {
            return fragment;
        }
        int lastSlashIndex = theURI.getPath().lastIndexOf(47);
        if (lastSlashIndex != -1) {
            return theURI.getPath().substring(lastSlashIndex + 1, theURI.getPath().length());
        }
        return theURI.toString();
    }

    public void visit(OWLAntiSymmetricObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.ANTISYMMETRIC_PROPERTY);
    }

    public void visit(OWLAxiomAnnotationAxiom theAxiom) {
    }

    public void visit(OWLClass theOWLClass) {
        this.write(theOWLClass.getURI());
    }

    public void visit(OWLClassAssertionAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.TYPE, (OWLObject)theAxiom.getIndividual(), (OWLObject)theAxiom.getDescription());
    }

    public void visit(OWLConstantAnnotation theAnnotation) {
        if (theAnnotation.isLabel()) {
            this.write(Keyword.LABEL);
            this.writeSpace();
            this.write("(");
        } else if (theAnnotation.isComment()) {
            this.write(Keyword.COMMENT);
            this.writeSpace();
            this.write("(");
        } else {
            this.write(Keyword.ANNOTATION);
            this.writeSpace();
            this.write("(");
            this.write(theAnnotation.getAnnotationURI());
        }
        this.write(" ");
        this.write(theAnnotation.getAnnotationValue());
        this.write(")");
    }

    public void visit(OWLDataAllRestriction theDescription) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?, ?>)theDescription, Keyword.ONLY);
    }

    public void visit(OWLDataComplementOf theDescription) {
        this.writeKeywordPrefix(Keyword.NOT, (OWLObject)theDescription.getDataRange());
    }

    public void visit(OWLDataExactCardinalityRestriction theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?>)theDescription, Keyword.EXACTLY);
    }

    public void visit(OWLDataMaxCardinalityRestriction theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?>)theDescription, Keyword.MAX);
    }

    public void visit(OWLDataMinCardinalityRestriction theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?>)theDescription, Keyword.MIN);
    }

    public void visit(OWLDataOneOf theDescription) {
        this.writeEnumeration(theDescription.getValues());
    }

    public void visit(OWLDataProperty theProperty) {
        this.write(theProperty.getURI());
    }

    public void visit(OWLDataPropertyAssertionAxiom theAxiom) {
        this.write((OWLObject)theAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getProperty());
        this.writeSpace();
        this.write(theAxiom.getObject());
    }

    public void visit(OWLDataPropertyDomainAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.DOMAIN, (OWLObject)theAxiom.getProperty(), (OWLObject)theAxiom.getDomain());
    }

    public void visit(OWLDataPropertyRangeAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.RANGE, (OWLObject)theAxiom.getProperty(), (OWLObject)theAxiom.getRange());
    }

    public void visit(OWLDataRangeFacetRestriction theRestriction) {
        this.write(theRestriction.getFacet().getSymbolicForm());
        this.writeSpace();
        this.write((OWLObject)theRestriction.getFacetValue());
    }

    public void visit(OWLDataRangeRestriction theRestriction) {
        this.write((OWLObject)theRestriction.getDataRange());
        this.write("[");
        boolean first = true;
        for (OWLDataRangeFacetRestriction restriction : theRestriction.getFacetRestrictions()) {
            if (first) {
                first = false;
            } else {
                this.write(",");
                this.writeSpace();
            }
            this.write((OWLObject)restriction);
        }
        this.write("]");
    }

    public void visit(OWLDataSomeRestriction theDescription) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?, ?>)theDescription, Keyword.SOME);
    }

    public void visit(OWLDataSubPropertyAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.SUB_PROPERTY_OF, (OWLObject)theAxiom.getSubProperty(), (OWLObject)theAxiom.getSuperProperty());
    }

    public void visit(OWLDataType node) {
        this.write(node.getURI());
    }

    public void visit(OWLDataValueRestriction theDescription) {
        this.writeRestriction(theDescription.getProperty(), Keyword.VALUE, theDescription.getValue());
    }

    public void visit(OWLDeclarationAxiom theAxiom) {
        this.writeKeywordPrefix(Keyword.DECLARATION, (OWLObject)theAxiom.getEntity());
    }

    public void visit(OWLDifferentIndividualsAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getIndividuals(), Keyword.DIFFERENT_INDIVIDUAL, Keyword.DIFFERENT_INDIVIDUALS);
    }

    public void visit(OWLDisjointClassesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getDescriptions(), Keyword.DISJOINT_CLASS, Keyword.DISJOINT_CLASSES);
    }

    public void visit(OWLDisjointDataPropertiesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getProperties(), Keyword.DISJOINT_PROPERTY, Keyword.DISJOINT_PROPERTIES);
    }

    public void visit(OWLDisjointObjectPropertiesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getProperties(), Keyword.DISJOINT_PROPERTY, Keyword.DISJOINT_PROPERTIES);
    }

    public void visit(OWLDisjointUnionAxiom theAxiom) {
        this.write((OWLObject)theAxiom.getOWLClass());
        this.writeSpace();
        this.write(Keyword.DISJOINT_UNION);
        this.writeSpace();
        this.writeNaryKeyword(Keyword.OR, theAxiom.getDescriptions());
    }

    public void visit(OWLEntityAnnotationAxiom theAxiom) {
        this.writeKeywordPrefix(Keyword.ENTITY_ANNOTATION_AXIOM, theAxiom.getSubject(), (OWLObject)theAxiom.getAnnotation());
    }

    public void visit(OWLEquivalentClassesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getDescriptions(), Keyword.EQUIVALENT_CLASS, Keyword.EQUIVALENT_CLASSES);
    }

    public void visit(OWLEquivalentDataPropertiesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getProperties(), Keyword.EQUIVALENT_PROPERTY, Keyword.EQUIVALENT_PROPERTIES);
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getProperties(), Keyword.EQUIVALENT_PROPERTY, Keyword.EQUIVALENT_PROPERTIES);
    }

    public void visit(OWLFunctionalDataPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.FUNCTIONAL);
    }

    public void visit(OWLFunctionalObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.FUNCTIONAL);
    }

    public void visit(OWLImportsDeclaration theAxiom) {
        this.write(Keyword.IMPORTS);
        this.writeSpace();
        this.write("(");
        this.write(theAxiom.getSubject().getURI().toString());
        this.write(" -> ");
        this.write(theAxiom.getImportedOntologyURI().toString());
        this.write(")");
    }

    public void visit(OWLIndividual theIndividual) {
        this.write(theIndividual.getURI());
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.INVERSE_FUNCTIONAL);
    }

    public void visit(OWLInverseObjectPropertiesAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.INVERSE_OF, (OWLObject)theAxiom.getFirstProperty(), (OWLObject)theAxiom.getSecondProperty());
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.IRREFLEXIVE);
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom theAxiom) {
        this.write(Keyword.NOT_RELATIONSHIP);
        this.writeSpace();
        this.write("(");
        this.write((OWLObject)theAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getProperty());
        this.writeSpace();
        this.write(theAxiom.getObject());
        this.write(")");
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom theAxiom) {
        this.write(Keyword.NOT_RELATIONSHIP);
        this.writeSpace();
        this.write("(");
        this.write((OWLObject)theAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getProperty());
        this.writeSpace();
        this.write(theAxiom.getObject());
        this.write(")");
    }

    public void visit(OWLObjectAllRestriction theDescription) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?, ?>)theDescription, Keyword.ONLY);
    }

    public void visit(OWLObjectAnnotation theAnnotation) {
        this.write(Keyword.ANNOTATION);
        this.writeSpace();
        this.write("(");
        this.write(theAnnotation.getAnnotationURI());
        this.writeSpace();
        this.write(theAnnotation.getAnnotationValue());
        this.write(")");
    }

    public void visit(OWLObjectComplementOf theDescription) {
        this.writeKeywordPrefix(Keyword.NOT, (OWLObject)theDescription.getOperand());
    }

    public void visit(OWLObjectExactCardinalityRestriction theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?>)theDescription, Keyword.EXACTLY);
    }

    public void visit(OWLObjectIntersectionOf theDescription) {
        this.writeNaryKeyword(Keyword.AND, theDescription.getOperands());
    }

    public void visit(OWLObjectMaxCardinalityRestriction theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?>)theDescription, Keyword.MAX);
    }

    public void visit(OWLObjectMinCardinalityRestriction theDescription) {
        this.writeCardinalityRestriction((OWLCardinalityRestriction<?, ?>)theDescription, Keyword.MIN);
    }

    public void visit(OWLObjectOneOf theDescription) {
        this.writeEnumeration(theDescription.getIndividuals());
    }

    public void visit(OWLObjectProperty theProperty) {
        this.write(theProperty.getURI());
    }

    public void visit(OWLObjectPropertyAssertionAxiom theAxiom) {
        this.write((OWLObject)theAxiom.getSubject());
        this.writeSpace();
        this.write((OWLObject)theAxiom.getProperty());
        this.writeSpace();
        this.write(theAxiom.getObject());
    }

    public void visit(OWLObjectPropertyChainSubPropertyAxiom theAxiom) {
        boolean first = true;
        for (OWLObjectPropertyExpression prop : theAxiom.getPropertyChain()) {
            if (first) {
                first = false;
            } else {
                this.writeSpace();
                this.write("o");
                this.writeSpace();
            }
            this.write((OWLObject)prop);
        }
        this.writeSpace();
        this.write(Keyword.SUB_PROPERTY_OF);
        this.writeSpace();
        this.write((OWLObject)theAxiom.getSuperProperty());
    }

    public void visit(OWLObjectPropertyDomainAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.DOMAIN, (OWLObject)theAxiom.getProperty(), (OWLObject)theAxiom.getDomain());
    }

    public void visit(OWLObjectPropertyInverse theInverse) {
        this.writeKeywordPrefix(Keyword.INVERSE, (OWLObject)theInverse.getInverse());
    }

    public void visit(OWLObjectPropertyRangeAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.RANGE, (OWLObject)theAxiom.getProperty(), (OWLObject)theAxiom.getRange());
    }

    public void visit(OWLObjectSelfRestriction theRestriction) {
        this.writeRestriction(theRestriction.getProperty(), Keyword.SELF, new Object[0]);
    }

    public void visit(OWLObjectSomeRestriction theDescription) {
        this.writeQuantifiedRestriction((OWLQuantifiedRestriction<?, ?>)theDescription, Keyword.SOME);
    }

    public void visit(OWLObjectSubPropertyAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.SUB_PROPERTY_OF, (OWLObject)theAxiom.getSubProperty(), (OWLObject)theAxiom.getSuperProperty());
    }

    public void visit(OWLObjectUnionOf theDescription) {
        this.writeNaryKeyword(Keyword.OR, theDescription.getOperands());
    }

    public void visit(OWLObjectValueRestriction theDescription) {
        this.writeRestriction(theDescription.getProperty(), Keyword.VALUE, theDescription.getValue());
    }

    public void visit(OWLOntology ontology) {
        this.write(ontology.getURI());
    }

    public void visit(OWLOntologyAnnotationAxiom theAxiom) {
        this.writeKeywordPrefix(Keyword.ONTOLOGY_ANNOTATION, (OWLObject)theAxiom.getAnnotation());
    }

    public void visit(OWLReflexiveObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.REFLEXIVE_PROPERTY);
    }

    public void visit(OWLSameIndividualsAxiom theAxiom) {
        this.writeNaryAxiom(theAxiom.getIndividuals(), Keyword.SAME_INDIVIDUAL, Keyword.SAME_INDIVIDUALS);
    }

    public void visit(OWLSubClassAxiom theAxiom) {
        this.writeKeywordInfix(Keyword.SUB_CLASS_OF, (OWLObject)theAxiom.getSubClass(), (OWLObject)theAxiom.getSuperClass());
    }

    public void visit(OWLSymmetricObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.SYMMETRIC);
    }

    public void visit(OWLTransitiveObjectPropertyAxiom theAxiom) {
        this.writeUnaryPropertyAxiom((OWLUnaryPropertyAxiom<?>)theAxiom, Keyword.TRANSITIVE);
    }

    public void visit(OWLTypedConstant node) {
        if (node.getDataType().getURI().equals(XSDVocabulary.INTEGER) || node.getDataType().getURI().equals(XSDVocabulary.DECIMAL)) {
            this.write(node.getLiteral());
        } else if (node.getDataType().getURI().equals(XSDVocabulary.FLOAT)) {
            this.write(node.getLiteral());
            this.write("f");
        } else {
            this.write("\"");
            this.write(node.getLiteral());
            this.write("\"");
            this.write("^^");
            this.write((OWLObject)node.getDataType());
        }
    }

    public void visit(OWLUntypedConstant node) {
        this.write("\"");
        this.write(node.getLiteral());
        this.write("\"");
        if (node.hasLang()) {
            this.write("@");
            this.write(node.getLang());
        }
    }

    public void visit(SWRLAtomConstantObject node) {
        this.write((OWLObject)node.getConstant());
    }

    public void visit(SWRLAtomDVariable node) {
        this.write("?");
        this.write(node.getURI());
    }

    public void visit(SWRLAtomIndividualObject node) {
        this.write((OWLObject)node.getIndividual());
    }

    public void visit(SWRLAtomIVariable node) {
        this.write("?");
        this.write(node.getURI());
    }

    public void visit(SWRLBuiltInAtom node) {
        this.write(((SWRLBuiltInsVocabulary)node.getPredicate()).getURI());
        this.write("(");
        for (SWRLAtomDObject arg : node.getArguments()) {
            this.write((OWLObject)arg);
            this.write(" ");
        }
        this.write(")");
    }

    public void visit(SWRLClassAtom node) {
        this.write((OWLObject)node.getPredicate());
        this.write("(");
        this.write((OWLObject)node.getArgument());
        this.write(")");
    }

    public void visit(SWRLDataRangeAtom node) {
        this.write((OWLObject)node.getPredicate());
        this.write("(");
        this.write((OWLObject)node.getArgument());
        this.write(")");
    }

    public void visit(SWRLDataValuedPropertyAtom node) {
        this.write((OWLObject)node.getPredicate());
        this.write("(");
        this.write((OWLObject)node.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)node.getSecondArgument());
        this.write(")");
    }

    public void visit(SWRLDifferentFromAtom node) {
        this.write("differentFrom");
        this.write("(");
        this.write((OWLObject)node.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)node.getSecondArgument());
        this.write(")");
    }

    public void visit(SWRLObjectPropertyAtom node) {
        this.write((OWLObject)node.getPredicate());
        this.write("(");
        this.write((OWLObject)node.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)node.getSecondArgument());
        this.write(")");
    }

    public void visit(SWRLRule rule) {
        this.write("Rule");
        this.write("(");
        if (!rule.isAnonymous()) {
            this.write(rule.getURI());
            this.writeSpace();
        }
        boolean first = true;
        for (SWRLAtom at : rule.getBody()) {
            if (first) {
                first = false;
            } else {
                this.write(", ");
            }
            this.write((OWLObject)at);
        }
        this.write(" -> ");
        first = true;
        for (SWRLAtom at : rule.getHead()) {
            if (first) {
                first = false;
            } else {
                this.write(", ");
            }
            this.write((OWLObject)at);
        }
        this.write(")");
    }

    public void visit(SWRLSameAsAtom node) {
        this.write("sameAs");
        this.write("(");
        this.write((OWLObject)node.getFirstArgument());
        this.write(", ");
        this.write((OWLObject)node.getSecondArgument());
        this.write(")");
    }

    protected void writeNaryKeyword(Keyword theKeyword, Set<? extends OWLObject> theObjects) {
        theObjects = DescriptionSorter.toSortedSet(theObjects);
        Iterator<? extends OWLObject> aIter = theObjects.iterator();
        if (this.smartIndent) {
            this.writer.startBlock();
        }
        this.write(aIter.next());
        while (aIter.hasNext()) {
            if (this.wrapLines) {
                this.writeNewLine();
            } else {
                this.writeSpace();
            }
            if (theKeyword != null) {
                this.write(theKeyword);
                this.writeSpace();
            }
            this.write(aIter.next());
        }
        if (this.smartIndent) {
            this.writer.endBlock();
        }
    }

    protected void writeCardinalityRestriction(OWLCardinalityRestriction<?, ?> theRestriction, Keyword theKeyword) {
        if (theRestriction.isQualified()) {
            this.writeRestriction(theRestriction.getProperty(), theKeyword, theRestriction.getCardinality(), theRestriction.getFiller());
        } else {
            this.writeRestriction(theRestriction.getProperty(), theKeyword, theRestriction.getCardinality());
        }
    }

    protected void writeNaryAxiom(Set<? extends OWLObject> set, Keyword binary, Keyword nary) {
        Set<? extends OWLObject> sortedSet = DescriptionSorter.toSortedSet(set);
        Iterator<? extends OWLObject> aIter = sortedSet.iterator();
        if (set.size() == 2) {
            this.writeKeywordInfix(binary, aIter.next(), aIter.next());
        } else {
            this.write(nary);
            this.write("(");
            this.writeNaryKeyword(null, set);
            this.write(")");
        }
    }

    protected void writeQuantifiedRestriction(OWLQuantifiedRestriction<?, ?> theRestriction, Keyword theKeyword) {
        this.writeRestriction(theRestriction.getProperty(), theKeyword, theRestriction.getFiller());
    }

    protected void writeRestriction(OWLPropertyExpression<?, ?> theProperty, Keyword theKeyword, Object ... theArgs) {
        this.write((OWLObject)theProperty);
        this.writeSpace();
        this.write(theKeyword);
        this.writeSpace();
        for (Object aObject : theArgs) {
            if (aObject instanceof OWLObject) {
                this.write((OWLObject)aObject);
                continue;
            }
            this.write(aObject.toString());
        }
    }

    protected void writeUnaryPropertyAxiom(OWLUnaryPropertyAxiom<?> theAxiom, Keyword keyword) {
        this.writeKeywordPrefix(keyword, (OWLObject)theAxiom.getProperty());
    }

    protected void writeKeywordPrefix(Keyword keyword, OWLObject arg) {
        this.write(keyword);
        this.writeSpace();
        this.write(arg);
    }

    protected void writeKeywordPrefix(Keyword keyword, OWLObject arg1, OWLObject arg2) {
        this.write(keyword);
        this.writeSpace();
        this.write("(");
        this.write(arg1);
        this.writeSpace();
        this.write(arg2);
        this.write(")");
    }

    protected void writeKeywordInfix(Keyword keyword, OWLObject arg1, OWLObject arg2) {
        this.write(arg1);
        this.writeSpace();
        this.write(keyword);
        this.writeSpace();
        this.write(arg2);
    }

    protected void writeEnumeration(Set<? extends OWLObject> objects) {
        this.write(Keyword.OPEN_BRACE);
        boolean first = true;
        for (OWLObject oWLObject : DescriptionSorter.toSortedSet(objects)) {
            if (first) {
                first = false;
            } else {
                this.write(",");
                this.writeSpace();
            }
            this.write(oWLObject);
        }
        this.write(Keyword.CLOSE_BRACE);
    }

    protected void write(OWLObject object) {
        object.accept((OWLObjectVisitor)this);
    }

    protected void write(Keyword keyword) {
        this.write(keyword.getLabel());
    }

    protected void write(String s) {
        this.writer.print(s);
    }

    protected void write(URI uri) {
        this.write(this.shortForm(uri));
    }

    protected void writeNewLine() {
        this.writer.println();
    }

    protected void writeSpace() {
        this.write(" ");
    }
}

