/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomImpl;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.rules.rete.Compiler;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import java.util.ArrayList;
import java.util.Collection;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReteToRulesTranslator {
    private ABox abox;

    public ReteToRulesTranslator(ABox abox) {
        this.abox = abox;
    }

    public AtomDObject translateDTerm(ATermAppl term) {
        if (ATermUtils.isVar(term)) {
            return new AtomDVariable(term.getName());
        }
        return new AtomDConstant(term);
    }

    public AtomIObject translateITerm(ATermAppl term) {
        if (ATermUtils.isVar(term)) {
            return new AtomIVariable(term.getName());
        }
        return new AtomIConstant(term);
    }

    public Rule translateRule(com.clarkparsia.pellet.rules.rete.Rule reteRule) {
        Collection<RuleAtom> headAtoms = this.translateTriples(reteRule.getHead());
        Collection<RuleAtom> bodyAtoms = this.translateTriples(reteRule.getBody());
        Rule rule = new Rule(headAtoms, bodyAtoms);
        return rule;
    }

    public RuleAtom translateTriple(TermTuple tuple) {
        RuleAtomImpl atom = null;
        if (tuple.getElements().size() == 3) {
            ATermAppl pred = (ATermAppl)tuple.getElements().get(0);
            ATermAppl subj = (ATermAppl)tuple.getElements().get(1);
            ATermAppl obj = (ATermAppl)tuple.getElements().get(2);
            AtomIObject argument1 = this.translateITerm(subj);
            if (pred.equals(Compiler.TYPE)) {
                ATermAppl description = obj;
                atom = new ClassAtom(description, argument1);
            } else if (pred.equals(Compiler.SAME_AS)) {
                AtomIObject argument2 = this.translateITerm(obj);
                atom = new SameIndividualAtom(argument1, argument2);
            } else if (pred.equals(Compiler.DIFF_FROM)) {
                AtomIObject argument2 = this.translateITerm(obj);
                atom = new DifferentIndividualsAtom(argument1, argument2);
            } else {
                ATermAppl predicate = pred;
                Role r = this.abox.getRole((ATerm)predicate);
                if (r != null && r.isObjectRole()) {
                    AtomIObject argument2 = this.translateITerm(obj);
                    atom = new IndividualPropertyAtom(predicate, argument1, argument2);
                } else if (r != null && r.isDatatypeRole()) {
                    AtomDObject argument2 = this.translateDTerm(obj);
                    atom = new DatavaluedPropertyAtom(predicate, argument1, argument2);
                }
            }
        }
        if (atom == null) {
            throw new InternalReasonerException("Can't translate triple to rule atom!: " + tuple);
        }
        return atom;
    }

    public Collection<RuleAtom> translateTriples(Collection<TermTuple> triples) {
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>(triples.size());
        for (TermTuple triple : triples) {
            atoms.add(this.translateTriple(triple));
        }
        return atoms;
    }
}

