/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.BindingIterator;
import com.clarkparsia.pellet.sparqldl.engine.CoreStrategy;
import com.clarkparsia.pellet.sparqldl.engine.LiteralIterator;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.engine.QueryExec;
import com.clarkparsia.pellet.sparqldl.engine.QueryOptimizer;
import com.clarkparsia.pellet.sparqldl.engine.QueryPlan;
import com.clarkparsia.pellet.sparqldl.model.CoreNewImpl;
import com.clarkparsia.pellet.sparqldl.model.Filter;
import com.clarkparsia.pellet.sparqldl.model.NotKnownQueryAtom;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.model.QueryImpl;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.QueryResultImpl;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.model.ResultBindingImpl;
import com.clarkparsia.pellet.sparqldl.model.UnionQueryAtom;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.CandidateSet;
import org.mindswap.pellet.utils.DisjointSet;
import org.mindswap.pellet.utils.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedQueryEngine
implements QueryExec {
    public static final Logger log = Logger.getLogger(CombinedQueryEngine.class.getName());
    public static final QueryOptimizer optimizer = new QueryOptimizer();
    private KnowledgeBase kb;
    protected QueryPlan plan;
    protected Query oldQuery;
    protected Query query;
    private QueryResult result;
    private Set<ATermAppl> downMonotonic;
    private long branches;
    private boolean STOP_ROLLING_ON_CONSTANTS = false;

    private void prepare(Query query) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Preparing plan ...");
        }
        this.kb = query.getKB();
        if (this.kb == null) {
            throw new RuntimeException("No input data set is given for query!");
        }
        this.result = new QueryResultImpl(query);
        this.oldQuery = query;
        this.query = this.setupCores(query);
        if (log.isLoggable(Level.FINE)) {
            log.fine("After setting-up cores : " + this.query);
        }
        this.plan = optimizer.getExecutionPlan(this.query);
        this.plan.reset();
        if (PelletOptions.USE_CACHING && !this.kb.isClassified()) {
            for (QueryAtom a : this.oldQuery.getAtoms()) {
                for (ATermAppl arg : a.getArguments()) {
                    if (!this.kb.isClass((ATerm)arg)) continue;
                    this.kb.isSatisfiable(arg);
                    this.kb.isSatisfiable(ATermUtils.makeNot((ATerm)arg));
                }
            }
        }
        if (PelletOptions.OPTIMIZE_DOWN_MONOTONIC) {
            this.downMonotonic = new HashSet<ATermAppl>();
            this.setupDownMonotonicVariables(this.query);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Variables to be optimized : " + this.downMonotonic);
            }
        }
    }

    private Query setupCores(Query query) {
        Iterator<ATermAppl> undistVarIterator = query.getUndistVars().iterator();
        if (!undistVarIterator.hasNext()) {
            return query;
        }
        DisjointSet<Object> coreVertices = new DisjointSet<Object>();
        ArrayList<QueryAtom> toRemove = new ArrayList<QueryAtom>();
        while (undistVarIterator.hasNext()) {
            ATermAppl a2;
            ATermAppl a = undistVarIterator.next();
            coreVertices.add(a);
            for (QueryAtom atom : query.findAtoms(QueryPredicate.PropertyValue, a, null, null)) {
                coreVertices.add(atom);
                coreVertices.union(a, atom);
                a2 = atom.getArguments().get(2);
                if (query.getUndistVars().contains(a2)) {
                    coreVertices.add(a2);
                    coreVertices.union(a, a2);
                }
                toRemove.add(atom);
            }
            for (QueryAtom atom : query.findAtoms(QueryPredicate.PropertyValue, null, null, a)) {
                coreVertices.add(atom);
                coreVertices.union(a, atom);
                a2 = atom.getArguments().get(0);
                if (query.getUndistVars().contains(a2)) {
                    coreVertices.add(a2);
                    coreVertices.union(a, a2);
                }
                toRemove.add(atom);
            }
            for (QueryAtom atom : query.findAtoms(QueryPredicate.Type, a, null)) {
                coreVertices.add(atom);
                coreVertices.union(a, atom);
                toRemove.add(atom);
            }
        }
        Query transformedQuery = query.apply(new ResultBindingImpl());
        for (Set set : coreVertices.getEquivalanceSets()) {
            ArrayList<QueryAtom> atoms = new ArrayList<QueryAtom>();
            for (Object a : set) {
                if (!(a instanceof QueryAtom)) continue;
                atoms.add((QueryAtom)a);
            }
            CoreNewImpl c = (CoreNewImpl)QueryAtomFactory.Core(atoms, query.getUndistVars(), this.kb);
            transformedQuery.add(c);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine(c.getUndistVars() + " : " + c.getDistVars() + " : " + c.getQuery().getAtoms());
        }
        for (QueryAtom atom : toRemove) {
            transformedQuery.remove(atom);
        }
        return transformedQuery;
    }

    private void setupDownMonotonicVariables(Query query) {
        block3: for (QueryAtom atom : query.getAtoms()) {
            ATermAppl arg;
            switch (atom.getPredicate()) {
                case PropertyValue: 
                case Type: {
                    arg = atom.getArguments().get(1);
                    if (!ATermUtils.isVar(arg)) continue block3;
                    this.downMonotonic.add(arg);
                    continue block3;
                }
            }
            arg = null;
        }
    }

    @Override
    public boolean supports(Query q) {
        return true;
    }

    @Override
    public QueryResult exec(Query query) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Executing query " + query);
        }
        Timer timer = new Timer("CombinedQueryEngine");
        timer.start();
        this.prepare(query);
        this.branches = 0L;
        this.exec(new ResultBindingImpl());
        timer.stop();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "#B=" + this.branches + ", time=" + timer.getLast() + " ms.");
        }
        return this.result;
    }

    private void exec(ResultBinding binding) {
        if (log.isLoggable(Level.FINE)) {
            ++this.branches;
        }
        if (!this.plan.hasNext()) {
            if (!binding.isEmpty() || this.result.isEmpty()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Found binding: " + binding);
                }
                Filter filter = this.query.getFilter();
                if (!this.result.getResultVars().containsAll(binding.getAllVariables())) {
                    ResultBindingImpl newBinding = new ResultBindingImpl();
                    for (ATermAppl var : this.result.getResultVars()) {
                        ATermAppl value = binding.getValue(var);
                        newBinding.setValue(var, value);
                    }
                    binding = newBinding;
                }
                this.result.add(binding);
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("Returning ... binding=" + binding);
            }
            return;
        }
        QueryAtom current = this.plan.next(binding);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Evaluating " + current);
        }
        if (current.isGround() && !current.getPredicate().equals((Object)QueryPredicate.UndistVarCore)) {
            if (QueryEngine.checkGround(current, this.kb)) {
                this.exec(binding);
            }
        } else {
            this.exec(current, binding);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Returning ... " + binding);
        }
        this.plan.back();
    }

    private void exec(QueryAtom current, ResultBinding binding) {
        List<ATermAppl> arguments = current.getArguments();
        boolean direct = false;
        boolean strict = false;
        block0 : switch (current.getPredicate()) {
            case DirectType: {
                direct = true;
            }
            case Type: {
                ATermAppl tI = arguments.get(0);
                ATermAppl tC = arguments.get(1);
                Set<ATermAppl> instanceCandidates = null;
                if (tI.equals(tC)) {
                    instanceCandidates = this.kb.getIndividuals().size() < this.kb.getClasses().size() ? this.kb.getIndividuals() : this.kb.getClasses();
                    for (ATermAppl ic : instanceCandidates) {
                        if (!(direct ? this.kb.getInstances(ic, direct).contains(ic) : this.kb.isType(ic, ic))) continue;
                        ResultBinding candidateBinding = binding.clone();
                        if (ATermUtils.isVar(tI)) {
                            candidateBinding.setValue(tI, ic);
                        }
                        this.exec(candidateBinding);
                    }
                } else {
                    Set<ATermAppl> classCandidates;
                    if (!ATermUtils.isVar(tC)) {
                        classCandidates = Collections.singleton(tC);
                        instanceCandidates = this.kb.getInstances(tC, direct);
                    } else if (!ATermUtils.isVar(tI)) {
                        classCandidates = this.flatten(this.kb.getTypes(tI, direct));
                        instanceCandidates = Collections.singleton(tI);
                    } else {
                        classCandidates = this.kb.getAllClasses();
                    }
                    boolean loadInstances = instanceCandidates == null;
                    for (ATermAppl cls : classCandidates) {
                        if (loadInstances) {
                            instanceCandidates = this.kb.getInstances(cls, direct);
                        }
                        for (ATermAppl inst : instanceCandidates) {
                            this.runNext(binding, arguments, inst, cls);
                        }
                    }
                }
                break;
            }
            case PropertyValue: {
                ATermAppl pvI = arguments.get(0);
                ATermAppl pvP = arguments.get(1);
                ATermAppl pvIL = arguments.get(2);
                Set<ATermAppl> propertyCandidates = null;
                Collection<ATermAppl> subjectCandidates = null;
                Collection<ATermAppl> objectCandidates = null;
                boolean loadProperty = false;
                boolean loadSubjects = false;
                boolean loadObjects = false;
                if (!ATermUtils.isVar(pvP)) {
                    propertyCandidates = Collections.singleton(pvP);
                    if (!ATermUtils.isVar(pvI)) {
                        subjectCandidates = Collections.singleton(pvI);
                        objectCandidates = this.kb.getPropertyValues(pvP, pvI);
                    } else if (!ATermUtils.isVar(pvIL)) {
                        objectCandidates = Collections.singleton(pvIL);
                        subjectCandidates = this.kb.getIndividualsWithProperty(pvP, pvIL);
                    }
                    loadProperty = false;
                } else {
                    if (!ATermUtils.isVar(pvI)) {
                        subjectCandidates = Collections.singleton(pvI);
                    }
                    if (!ATermUtils.isVar(pvIL)) {
                        objectCandidates = Collections.singleton(pvIL);
                    } else if (!this.plan.getQuery().getDistVarsForType(Query.VarType.LITERAL).contains(pvIL)) {
                        propertyCandidates = this.kb.getObjectProperties();
                    }
                    if (propertyCandidates == null) {
                        propertyCandidates = this.kb.getProperties();
                    }
                    loadProperty = true;
                }
                loadSubjects = subjectCandidates == null;
                loadObjects = objectCandidates == null;
                for (ATermAppl property : propertyCandidates) {
                    if (loadObjects && loadSubjects) {
                        if (pvI.equals(pvIL)) {
                            if (pvI.equals(pvP)) {
                                if (!this.kb.hasPropertyValue(property, property, property)) continue;
                                this.runNext(binding, arguments, property, property, property);
                                continue;
                            }
                            for (ATermAppl i : this.kb.getIndividuals()) {
                                if (!this.kb.hasPropertyValue(i, property, i)) continue;
                                this.runNext(binding, arguments, i, property, i);
                            }
                            continue;
                        }
                        if (pvI.equals(pvP)) {
                            for (ATermAppl i : this.kb.getIndividuals()) {
                                if (!this.kb.hasPropertyValue(property, property, i)) continue;
                                this.runNext(binding, arguments, property, property, i);
                            }
                            continue;
                        }
                        if (pvIL.equals(pvP)) {
                            for (ATermAppl i : this.kb.getIndividuals()) {
                                if (!this.kb.hasPropertyValue(i, property, property)) continue;
                                this.runNext(binding, arguments, i, property, property);
                            }
                            continue;
                        }
                        for (ATermAppl subject : this.kb.getIndividuals()) {
                            for (ATermAppl object : this.kb.getPropertyValues(property, subject)) {
                                this.runNext(binding, arguments, subject, property, object);
                            }
                        }
                        continue;
                    }
                    if (loadObjects) {
                        if (pvP.equals(pvIL) && !this.kb.hasPropertyValue(subjectCandidates.iterator().next(), property, property)) {
                            subjectCandidates = Collections.emptySet();
                        }
                        for (ATermAppl subject : subjectCandidates) {
                            for (ATermAppl object : this.kb.getPropertyValues(property, subject)) {
                                this.runNext(binding, arguments, subject, property, object);
                            }
                        }
                        continue;
                    }
                    for (ATermAppl object : objectCandidates) {
                        if (loadSubjects) {
                            subjectCandidates = pvI.equals(pvP) ? (this.kb.hasPropertyValue(property, property, object) ? Collections.singleton(property) : Collections.emptySet()) : new HashSet<ATermAppl>(this.kb.getIndividualsWithProperty(property, object));
                        }
                        for (ATermAppl subject : subjectCandidates) {
                            if (loadProperty && !this.kb.hasPropertyValue(subject, property, object)) continue;
                            this.runNext(binding, arguments, subject, property, object);
                        }
                    }
                }
                break;
            }
            case SameAs: {
                ATermAppl saI1 = arguments.get(0);
                ATermAppl saI2 = arguments.get(1);
                for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.INDIVIDUAL, saI1, saI2)) {
                    Set<ATermAppl> dependents = saI1.equals(saI2) ? Collections.singleton(known) : this.kb.getSames(known);
                    for (ATermAppl dependent : dependents) {
                        this.runSymetricCheck(current, saI1, known, saI2, dependent, binding);
                    }
                }
                break;
            }
            case DifferentFrom: {
                ATermAppl dfI1 = arguments.get(0);
                ATermAppl dfI2 = arguments.get(1);
                if (!dfI1.equals(dfI2)) {
                    for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.INDIVIDUAL, dfI1, dfI2)) {
                        for (ATermAppl dependent : this.kb.getDifferents(known)) {
                            this.runSymetricCheck(current, dfI1, known, dfI2, dependent, binding);
                        }
                    }
                    break;
                }
                if (!log.isLoggable(Level.FINER)) break;
                log.finer("Atom " + current + "cannot be satisfied in any consistent ontology.");
                break;
            }
            case Annotation: {
                ATermAppl aI = arguments.get(0);
                ATermAppl aP = arguments.get(1);
                ATermAppl aIL = arguments.get(2);
                Set<ATermAppl> propertyCandidates = null;
                Set<ATermAppl> subjectCandidates = null;
                Set<ATermAppl> objectCandidates = null;
                boolean loadProperty = false;
                boolean loadSubjects = false;
                boolean loadObjects = false;
                propertyCandidates = Collections.singleton(aP);
                if (!ATermUtils.isVar(aI)) {
                    subjectCandidates = Collections.singleton(aI);
                    objectCandidates = this.kb.getAnnotations(aI, aP);
                } else if (!ATermUtils.isVar(aIL)) {
                    objectCandidates = Collections.singleton(aIL);
                    subjectCandidates = this.kb.getIndividuals();
                }
                loadProperty = false;
                loadSubjects = subjectCandidates == null;
                loadObjects = objectCandidates == null;
                for (ATermAppl property : propertyCandidates) {
                    Set<ATermAppl> annotations;
                    if (loadObjects && loadSubjects) {
                        if (aI.equals(aIL)) {
                            for (ATermAppl i : this.kb.getIndividuals()) {
                                if (!this.kb.isAnnotation(i, property, i)) continue;
                                this.runNext(binding, arguments, i, property, i);
                            }
                            continue;
                        }
                        for (ATermAppl subject : this.kb.getIndividuals()) {
                            annotations = this.kb.getAnnotations(subject, property);
                            if (annotations == null) continue;
                            for (ATermAppl object : annotations) {
                                this.runNext(binding, arguments, subject, property, object);
                            }
                        }
                        continue;
                    }
                    if (loadObjects) {
                        for (ATermAppl subject : subjectCandidates) {
                            annotations = this.kb.getAnnotations(subject, property);
                            if (annotations == null) continue;
                            for (ATermAppl object : annotations) {
                                this.runNext(binding, arguments, subject, property, object);
                            }
                        }
                        continue;
                    }
                    for (ATermAppl object : objectCandidates) {
                        if (loadSubjects) {
                            subjectCandidates = new HashSet<ATermAppl>(this.kb.getIndividualsWithAnnotation(property, object));
                        }
                        for (ATermAppl subject : subjectCandidates) {
                            if (loadProperty && !this.kb.isAnnotation(subject, property, object)) continue;
                            this.runNext(binding, arguments, subject, property, object);
                        }
                    }
                }
                break;
            }
            case DirectSubClassOf: {
                direct = true;
            }
            case StrictSubClassOf: {
                strict = true;
            }
            case SubClassOf: {
                ATermAppl scLHS = arguments.get(0);
                ATermAppl scRHS = arguments.get(1);
                if (scLHS.equals(scRHS)) {
                    for (ATermAppl ic : this.kb.getClasses()) {
                        this.runNext(binding, arguments, ic, ic);
                    }
                } else {
                    Set<ATermAppl> lhsCandidates;
                    boolean lhsDM = this.isDownMonotonic(scLHS);
                    boolean rhsDM = this.isDownMonotonic(scRHS);
                    if (lhsDM || rhsDM) {
                        this.downMonotonic(this.kb.getTaxonomy(), this.kb.getClasses(), lhsDM, scLHS, scRHS, binding, direct, strict);
                        break;
                    }
                    Set<ATermAppl> rhsCandidates = null;
                    if (!ATermUtils.isVar(scLHS)) {
                        lhsCandidates = Collections.singleton(scLHS);
                        rhsCandidates = this.flatten(this.kb.getSuperClasses(scLHS, direct));
                        rhsCandidates.addAll(this.kb.getEquivalentClasses(scLHS));
                        if (strict) {
                            rhsCandidates.removeAll(this.kb.getEquivalentClasses(scLHS));
                        } else if (!ATermUtils.isComplexClass((ATerm)scLHS)) {
                            rhsCandidates.add(scLHS);
                        }
                    } else if (!ATermUtils.isVar(scRHS)) {
                        rhsCandidates = Collections.singleton(scRHS);
                        lhsCandidates = this.flatten(this.kb.getSubClasses(scRHS, direct));
                        lhsCandidates.addAll(this.kb.getEquivalentClasses(scRHS));
                        if (strict) {
                            lhsCandidates.removeAll(this.kb.getEquivalentClasses(scRHS));
                        } else if (!ATermUtils.isComplexClass((ATerm)scRHS)) {
                            lhsCandidates.add(scRHS);
                        }
                    } else {
                        lhsCandidates = this.kb.getClasses();
                    }
                    boolean reload = rhsCandidates == null;
                    for (ATermAppl subject : lhsCandidates) {
                        if (reload) {
                            rhsCandidates = this.flatten(this.kb.getSuperClasses(subject, direct));
                            if (strict) {
                                rhsCandidates.removeAll(this.kb.getEquivalentClasses(subject));
                            } else if (!ATermUtils.isComplexClass((ATerm)subject)) {
                                rhsCandidates.add(subject);
                            }
                        }
                        for (ATermAppl object : rhsCandidates) {
                            this.runNext(binding, arguments, subject, object);
                        }
                    }
                }
                break;
            }
            case EquivalentClass: {
                ATermAppl eqcLHS = arguments.get(0);
                ATermAppl eqcRHS = arguments.get(1);
                block62: for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.CLASS, eqcLHS, eqcRHS)) {
                    Set<ATermAppl> dependents = eqcLHS.equals(eqcRHS) ? Collections.singleton(known) : this.kb.getEquivalentClasses(known);
                    for (ATermAppl dependent : dependents) {
                        int size = this.result.size();
                        this.runSymetricCheck(current, eqcLHS, known, eqcRHS, dependent, binding);
                        if (this.result.size() != size) continue;
                        continue block62;
                    }
                }
                break;
            }
            case DisjointWith: {
                ATermAppl dwLHS = arguments.get(0);
                ATermAppl dwRHS = arguments.get(1);
                if (!dwLHS.equals(dwRHS)) {
                    for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.CLASS, dwLHS, dwRHS)) {
                        for (Set<ATermAppl> dependents : this.kb.getDisjointClasses(known)) {
                            for (ATermAppl dependent : dependents) {
                                this.runSymetricCheck(current, dwLHS, known, dwRHS, dependent, binding);
                            }
                        }
                    }
                    break;
                }
                log.finer("Atom " + current + "cannot be satisfied in any consistent ontology.");
                break;
            }
            case ComplementOf: {
                ATermAppl coLHS = arguments.get(0);
                ATermAppl coRHS = arguments.get(1);
                if (!coLHS.equals(coRHS)) {
                    for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.CLASS, coLHS, coRHS)) {
                        for (ATermAppl dependent : this.kb.getComplements(known)) {
                            this.runSymetricCheck(current, coLHS, known, coRHS, dependent, binding);
                        }
                    }
                    break;
                }
                log.finer("Atom " + current + "cannot be satisfied in any consistent ontology.");
                break;
            }
            case DirectSubPropertyOf: {
                direct = true;
            }
            case StrictSubPropertyOf: {
                strict = true;
            }
            case SubPropertyOf: {
                ATermAppl spLHS = arguments.get(0);
                ATermAppl spRHS = arguments.get(1);
                if (spLHS.equals(spRHS)) {
                    for (ATermAppl ic : this.kb.getProperties()) {
                        this.runNext(binding, arguments, ic, ic);
                    }
                } else {
                    Set<ATermAppl> spLhsCandidates;
                    boolean lhsDM = this.isDownMonotonic(spLHS);
                    boolean rhsDM = this.isDownMonotonic(spRHS);
                    if (lhsDM || rhsDM) {
                        this.downMonotonic(this.kb.getRoleTaxonomy(), this.kb.getProperties(), lhsDM, spLHS, spRHS, binding, direct, strict);
                        break;
                    }
                    Set<ATermAppl> spRhsCandidates = null;
                    if (!ATermUtils.isVar(spLHS)) {
                        spLhsCandidates = Collections.singleton(spLHS);
                        spRhsCandidates = this.flatten(this.kb.getSuperProperties(spLHS, direct));
                        if (strict) {
                            spRhsCandidates.removeAll(this.kb.getEquivalentProperties(spLHS));
                        } else {
                            spRhsCandidates.add(spLHS);
                        }
                    } else if (!ATermUtils.isVar(spRHS)) {
                        spRhsCandidates = Collections.singleton(spRHS);
                        spLhsCandidates = this.flatten(this.kb.getSubProperties(spRHS, direct));
                        if (strict) {
                            spLhsCandidates.removeAll(this.kb.getEquivalentProperties(spRHS));
                        } else {
                            spLhsCandidates.add(spRHS);
                        }
                    } else {
                        spLhsCandidates = this.kb.getProperties();
                    }
                    boolean reload = spRhsCandidates == null;
                    for (ATermAppl subject : spLhsCandidates) {
                        if (reload) {
                            spRhsCandidates = this.flatten(this.kb.getSuperProperties(subject, direct));
                            if (strict) {
                                spRhsCandidates.removeAll(this.kb.getEquivalentProperties(subject));
                            } else {
                                spRhsCandidates.add(subject);
                            }
                        }
                        for (ATermAppl object : spRhsCandidates) {
                            this.runNext(binding, arguments, subject, object);
                        }
                    }
                }
                break;
            }
            case EquivalentProperty: {
                ATermAppl eqpLHS = arguments.get(0);
                ATermAppl eqpRHS = arguments.get(1);
                block72: for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.PROPERTY, eqpLHS, eqpRHS)) {
                    Set<ATermAppl> dependents = eqpLHS.equals(eqpRHS) ? Collections.singleton(known) : this.kb.getEquivalentProperties(known);
                    for (ATermAppl dependent : dependents) {
                        int size = this.result.size();
                        this.runSymetricCheck(current, eqpLHS, known, eqpRHS, dependent, binding);
                        if (this.result.size() != size) continue;
                        continue block72;
                    }
                }
                break;
            }
            case InverseOf: {
                ATermAppl ioLHS = arguments.get(0);
                ATermAppl ioRHS = arguments.get(1);
                if (!ioLHS.equals(ioRHS)) {
                    for (ATermAppl known : this.getSymmetricCandidates(Query.VarType.PROPERTY, ioLHS, ioRHS)) {
                        for (ATermAppl dependent : this.kb.getInverses((ATerm)known)) {
                            this.runSymetricCheck(current, ioLHS, known, ioRHS, dependent, binding);
                        }
                    }
                }
            }
            case Symmetric: {
                this.runAllPropertyChecks(current, arguments.get(0), this.kb.getSymmetricProperties(), binding);
                break;
            }
            case ObjectProperty: {
                this.runAllPropertyChecks(current, arguments.get(0), this.kb.getObjectProperties(), binding);
                break;
            }
            case DatatypeProperty: {
                this.runAllPropertyChecks(current, arguments.get(0), this.kb.getDataProperties(), binding);
                break;
            }
            case Functional: {
                this.runAllPropertyChecks(current, arguments.get(0), this.kb.getFunctionalProperties(), binding);
                break;
            }
            case InverseFunctional: {
                this.runAllPropertyChecks(current, arguments.get(0), this.kb.getInverseFunctionalProperties(), binding);
                break;
            }
            case Transitive: {
                this.runAllPropertyChecks(current, arguments.get(0), this.kb.getTransitiveProperties(), binding);
                break;
            }
            case UndistVarCore: {
                CoreNewImpl core = (CoreNewImpl)current.apply(binding);
                Collection distVars = core.getDistVars();
                if (distVars.isEmpty()) {
                    ATermAppl clazz;
                    Collection constants = core.getConstants();
                    if (constants.isEmpty()) {
                        if (!QueryEngine.execBooleanABoxQuery(core.getQuery())) break;
                        this.result.add(binding);
                        break;
                    }
                    ATermAppl c = (ATermAppl)constants.iterator().next();
                    if (!this.kb.isType(c, clazz = core.getQuery().rollUpTo(c, Collections.<ATermAppl>emptySet(), this.STOP_ROLLING_ON_CONSTANTS))) break;
                    this.exec(binding);
                    break;
                }
                if (distVars.size() == 1) {
                    ATermAppl var = (ATermAppl)distVars.iterator().next();
                    ATermAppl c = core.getQuery().rollUpTo(var, Collections.<ATermAppl>emptySet(), this.STOP_ROLLING_ON_CONSTANTS);
                    Set<ATermAppl> instances = this.kb.getInstances(c);
                    for (ATermAppl a : instances) {
                        ResultBinding candidateBinding = binding.clone();
                        candidateBinding.setValue(var, a);
                        this.exec(candidateBinding);
                    }
                    break;
                }
                CoreStrategy s = QueryEngine.getStrategy(current);
                switch (s) {
                    case SIMPLE: {
                        this.execSimpleCore(this.oldQuery, binding, distVars);
                        break block0;
                    }
                    case ALLFAST: {
                        this.execAllFastCore(this.oldQuery, binding, distVars, core.getUndistVars());
                        break block0;
                    }
                }
                throw new InternalReasonerException("Unknown core strategy.");
            }
            case NegativePropertyValue: {
                ATermAppl s = arguments.get(0);
                ATermAppl p = arguments.get(1);
                ATermAppl o = arguments.get(2);
                if (ATermUtils.isVar(p)) {
                    throw new UnsupportedQueryException("NegativePropertyValue atom with a variable property not supported");
                }
                if (ATermUtils.isVar(o) && this.kb.isDatatypeProperty((ATerm)p)) {
                    throw new UnsupportedQueryException("NegativePropertyValue atom with a datatype property and variable object not supported");
                }
                if (ATermUtils.isVar(s)) {
                    Set<ATermAppl> oValues = ATermUtils.isVar(o) ? this.kb.getIndividuals() : Collections.singleton(o);
                    for (ATermAppl oValue : oValues) {
                        Set<ATermAppl> sValues = this.kb.getInstances(TermFactory.not(TermFactory.hasValue(p, oValue)));
                        for (ATermAppl sValue : sValues) {
                            this.runNext(binding, arguments, sValue, p, oValue);
                        }
                    }
                    break;
                }
                if (ATermUtils.isVar(o)) {
                    Set<ATermAppl> oValues = this.kb.getInstances(TermFactory.not(TermFactory.hasValue(TermFactory.inv(p), o)));
                    for (ATermAppl oValue : oValues) {
                        this.runNext(binding, arguments, s, p, oValue);
                    }
                    break;
                }
                if (!this.kb.isType(s, TermFactory.hasValue(p, o))) break;
                this.exec(binding);
                break;
            }
            case NotKnown: {
                QueryImpl newQuery = new QueryImpl(this.kb, true);
                for (QueryAtom atom : ((NotKnownQueryAtom)current).getAtoms()) {
                    newQuery.add(atom.apply(binding));
                }
                for (ATermAppl var : newQuery.getUndistVars()) {
                    newQuery.addDistVar(var, Query.VarType.INDIVIDUAL);
                }
                CombinedQueryEngine newEngine = new CombinedQueryEngine();
                boolean isNegationTrue = newEngine.exec(newQuery).isEmpty();
                if (!isNegationTrue) break;
                this.exec(binding);
                break;
            }
            case Union: {
                for (List<QueryAtom> atoms : ((UnionQueryAtom)current).getUnion()) {
                    QueryImpl newQuery = new QueryImpl(this.kb, true);
                    for (QueryAtom atom : atoms) {
                        newQuery.add(atom.apply(binding));
                    }
                    for (ATermAppl var : newQuery.getUndistVars()) {
                        newQuery.addDistVar(var, Query.VarType.INDIVIDUAL);
                    }
                    CombinedQueryEngine newEngine = new CombinedQueryEngine();
                    QueryResult newResult = newEngine.exec(newQuery);
                    for (ResultBinding newBinding : newResult) {
                        this.exec(newBinding);
                    }
                }
                break;
            }
            case Datatype: {
                throw new UnsupportedQueryException("Datatype atom not ground: " + current);
            }
            default: {
                throw new UnsupportedQueryException("Unknown atom type '" + (Object)((Object)current.getPredicate()) + "'.");
            }
        }
    }

    private void execSimpleCore(Query q, ResultBinding binding, Collection<ATermAppl> distVars) {
        HashMap<ATermAppl, Set<ATermAppl>> varBindings = new HashMap<ATermAppl, Set<ATermAppl>>();
        KnowledgeBase kb = q.getKB();
        for (ATermAppl currVar : distVars) {
            ATermAppl rolledUpClass = q.rollUpTo(currVar, Collections.<ATermAppl>emptySet(), this.STOP_ROLLING_ON_CONSTANTS);
            if (log.isLoggable(Level.FINER)) {
                log.finer(currVar + " rolled to " + rolledUpClass);
            }
            Set<ATermAppl> inst = kb.getInstances(rolledUpClass);
            varBindings.put(currVar, inst);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Var bindings: " + varBindings);
        }
        Set<ATermAppl> literalVars = q.getDistVarsForType(Query.VarType.LITERAL);
        Set<ATermAppl> individualVars = q.getDistVarsForType(Query.VarType.INDIVIDUAL);
        boolean hasLiterals = !individualVars.containsAll(literalVars);
        BindingIterator i = new BindingIterator(varBindings);
        while (i.hasNext()) {
            ResultBinding candidate = ((ResultBinding)i.next()).clone();
            candidate.setValues(binding);
            if (hasLiterals) {
                LiteralIterator l = new LiteralIterator(q, candidate);
                while (l.hasNext()) {
                    ResultBinding mappy = binding.clone();
                    mappy.setValues((ResultBinding)l.next());
                    if (!QueryEngine.execBooleanABoxQuery(q.apply(mappy))) continue;
                    this.exec(mappy);
                }
                continue;
            }
            if (!QueryEngine.execBooleanABoxQuery(q.apply(candidate))) continue;
            this.exec(candidate);
        }
    }

    private Map<ATermAppl, Boolean> fastPrune(Query q, ATermAppl var) {
        ATermAppl c = q.rollUpTo(var, Collections.<ATermAppl>emptySet(), this.STOP_ROLLING_ON_CONSTANTS);
        if (log.isLoggable(Level.FINER)) {
            log.finer(var + " rolled to " + c);
        }
        CandidateSet<ATermAppl> set = this.kb.getABox().getObviousInstances(c);
        HashMap<ATermAppl, Boolean> map = new HashMap<ATermAppl, Boolean>();
        for (ATermAppl o : set.getKnowns()) {
            map.put(o, true);
        }
        for (ATermAppl o : set.getUnknowns()) {
            map.put(o, false);
        }
        return map;
    }

    private void execAllFastCore(Query q, ResultBinding binding, Collection<ATermAppl> distVars, Collection<ATermAppl> undistVars) {
        if (distVars.isEmpty()) {
            this.exec(binding);
        } else {
            ATermAppl var = distVars.iterator().next();
            distVars.remove(var);
            Map<ATermAppl, Boolean> instances = this.fastPrune(q, var);
            for (ATermAppl b : instances.keySet()) {
                ResultBinding newBinding = binding.clone();
                newBinding.setValue(var, b);
                Query q2 = q.apply(newBinding);
                if (!instances.get(b).booleanValue() && !QueryEngine.execBooleanABoxQuery(q2)) continue;
                this.execAllFastCore(q2, newBinding, distVars, undistVars);
            }
            distVars.add(var);
        }
    }

    private void downMonotonic(Taxonomy<ATermAppl> taxonomy, Collection<ATermAppl> all, boolean lhsDM, ATermAppl lhs, ATermAppl rhs, ResultBinding binding, boolean direct, boolean strict) {
        Collection<ATermAppl> candidates;
        ATermAppl theOther;
        ATermAppl downMonotonic = lhsDM ? lhs : rhs;
        ATermAppl aTermAppl = theOther = lhsDM ? rhs : lhs;
        if (ATermUtils.isVar(theOther)) {
            candidates = all;
        } else {
            ATermAppl top;
            ATermAppl aTermAppl2 = top = lhsDM ? rhs : taxonomy.getTop().getName();
            if (ATermUtils.isComplexClass((ATerm)top)) {
                candidates = this.kb.getEquivalentClasses(top);
                if (!strict && candidates.isEmpty()) {
                    candidates = this.flatten(this.kb.getSubClasses(top, true));
                }
            } else {
                candidates = Collections.singleton(top);
            }
        }
        for (ATermAppl candidate : candidates) {
            Set<ATermAppl> toDo;
            ResultBinding newBinding = binding.clone();
            if (ATermUtils.isVar(theOther)) {
                newBinding.setValue(theOther, candidate);
            }
            Set<ATermAppl> set = toDo = lhsDM ? this.flatten(taxonomy.getSubs(candidate, direct)) : this.flatten(taxonomy.getSupers(candidate, direct));
            if (strict) {
                toDo.removeAll(taxonomy.getEquivalents(candidate));
            } else {
                toDo.add(candidate);
            }
            this.runRecursively(taxonomy, downMonotonic, candidate, newBinding, new HashSet<ATermAppl>(toDo), direct, strict);
        }
    }

    private boolean isDownMonotonic(ATermAppl scLHS) {
        return PelletOptions.OPTIMIZE_DOWN_MONOTONIC && this.downMonotonic.contains(scLHS);
    }

    private void runNext(ResultBinding binding, List<ATermAppl> arguments, ATermAppl ... values) {
        ResultBinding candidateBinding = binding.clone();
        for (int i = 0; i < arguments.size(); ++i) {
            if (!ATermUtils.isVar(arguments.get(i))) continue;
            candidateBinding.setValue(arguments.get(i), values[i]);
        }
        this.exec(candidateBinding);
    }

    private Set<ATermAppl> getSymmetricCandidates(Query.VarType forType, ATermAppl cA, ATermAppl cB) {
        Set<ATermAppl> candidates;
        if (!ATermUtils.isVar(cA)) {
            candidates = Collections.singleton(cA);
        } else if (!ATermUtils.isVar(cB)) {
            candidates = Collections.singleton(cB);
        } else {
            switch (forType) {
                case CLASS: {
                    candidates = this.kb.getClasses();
                    break;
                }
                case PROPERTY: {
                    candidates = this.kb.getProperties();
                    break;
                }
                case INDIVIDUAL: {
                    candidates = this.kb.getIndividuals();
                    break;
                }
                default: {
                    throw new RuntimeException("Uknown variable type : " + (Object)((Object)forType));
                }
            }
        }
        return candidates;
    }

    private void runRecursively(Taxonomy<ATermAppl> t, ATermAppl downMonotonic, ATermAppl rootCandidate, ResultBinding binding, Set<ATermAppl> toDo, boolean direct, boolean strict) {
        int size = this.result.size();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Trying : " + rootCandidate + ", done=" + toDo);
        }
        if (!strict) {
            toDo.remove(rootCandidate);
            this.runNext(binding, Collections.singletonList(downMonotonic), rootCandidate);
        }
        if (strict || this.result.size() > size) {
            Set<ATermAppl> subs = this.flatten(t.getSubs(rootCandidate, direct));
            for (ATermAppl subject : subs) {
                if (!toDo.contains(subject)) continue;
                this.runRecursively(t, downMonotonic, subject, binding, toDo, false, false);
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Skipping subs of " + rootCandidate);
            }
            toDo.removeAll(this.flatten(t.getSubs(rootCandidate, false)));
        }
    }

    private void runSymetricCheck(QueryAtom current, ATermAppl cA, ATermAppl known, ATermAppl cB, ATermAppl dependent, ResultBinding binding) {
        ResultBinding candidateBinding = binding.clone();
        if (!ATermUtils.isVar(cA)) {
            candidateBinding.setValue(cB, dependent);
        } else if (!ATermUtils.isVar(cB)) {
            candidateBinding.setValue(cA, dependent);
        } else {
            candidateBinding.setValue(cA, known);
            candidateBinding.setValue(cB, dependent);
        }
        this.exec(candidateBinding);
    }

    private void runAllPropertyChecks(QueryAtom current, ATermAppl var, Set<ATermAppl> candidates, ResultBinding binding) {
        if (this.isDownMonotonic(var)) {
            for (TaxonomyNode<ATermAppl> topNode : this.kb.getRoleTaxonomy().getTop().getSubs()) {
                ATermAppl top = topNode.getName();
                if (!candidates.contains(top)) continue;
                this.runRecursively(this.kb.getRoleTaxonomy(), var, topNode.getName(), binding, new HashSet<ATermAppl>(candidates), false, false);
            }
        } else {
            for (ATermAppl candidate : candidates) {
                ResultBinding candidateBinding = binding.clone();
                candidateBinding.setValue(var, candidate);
                this.exec(candidateBinding);
            }
        }
    }

    private Set<ATermAppl> flatten(Set<Set<ATermAppl>> set) {
        HashSet<ATermAppl> result = new HashSet<ATermAppl>();
        for (Set<ATermAppl> set2 : set) {
            for (ATermAppl a : set2) {
                result.add(a);
            }
        }
        return result;
    }
}

