/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.jena;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.resultset.XMLInput;
import com.hp.hpl.jena.util.FileManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class JenaIOUtils {
    public static ResultSet parseResultSet(String resultURI) throws IOException {
        if (resultURI.endsWith("srx")) {
            return ResultSetFactory.fromXML((InputStream)URI.create(resultURI).toURL().openStream());
        }
        if (resultURI.endsWith("ttl")) {
            return ResultSetFactory.fromRDF((Model)FileManager.get().loadModel(resultURI));
        }
        if (resultURI.endsWith("rdf")) {
            return ResultSetFactory.fromRDF((Model)FileManager.get().loadModel(resultURI));
        }
        throw new RuntimeException("Unknown format.");
    }

    public static boolean parseAskResult(String resultURI) throws FileNotFoundException {
        if (resultURI.endsWith("srx")) {
            return XMLInput.booleanFromXML((InputStream)new FileInputStream(resultURI.substring(5)));
        }
        if (resultURI.endsWith("ttl") || resultURI.endsWith("rdf")) {
            return FileManager.get().loadModel(resultURI.substring(5)).getProperty(null, ResourceFactory.createProperty((String)"http://www.w3.org/2001/sw/DataAccess/tests/result-set#boolean")).getBoolean();
        }
        throw new RuntimeException("Unknown format.");
    }

    public static RDFFormatType fileType(String fileURI) {
        if (fileURI.endsWith(".n3")) {
            return RDFFormatType.N3;
        }
        if (fileURI.endsWith(".ttl")) {
            return RDFFormatType.TURTLE;
        }
        return RDFFormatType.RDFXML;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RDFFormatType {
        N3("N3"),
        RDFXML("RDF/XML"),
        TURTLE("TURTLE"),
        NTRIPLE("N-TRIPLE");

        private String jenaName;

        private RDFFormatType(String s) {
            this.jenaName = s;
        }

        public String jenaName() {
            return this.jenaName;
        }
    }
}

