/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.model;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionQueryAtom
implements QueryAtom {
    private List<List<QueryAtom>> union;
    private boolean isGround;
    private List<ATermAppl> args;

    public UnionQueryAtom(List<QueryAtom> atoms1, List<QueryAtom> atoms2) {
        this(Arrays.asList(atoms1, atoms2));
    }

    public UnionQueryAtom(List<List<QueryAtom>> union) {
        if (union.isEmpty()) {
            throw new IllegalArgumentException("Empty collection of atoms not allowed in NotKnown atom");
        }
        this.union = Collections.unmodifiableList(union);
        this.isGround = true;
        this.args = new ArrayList<ATermAppl>();
        for (List<QueryAtom> atoms : union) {
            for (QueryAtom atom : atoms) {
                this.args.addAll(atom.getArguments());
                this.isGround &= atom.isGround();
            }
        }
    }

    @Override
    public QueryAtom apply(ResultBinding binding) {
        ArrayList<List<QueryAtom>> newUnion = new ArrayList<List<QueryAtom>>();
        for (List<QueryAtom> atoms : this.union) {
            ArrayList<QueryAtom> newAtoms = new ArrayList<QueryAtom>();
            for (QueryAtom atom : atoms) {
                newAtoms.add(atom.apply(binding));
            }
            newUnion.add(newAtoms);
        }
        return new UnionQueryAtom(newUnion);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UnionQueryAtom)) {
            return false;
        }
        return ((Object)this.union).equals(((UnionQueryAtom)obj).union);
    }

    @Override
    public List<ATermAppl> getArguments() {
        return this.args;
    }

    public List<List<QueryAtom>> getUnion() {
        return this.union;
    }

    @Override
    public QueryPredicate getPredicate() {
        return QueryPredicate.Union;
    }

    public int hashCode() {
        return 31 * ((Object)this.union).hashCode();
    }

    @Override
    public boolean isGround() {
        return this.isGround;
    }

    public String toString() {
        return "Union" + this.union;
    }
}

