/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.axiom;

import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.pellint.format.CompactClassLintFormat;
import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import java.util.Set;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLSubClassAxiom;

public class EquivalentToAllValuePattern
extends AxiomLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new CompactClassLintFormat();

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getDescription() {
        return "A named concept is equivalent to an AllValues restriction";
    }

    public boolean isFixable() {
        return true;
    }

    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        Set owlDescs = axiom.getDescriptions();
        if (owlDescs.size() != 2) {
            return;
        }
        OWLClass namedClass = null;
        OWLDescription all = null;
        for (OWLDescription owlDesc : owlDescs) {
            if (!owlDesc.isAnonymous()) {
                namedClass = owlDesc.asOWLClass();
                continue;
            }
            if (!(owlDesc instanceof OWLObjectAllRestriction) && !(owlDesc instanceof OWLDataAllRestriction)) continue;
            all = owlDesc;
        }
        if (namedClass != null && all != null) {
            Lint lint = this.makeLint();
            lint.addParticipatingClass(namedClass);
            lint.addParticipatingAxiom((OWLClassAxiom)axiom);
            OWLSubClassAxiom newAxiom = OWL.subClassOf((OWLDescription)namedClass, all);
            LintFixer fixer = new LintFixer((OWLAxiom)axiom, (OWLAxiom)newAxiom);
            lint.setLintFixer(fixer);
            this.setLint(lint);
        }
    }
}

