/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.VersionInfo;
import pellet.PelletClassify;
import pellet.PelletCmdException;
import pellet.PelletConsistency;
import pellet.PelletDIG;
import pellet.PelletEntailment;
import pellet.PelletExplain;
import pellet.PelletExtractInferences;
import pellet.PelletModularity;
import pellet.PelletQuery;
import pellet.PelletRealize;
import pellet.PelletTransTree;
import pellet.PelletUnsatisfiable;
import pellet.Pellint;

public class Pellet {
    public static final Logger logger = Logger.getLogger(Pellet.class.getName());

    public static void main(String[] args) {
        Pellet app = new Pellet();
        try {
            app.run(args);
        }
        catch (PelletCmdException e) {
            Pellet.printError(e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.fine(sw.toString());
            logger.throwing(null, null, e);
        }
    }

    private static void printError(Throwable e) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof FileNotFoundException) {
            System.err.println("ERROR: File not found: " + cause.getMessage());
        } else {
            int index;
            String msg = cause.getMessage();
            if (msg != null && (index = msg.indexOf(10, 0)) != -1) {
                msg = msg.substring(0, index);
            }
            System.err.println("ERROR: " + msg);
        }
    }

    private void run(String[] args) {
        if (args.length == 0) {
            throw new PelletCmdException("Type 'pellet help' for usage.");
        }
        String arg = args[0];
        if (this.matches(arg, "--help", "-h") || this.matches(arg, "help", "h")) {
            this.help(this.shift(args));
        } else if (this.matches(arg, "--version", "-V")) {
            this.version();
        } else if (this.matches(arg, "consistency")) {
            this.consistency(this.shift(args));
        } else if (this.matches(arg, "classify")) {
            this.classify(this.shift(args));
        } else if (this.matches(arg, "realize")) {
            this.realize(this.shift(args));
        } else if (this.matches(arg, "unsat")) {
            this.unsat(this.shift(args));
        } else if (this.matches(arg, "explain")) {
            this.explain(this.shift(args));
        } else if (this.matches(arg, "query")) {
            this.query(this.shift(args));
        } else if (this.matches(arg, "entail")) {
            this.entail(this.shift(args));
        } else if (this.matches(arg, "modularity")) {
            this.modularity(this.shift(args));
        } else if (this.matches(arg, "trans-tree")) {
            this.transtree(this.shift(args));
        } else if (this.matches(arg, "extract")) {
            this.extractinferences(this.shift(args));
        } else if (this.matches(arg, "lint")) {
            this.lint(this.shift(args));
        } else if (this.matches(arg, "dig")) {
            this.dig(this.shift(args));
        } else {
            throw new PelletCmdException("Unrecognized subcommand: " + arg);
        }
    }

    private void help(String[] args) {
        if (args.length == 0) {
            this.mainhelp();
        }
        this.subhelp(args);
    }

    private void mainhelp() {
        StringBuffer buf = new StringBuffer();
        String version = this.getVersionInfo().getVersionString();
        buf.append("Usage: pellet <subcommand> [options] <file URI>...\n");
        buf.append("Pellet command-line client, version " + version + "." + "\n");
        buf.append("Type 'pellet help <subcommand>' for help on a specific subcommand.\n");
        buf.append("\n");
        buf.append("Available subcommands:\n");
        buf.append("  classify\n");
        buf.append("  consistency\n");
        buf.append("  dig\n");
        buf.append("  entail\n");
        buf.append("  explain\n");
        buf.append("  extract\n");
        buf.append("  lint\n");
        buf.append("  modularity\n");
        buf.append("  query\n");
        buf.append("  realize\n");
        buf.append("  trans-tree\n");
        buf.append("  unsat\n\n");
        buf.append("Pellet is an OWL ontology reasoner.\n");
        buf.append("For more information, see http://clarkparsia.com/pellet");
        System.out.println(buf);
        System.exit(0);
    }

    private void subhelp(String[] args) {
        String arg = args[0];
        if (this.matches(arg, "classify")) {
            new PelletClassify(new String[]{"--help"});
        } else if (this.matches(arg, "consistency")) {
            new PelletConsistency(new String[]{"--help"});
        } else if (this.matches(arg, "dig")) {
            new PelletDIG(new String[]{"--help"});
        } else if (this.matches(arg, "entail")) {
            new PelletEntailment(new String[]{"--help"});
        } else if (this.matches(arg, "explain")) {
            new PelletExplain(new String[]{"--help"});
        } else if (this.matches(arg, "extract")) {
            new PelletExtractInferences(new String[]{"--help"});
        } else if (this.matches(arg, "lint")) {
            new Pellint(new String[]{"--help"});
        } else if (this.matches(arg, "modularity")) {
            new PelletModularity(new String[]{"--help"});
        } else if (this.matches(arg, "query")) {
            new PelletQuery(new String[]{"--help"});
        } else if (this.matches(arg, "realize")) {
            new PelletRealize(new String[]{"--help"});
        } else if (this.matches(arg, "trans-tree")) {
            new PelletTransTree(new String[]{"--help"});
        } else if (this.matches(arg, "unsat")) {
            new PelletUnsatisfiable(new String[]{"--help"});
        } else {
            throw new PelletCmdException("Unrecognized subcommand: " + arg);
        }
    }

    private VersionInfo getVersionInfo() {
        return VersionInfo.getInstance();
    }

    private void version() {
        System.out.println(this.getVersionInfo());
    }

    private boolean matches(String arg, String arg1, String arg2) {
        if (arg.equalsIgnoreCase(arg1)) {
            return true;
        }
        return arg.equalsIgnoreCase(arg2);
    }

    private boolean matches(String arg, String arg1) {
        return arg.equalsIgnoreCase(arg1);
    }

    private String[] shift(String[] args) {
        List<String> list = Arrays.asList(args);
        List<String> sub = list.subList(1, args.length);
        return sub.toArray(new String[0]);
    }

    private void dig(String[] args) {
        PelletDIG app = new PelletDIG(args);
        app.run();
    }

    private void lint(String[] args) {
        Pellint app = new Pellint(args);
        app.run();
        System.exit(0);
    }

    private void extractinferences(String[] args) {
        PelletExtractInferences app = new PelletExtractInferences(args);
        app.run();
        System.exit(0);
    }

    private void transtree(String[] args) {
        PelletTransTree app = new PelletTransTree(args);
        app.run();
        System.exit(0);
    }

    private void modularity(String[] args) {
        PelletModularity app = new PelletModularity(args);
        app.run();
        System.exit(0);
    }

    private void entail(String[] args) {
        PelletEntailment app = new PelletEntailment(args);
        app.run();
        System.exit(0);
    }

    private void query(String[] args) {
        PelletQuery app = new PelletQuery(args);
        app.run();
        System.exit(0);
    }

    private void explain(String[] args) {
        PelletExplain app = new PelletExplain(args);
        app.run();
        System.exit(0);
    }

    private void unsat(String[] args) {
        PelletUnsatisfiable app = new PelletUnsatisfiable(args);
        app.run();
        System.exit(0);
    }

    private void realize(String[] args) {
        PelletRealize app = new PelletRealize(args);
        app.run();
        System.exit(0);
    }

    private void classify(String[] args) {
        PelletClassify app = new PelletClassify(args);
        app.run();
        System.exit(0);
    }

    private void consistency(String[] args) {
        PelletConsistency app = new PelletConsistency(args);
        app.run();
        System.exit(0);
    }
}

