/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import java.io.PrintWriter;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.owlapi.OWLAPILoader;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.utils.FileUtils;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLOntology;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletEntailment
extends PelletCmdApp {
    private String entailmentFile;
    private boolean showAll;
    private boolean isEntailed;
    private PrintWriter out = new PrintWriter(System.out);
    private Set<OWLAxiom> nonEntailments = new HashSet<OWLAxiom>();

    public PelletEntailment(String[] args) {
        super(args);
    }

    @Override
    public String getAppId() {
        return "PelletEntailment: Check if all axioms are entailed by the ontology";
    }

    @Override
    public String getAppCmd() {
        return "pellet entailed " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    @Override
    public PelletCmdOptions getOptions() {
        this.showAll = false;
        this.isEntailed = false;
        PelletCmdOptions options = new PelletCmdOptions();
        PelletCmdOption option = new PelletCmdOption("entailment-file");
        option.setShortOption("e");
        option.setType("<file URI>");
        option.setDescription("Entailment ontology URI");
        option.setIsMandatory(true);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("all");
        option.setShortOption("a");
        option.setDescription("Show all non-entailments");
        option.setDefaultValue(this.showAll);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        return options;
    }

    @Override
    public void run() {
        this.entailmentFile = this.options.getOption("entailment-file").getValueAsString();
        this.showAll = this.options.getOption("all").getValueAsBoolean();
        OWLAPILoader loader = (OWLAPILoader)this.getLoader("OWLAPI");
        this.getKB();
        Reasoner reasoner = loader.getReasoner();
        OWLOntology entailmentOntology = null;
        try {
            URI entailmentFileURI = URI.create(FileUtils.toURI(this.entailmentFile));
            entailmentOntology = loader.getManager().loadOntology(entailmentFileURI);
        }
        catch (Exception e) {
            throw new PelletCmdException(e);
        }
        boolean findNext = true;
        Iterator axioms = entailmentOntology.getAxioms().iterator();
        while (axioms.hasNext() && findNext) {
            OWLAxiom axiom = (OWLAxiom)axioms.next();
            boolean isEntailed = reasoner.isEntailed(axiom);
            if (isEntailed) continue;
            this.nonEntailments.add(axiom);
            if (this.showAll) continue;
            findNext = false;
        }
        if (this.nonEntailments.isEmpty()) {
            this.isEntailed = true;
            this.out.append("All axioms are entailed\n");
        } else {
            this.out.append("Non-entailments:\n");
            for (OWLAxiom axiom : this.nonEntailments) {
                this.out.append(axiom.toString() + "\n");
            }
        }
        this.out.flush();
    }

    public boolean isEntailed() {
        return this.isEntailed;
    }

    public Set<OWLAxiom> getNonEntailments() {
        return this.nonEntailments;
    }

    public static void main(String[] args) {
        PelletEntailment app = new PelletEntailment(args);
        app.run();
    }
}

