/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.util.FileManager;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InconsistentOntologyException;
import org.mindswap.pellet.jena.JenaLoader;
import org.mindswap.pellet.jena.NodeFormatter;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

public class PelletQuery
extends PelletCmdApp {
    private String queryFile;
    private String queryString;
    private Timers timers;
    private Query query;
    private JenaLoader loader;
    private PrintWriter out;
    private ResultSet queryResults;
    private Model constructQueryModel;
    private boolean askQueryResult;
    private boolean printTiming = false;
    private boolean printResults = true;
    private boolean displayQuery = false;
    private boolean verbose = false;
    private Syntax queryFormat = Syntax.syntaxSPARQL;
    private OutputFormat outputFormat = OutputFormat.TABULAR;
    private SparqlDLExecutionFactory.QueryEngineType queryEngine = null;

    public String getAppId() {
        return "PelletQuery: SPARQL-DL Query Engine";
    }

    public String getAppCmd() {
        return "pellet query " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = new PelletCmdOptions();
        PelletCmdOption option = new PelletCmdOption("query-file");
        option.setShortOption("q");
        option.setType("<file URI>");
        option.setDescription("Read the SPARQL (or RDQL) query from the given file");
        option.setIsMandatory(true);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("output-format");
        option.setShortOption("o");
        option.setType("Tabular | XML | JSON");
        option.setDescription("Format of result set (SELECT queries)");
        option.setDefaultValue("Tabular");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("query-format");
        option.setType("SPARQL | ARQ | RDQL");
        option.setDescription("The query format");
        option.setDefaultValue("SPARQL");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        options.add(this.getInputFormatOption());
        option = new PelletCmdOption("display-query");
        option.setShortOption("d");
        option.setDescription("Display the input query");
        option.setDefaultValue(this.displayQuery);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        option = new PelletCmdOption("query-engine");
        option.setType("Pellet | ARQ | Mixed");
        option.setShortOption("e");
        option.setDescription("The query engine that will be used. Default behavior is to auto select the engine that can handle the given query with best performance. Pellet query engine is the typically fastest but cannot handle FILTER, OPTIONAL, UNION, DESCRIBE or named graphs. Mixed engine uses ARQ to handle SPARQL algebra and uses Pellet to answer Basic Graph Patterns (BGP) which cane be expressed in SPARQL-DL. ARQ engine uses Pellet to answer single triple patterns and can handle queries that does not fit into SPARQL-DL. As a consequence SPARQL-DL extenions and complex class expression encoded inside the SPARQL query are not supported.");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("bnode");
        option.setDescription("Treat bnodes in the query as undistinguished variables. Undistinguished variables can match individuals whose existence is inferred by the reasoner, e.g. due to a someValuesFrom restriction. This option hasno effect if ARQ engine is selected.");
        option.setDefaultValue(false);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        option = new PelletCmdOption("timing");
        option.setShortOption("t");
        option.setDescription("Print detailed timing information");
        option.setDefaultValue(this.printTiming);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        option = new PelletCmdOption("verbose");
        option.setShortOption("v");
        option.setDescription("Alias for -t -d");
        option.setDefaultValue(this.verbose);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        return options;
    }

    public PelletQuery(String[] args) {
        super(args);
        this.timers = new Timers();
        this.out = new PrintWriter(System.out);
        this.setQueryFile(this.options.getOption("query-file").getValueAsString());
        this.setOutputFormat(this.options.getOption("output-format").getValueAsString());
        this.setQueryFormat(this.options.getOption("query-format").getValueAsString());
        this.setQueryEngine(this.options.getOption("query-engine").getValueAsString());
        this.setPrintTiming(this.options.getOption("timing").getValueAsBoolean());
        this.setDisplayQuery(this.options.getOption("display-query").getValueAsBoolean());
        this.setVerbose(this.options.getOption("verbose").getValueAsBoolean());
        PelletOptions.TREAT_ALL_VARS_DISTINGUISHED = this.options.getOption("bnode").getValueAsBoolean() == false;
    }

    public void run() {
        Timer t = this.timers.startTimer("totalTime");
        this.loadQuery();
        this.loadInput();
        this.execQuery();
        t.stop();
        if (this.printResults) {
            this.printQueryResults();
        }
        if (this.verbose || this.printTiming) {
            this.loader.getKB().timers.print();
        }
        this.out.flush();
    }

    public void setQueryFile(String s) {
        this.queryFile = s;
    }

    public void setPrintResults(Boolean b) {
        this.printResults = b;
    }

    public void setPrintTiming(boolean b) {
        this.printTiming = b;
    }

    public void setDisplayQuery(boolean b) {
        this.displayQuery = b;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public void setOutputFormat(String s) {
        if (s == null) {
            this.outputFormat = OutputFormat.TABULAR;
        } else if (s.equalsIgnoreCase("Tabular")) {
            this.outputFormat = OutputFormat.TABULAR;
        } else if (s.equalsIgnoreCase("XML")) {
            this.outputFormat = OutputFormat.XML;
        } else if (s.equalsIgnoreCase("JSON")) {
            this.outputFormat = OutputFormat.JSON;
        } else {
            throw new PelletCmdException("Invalid output format: " + (Object)((Object)this.outputFormat));
        }
    }

    public ResultSet getQueryResults() {
        return this.queryResults;
    }

    public Model getConstructQueryModel() {
        return this.constructQueryModel;
    }

    public boolean getAskQueryResult() {
        return this.askQueryResult;
    }

    public void setQueryFormat(String s) {
        if (s == null) {
            throw new PelletCmdException("Query format is null: " + s);
        }
        if (s.equalsIgnoreCase("SPARQL")) {
            this.queryFormat = Syntax.lookup((String)"SPARQL");
        } else if (s.equalsIgnoreCase("ARQ")) {
            this.queryFormat = Syntax.lookup((String)"ARQ");
        } else if (s.equalsIgnoreCase("RDQL")) {
            this.queryFormat = Syntax.lookup((String)"RDQL");
        } else {
            throw new PelletCmdException("Unknown query format: " + s);
        }
        if (this.queryFormat == null) {
            throw new PelletCmdException("Query format is null: " + s);
        }
    }

    public void setQueryEngine(String s) {
        if (s == null) {
            this.queryEngine = null;
            return;
        }
        try {
            this.queryEngine = SparqlDLExecutionFactory.QueryEngineType.valueOf(s.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new PelletCmdException("Unknown query engine: " + s);
        }
    }

    public static void main(String[] args) {
        PelletQuery pelletQuery = new PelletQuery(args);
        pelletQuery.run();
    }

    private void loadInput() {
        Timer t = this.timers.startTimer("Loading");
        try {
            this.loader = (JenaLoader)this.getLoader("Jena");
            this.loader.createKB(this.getInputFiles()).ensureConsistency();
        }
        catch (NotFoundException e) {
            throw new PelletCmdException(e);
        }
        catch (QueryParseException e) {
            throw new PelletCmdException(e);
        }
        catch (InconsistentOntologyException e) {
            throw new PelletCmdException("Cannot query inconsistent ontology!");
        }
        t.stop();
    }

    private void loadQuery() {
        try {
            this.queryString = FileManager.get().readWholeFileAsUTF8(this.queryFile);
            this.query = QueryFactory.create((String)this.queryString, (Syntax)this.queryFormat);
        }
        catch (NotFoundException e) {
            throw new PelletCmdException(e);
        }
        catch (QueryParseException e) {
            throw new PelletCmdException(e);
        }
    }

    private void execQuery() {
        QueryExecution qe;
        DataSource dataset = DatasetFactory.create((Model)this.loader.getModel());
        QueryExecution queryExecution = qe = this.queryEngine == null ? SparqlDLExecutionFactory.create(this.query, (Dataset)dataset) : SparqlDLExecutionFactory.create(this.query, (Dataset)dataset, null, this.queryEngine);
        if (this.query.isSelectType()) {
            this.queryResults = qe.execSelect();
        } else if (this.query.isConstructType()) {
            this.constructQueryModel = qe.execConstruct();
        } else if (this.query.isAskType()) {
            this.askQueryResult = qe.execAsk();
        } else {
            throw new UnsupportedOperationException("Unsupported query type");
        }
    }

    private void printQueryResults() {
        if (this.verbose || this.displayQuery) {
            this.out.println("Query: ");
            this.out.println(this.queryString.trim());
            this.out.println("-----------------------------------------------------");
        }
        if (this.query.isSelectType()) {
            this.printSelectQueryResuts();
        } else if (this.query.isConstructType()) {
            this.printConstructQueryResults();
        } else if (this.query.isAskType()) {
            this.printAskQueryResult();
        }
    }

    private void printSelectQueryResuts() {
        if (this.queryResults.hasNext()) {
            if (this.outputFormat == OutputFormat.TABULAR) {
                this.printTabularQueryResults();
            } else if (this.outputFormat == OutputFormat.XML) {
                this.printXMLQueryResults();
            } else if (this.outputFormat == OutputFormat.JSON) {
                this.printJSONQueryResults();
            } else {
                this.printTabularQueryResults();
            }
        } else {
            this.out.println("Query Results (0 answers): ");
            this.out.println("NO RESULTS");
        }
    }

    private void printTabularQueryResults() {
        int count = 0;
        NodeFormatter formatter = new NodeFormatter((Model)this.loader.getModel());
        List resultVars = this.query.getResultVars();
        LinkedHashSet data = new LinkedHashSet();
        while (this.queryResults.hasNext()) {
            QuerySolution binding = this.queryResults.nextSolution();
            ArrayList<String> formattedBinding = new ArrayList<String>();
            for (int i = 0; i < resultVars.size(); ++i) {
                String var = (String)resultVars.get(i);
                RDFNode result = binding.get(var);
                formattedBinding.add(formatter.format(result));
            }
            if (!data.add(formattedBinding)) continue;
            ++count;
        }
        this.out.println("Query Results (" + count + " answers): ");
        TableData table = new TableData(data, resultVars);
        table.print(this.out);
    }

    private void printXMLQueryResults() {
        ResultSetFormatter.outputAsXML((ResultSet)this.queryResults);
    }

    private void printJSONQueryResults() {
        ResultSetFormatter.outputAsJSON((ResultSet)this.queryResults);
    }

    private void printConstructQueryResults() {
        this.constructQueryModel.write((Writer)this.out);
    }

    private void printAskQueryResult() {
        this.out.print("ASK query result: ");
        this.out.println(this.askQueryResult ? "yes" : "no");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OutputFormat {
        TABULAR,
        XML,
        JSON;

    }
}

