/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOptions;

public class PelletRealize
extends PelletCmdApp {
    public PelletRealize(String[] args) {
        super(args);
    }

    public String getAppCmd() {
        return "pellet realize " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    public String getAppId() {
        return "PelletRealize: Compute and display the most specific instances for each class";
    }

    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = new PelletCmdOptions();
        options.add(this.getLoaderOption());
        options.add(this.getInputFormatOption());
        return options;
    }

    public void run() {
        Timers timers = new Timers();
        KnowledgeBase kb = this.getKB();
        if (!kb.isConsistent()) {
            throw new PelletCmdException("Ontology is inconsistent");
        }
        Timer t = timers.startTimer("Realization");
        kb.realize();
        t.stop();
        ClassTreePrinter printer = new ClassTreePrinter();
        printer.print(kb.getTaxonomy());
    }

    public static void main(String[] args) {
        PelletRealize app = new PelletRealize(args);
        app.run();
    }
}

