/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import aterm.ATermAppl;
import java.util.Iterator;
import java.util.TreeSet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.utils.Comparators;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOptions;

public class PelletUnsatisfiable
extends PelletCmdApp {
    public PelletUnsatisfiable(String[] args) {
        super(args);
    }

    public String getAppCmd() {
        return "pellet unsatisfiable " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    public String getAppId() {
        return "PelletUnsatisfiable: Find the unsatisfiable classes in the ontology";
    }

    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = new PelletCmdOptions();
        options.add(this.getLoaderOption());
        options.add(this.getInputFormatOption());
        return options;
    }

    public void run() {
        KnowledgeBase kb = this.getKB();
        if (!kb.isConsistent()) {
            throw new PelletCmdException("Ontology is inconsistent");
        }
        QNameProvider qnames = new QNameProvider();
        TreeSet<Object> unsatisfiableClasses = new TreeSet<Object>(Comparators.stringComparator);
        ProgressMonitor monitor = PelletOptions.USE_CLASSIFICATION_MONITOR.create();
        monitor.setProgressTitle("Checking unsatisfiability");
        monitor.setProgressLength(kb.getClasses().size());
        monitor.taskStarted();
        Iterator<ATermAppl> i = kb.getClasses().iterator();
        while (i.hasNext()) {
            monitor.incrementProgress();
            ATermAppl c = i.next();
            if (kb.isSatisfiable(c)) continue;
            unsatisfiableClasses.add(qnames.shortForm(c.getName()));
        }
        monitor.taskFinished();
        this.out.println();
        if (unsatisfiableClasses.isEmpty()) {
            this.out.println("There are no unsatisfiable concepts.");
        } else {
            this.out.println("There are " + unsatisfiableClasses.size() + " unsatisfiable concept(s):");
            for (String string : unsatisfiableClasses) {
                this.out.println(string);
            }
        }
    }

    public static void main(String[] args) {
        PelletUnsatisfiable app = new PelletUnsatisfiable(args);
        app.run();
    }
}

