/*
 * Decompiled with CFR 0.152.
 */
package com.lre.graph;

import com.lre.graph.Edge;
import com.lre.utils.Util;
import java.util.Vector;

public class Vertex
implements Cloneable {
    private String name;
    private Vector edgeList;

    public Vertex(String s) {
        this.name = s;
        this.edgeList = new Vector();
    }

    public Object clone() {
        Vertex v = new Vertex(new String(this.name));
        Vector<Object> edges = new Vector<Object>();
        for (int i = 0; i < this.edgeList.size(); ++i) {
            edges.addElement(((Edge)this.edgeList.elementAt(i)).clone());
        }
        v.edgeList = edges;
        return v;
    }

    public String getName() {
        return this.name;
    }

    public void addEdge(Edge e) {
        this.edgeList.addElement(e);
    }

    public int countEdges() {
        return this.edgeList.size();
    }

    public Edge getEdgeAt(int i) {
        return (Edge)this.edgeList.elementAt(i);
    }

    public boolean matches(Vertex v) {
        if (this.name.equals(v.getName())) {
            return this.edgesMatch(v);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vertex) {
            return ((Vertex)obj).matches(this);
        }
        return false;
    }

    public boolean hasNeighbor(Vertex v) {
        for (int i = 0; i < this.countEdges(); ++i) {
            Edge e = this.getEdgeAt(i);
            if (!e.getTarget().equals(v)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNeighbor(Vertex v, String edgeName) {
        for (int i = 0; i < this.countEdges(); ++i) {
            Edge e = this.getEdgeAt(i);
            if (!e.getTarget().equals(v) || !e.getLabel().equals(edgeName)) continue;
            return true;
        }
        return false;
    }

    public Vector listNeighbors() {
        Vector<Vertex> v = new Vector<Vertex>();
        for (int i = 0; i < this.countEdges(); ++i) {
            Edge e = this.getEdgeAt(i);
            if (v.contains(e.getTarget())) continue;
            v.addElement(e.getTarget());
        }
        return v;
    }

    public boolean similar(Vertex v) {
        return this.edgesMatch(v);
    }

    private boolean edgesMatch(Vertex v) {
        if (v.countEdges() != this.countEdges()) {
            return false;
        }
        int count = 0;
        int[] matched = new int[]{};
        block0: for (int i = 0; i < v.countEdges(); ++i) {
            for (int j = 0; j < this.countEdges(); ++j) {
                if (!v.getEdgeAt(i).equals(this.getEdgeAt(j)) || Util.isInArray(j, matched)) continue;
                ++count;
                Util.addToIntArray(j, matched);
                continue block0;
            }
        }
        return count == this.countEdges();
    }

    public boolean isLeaf() {
        return this.edgeList.size() == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        for (int i = 0; i < this.countEdges(); ++i) {
            sb.append("\n\t" + this.getEdgeAt(i).getLabel() + " --> " + this.getEdgeAt(i).getTarget().getName());
        }
        return sb.toString();
    }
}

