/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import com.hp.hpl.jena.rdf.model.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.utils.FileUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public class Benchmark {
    static String[] DEFAULT_FILES = new String[]{"Mindswappers", "http://www.mindswap.org/2004/owl/mindswappers", "Food", "http://www.w3.org/2001/sw/WebOnt/guide-src/food.owl", "AKT Portal", "http://www.aktors.org/ontology/portal", "OWL-S CongoService", "http://www.daml.org/services/owl-s/1.1/CongoService.owl", "SUMO", "http://reliant.teknowledge.com/DAML/SUMO.owl", "Tambis", "http://www.cs.man.ac.uk/~horrocks/OWL/Ontologies/tambis-full.owl", "Financial", "http://www.cs.put.poznan.pl/alawrynowicz/financial.owl", "SWEET-JPL", "http://sweet.jpl.nasa.gov/ontology/earthrealm.owl", "Galen", "http://www.cs.man.ac.uk/~horrocks/OWL/Ontologies/galen.owl", "Wine", "http://www.w3.org/2001/sw/WebOnt/guide-src/wine.owl"};

    public static void main(String[] args) throws Exception {
        String[] files = DEFAULT_FILES;
        if (args.length > 0) {
            files = new String[args.length * 2];
            for (int i = 0; i < args.length; ++i) {
                files[2 * i] = "-";
                files[2 * i + 1] = args[i];
            }
        }
        List<String> cols = Arrays.asList("Name", "OWL Species", "DL Expressivity", "Triples", "Classes", "Properties", "Individuals", "Loading", "Consistency", "Classify", "Realize", "Total");
        TableData table = new TableData(cols);
        for (int i = 0; i < files.length; i += 2) {
            try {
                String file = FileUtils.toURI(files[i + 1]);
                ArrayList<Object> list = new ArrayList<Object>();
                list.add("<a href=\"" + file + "\">" + files[i] + "</a>");
                System.out.print("Classifying " + file);
                ModelReader reader = new ModelReader();
                Model model = reader.read(file);
                System.out.println(" Triples: " + model.size());
                Timer t = new Timer("timer");
                OWLReasoner reasoner = new OWLReasoner();
                t.start();
                reasoner.load(model);
                reasoner.isConsistent();
                t.stop();
                list.add(reasoner.getSpecies().toString());
                list.add(reasoner.getKB().getExpressivity());
                list.add(new Long(model.size()));
                KnowledgeBase kb = reasoner.getKB();
                list.add(new Long(kb.getClasses().size()));
                list.add(new Long(kb.getProperties().size()));
                list.add(new Long(kb.getIndividuals().size()));
                t.start();
                reasoner.realize();
                t.stop();
                Timers timers = reasoner.getKB().timers;
                list.add(new Long(timers.getTimer("Loading").getTotal() + timers.getTimer("preprocessing").getTotal()));
                list.add(new Long(timers.getTimer("consistency").getTotal()));
                list.add(new Long(timers.getTimer("classify").getTotal()));
                list.add(new Long(timers.getTimer("realize").getTotal()));
                list.add(new Long(t.getTotal()));
                System.out.println(list);
                table.addRow(list);
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        System.out.println();
        table.print(System.out, true);
        System.out.println();
        table.print(System.out, false);
    }
}

