/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.utils.SetUtils;

public abstract class Blocking {
    protected boolean subset(Individual x, Individual y) {
        Set xTypes = x.getTypes();
        Set yTypes = y.getTypes();
        return SetUtils.subset(xTypes, yTypes);
    }

    protected boolean equals(Individual x, Individual y) {
        Set xTypes = x.getTypes();
        Set yTypes = y.getTypes();
        return SetUtils.equals(xTypes, yTypes);
    }

    public boolean isBlocked(Individual x) {
        if (x.isNominal()) {
            return false;
        }
        List ancestors = x.getAncestors();
        boolean isBlocked = this.isIndirectlyBlocked(ancestors) || this.isDirectlyBlocked(x, ancestors);
        return isBlocked;
    }

    public boolean isIndirectlyBlocked(Individual x) {
        if (x.isNominal()) {
            return false;
        }
        return this.isIndirectlyBlocked(x.getAncestors());
    }

    private boolean isIndirectlyBlocked(List ancestors) {
        Iterator i = ancestors.iterator();
        while (i.hasNext()) {
            Individual ancestor = (Individual)i.next();
            if (!this.isDirectlyBlocked(ancestor, ancestor.getAncestors())) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isDirectlyBlocked(Individual var1, List var2);
}

