/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.HashCodeUtil;

public class Edge {
    private Individual from;
    private Node to;
    private Role role;
    private DependencySet depends;
    private int hashCode;

    public Edge(Role name, Individual from, Node to) {
        this.role = name;
        this.from = from;
        this.to = to;
        this.computeHashCode();
    }

    public Edge(Role name, Individual from, Node to, DependencySet d) {
        this.role = name;
        this.from = from;
        this.to = to;
        this.depends = d;
        this.computeHashCode();
    }

    public Node getNeighbor(Individual node) {
        if (this.from.equals(node)) {
            return this.to;
        }
        if (this.to.equals(node)) {
            return this.from;
        }
        return null;
    }

    public String toString() {
        return "[" + this.from + ", " + this.role + ", " + this.to + "] - " + this.depends;
    }

    public DependencySet getDepends() {
        return this.depends;
    }

    public Individual getFrom() {
        return this.from;
    }

    public Role getRole() {
        return this.role;
    }

    public Node getTo() {
        return this.to;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Edge)) {
            return false;
        }
        Edge that = (Edge)other;
        return this.from.equals(that.from) && this.role.equals(that.role) && this.to.equals(that.to);
    }

    private void computeHashCode() {
        this.hashCode = 23;
        this.hashCode = HashCodeUtil.hash(this.hashCode, this.from);
        this.hashCode = HashCodeUtil.hash(this.hashCode, this.role);
        this.hashCode = HashCodeUtil.hash(this.hashCode, this.to);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

