/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.CachedNode;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.DisjunctionBranch;
import org.mindswap.pellet.DisjunctionSorting;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.MaxBranch;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.SubsetBlocking;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.Timer;

public class EmptySHNStrategy
extends CompletionStrategy {
    private LinkedList mayNeedExpanding;
    private Individual root;
    private Map cachedNodes;

    public EmptySHNStrategy(ABox abox) {
        super(abox, new SubsetBlocking());
    }

    boolean supportsPseudoModelCompletion() {
        return false;
    }

    public void initialize() {
        this.mergeList = new ArrayList();
        this.unfoldingMap = this.abox.getKB().getTBox().Tu.normalizedMap;
        this.cachedNodes = new HashMap();
        this.root = (Individual)this.abox.getNodes().iterator().next();
        this.root.setChanged(true);
        this.abox.applyUC(this.root);
        this.abox.setBranch(1);
        this.abox.treeDepth = 1;
        this.abox.changed = true;
        this.abox.setComplete(false);
        this.abox.setInitialized(true);
    }

    ABox complete() {
        if (ABox.DEBUG) {
            System.out.println("************  EmptySHNStrategy  ************");
        }
        if (this.abox.getNodes().isEmpty()) {
            this.abox.setComplete(true);
            return this.abox;
        }
        if (this.abox.getNodes().size() > 1) {
            throw new RuntimeException("EmptySHNStrategy can only be used with an ABox that has a single individual.");
        }
        this.initialize();
        this.mayNeedExpanding = new LinkedList();
        this.mayNeedExpanding.add(this.root);
        while (!this.abox.isComplete() && !this.abox.isClosed()) {
            Individual x = this.getNextIndividual();
            if (x == null) {
                this.abox.setComplete(true);
                break;
            }
            if (ABox.DEBUG) {
                System.out.println("Starting with node " + x);
            }
            if (ABox.DEBUG) {
                this.abox.printTree();
            }
            this.abox.validate();
            this.expand(x);
            if (!this.abox.isClosed()) continue;
            if (ABox.DEBUG) {
                System.out.println("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
            }
            if (this.backtrack()) {
                this.abox.setClash(null);
                continue;
            }
            this.abox.setComplete(true);
        }
        if (ABox.DEBUG) {
            this.abox.printTree();
        }
        if (PelletOptions.USE_ADVANCED_CACHING && !this.abox.isClosed()) {
            IndividualIterator i = this.abox.getIndIterator();
            while (i.hasNext()) {
                Individual ind = (Individual)i.next();
                ATermAppl c = (ATermAppl)this.cachedNodes.get(ind);
                if (c == null || !this.abox.cacheSatConcept(c)) continue;
                if ((PelletOptions.SHOW_CACHE_INFO & 8) != 0) {
                    System.out.println("+++ Cache sat concept " + c);
                }
                if (!ATermUtils.isAnd(c)) continue;
                ATermList list = (ATermList)c.getArgument(0);
                while (!list.isEmpty()) {
                    ATermAppl d = (ATermAppl)list.getFirst();
                    if (this.abox.cacheSatConcept(d) && (PelletOptions.SHOW_CACHE_INFO & 8) != 0) {
                        System.out.println("+++ Cache sat concept " + d);
                    }
                    list = list.getNext();
                }
            }
        }
        return this.abox;
    }

    private Individual getNextIndividual() {
        Node next = null;
        while (!this.mayNeedExpanding.isEmpty() && (next = (Node)this.mayNeedExpanding.getFirst()) instanceof Literal) {
            next = null;
            this.mayNeedExpanding.removeFirst();
        }
        return (Individual)next;
    }

    private void expand(Individual x) {
        if (this.blocking.isBlocked(x)) {
            this.mayNeedExpanding.removeFirst();
            return;
        }
        if (PelletOptions.USE_ADVANCED_CACHING) {
            Timer t = this.abox.getKB().timers.startTimer("cache");
            Bool cachedSat = this.cachedSat(x);
            t.stop();
            if (cachedSat.isKnown()) {
                if (cachedSat.isTrue()) {
                    this.mayNeedExpanding.removeFirst();
                } else {
                    DependencySet ds = DependencySet.EMPTY;
                    Iterator i = x.getTypes().iterator();
                    while (i.hasNext()) {
                        ATermAppl c = (ATermAppl)i.next();
                        ds = ds.union(x.getDepends((ATerm)c));
                    }
                    this.abox.setClash(Clash.atomic(x, ds));
                }
                return;
            }
        }
        do {
            this.applyUnfoldingRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            this.applyDisjunctionRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            if (x.canApply(Node.ATOM) || x.canApply(Node.OR)) continue;
            this.applySomeValuesRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            this.applyMinRule(x);
            if (this.abox.isClosed()) {
                return;
            }
            if (x.canApply(Node.ATOM) || x.canApply(Node.OR)) continue;
            this.applyMaxRule(x);
            if (!this.abox.isClosed()) continue;
            return;
        } while (x.canApply(Node.ATOM) || x.canApply(Node.OR) || x.canApply(Node.SOME) || x.canApply(Node.MIN));
        this.mayNeedExpanding.removeFirst();
        int insert = PelletOptions.SEARCH_TYPE ? 0 : this.mayNeedExpanding.size();
        this.mayNeedExpanding.addAll(insert, x.getSortedSuccessors());
    }

    private ATermAppl createConcept(Individual x) {
        HashSet types = new HashSet(x.getTypes());
        types.remove(ATermUtils.TOP);
        types.remove(ATermUtils.makeValue((ATerm)x.getName()));
        if (types.isEmpty()) {
            return ATermUtils.TOP;
        }
        int count = 0;
        ATerm[] terms = new ATerm[types.size()];
        Iterator i = types.iterator();
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            if (ATermUtils.isAnd(c)) continue;
            terms[count++] = c;
        }
        return ATermUtils.makeAnd(ATermUtils.toSet(terms, count));
    }

    private Bool cachedSat(Individual x) {
        ATermList concepts;
        if (x.equals(this.root)) {
            return Bool.UNKNOWN;
        }
        ATermAppl c = this.createConcept(x);
        if (this.cachedNodes.containsValue(c)) {
            if ((PelletOptions.SHOW_CACHE_INFO & 1) != 0) {
                System.out.println("already searching for " + c);
            }
            return Bool.TRUE;
        }
        Bool sat = this.abox.getCachedSat(c);
        if (sat.isUnknown() && ATermUtils.isAnd(c) && (concepts = (ATermList)c.getArgument(0)).getLength() == 2) {
            ATermAppl c1 = (ATermAppl)concepts.getFirst();
            ATermAppl c2 = (ATermAppl)concepts.getLast();
            CachedNode cached1 = this.abox.getCached(c1);
            CachedNode cached2 = this.abox.getCached(c2);
            if (cached1 != null && cached1.isComplete() && cached2 != null && cached2.isComplete() && (sat = this.abox.mergable(cached1.node, cached2.node, cached1.depends.isIndependent() && cached2.depends.isIndependent())).isKnown()) {
                if (sat.isTrue()) {
                    this.abox.cacheSatConcept(c);
                } else {
                    this.abox.cacheUnsatConcept(c);
                }
            }
        }
        if (sat.isUnknown()) {
            if ((PelletOptions.SHOW_CACHE_INFO & 2) != 0) {
                System.out.println("??? Cache miss for " + c);
            }
            this.cachedNodes.put(x, c);
        } else if ((PelletOptions.SHOW_CACHE_INFO & 1) != 0) {
            System.out.println("*** Cache hit for " + c + " sat = " + sat);
        }
        return sat;
    }

    public void restore(Branch br) {
        Node clashNode = this.abox.getClash().node;
        List clashPath = clashNode.getPath();
        clashPath.add(clashNode.getName());
        this.abox.setBranch(br.branch);
        this.abox.setClash(null);
        this.abox.anonCount = br.anonCount;
        this.mergeList.clear();
        List nodeList = this.abox.getNodeNames();
        Map nodes = this.abox.getNodeMap();
        if (ABox.DEBUG) {
            System.out.println("RESTORE: Branch " + br.branch);
        }
        if (ABox.DEBUG && br.nodeCount < nodeList.size()) {
            System.out.println("Remove nodes " + nodeList.subList(br.nodeCount, nodeList.size()));
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            ATerm x = (ATerm)nodeList.get(i);
            Node node = this.abox.getNode(x);
            if (i >= br.nodeCount) {
                nodes.remove(x);
                ATermAppl c = (ATermAppl)this.cachedNodes.remove(node);
                if (c == null) continue;
                if (clashPath.contains(x)) {
                    if ((PelletOptions.SHOW_CACHE_INFO & 8) != 0) {
                        System.out.println("+++ Cache unsat concept " + c);
                    }
                    this.abox.cacheUnsatConcept(c);
                    continue;
                }
                if ((PelletOptions.SHOW_CACHE_INFO & 8) == 0) continue;
                System.out.println("--- Do not cache concept " + c + " " + x + " " + clashNode + " " + clashPath);
                continue;
            }
            node.restore(br.branch);
            if (!node.equals(clashNode)) continue;
            this.cachedNodes.remove(node);
        }
        nodeList.subList(br.nodeCount, nodeList.size()).clear();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            this.applyAllValues(ind);
        }
        if (ABox.DEBUG) {
            this.abox.printTree();
        }
    }

    protected boolean backtrack() {
        boolean branchFound = false;
        while (!branchFound) {
            int lastBranch = this.abox.getClash().depends.max();
            if (lastBranch <= 0) {
                return false;
            }
            List branches = this.abox.getBranches();
            branches.subList(lastBranch, branches.size()).clear();
            Branch newBranch = (Branch)branches.get(lastBranch - 1);
            if (ABox.DEBUG) {
                System.out.println("JUMP: " + lastBranch);
            }
            if (newBranch == null || lastBranch != newBranch.branch) {
                throw new RuntimeException("Internal error in reasoner: Trying to backtrack branch " + lastBranch + " but got " + newBranch);
            }
            if (newBranch.tryNext < newBranch.tryCount) {
                newBranch.prevDS[newBranch.tryNext] = this.abox.getClash().depends.copy();
            }
            ++newBranch.tryNext;
            if (newBranch.tryNext < newBranch.tryCount) {
                this.restore(newBranch);
                branchFound = newBranch.tryNext();
            } else {
                this.abox.getClash().depends.remove(lastBranch);
            }
            if (!branchFound) {
                if (!ABox.DEBUG) continue;
                System.out.println("FAIL: " + lastBranch);
                continue;
            }
            this.mayNeedExpanding = new LinkedList((LinkedList)newBranch.get("mnx"));
            if (!ABox.DEBUG) continue;
            System.out.println("MNX : " + this.mayNeedExpanding);
        }
        this.abox.validate();
        return branchFound;
    }

    void addBranch(Branch newBranch) {
        super.addBranch(newBranch);
        newBranch.put("mnx", new LinkedList(this.mayNeedExpanding));
    }

    protected void applyDisjunctionRule(Individual node) {
        if (!node.canApply(Node.OR)) {
            return;
        }
        List types = node.getTypes(Node.OR);
        int size = types.size();
        ATermAppl[] disjunctions = new ATermAppl[size - node.applyNext[Node.OR]];
        types.subList(node.applyNext[Node.OR], size).toArray(disjunctions);
        if (PelletOptions.USE_DISJUNCTION_SORTING != "NO") {
            DisjunctionSorting.sort(node, disjunctions);
        }
        int n = disjunctions.length;
        for (int j = 0; j < n; ++j) {
            ATermAppl disjunction = disjunctions[j];
            ATermAppl a = (ATermAppl)disjunction.getArgument(0);
            ATermList disjuncts = (ATermList)a.getArgument(0);
            ATerm[] disj = new ATerm[disjuncts.getLength()];
            int index = 0;
            while (!disjuncts.isEmpty()) {
                disj[index] = ATermUtils.negate((ATermAppl)disjuncts.getFirst());
                if (node.hasType(disj[index])) break;
                disjuncts = disjuncts.getNext();
                ++index;
            }
            if (!disjuncts.isEmpty()) continue;
            DisjunctionBranch newBranch = new DisjunctionBranch(this.abox, this, node, disjunction, node.getDepends((ATerm)disjunction), disj);
            this.addBranch(newBranch);
            if (newBranch.tryNext()) continue;
            return;
        }
        node.applyNext[Node.OR] = size;
    }

    protected void applyMinRule(Individual x) {
        if (!x.canApply(Individual.MIN)) {
            return;
        }
        List types = x.getTypes(Node.MIN);
        int size = types.size();
        for (int j = x.applyNext[Node.MIN]; j < size; ++j) {
            int c1;
            int n;
            ATermAppl mc = (ATermAppl)types.get(j);
            Role r = this.abox.getRole(mc.getArgument(0));
            if (x.hasDistinctRNeighborsForMin(r, n = ((ATermInt)mc.getArgument(1)).getInt())) continue;
            DependencySet ds = x.getDepends((ATerm)mc);
            if (ABox.DEBUG) {
                System.out.println("MIN : " + x + " -> " + r + " -> anon" + (n == 1 ? "" : this.abox.anonCount + 1 + " - anon") + (this.abox.anonCount + n) + " " + ds);
            }
            Node[] y = new Node[n];
            for (c1 = 0; c1 < n; ++c1) {
                if (r.isDatatypeRole()) {
                    y[c1] = this.abox.addLiteral();
                } else {
                    y[c1] = this.abox.addFreshIndividual();
                    y[c1].depth = x.depth + 1;
                    if (x.depth >= this.abox.treeDepth) {
                        this.abox.treeDepth = x.depth + 1;
                    }
                }
                this.addEdge(x, r, y[c1], ds);
            }
            for (c1 = 0; c1 < n; ++c1) {
                for (int c2 = c1 + 1; c2 < n; ++c2) {
                    y[c1].setDifferent(y[c2], ds);
                }
            }
        }
        x.applyNext[Node.MIN] = size;
    }

    protected void applySomeValuesRule(Individual x) {
        if (!x.canApply(Individual.SOME)) {
            return;
        }
        List types = x.getTypes(Node.SOME);
        int size = types.size();
        for (int j = x.applyNext[Node.SOME]; j < size; ++j) {
            ATermAppl sv = (ATermAppl)types.get(j);
            ATermAppl a = (ATermAppl)sv.getArgument(0);
            ATermAppl s = (ATermAppl)a.getArgument(0);
            ATermAppl c = (ATermAppl)a.getArgument(1);
            Role role = this.abox.getRole((ATerm)s);
            c = ATermUtils.negate(c);
            boolean neighborFound = false;
            Node y = null;
            Edge edge = null;
            EdgeList edges = x.getRNeighborEdges(role);
            for (int e = 0; !neighborFound && e < edges.size(); ++e) {
                edge = edges.edgeAt(e);
                y = edge.getNeighbor(x);
                neighborFound = y.hasType((ATerm)c);
            }
            if (neighborFound) continue;
            DependencySet ds = x.getDepends((ATerm)sv).copy();
            if (role.isDatatypeRole()) {
                if (ABox.DEBUG) {
                    System.out.println("SOME: " + x + " -> " + s + " -> " + y + " : " + c + " - " + ds);
                }
                Literal literal = (Literal)y;
                if (ATermUtils.isNominal(c)) {
                    literal = this.abox.addLiteral((ATermAppl)c.getArgument(0));
                } else {
                    if (!role.isFunctional() || literal == null) {
                        literal = this.abox.addLiteral();
                    }
                    literal.addType(c, ds);
                }
                this.addEdge(x, role, literal, ds);
            } else if (ATermUtils.isNominal(c) && !PelletOptions.USE_PSEUDO_NOMINALS) {
                ATermAppl value = (ATermAppl)c.getArgument(0);
                y = this.abox.getIndividual((ATerm)value);
                if (ABox.DEBUG) {
                    System.out.println("VAL : " + x + " -> " + s + " -> " + y + " - " + ds);
                }
                if (y == null) {
                    if (ATermUtils.isLiteral(value)) {
                        throw new InternalReasonerException("Object Property " + role + " is used with a hasValue restriction " + "where the value is a literal: " + ATermUtils.toString(value));
                    }
                    throw new InternalReasonerException("Nominal " + c + " is not found in the KB!");
                }
                this.addEdge(x, role, y, ds);
            } else {
                DependencySet maxCardDS;
                boolean useExistingNode = false;
                boolean useExistingRole = false;
                DependencySet dependencySet = maxCardDS = role.isFunctional() ? DependencySet.INDEPENDENT : x.hasMax1(role);
                if (maxCardDS != null) {
                    ds = ds.union(maxCardDS);
                    if (!edges.isEmpty()) {
                        useExistingNode = true;
                        useExistingRole = true;
                    } else {
                        Set fs = role.isFunctional() ? role.getFunctionalSupers() : role.getSubRoles();
                        Iterator it = fs.iterator();
                        while (it.hasNext()) {
                            Role f = (Role)it.next();
                            edges = x.getRNeighborEdges(f);
                            if (edges.isEmpty()) continue;
                            if (useExistingNode) {
                                Edge otherEdge = edges.edgeAt(0);
                                Node otherNode = otherEdge.getNeighbor(x);
                                DependencySet d = ds.union(edge.getDepends()).union(otherEdge.getDepends());
                                this.mergeTo(y, otherNode, d);
                                continue;
                            }
                            useExistingNode = true;
                            edge = edges.edgeAt(0);
                            y = edge.getNeighbor(x);
                        }
                        if (y != null) {
                            y = y.getSame();
                        }
                    }
                }
                if (useExistingNode) {
                    ds = ds.union(edge.getDepends());
                } else {
                    y = this.abox.addFreshIndividual();
                    y.depth = x.depth + 1;
                    if (x.depth >= this.abox.treeDepth) {
                        this.abox.treeDepth = x.depth + 1;
                    }
                }
                if (ABox.DEBUG) {
                    System.out.println("SOME: " + x + " -> " + s + " -> " + y + " : " + c + (useExistingNode ? "" : " (*)") + " - " + ds);
                }
                if (!useExistingRole) {
                    this.addEdge(x, role, y, ds);
                }
                this.addType(y.getSame(), c, ds);
            }
            if (!this.abox.isClosed()) continue;
            return;
        }
        x.applyNext[Individual.SOME] = size;
    }

    protected void applyMaxRule(Individual x) {
        if (!x.isChanged(Node.MAX)) {
            return;
        }
        List maxCardinality = x.getTypes(Node.MAX);
        Iterator j = maxCardinality.iterator();
        while (j.hasNext()) {
            ATermAppl mc = (ATermAppl)j.next();
            ATermAppl max = (ATermAppl)mc.getArgument(0);
            Role r = this.abox.getRole(max.getArgument(0));
            int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
            DependencySet ds = x.getDepends((ATerm)mc);
            if (n == 1) {
                this.applyFunctionalMaxRule(x, r, ds);
            } else {
                boolean hasMore = true;
                while (hasMore) {
                    hasMore = this.applyMaxRule(x, r, n, ds);
                }
            }
            if (!this.abox.isClosed()) continue;
            return;
        }
        x.setChanged(Node.MAX, false);
    }

    protected boolean applyMaxRule(Individual x, Role r, int k, DependencySet ds) {
        EdgeList edges = x.getRSuccessorEdges(r);
        Set neighbors = edges.getNeighbors(x);
        if (k == 0 && neighbors.size() > 0) {
            for (int e = 0; e < edges.size(); ++e) {
                Edge edge = edges.edgeAt(e);
                ds = ds.union(edge.getDepends());
            }
            this.abox.setClash(new Clash(x, 4, ds));
            return false;
        }
        if (neighbors.size() <= k) {
            return false;
        }
        List mergePairs = this.findMergeNodes(neighbors, x);
        if (mergePairs.size() == 0) {
            DependencySet dsEdges = x.hasDistinctRNeighborsForMax(r, k + 1);
            if (dsEdges == null) {
                return false;
            }
            if (ABox.DEBUG) {
                System.out.println("Early clash detection for max rule worked " + x + " has more than " + k + " " + r + " edges " + ds.union(dsEdges) + " " + neighbors);
            }
            this.abox.setClash(new Clash(x, 4, ds.union(dsEdges)));
            return false;
        }
        MaxBranch newBranch = new MaxBranch(this.abox, this, x, r, k, mergePairs, ds);
        this.addBranch(newBranch);
        if (!newBranch.tryNext()) {
            return false;
        }
        if (ABox.DEBUG) {
            this.abox.printTree();
        }
        return neighbors.size() > k + 1;
    }
}

