/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.SetUtils;

public class Individual
extends Node {
    private EdgeList outEdges;
    private EdgeList inEdges;
    private ArrayList[] types = new ArrayList[TYPES];
    int[] applyNext = new int[TYPES];
    private int nominalLevel;
    List ancestors;

    Individual(ATermAppl name) {
        this(name, null, NOMINAL);
    }

    Individual(ATermAppl name, ABox abox, int nominalLevel) {
        super(name, abox);
        this.nominalLevel = nominalLevel;
        for (int i = 0; i < TYPES; ++i) {
            this.types[i] = new ArrayList();
            this.applyNext[i] = 0;
        }
        this.outEdges = new EdgeList();
        this.inEdges = new EdgeList();
    }

    Individual(Individual ind, ABox abox) {
        super(ind, abox);
        int i;
        this.nominalLevel = ind.nominalLevel;
        for (i = 0; i < TYPES; ++i) {
            this.types[i] = new ArrayList(ind.types[i]);
            this.applyNext[i] = ind.applyNext[i];
        }
        if (abox == null) {
            Edge newEdge;
            Individual to;
            Individual from;
            Edge edge;
            this.mergedTo = null;
            this.outEdges = new EdgeList(ind.outEdges.size());
            for (i = 0; i < ind.outEdges.size(); ++i) {
                edge = ind.outEdges.edgeAt(i);
                from = this;
                to = new Individual(edge.getTo().getName());
                newEdge = new Edge(edge.getRole(), from, to, edge.getDepends());
                this.outEdges.addEdge(newEdge);
            }
            this.inEdges = new EdgeList(ind.inEdges.size());
            for (i = 0; i < ind.inEdges.size(); ++i) {
                edge = ind.inEdges.edgeAt(i);
                from = this;
                to = new Individual(edge.getTo().getName());
                newEdge = new Edge(edge.getRole(), from, to, edge.getDepends());
                this.inEdges.addEdge(newEdge);
            }
        } else {
            this.outEdges = new EdgeList(ind.outEdges.size());
            this.inEdges = ind.inEdges;
        }
    }

    public boolean isLiteral() {
        return false;
    }

    public boolean isIndividual() {
        return true;
    }

    public boolean isNominal() {
        return this.nominalLevel != BLOCKABLE;
    }

    public boolean isBlockable() {
        return this.nominalLevel == BLOCKABLE;
    }

    public void setNominalLevel(int level) {
        this.nominalLevel = level;
        if (this.nominalLevel != BLOCKABLE) {
            this.ancestors = null;
        }
    }

    public int getNominalLevel() {
        return this.nominalLevel;
    }

    public ATermAppl getTerm() {
        return this.name;
    }

    public Node copyTo(ABox abox) {
        return new Individual(this, abox);
    }

    protected void updateNodeReferences() {
        super.updateNodeReferences();
        boolean addOutEdges = !this.isMerged();
        EdgeList oldEdges = this.inEdges;
        this.inEdges = new EdgeList(oldEdges.size());
        for (int i = 0; i < oldEdges.size(); ++i) {
            Edge edge = oldEdges.edgeAt(i);
            Individual from = this.abox.getIndividual((ATerm)edge.getFrom().getName());
            Edge newEdge = new Edge(edge.getRole(), from, this, edge.getDepends());
            this.inEdges.addEdge(newEdge);
            if (!addOutEdges) continue;
            from.addOutEdge(newEdge);
        }
    }

    public Set getMerged() {
        return this.merged == null ? SetUtils.EMPTY_SET : this.merged;
    }

    public List getTypes(int type) {
        return this.types[type];
    }

    public boolean canApply(int type) {
        return this.applyNext[type] < this.types[type].size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addType(ATermAppl c, DependencySet ds) {
        if (this.isPruned()) {
            throw new InternalReasonerException("Adding type to a pruned node " + this + " " + c);
        }
        if (this.depends.containsKey(c)) {
            return;
        }
        ds = ds.copy();
        ds.branch = this.abox.getBranch();
        int max = ds.max();
        if (ds.branch == -1 && max != 0) {
            ds.branch = max + 1;
        }
        this.depends.put(c, ds);
        this.abox.changed = true;
        ATermAppl notC = ATermUtils.negate(c);
        DependencySet clashDepends = (DependencySet)this.depends.get(notC);
        if (clashDepends != null) {
            if (this.abox.doExplanation()) {
                ATermAppl positive = ATermUtils.isNot(notC) ? c : notC;
                this.abox.setClash(Clash.atomic(this, clashDepends.union(ds), positive));
            } else {
                this.abox.setClash(Clash.atomic(this, clashDepends.union(ds)));
            }
        }
        if (ATermUtils.isPrimitive(c)) {
            this.setChanged(ATOM, true);
            this.types[ATOM].add(c);
            return;
        } else if (c.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList cs = (ATermList)c.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                this.addType(conj, ds);
                cs = cs.getNext();
            }
            return;
        } else if (c.getAFun().equals(ATermUtils.ALLFUN)) {
            this.setChanged(ALL, true);
            this.types[ALL].add(c);
            return;
        } else if (c.getAFun().equals(ATermUtils.MINFUN)) {
            if (this.checkMinClash(c, ds)) {
                return;
            }
            if (this.isRedundantMin(c)) return;
            this.types[MIN].add(c);
            this.setChanged(MIN, true);
            return;
        } else if (c.getAFun().equals(ATermUtils.NOTFUN)) {
            ATermAppl x = (ATermAppl)c.getArgument(0);
            if (ATermUtils.isAnd(x)) {
                this.setChanged(OR, true);
                this.types[OR].add(c);
                return;
            } else if (ATermUtils.isAllValues(x)) {
                this.setChanged(SOME, true);
                this.types[SOME].add(c);
                return;
            } else if (ATermUtils.isMin(x)) {
                if (this.checkMaxClash(x, ds)) {
                    return;
                }
                if (this.isRedundantMax(x)) return;
                this.types[MAX].add(c);
                this.setChanged(MAX, true);
                return;
            } else if (ATermUtils.isNominal(x)) {
                this.setChanged(ATOM, true);
                this.types[ATOM].add(c);
                return;
            } else {
                if (x.getArity() != 0) throw new InternalReasonerException("Invalid type " + c + " for individual " + this.name);
                this.setChanged(ATOM, true);
                this.types[ATOM].add(c);
            }
            return;
        } else if (c.getAFun().equals(ATermUtils.VALUEFUN)) {
            this.setChanged(NOM, true);
            this.types[NOM].add(c);
            return;
        } else {
            System.err.println("Warning: Adding invalid class constructor - " + c);
            this.depends.put(ATermUtils.BOTTOM, ds);
        }
    }

    private boolean checkMinClash(ATermAppl minCard, DependencySet minDepends) {
        Role minR = this.abox.getRole(minCard.getArgument(0));
        int min = ((ATermInt)minCard.getArgument(1)).getInt();
        if (minR != null && minR.isFunctional() && min > 1) {
            String exp = null;
            if (this.abox.doExplanation()) {
                exp = minCard + " on FunctionalProperty";
            }
            this.abox.setClash(new Clash((Node)this, 1, minDepends, exp));
            return true;
        }
        Iterator i = this.types[MAX].iterator();
        while (i.hasNext()) {
            ATermAppl mc = (ATermAppl)i.next();
            ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
            Role maxR = this.abox.getRole(maxCard.getArgument(0));
            int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
            if (max >= min || !minR.isSubRoleOf(maxR)) continue;
            DependencySet maxDepends = this.getDepends((ATerm)mc);
            DependencySet ds = minDepends.union(maxDepends);
            String exp = null;
            if (this.abox.doExplanation()) {
                exp = minCard + " max(" + maxR + ", " + max + ")";
            }
            this.abox.setClash(new Clash((Node)this, 1, ds, exp));
            return true;
        }
        return false;
    }

    private boolean checkMaxClash(ATermAppl maxCard, DependencySet maxDepends) {
        Role maxR = this.abox.getRole(maxCard.getArgument(0));
        int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
        Iterator i = this.types[MIN].iterator();
        while (i.hasNext()) {
            ATermAppl minCard = (ATermAppl)i.next();
            Role minR = this.abox.getRole(minCard.getArgument(0));
            int min = ((ATermInt)minCard.getArgument(1)).getInt();
            if (max >= min || !minR.isSubRoleOf(maxR)) continue;
            DependencySet minDepends = this.getDepends((ATerm)minCard);
            DependencySet ds = minDepends.union(maxDepends);
            String exp = null;
            if (this.abox.doExplanation()) {
                exp = minCard + " max(" + maxR + ", " + max + ")";
            }
            this.abox.setClash(new Clash((Node)this, 1, ds, exp));
            return true;
        }
        return false;
    }

    private boolean isRedundantMin(ATermAppl minCard) {
        Role minR = this.abox.getRole(minCard.getArgument(0));
        int min = ((ATermInt)minCard.getArgument(1)).getInt();
        Iterator i = this.types[MIN].iterator();
        while (i.hasNext()) {
            ATermAppl prevMinCard = (ATermAppl)i.next();
            Role prevMinR = this.abox.getRole(prevMinCard.getArgument(0));
            int prevMin = ((ATermInt)prevMinCard.getArgument(1)).getInt() - 1;
            if (min > prevMin || !prevMinR.isSubRoleOf(minR)) continue;
            return true;
        }
        return false;
    }

    private boolean isRedundantMax(ATermAppl maxCard) {
        Role maxR = this.abox.getRole(maxCard.getArgument(0));
        int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
        if (max == 1 && maxR != null && maxR.isFunctional()) {
            return true;
        }
        Iterator i = this.types[MAX].iterator();
        while (i.hasNext()) {
            ATermAppl mc = (ATermAppl)i.next();
            ATermAppl prevMaxCard = (ATermAppl)mc.getArgument(0);
            Role prevMaxR = this.abox.getRole(prevMaxCard.getArgument(0));
            int prevMax = ((ATermInt)prevMaxCard.getArgument(1)).getInt() - 1;
            if (max < prevMax || !maxR.isSubRoleOf(prevMaxR)) continue;
            return true;
        }
        return false;
    }

    public DependencySet hasMax1(Role maxR) {
        Iterator i = this.types[MAX].iterator();
        while (i.hasNext()) {
            ATermAppl mc = (ATermAppl)i.next();
            ATermAppl prevMaxCard = (ATermAppl)mc.getArgument(0);
            Role prevMaxR = this.abox.getRole(prevMaxCard.getArgument(0));
            int prevMax = ((ATermInt)prevMaxCard.getArgument(1)).getInt() - 1;
            if (prevMax != 1 || !maxR.isSubRoleOf(prevMaxR)) continue;
            return this.getDepends((ATerm)mc);
        }
        return null;
    }

    public int getMaxCard(Role r) {
        int min = Integer.MAX_VALUE;
        Iterator i = this.types[MAX].iterator();
        while (i.hasNext()) {
            ATermAppl mc = (ATermAppl)i.next();
            ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
            Role maxR = this.abox.getRole(maxCard.getArgument(0));
            int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
            if (!r.isSubRoleOf(maxR) || max >= min) continue;
            min = max;
        }
        if (r.isFunctional() && min > 1) {
            min = 1;
        }
        return min;
    }

    public int getMinCard(Role r) {
        int max = 0;
        Iterator i = this.types[MIN].iterator();
        while (i.hasNext()) {
            ATermAppl minCard = (ATermAppl)i.next();
            Role minR = this.abox.getRole(minCard.getArgument(0));
            int min = ((ATermInt)minCard.getArgument(1)).getInt();
            if (!minR.isSubRoleOf(r) || max >= min) continue;
            max = min;
        }
        return max;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeType(ATermAppl c) {
        this.depends.remove(c);
        this.setChanged(true);
        if (ATermUtils.isPrimitive(c)) {
            this.types[ATOM].remove(c);
            return;
        } else {
            if (c.getAFun().equals(ATermUtils.ANDFUN)) return;
            if (c.getAFun().equals(ATermUtils.ALLFUN)) {
                this.types[ALL].remove(c);
                return;
            } else if (c.getAFun().equals(ATermUtils.MINFUN)) {
                this.types[MIN].remove(c);
                return;
            } else if (c.getAFun().equals(ATermUtils.NOTFUN)) {
                ATermAppl x = (ATermAppl)c.getArgument(0);
                if (ATermUtils.isAnd(x)) {
                    this.types[OR].remove(c);
                    return;
                } else if (ATermUtils.isAllValues(x)) {
                    this.types[SOME].remove(c);
                    return;
                } else if (ATermUtils.isMin(x)) {
                    this.types[MAX].remove(c);
                    return;
                } else if (ATermUtils.isNominal(x)) {
                    this.types[ATOM].remove(c);
                    return;
                } else {
                    if (x.getArity() != 0) throw new InternalReasonerException("Invalid type " + c + " for individual " + this.name);
                    this.types[ATOM].remove(c);
                }
                return;
            } else {
                if (!c.getAFun().equals(ATermUtils.VALUEFUN)) throw new RuntimeException("Invalid concept " + c);
                this.types[NOM].remove(c);
            }
        }
    }

    public final boolean isLeaf() {
        return !this.isRoot() && this.outEdges.isEmpty();
    }

    public final Set getSuccessors() {
        return this.outEdges.getSuccessors();
    }

    public final Set getSortedSuccessors() {
        return this.outEdges.sort().getSuccessors();
    }

    public final Set getRSuccessors(Role r) {
        return this.outEdges.getEdges(r).getNeighbors(this);
    }

    public final EdgeList getRSuccessorEdges(Role r) {
        return this.outEdges.getEdges(r);
    }

    public final EdgeList getRPredecessorEdges(Role r) {
        return this.inEdges.getEdges(r);
    }

    public final Set getRNeighbors(Role r) {
        return this.getRNeighborEdges(r).getNeighbors(this);
    }

    public EdgeList getRNeighborEdges(Role r) {
        EdgeList neighbors = this.outEdges.getEdges(r);
        Role invR = r.getInverse();
        if (invR != null) {
            neighbors.addEdgeList(this.inEdges.getEdges(invR));
        }
        return neighbors;
    }

    public EdgeList getEdgesTo(Node x) {
        return this.outEdges.getEdgesTo(x);
    }

    public EdgeList getEdgesTo(Node x, Role r) {
        return this.outEdges.getEdgesTo(x).getEdges(r);
    }

    DependencySet hasDistinctRNeighborsForMax(Role r, long n) {
        DependencySet ds = null;
        EdgeList edges = this.getRNeighborEdges(r);
        if ((long)edges.size() >= n) {
            ArrayList allDisjointSets = new ArrayList();
            block0: for (int i = 0; i < edges.size(); ++i) {
                Node y = edges.edgeAt(i).getNeighbor(this);
                boolean added = false;
                for (int j = 0; j < allDisjointSets.size(); ++j) {
                    Node z;
                    int k;
                    List disjointSet = (List)allDisjointSets.get(j);
                    for (k = 0; k < disjointSet.size() && y.isDifferent(z = (Node)disjointSet.get(k)); ++k) {
                    }
                    if (k != disjointSet.size()) continue;
                    added = true;
                    disjointSet.add(y);
                    if ((long)disjointSet.size() < n) continue;
                    ds = DependencySet.EMPTY;
                    for (int e = 0; e < edges.size(); ++e) {
                        ds = ds.union(edges.edgeAt(e).getDepends());
                    }
                    break block0;
                }
                if (added) continue;
                ArrayList<Node> singletonSet = new ArrayList<Node>();
                singletonSet.add(y);
                allDisjointSets.add(singletonSet);
                if (n != 1L) continue;
                ds = DependencySet.EMPTY;
                for (int e = 0; e < edges.size(); ++e) {
                    ds = ds.union(edges.edgeAt(e).getDepends());
                }
                break;
            }
        }
        return ds;
    }

    boolean hasDistinctRNeighborsForMin(Role r, long n) {
        return this.hasDistinctRNeighborsForMin(r, n, false);
    }

    boolean hasDistinctRNeighborsForMin(Role r, long n, boolean onlyNominals) {
        EdgeList edges = this.getRNeighborEdges(r);
        if (n == 1L && !onlyNominals) {
            return !edges.isEmpty();
        }
        if ((long)edges.size() < n) {
            return false;
        }
        ArrayList allDisjointSets = new ArrayList();
        for (int i = 0; i < edges.size(); ++i) {
            Node y = edges.edgeAt(i).getNeighbor(this);
            if (onlyNominals) {
                if (y.isBlockable()) continue;
                if (n == 1L) {
                    return true;
                }
            }
            boolean added = false;
            for (int j = 0; j < allDisjointSets.size(); ++j) {
                boolean addToThis = true;
                List disjointSet = (List)allDisjointSets.get(j);
                for (int k = 0; k < disjointSet.size(); ++k) {
                    Node z = (Node)disjointSet.get(k);
                    if (y.isDifferent(z)) continue;
                    addToThis = false;
                    break;
                }
                if (!addToThis) continue;
                added = true;
                disjointSet.add(y);
                if ((long)disjointSet.size() < n) continue;
                return true;
            }
            if (added) continue;
            ArrayList<Node> singletonSet = new ArrayList<Node>();
            singletonSet.add(y);
            allDisjointSets.add(singletonSet);
        }
        return false;
    }

    public final boolean hasRNeighbor(Role r) {
        if (this.outEdges.hasEdge(r)) {
            return true;
        }
        Role invR = r.getInverse();
        return invR != null && this.inEdges.hasEdge(invR);
    }

    public boolean hasRSuccessor(Role r) {
        return this.outEdges.hasEdge(r);
    }

    public boolean hasEdge(Role r, Node x) {
        return this.outEdges.hasEdge(this, r, x);
    }

    public boolean hasSuccessor(Node x) {
        return this.outEdges.hasEdgeTo(x);
    }

    final boolean hasRSuccessor(Role r, Node x) {
        return this.hasEdge(r, x);
    }

    public Bool hasDataPropertyValue(Role r, Object value) {
        Bool hasValue = Bool.FALSE;
        EdgeList edges = this.outEdges.getEdges(r);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Literal literal = (Literal)edge.getTo();
            Object literalValue = literal.getValue();
            if (literalValue == null) {
                Datatype datatype = literal.getDatatype();
                if (datatype.size() != 1L || !datatype.contains(value)) continue;
                hasValue = Bool.UNKNOWN;
                continue;
            }
            if (!literalValue.equals(value)) continue;
            if (ds.max() == 0) {
                return Bool.TRUE;
            }
            hasValue = Bool.UNKNOWN;
        }
        return hasValue;
    }

    public Bool hasObjectPropertyValue(Role r, Individual value) {
        Bool hasValue = Bool.FALSE;
        EdgeList edges = this.outEdges.getEdges(r);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            if (value == null) {
                return Bool.TRUE;
            }
            if (!edge.getTo().isSame(value)) continue;
            if (ds.max() == 0) {
                return Bool.TRUE;
            }
            hasValue = Bool.UNKNOWN;
        }
        Role invR = r.getInverse();
        edges = this.inEdges.getEdges(invR);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            if (value == null) {
                return Bool.TRUE;
            }
            if (!edge.getFrom().isSame(value)) continue;
            if (ds.max() == 0) {
                return Bool.TRUE;
            }
            hasValue = Bool.UNKNOWN;
        }
        return hasValue;
    }

    boolean hasRNeighbor(Role r, Node x) {
        if (this.hasRSuccessor(r, x)) {
            return true;
        }
        if (x instanceof Individual) {
            return ((Individual)x).hasRSuccessor(r.getInverse(), this);
        }
        return false;
    }

    protected void addInEdge(Edge edge) {
        this.setChanged(ALL, true);
        this.setChanged(MAX, true);
        this.inEdges.addEdge(edge);
    }

    protected void addOutEdge(Edge edge) {
        this.setChanged(ALL, true);
        this.setChanged(MAX, true);
        this.outEdges.addEdge(edge);
    }

    public Edge addEdge(Role r, Node x, DependencySet ds) {
        if (this.hasEdge(r, x)) {
            return null;
        }
        if (this.isPruned()) {
            throw new InternalReasonerException("Adding edge to a pruned node " + this + " " + r + " " + x);
        }
        this.abox.changed = true;
        this.setChanged(ALL, true);
        this.setChanged(MAX, true);
        ds = ds.copy();
        ds.branch = this.abox.getBranch();
        Edge edge = new Edge(r, this, x, ds);
        this.outEdges.addEdge(edge);
        x.addInEdge(edge);
        return edge;
    }

    public final EdgeList getOutEdges() {
        return this.outEdges;
    }

    public final EdgeList getInEdges() {
        return this.inEdges;
    }

    public Individual getParent() {
        if (this.isBlockable()) {
            if (this.inEdges.size() == 0) {
                return null;
            }
            return this.inEdges.edgeAt(0).getFrom();
        }
        return null;
    }

    public List getAncestors() {
        if (this.ancestors == null) {
            if (this.isNominal()) {
                this.ancestors = Collections.EMPTY_LIST;
            } else {
                this.ancestors = new ArrayList();
                for (Individual node = this.getParent(); node != null; node = ((Node)node).getParent()) {
                    this.ancestors.add(node);
                }
            }
        }
        return this.ancestors;
    }

    public boolean restore(int branch) {
        boolean restored = super.restore(branch);
        if (!restored) {
            return false;
        }
        for (int i = 0; i < TYPES; ++i) {
            this.applyNext[i] = 0;
        }
        Iterator i = this.outEdges.iterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            Node n = e.getTo();
            DependencySet d = e.getDepends();
            if (d.branch <= branch) continue;
            if (DEBUG) {
                System.out.println("RESTORE: " + this.name + " remove edge " + e + " " + d.max() + " " + branch + " " + n.branch);
            }
            i.remove();
        }
        return true;
    }

    public final boolean removeEdge(Edge edge) {
        boolean removed = this.outEdges.removeEdge(edge);
        if (!removed) {
            throw new InternalReasonerException("Trying to remove a non-existing edge " + edge);
        }
        return true;
    }

    public final boolean removeInEdge(Edge edge) {
        boolean removed = this.inEdges.removeEdge(edge);
        if (!removed) {
            throw new InternalReasonerException("Trying to remove a non-existing edge " + edge);
        }
        return true;
    }

    public final void removeInEdges() {
        this.inEdges = new EdgeList();
    }

    public void prune(DependencySet ds) {
        this.pruned = ds;
        for (int i = 0; i < this.outEdges.size(); ++i) {
            Edge edge = this.outEdges.edgeAt(i);
            Node succ = edge.getTo();
            if (succ.isNominal()) {
                succ.removeInEdge(edge);
                continue;
            }
            succ.prune(ds);
        }
    }

    public void unprune(int branch) {
        Role role;
        DependencySet d;
        Edge edge;
        int i;
        this.pruned = null;
        for (i = 0; i < this.inEdges.size(); ++i) {
            Individual pred;
            edge = this.inEdges.edgeAt(i);
            d = edge.getDepends();
            if (d.branch > branch || (pred = edge.getFrom()).hasEdge(role = edge.getRole(), this)) continue;
            pred.addOutEdge(edge);
            if (!DEBUG) continue;
            System.out.println("RESTORE: " + this.name + " ADD reverse edge " + edge);
        }
        for (i = 0; i < this.outEdges.size(); ++i) {
            edge = this.outEdges.edgeAt(i);
            d = edge.getDepends();
            if (d.branch > branch) continue;
            Node succ = edge.getTo();
            role = edge.getRole();
            if (succ.getInEdges().hasEdge(this, role, succ)) continue;
            succ.addInEdge(edge);
        }
    }

    public String debugString() {
        return this.name.getName() + " = " + this.types[ATOM] + this.types[ALL] + this.types[SOME] + this.types[OR] + this.types[MIN] + this.types[MAX] + this.types[NOM] + "; **" + this.outEdges + "**" + "; **" + this.inEdges + "**" + " --> " + this.depends + "";
    }
}

