/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.EmptySHNStrategy;
import org.mindswap.pellet.Expressivity;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.MatrixTaxonomyBuilder;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.SHINStrategy;
import org.mindswap.pellet.SHNStrategy;
import org.mindswap.pellet.SHOINStrategy;
import org.mindswap.pellet.SHONStrategy;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.Taxonomy;
import org.mindswap.pellet.TaxonomyBuilder;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.exceptions.InconsistentOntologyException;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public class KnowledgeBase {
    public static boolean DEBUG = false;
    protected ABox abox;
    protected TBox tbox;
    protected RBox rbox;
    private Set individuals;
    protected TaxonomyBuilder builder;
    protected Taxonomy taxonomy;
    protected Taxonomy roleTaxonomy;
    private boolean consistent;
    protected int status;
    protected static final int UNCHANGED = 0;
    protected static final int ABOX_CHANGED = 1;
    protected static final int TBOX_CHANGED = 2;
    protected static final int RBOX_CHANGED = 4;
    protected static final int ALL_CHANGED = 7;
    protected static final int CONSISTENCY = 8;
    protected static final int CLASSIFICATION = 16;
    protected static final int REALIZATION = 32;
    protected String ontology;
    private Map instances;
    private Expressivity expressivity;
    public Timers timers = new Timers();

    public KnowledgeBase() {
        this.clear();
        this.timers.createTimer("preprocessing");
        this.timers.createTimer("consistency");
        this.status = 7;
    }

    public KnowledgeBase(KnowledgeBase kb) {
        this.abox = kb.abox.copy();
        this.tbox = kb.tbox;
        this.rbox = kb.rbox;
        this.expressivity = kb.expressivity;
        this.individuals = new HashSet(kb.individuals);
        this.instances = new HashMap(kb.instances);
        this.status = 7;
        this.timers = kb.timers;
    }

    public Expressivity getExpressivity() {
        this.prepare();
        return this.expressivity;
    }

    public void clear() {
        this.abox = new ABox(this);
        this.tbox = new TBox(this);
        this.rbox = new RBox();
        this.expressivity = new Expressivity(this);
        this.individuals = new HashSet();
        this.instances = new HashMap();
        this.status = 7;
    }

    public KnowledgeBase copy() {
        return new KnowledgeBase(this);
    }

    public void addClass(ATerm c) {
        if (c.equals(ATermUtils.TOP) || ATermUtils.isComplexClass(c)) {
            return;
        }
        this.status |= 2;
        this.tbox.classes.add(c);
        if (DEBUG) {
            System.out.println("class " + c);
        }
    }

    public void addSubClass(ATermAppl c1, ATermAppl c2) {
        if (c1.equals(c2)) {
            return;
        }
        this.status |= 2;
        if (ATermUtils.isOneOf(c1)) {
            ATermList list = (ATermList)c1.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl nominal = (ATermAppl)list.getFirst();
                ATermAppl ind = (ATermAppl)nominal.getArgument(0);
                this.addIndividual(ind);
                this.addType(ind, c2);
                list = list.getNext();
            }
        } else {
            ATermAppl subAxiom = ATermUtils.makeSub((ATerm)c1, (ATerm)c2);
            this.tbox.addAxiom(subAxiom);
            if (DEBUG) {
                System.out.println("sub " + c1 + " " + c2);
            }
        }
    }

    public void addSameClass(ATermAppl c1, ATermAppl c2) {
        if (c1.equals(c2)) {
            return;
        }
        this.status |= 2;
        if (ATermUtils.isOneOf(c2) || ATermUtils.isOneOf(c1)) {
            this.addSubClass(c1, c2);
            this.addSubClass(c2, c1);
        } else {
            ATermAppl sameAxiom = ATermUtils.makeSame((ATerm)c1, (ATerm)c2);
            this.tbox.addAxiom(sameAxiom);
            if (DEBUG) {
                System.out.println("same " + c1 + " " + c2);
            }
        }
    }

    public void addDisjointClass(ATerm c1, ATerm c2) {
        this.status |= 2;
        ATermAppl notC2 = ATermUtils.makeNot(c2);
        ATermAppl notC1 = ATermUtils.makeNot(c1);
        this.tbox.addAxiom(ATermUtils.makeSub(c1, (ATerm)notC2));
        this.tbox.addAxiom(ATermUtils.makeSub(c2, (ATerm)notC1));
        if (DEBUG) {
            System.out.println("disjoint " + c1 + " " + c2);
        }
    }

    public void addComplementClass(ATerm c1, ATerm c2) {
        this.status |= 2;
        ATermAppl notC2 = ATermUtils.makeNot(c2);
        ATermAppl notC1 = ATermUtils.makeNot(c1);
        this.tbox.addAxiom(ATermUtils.makeSame(c1, (ATerm)notC2));
        this.tbox.addAxiom(ATermUtils.makeSame(c2, (ATerm)notC1));
        if (DEBUG) {
            System.out.println("complement " + c1 + " " + c2);
        }
    }

    public void addDataPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        this.addPropertyValue(p, s, o);
    }

    public Individual addIndividual(ATermAppl i) {
        Node node = this.abox.getNode((ATerm)i);
        if (node == null) {
            this.status |= 1;
            node = this.abox.addIndividual(i);
            node.setOntology(this.ontology);
            this.individuals.add(i);
            if (DEBUG) {
                System.out.println("individual " + i);
            }
        } else if (node instanceof Literal) {
            throw new UnsupportedFeatureException("Trying to use a literal as an individual. Literal ID: " + i.getName());
        }
        return (Individual)node;
    }

    public void addType(ATermAppl i, ATermAppl c) {
        this.status |= 1;
        this.abox.addType(i, c);
        if (DEBUG) {
            System.out.println("type " + i + " " + c);
        }
    }

    public void addSame(ATermAppl i1, ATermAppl i2) {
        this.status |= 1;
        this.abox.addSame(i1, i2);
        if (DEBUG) {
            System.out.println("same " + i1 + " " + i2);
        }
    }

    public void addDifferent(ATermAppl i1, ATermAppl i2) {
        this.status |= 1;
        this.abox.addDifferent(i1, i2);
        if (DEBUG) {
            System.out.println("diff " + i1 + " " + i2);
        }
    }

    public void addObjectPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        this.addPropertyValue(p, s, o);
    }

    public boolean addPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        this.status |= 1;
        Individual subj = this.abox.getIndividual((ATerm)s);
        Role role = this.getRole((ATerm)p);
        Node obj = null;
        if (subj == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(s + " is not a known individual!");
        }
        if (role == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(p + " is not a known property!");
        }
        if (role.isObjectRole()) {
            obj = this.abox.getIndividual((ATerm)o);
            if (obj == null) {
                if (ATermUtils.isLiteral(o)) {
                    System.err.println("Ignoring literal value " + o + " for object property " + p);
                    return false;
                }
                if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                    return false;
                }
                throw new UnsupportedFeatureException(o + " is not a known individual!");
            }
        } else if (role.isDatatypeRole()) {
            obj = this.abox.addLiteral(o);
        }
        subj.addEdge(role, obj, DependencySet.INDEPENDENT);
        if (DEBUG) {
            System.out.println("prop-value " + s + " " + p + " " + o);
        }
        return true;
    }

    public void addProperty(ATermAppl p) {
        this.status |= 4;
        this.rbox.addRole(p);
        if (DEBUG) {
            System.out.println("undefined-prop " + p);
        }
    }

    public boolean addObjectProperty(ATerm p) {
        this.status |= 4;
        Role role = this.rbox.addObjectRole((ATermAppl)p);
        if (DEBUG) {
            System.out.println("object-prop " + p);
        }
        return role.isObjectRole();
    }

    public boolean addDatatypeProperty(ATerm p) {
        this.status |= 4;
        Role role = this.rbox.addDatatypeRole((ATermAppl)p);
        if (DEBUG) {
            System.out.println("data-prop " + p);
        }
        return role.isDatatypeRole();
    }

    public void addOntologyProperty(ATermAppl p) {
        this.status |= 4;
        this.rbox.addOntologyRole(p);
        if (DEBUG) {
            System.out.println("onto-prop " + p);
        }
    }

    public void addAnnotationProperty(ATermAppl p) {
        this.status |= 4;
        this.rbox.addAnnotationRole(p);
        if (DEBUG) {
            System.out.println("annotation-prop " + p);
        }
    }

    public void addSubProperty(ATermAppl p1, ATermAppl p2) {
        this.status |= 4;
        this.rbox.addSubRole((ATerm)p1, (ATerm)p2);
        if (DEBUG) {
            System.out.println("sub-prop " + p1 + " " + p2);
        }
    }

    public void addSameProperty(ATermAppl p1, ATermAppl p2) {
        this.status |= 4;
        this.rbox.addSubRole((ATerm)p1, (ATerm)p2);
        this.rbox.addSubRole((ATerm)p2, (ATerm)p1);
        if (DEBUG) {
            System.out.println("same-prop " + p1 + " " + p2);
        }
    }

    public void addInverseProperty(ATermAppl p1, ATermAppl p2) {
        this.status |= 4;
        this.rbox.addInverseRole((ATerm)p1, (ATerm)p2);
        if (DEBUG) {
            System.out.println("inv-prop " + p1 + " " + p2);
        }
    }

    public void addTransitiveProperty(ATermAppl p) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole((ATerm)p);
        r.setTransitive(true);
        if (DEBUG) {
            System.out.println("trans-prop " + p);
        }
    }

    public void addSymmetricProperty(ATermAppl p) {
        this.status |= 4;
        this.rbox.addInverseRole((ATerm)p, (ATerm)p);
        if (DEBUG) {
            System.out.println("sym-prop " + p);
        }
    }

    public void addFunctionalProperty(ATermAppl p) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole((ATerm)p);
        r.setFunctional(true);
        if (DEBUG) {
            System.out.println("func-prop " + p);
        }
    }

    public void addInverseFunctionalProperty(ATerm p) {
        this.status |= 4;
        Role role = this.rbox.getDefinedRole(p);
        Role inv = role.getInverse();
        inv.setFunctional(true);
        if (DEBUG) {
            System.out.println("inv-func-prop " + p);
        }
    }

    public void addDomain(ATerm p, ATermAppl c) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole(p);
        r.addDomain(c);
        if (DEBUG) {
            System.out.println("domain " + p + " " + c + " (" + r.getDomain() + ")");
        }
    }

    public void addRange(ATerm p, ATermAppl c) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole(p);
        r.addRange(c);
        if (DEBUG) {
            System.out.println("range " + p + " " + c);
        }
    }

    public boolean isDatatype(ATerm p) {
        DatatypeReasoner dtReasoner = this.getDatatypeReasoner();
        return dtReasoner.isDefined(p.toString());
    }

    public void addDatatype(ATerm p) {
        DatatypeReasoner dtReasoner = this.getDatatypeReasoner();
        if (!dtReasoner.isDefined(p.toString())) {
            this.status |= 2;
            dtReasoner.defineUnknownDatatype(p.toString());
            if (DEBUG) {
                System.out.println("datatype " + p);
            }
        }
    }

    public void loadDatatype(ATerm p) {
        DatatypeReasoner dtReasoner = this.getDatatypeReasoner();
        if (!dtReasoner.isDefined(p.toString())) {
            this.status |= 2;
            dtReasoner.loadUserDefinedDatatype(p.toString());
            if (DEBUG) {
                System.out.println("datatype " + p);
            }
        }
    }

    public void addDataRange(String datatypeURI, ATermList values) {
        DatatypeReasoner dtReasoner = this.getDatatypeReasoner();
        if (!dtReasoner.isDefined(datatypeURI.toString())) {
            this.status |= 2;
            Datatype dataRange = dtReasoner.enumeration(ATermUtils.listToSet(values));
            this.getDatatypeReasoner().defineDatatype(datatypeURI.toString(), dataRange);
            if (DEBUG) {
                System.out.println("datarange " + datatypeURI.toString() + " " + values);
            }
        }
    }

    public boolean removeObjectPropertyValue(ATermAppl p, ATermAppl i1, ATermAppl i2) {
        boolean removed = false;
        Individual subj = this.abox.getIndividual((ATerm)i1);
        Individual obj = this.abox.getIndividual((ATerm)i2);
        Role role = this.getRole((ATerm)p);
        if (subj == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                throw new UnsupportedFeatureException(i1 + " is not an individual!");
            }
            return false;
        }
        if (obj == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(i2 + " is not an individual!");
        }
        if (role == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(p + " is not a property!");
        }
        EdgeList edges = subj.getEdgesTo(obj, role);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            if (!edge.getRole().equals(role)) continue;
            subj.removeEdge(edge);
            this.status |= 1;
            removed = true;
            break;
        }
        if (DEBUG) {
            System.out.println("Remove ObjectPropertyValue " + i1 + " " + p + " " + i2);
        }
        return removed;
    }

    public void removeType(ATermAppl ind, ATermAppl c) {
        this.status |= 1;
        Individual subj = this.abox.getIndividual((ATerm)ind);
        if (subj == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return;
            }
            throw new UnsupportedFeatureException(ind + " is not an individual!");
        }
        subj.removeType(c);
        if (DEBUG) {
            System.out.println("Remove Type " + ind + " " + c);
        }
    }

    public void prepare() {
        if (!this.isChanged()) {
            return;
        }
        boolean explain = this.abox.doExplanation();
        this.abox.setDoExplanation(true);
        Timer timer = this.timers.startTimer("preprocessing");
        boolean reuseTaxonomy = this.taxonomy != null && !this.isTBoxChanged() && (!this.expressivity.hasNominal() || PelletOptions.USE_PSEUDO_NOMINALS);
        int sizeTg = 0;
        if (this.isTBoxChanged()) {
            if (DEBUG) {
                System.out.print("Splitting...");
            }
            this.tbox.split();
            sizeTg = this.tbox.Tg.size();
            if (PelletOptions.USE_ABSORPTION) {
                if (DEBUG) {
                    System.out.print("Absorbing...");
                }
                this.tbox.absorb();
            }
            if (DEBUG) {
                System.out.print("Normalizing...");
            }
            this.tbox.Tu.normalize();
            if (DEBUG) {
                System.out.print("Internalizing...");
            }
            this.tbox.Tg.internalize();
            if (DEBUG) {
                System.out.print("Role hierarchy...");
            }
            this.rbox.computeRoleHierarchy();
        } else if (this.isRBoxChanged()) {
            if (DEBUG) {
                System.out.print("Role hierarchy...");
            }
            this.rbox.computeRoleHierarchy();
        }
        this.status = 0;
        if (DEBUG) {
            System.out.print("Expressivity...");
        }
        this.expressivity.compute();
        if (DEBUG) {
            System.out.print("ABox init...");
        }
        this.instances.clear();
        if (DEBUG) {
            System.out.println("done.");
        }
        this.abox.setDoExplanation(explain);
        this.abox.clearCaches(!reuseTaxonomy);
        if (reuseTaxonomy) {
            this.status |= 0x10;
        } else {
            this.taxonomy = null;
        }
        timer.stop();
        if (PelletOptions.PRINT_SIZE) {
            System.out.print("Expressivity: " + this.expressivity + ", ");
            System.out.print("Individuals: " + this.individuals.size() + ", ");
            System.out.print("Classes: " + this.tbox.classes.size());
            if (sizeTg > 0) {
                System.out.print(", GCIs: " + this.tbox.Tg.size() + " (");
                System.out.print(sizeTg - this.tbox.Tg.size() + " absorbed)");
            }
            System.out.print(" Strategy: " + this.chooseStrategy(this.abox));
            System.out.println();
            this.tbox.Tg.print();
        }
    }

    public boolean isConsistencyDone() {
        return (this.status & 0xF) == 8;
    }

    public boolean isClassified() {
        return (this.status & 0x17) == 16;
    }

    public boolean isRealized() {
        return (this.status & 0x27) == 32;
    }

    public boolean isChanged() {
        return (this.status & 7) != 0;
    }

    public boolean isTBoxChanged() {
        return (this.status & 2) != 0;
    }

    public boolean isRBoxChanged() {
        return (this.status & 4) != 0;
    }

    public boolean isABoxChanged() {
        return (this.status & 1) != 0;
    }

    private void consistency() {
        if (this.isConsistencyDone()) {
            return;
        }
        boolean explain = this.abox.doExplanation();
        this.abox.setDoExplanation(true);
        this.prepare();
        Timer timer = this.timers.startTimer("consistency");
        this.consistent = this.abox.isConsistent();
        this.abox.setDoExplanation(explain);
        if (!this.consistent) {
            System.err.println("WARNING: Inconsistent ontology. Reason: " + this.getExplanation());
        }
        timer.stop();
        this.status |= 8;
    }

    public boolean isConsistent() {
        this.consistency();
        return this.consistent;
    }

    public void ensureConsistency() {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException("Cannot do reasoning with inconsistent ontologies!");
        }
    }

    public void classify() {
        this.ensureConsistency();
        if (this.isClassified()) {
            return;
        }
        Timer timer = this.timers.startTimer("classify");
        this.builder = PelletOptions.USE_OLD_CLASSIFICATION ? new MatrixTaxonomyBuilder(this) : new TaxonomyBuilder(this);
        this.taxonomy = this.builder.classify();
        timer.stop();
        this.status |= 0x10;
    }

    public void realize() {
        if (this.isRealized()) {
            return;
        }
        this.classify();
        Timer timer = this.timers.startTimer("realize");
        this.taxonomy = this.builder.realize();
        timer.stop();
        this.status |= 0x20;
    }

    public Set getClasses() {
        return Collections.unmodifiableSet(this.tbox.classes);
    }

    public Set getAllClasses() {
        return Collections.unmodifiableSet(this.tbox.getAllClasses());
    }

    public Set getProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        Iterator i = this.rbox.getRoles().iterator();
        while (i.hasNext()) {
            Role role = (Role)i.next();
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isObjectRole() && !role.isDatatypeRole()) continue;
            set.add(p);
        }
        return set;
    }

    public Set getObjectProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        Iterator i = this.rbox.getRoles().iterator();
        while (i.hasNext()) {
            Role role = (Role)i.next();
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isObjectRole()) continue;
            set.add(p);
        }
        return set;
    }

    public Set getDataProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        Iterator i = this.rbox.getRoles().iterator();
        while (i.hasNext()) {
            Role role = (Role)i.next();
            ATermAppl p = role.getName();
            if (!ATermUtils.isPrimitive(p) || !role.isDatatypeRole()) continue;
            set.add(p);
        }
        return set;
    }

    public Set getIndividuals() {
        return Collections.unmodifiableSet(this.individuals);
    }

    public Role getProperty(ATerm r) {
        return this.rbox.getRole(r);
    }

    public int getPropertyType(ATerm r) {
        Role role = this.getProperty(r);
        return role == null ? 0 : role.getType();
    }

    public boolean isClass(ATerm c) {
        return this.tbox.classes.contains(c) || c.equals(ATermUtils.TOP) || ATermUtils.isComplexClass(c);
    }

    public boolean isProperty(ATerm p) {
        return this.rbox.isRole(p);
    }

    public boolean isDatatypeProperty(ATerm p) {
        return this.getPropertyType(p) == 2;
    }

    public boolean isObjectProperty(ATerm p) {
        return this.getPropertyType(p) == 1;
    }

    public boolean isABoxProperty(ATerm p) {
        int type = this.getPropertyType(p);
        return type == 1 || type == 2;
    }

    public boolean isAnnotationProperty(ATerm p) {
        return this.getPropertyType(p) == 3;
    }

    public boolean isOntologyProperty(ATerm p) {
        return this.getPropertyType(p) == 4;
    }

    public boolean isIndividual(ATerm ind) {
        return this.getIndividuals().contains(ind);
    }

    public boolean isTransitiveProperty(ATermAppl r) {
        Role role = this.getRole((ATerm)r);
        if (role == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(r + " is not a known property");
        }
        if (role.isTransitive()) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot((ATerm)c);
        ATermAppl test = ATermUtils.makeAnd((ATerm)ATermUtils.makeSomeValues((ATerm)r, (ATerm)ATermUtils.makeSomeValues((ATerm)r, (ATerm)c)), (ATerm)ATermUtils.makeAllValues((ATerm)r, (ATerm)notC));
        return !this.abox.isSatisfiable(test);
    }

    public boolean isSymmetricProperty(ATermAppl p) {
        return this.isInverse(p, p);
    }

    public boolean isFunctionalProperty(ATermAppl p) {
        if (this.rbox.getRole((ATerm)p).isFunctional()) {
            return true;
        }
        ATermAppl max1P = ATermUtils.makeMax((ATerm)p, 1);
        return this.isSubClassOf(ATermUtils.TOP, max1P);
    }

    public boolean isInverseFunctionalProperty(ATermAppl p) {
        Role role = this.rbox.getRole((ATerm)p);
        if (role.isInverseFunctional()) {
            return true;
        }
        ATermAppl invP = role.getInverse().getName();
        ATermAppl max1invP = ATermUtils.makeMax((ATerm)invP, 1);
        return this.isSubClassOf(ATermUtils.TOP, max1invP);
    }

    public boolean isSubPropertyOf(ATermAppl sub, ATermAppl sup) {
        Role roleSup;
        Role roleSub = this.rbox.getRole((ATerm)sub);
        if (roleSub.isSubRoleOf(roleSup = this.rbox.getRole((ATerm)sup))) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot((ATerm)c);
        ATermAppl test = ATermUtils.makeAnd((ATerm)ATermUtils.makeSomeValues((ATerm)sub, (ATerm)c), (ATerm)ATermUtils.makeAllValues((ATerm)sup, (ATerm)notC));
        return !this.abox.isSatisfiable(test);
    }

    public boolean isEquivalentProperty(ATermAppl p1, ATermAppl p2) {
        return this.isSubPropertyOf(p1, p2) && this.isSubPropertyOf(p2, p1);
    }

    public boolean isInverse(ATermAppl r1, ATermAppl r2) {
        if (this.rbox.getRole((ATerm)r1).getInverse().getName().equals(r2)) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot((ATerm)c);
        ATermAppl test = ATermUtils.makeAnd((ATerm)c, (ATerm)ATermUtils.makeSomeValues((ATerm)r1, (ATerm)ATermUtils.makeAllValues((ATerm)r2, (ATerm)notC)));
        return !this.abox.isSatisfiable(test);
    }

    public boolean hasDomain(ATermAppl p, ATermAppl c) {
        ATermAppl minP1 = ATermUtils.makeMin((ATerm)p, 1);
        return this.isSubClassOf(minP1, c);
    }

    public boolean hasRange(ATermAppl p, ATermAppl c) {
        ATermAppl allValues = ATermUtils.makeAllValues((ATerm)p, (ATerm)c);
        return this.isSubClassOf(ATermUtils.TOP, allValues);
    }

    public boolean isDatatype(ATermAppl c) {
        return this.abox.getDatatypeReasoner().isDefined(c.getName());
    }

    public boolean isSatisfiable(ATermAppl c) {
        this.ensureConsistency();
        if (!this.isClass((ATerm)c)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(c + " is not a known class!");
        }
        return this.abox.isSatisfiable(c);
    }

    public boolean hasIndividual(ATerm d) {
        this.ensureConsistency();
        Timer timer = this.timers.startTimer("hasIndividual");
        ATermAppl c = ATermUtils.normalize((ATermAppl)d);
        ATermAppl notC = ATermUtils.negate(c);
        ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            ATermAppl x = ((Individual)i.next()).getName();
            if (this.abox.isObviousType(x, c)) {
                return true;
            }
            if (!this.abox.isPossibleType(x, notC)) continue;
            unknowns.add(x);
        }
        boolean hasIndividual = !unknowns.isEmpty() && this.abox.isType(unknowns, c);
        timer.stop();
        return hasIndividual;
    }

    public boolean isSubTypeOf(ATermAppl d1, ATermAppl d2) {
        if (!this.isDatatype(d1)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(d1 + " is not a known datatype");
        }
        if (!this.isDatatype(d2)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(d2 + " is not a known datatype");
        }
        return this.getDatatypeReasoner().isSubTypeOf(d1, d2);
    }

    public boolean isSubClassOf(ATermAppl c1, ATermAppl c2) {
        this.ensureConsistency();
        if (!this.isClass((ATerm)c1)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(c1 + " is not a known class");
        }
        if (!this.isClass((ATerm)c2)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(c2 + " is not a known class");
        }
        if (c1.equals(c2)) {
            return true;
        }
        c1 = ATermUtils.normalize(c1);
        c2 = ATermUtils.normalize(c2);
        if (this.isClassified() && this.taxonomy.contains(c1) && this.taxonomy.contains(c2)) {
            return this.taxonomy.isSubNodeOf(c1, c2);
        }
        return this.abox.isSubClassOf(c1, c2);
    }

    public boolean isSubclassOf(ATermAppl c1, ATermAppl c2) {
        return this.isSubClassOf(c1, c2);
    }

    public boolean isEquivalentClass(ATermAppl c1, ATermAppl c2) {
        return this.isSubClassOf(c1, c2) && this.isSubClassOf(c2, c1);
    }

    public boolean isDisjoint(ATermAppl c1, ATermAppl c2) {
        ATermAppl c1and2 = ATermUtils.makeAnd((ATerm)c1, (ATerm)c2);
        return !this.isSatisfiable(c1and2);
    }

    public boolean isComplement(ATermAppl c1, ATermAppl c2) {
        ATermAppl notC2 = ATermUtils.makeNot((ATerm)c2);
        return this.isEquivalentClass(c1, notC2);
    }

    public Bool isKnownType(ATermAppl x, ATermAppl c) {
        this.ensureConsistency();
        c = ATermUtils.normalize(c);
        if (this.abox.isObviousType(x, c)) {
            return Bool.TRUE;
        }
        if (!this.abox.isPossibleType(x, c)) {
            return Bool.FALSE;
        }
        return null;
    }

    public boolean isType(ATermAppl x, ATermAppl c) {
        this.ensureConsistency();
        if (!this.isIndividual((ATerm)x)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(x + " is not an individual!");
        }
        if (!this.isClass((ATerm)c)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(c + " is not a valid class expression");
        }
        if (this.isRealized() && this.taxonomy.contains(c)) {
            return this.taxonomy.getInstances(c).contains(x);
        }
        return this.abox.isType(x, c);
    }

    public boolean isSameAs(ATermAppl t1, ATermAppl t2) {
        this.ensureConsistency();
        if (!this.isIndividual((ATerm)t1)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(t1 + " is not an individual!");
        }
        if (!this.isIndividual((ATerm)t2)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(t2 + " is not an individual!");
        }
        HashSet knowns = new HashSet();
        HashSet unknowns = new HashSet();
        Individual ind = (Individual)this.abox.getPseudoModel().getIndividual((ATerm)t1).getSame();
        this.abox.getSames(ind, knowns, unknowns);
        if (knowns.contains(t2)) {
            return true;
        }
        if (!unknowns.contains(t2)) {
            return false;
        }
        return this.abox.isSameAs(t1, t2);
    }

    public boolean isDifferentFrom(ATermAppl t1, ATermAppl t2) {
        Individual ind1 = this.abox.getIndividual((ATerm)t1);
        Individual ind2 = this.abox.getIndividual((ATerm)t2);
        if (ind1 == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(t1 + " is not an individual!");
        }
        if (ind2 == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(t2 + " is not an individual!");
        }
        if (ind1.isDifferent(ind2)) {
            return true;
        }
        ATermAppl c = ATermUtils.makeValue((ATerm)t2);
        return !this.isType(t1, c);
    }

    public boolean hasPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        this.ensureConsistency();
        if (!this.isIndividual((ATerm)s)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(s + " is not an individual!");
        }
        if (!this.isProperty((ATerm)p)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(p + " is not a known property!");
        }
        if (o != null && (this.isDatatypeProperty((ATerm)p) ? !ATermUtils.isLiteral(o) : !this.isIndividual((ATerm)o))) {
            return false;
        }
        return this.abox.hasPropertyValue(s, p, o);
    }

    public Bool hasKnownPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        this.ensureConsistency();
        return this.abox.hasObviousPropertyValue(s, p, o);
    }

    public ABox getABox() {
        return this.abox;
    }

    public RBox getRBox() {
        return this.rbox;
    }

    public TBox getTBox() {
        return this.tbox;
    }

    public DatatypeReasoner getDatatypeReasoner() {
        return this.abox.getDatatypeReasoner();
    }

    public Set getSuperClasses(ATermAppl c, boolean direct) {
        if (!this.isClass((ATerm)(c = ATermUtils.normalize(c)))) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_SET;
            }
            throw new UnsupportedFeatureException(c + " is not a class!");
        }
        this.classify();
        if (!this.taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        return this.taxonomy.getSupers(c, direct);
    }

    public Set getSubClasses(ATermAppl c) {
        return this.getSubClasses(c, false);
    }

    public Set getDisjoints(ATermAppl c) {
        if (!this.isClass((ATerm)c)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_SET;
            }
            throw new UnsupportedFeatureException(c + " is not a class!");
        }
        ATermAppl notC = ATermUtils.normalize(ATermUtils.makeNot((ATerm)c));
        Set disjoints = this.getSubClasses(notC);
        if (this.tbox.getAllClasses().contains(notC)) {
            disjoints.add(this.getAllEquivalentClasses(notC));
        }
        return disjoints;
    }

    public Set getComplements(ATermAppl c) {
        if (!this.isClass((ATerm)c)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_SET;
            }
            throw new UnsupportedFeatureException(c + " is not a class!");
        }
        ATermAppl notC = ATermUtils.normalize(ATermUtils.makeNot((ATerm)c));
        Set complements = this.getEquivalentClasses(notC);
        if (this.tbox.getAllClasses().contains(notC)) {
            complements.add(notC);
        }
        return complements;
    }

    public Set getTypes(ATermAppl ind, boolean direct) {
        if (!this.isIndividual((ATerm)ind)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_SET;
            }
            throw new UnsupportedFeatureException(ind + " is not an individual!");
        }
        this.realize();
        return this.taxonomy.getTypes(ind, direct);
    }

    public Set getTypes(ATermAppl ind) {
        if (!this.isIndividual((ATerm)ind)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_SET;
            }
            throw new UnsupportedFeatureException(ind + " is not an individual!");
        }
        this.realize();
        return this.taxonomy.getTypes(ind);
    }

    public ATermAppl getType(ATermAppl ind) {
        if (!this.isIndividual((ATerm)ind)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return null;
            }
            throw new UnsupportedFeatureException(ind + " is not an individual!");
        }
        return (ATermAppl)this.abox.getIndividual((ATerm)ind).getTypes(Node.ATOM).iterator().next();
    }

    public ATermAppl getType(ATermAppl ind, boolean direct) {
        if (!this.isIndividual((ATerm)ind)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return null;
            }
            throw new UnsupportedFeatureException(ind + " is not an individual!");
        }
        this.realize();
        Set setOfSets = this.taxonomy.getTypes(ind, direct);
        Set set = (Set)setOfSets.iterator().next();
        return (ATermAppl)set.iterator().next();
    }

    public Set getInstances(ATermAppl c) {
        if (!this.isClass((ATerm)c)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_SET;
            }
            throw new UnsupportedFeatureException(c + " is not a class!");
        }
        if (this.isRealized() && this.taxonomy.contains(c)) {
            return this.taxonomy.getInstances(c);
        }
        return new HashSet(this.retrieve(c));
    }

    public Set getInstances(ATermAppl c, boolean direct) {
        if (!this.isClass((ATerm)c)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_SET;
            }
            throw new UnsupportedFeatureException(c + " is not a class!");
        }
        if (!direct) {
            return this.getInstances(c);
        }
        if (ATermUtils.isPrimitive(c)) {
            this.realize();
            return this.taxonomy.getInstances(c, direct);
        }
        return Collections.EMPTY_SET;
    }

    public Set getEquivalentClasses(ATermAppl c) {
        if (!this.isClass((ATerm)(c = ATermUtils.normalize(c)))) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_SET;
            }
            throw new UnsupportedFeatureException(c + " is not a class!");
        }
        this.classify();
        if (!this.taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        return this.taxonomy.getEquivalents(c);
    }

    public Set getAllEquivalentClasses(ATermAppl c) {
        if (!this.isClass((ATerm)(c = ATermUtils.normalize(c)))) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_SET;
            }
            throw new UnsupportedFeatureException(c + " is not a class!");
        }
        this.classify();
        if (!this.taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        return this.taxonomy.getAllEquivalents(c);
    }

    public Set getSuperClasses(ATermAppl c) {
        return this.getSuperClasses(c, false);
    }

    public Set getSubClasses(ATermAppl c, boolean direct) {
        if (!this.isClass((ATerm)(c = ATermUtils.normalize(c)))) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_SET;
            }
            throw new UnsupportedFeatureException(c + " is not a class!");
        }
        this.classify();
        if (!this.taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        return this.taxonomy.getSubs(c, direct);
    }

    public Set getSuperProperties(ATermAppl prop) {
        return this.getSuperProperties(prop, false);
    }

    public Set getSuperProperties(ATermAppl prop, boolean direct) {
        this.prepare();
        return this.rbox.getTaxonomy().getSupers(prop, direct);
    }

    public Set getSubProperties(ATermAppl prop) {
        return this.getSubProperties(prop, false);
    }

    public Set getSubProperties(ATermAppl prop, boolean direct) {
        this.prepare();
        return this.rbox.getTaxonomy().getSubs(prop, direct);
    }

    public Set getEquivalentProperties(ATermAppl prop) {
        this.prepare();
        return this.rbox.getTaxonomy().getEquivalents(prop);
    }

    public Set getAllEquivalentProperties(ATermAppl prop) {
        this.prepare();
        return this.rbox.getTaxonomy().getAllEquivalents(prop);
    }

    public Set getInverses(ATerm prop) {
        Role invR = this.rbox.getRole(prop).getInverse();
        if (invR != null && !invR.isAnon()) {
            Set inverses = this.getAllEquivalentProperties(invR.getName());
            return inverses;
        }
        return SetUtils.EMPTY_SET;
    }

    public Set getDomains(ATermAppl prop) {
        Set<Object> set = new HashSet<ATermAppl>();
        ATermAppl domain = this.rbox.getRole((ATerm)prop).getDomain();
        if (domain != null) {
            if (ATermUtils.isAnd(domain)) {
                set = ATermUtils.listToSet((ATermList)domain.getArgument(0));
            } else {
                set.add(domain);
            }
        }
        return set;
    }

    public Set getRanges(ATerm prop) {
        Set<Object> set = new HashSet<ATermAppl>();
        ATermAppl range = this.rbox.getRole(prop).getRange();
        if (range != null) {
            if (ATermUtils.isAnd(range)) {
                set = ATermUtils.listToSet((ATermList)range.getArgument(0));
            } else {
                set.add(range);
            }
        }
        return set;
    }

    public Set getAllSames(ATermAppl name) {
        this.ensureConsistency();
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet unknowns = new HashSet();
        Individual ind = (Individual)this.abox.getPseudoModel().getIndividual((ATerm)name).getSame();
        this.abox.getSames(ind, knowns, unknowns);
        Iterator i = unknowns.iterator();
        while (i.hasNext()) {
            ATermAppl other = (ATermAppl)i.next();
            if (!this.abox.isSameAs(name, other)) continue;
            knowns.add(other);
        }
        return knowns;
    }

    public Set getSames(ATermAppl name) {
        Set sames = this.getAllSames(name);
        sames.remove(name);
        return sames;
    }

    public QueryResults runQuery(String queryStr) {
        QueryResults results = QueryEngine.exec(queryStr, this);
        return results;
    }

    public List getDataPropertyValues(ATermAppl r, ATermAppl x, Datatype datatype) {
        Role role = this.rbox.getRole((ATerm)r);
        if (role == null || !role.isDatatypeRole()) {
            throw new UnsupportedFeatureException("getDataPropertyValues function can only be used with datatype properties. Property: " + role);
        }
        ArrayList<Literal> result = new ArrayList<Literal>();
        List values = this.getDataPropertyValues(r, x);
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Literal lit = (Literal)i.next();
            Object value = lit.getValue();
            if (!datatype.contains(value)) continue;
            result.add(lit);
        }
        return result;
    }

    public List getDataPropertyValues(ATermAppl r, ATermAppl x, String lang) {
        List values = this.getDataPropertyValues(r, x);
        if (lang == null) {
            return values;
        }
        ArrayList<Literal> result = new ArrayList<Literal>();
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Literal lit = (Literal)i.next();
            String litLang = lit.getLang();
            if (!litLang.equals(lang)) continue;
            result.add(lit);
        }
        return result;
    }

    public List getDataPropertyValues(ATermAppl r, ATermAppl x) {
        this.ensureConsistency();
        Individual ind = this.abox.getIndividual((ATerm)x);
        Role role = this.rbox.getRole((ATerm)r);
        if (ind == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_LIST;
            }
            throw new UnsupportedFeatureException(x + " is not an individual!");
        }
        if (role == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_LIST;
            }
            throw new UnsupportedFeatureException(r + " is not a known property!");
        }
        return this.abox.getObviousDataPropertyValues(x, role);
    }

    public List getObjectPropertyValues(ATermAppl r, ATermAppl x) {
        Role role = this.rbox.getRole((ATerm)r);
        if (role == null || !role.isObjectRole()) {
            throw new UnsupportedFeatureException("getObjectPropertyValues function can only be used with object properties. Property: " + role);
        }
        HashSet knowns = new HashSet();
        HashSet unknowns = new HashSet();
        this.abox.getObjectPropertyValues(x, role, knowns, unknowns);
        if (!unknowns.isEmpty()) {
            ATermAppl valueX = ATermUtils.makeHasValue((ATerm)role.getInverse().getName(), (ATerm)x);
            ATermAppl c = ATermUtils.normalize(valueX);
            this.binaryInstanceRetrieval(c, new ArrayList(unknowns), knowns);
        }
        return new ArrayList(knowns);
    }

    public List getPropertyValues(ATermAppl r, ATermAppl x) {
        Role role = this.rbox.getRole((ATerm)r);
        if (role.isObjectRole()) {
            return this.getObjectPropertyValues(r, x);
        }
        return this.getDataPropertyValues(r, x);
    }

    public List getIndividualsWithProperty(ATermAppl r, ATermAppl x) {
        Role role = this.rbox.getRole((ATerm)r);
        if (role == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_LIST;
            }
            throw new UnsupportedFeatureException(r + " is not a known property!");
        }
        if (role.isObjectRole()) {
            return this.getIndividualsWithObjectProperty(r, x);
        }
        return this.getIndividualsWithDataProperty(r, x);
    }

    public List getIndividualsWithDataProperty(ATermAppl r, ATermAppl litValue) {
        this.ensureConsistency();
        Object value = this.getDatatypeReasoner().getValue(litValue);
        if (value == null) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_LIST;
            }
            throw new UnsupportedFeatureException(litValue + " is not a valid literal value!");
        }
        ArrayList<ATermAppl> knowns = new ArrayList<ATermAppl>();
        ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            ATermAppl subj = ((Individual)i.next()).getName();
            Bool hasObviousValue = this.abox.hasObviousDataPropertyValue(subj, r, value);
            if (hasObviousValue.isUnknown()) {
                unknowns.add(subj);
                continue;
            }
            if (!hasObviousValue.isTrue()) continue;
            knowns.add(subj);
        }
        if (!unknowns.isEmpty()) {
            ATermAppl c = ATermUtils.normalize(ATermUtils.makeHasValue((ATerm)r, (ATerm)litValue));
            this.binaryInstanceRetrieval(c, unknowns, knowns);
        }
        return knowns;
    }

    public List getIndividualsWithObjectProperty(ATermAppl r, ATermAppl o) {
        this.ensureConsistency();
        if (!this.isIndividual((ATerm)o)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_LIST;
            }
            throw new UnsupportedFeatureException(o + " is not an individual!");
        }
        Role role = this.rbox.getRole((ATerm)r);
        ATermAppl invR = role.getInverse().getName();
        return this.getObjectPropertyValues(invR, o);
    }

    public List getProperties(ATermAppl s, ATermAppl o) {
        Iterator i;
        if (!this.isIndividual((ATerm)s)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_LIST;
            }
            throw new UnsupportedFeatureException(s + " is not an individual!");
        }
        if (!this.isIndividual((ATerm)o)) {
            if (PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return Collections.EMPTY_LIST;
            }
            throw new UnsupportedFeatureException(o + " is not an individual!");
        }
        ArrayList<ATermAppl> props = new ArrayList<ATermAppl>();
        Iterator iterator = i = ATermUtils.isLiteral(o) ? this.getDataProperties().iterator() : this.getObjectProperties().iterator();
        while (i.hasNext()) {
            ATermAppl p = (ATermAppl)i.next();
            if (!this.abox.hasPropertyValue(s, p, o)) continue;
            props.add(p);
        }
        return props;
    }

    public Map getPropertyValues(ATermAppl pred) {
        HashMap<ATermAppl, List> result = new HashMap<ATermAppl, List>();
        Iterator subjects = this.retrieveIndividualsWithProperty(pred).iterator();
        while (subjects.hasNext()) {
            ATermAppl subj = (ATermAppl)subjects.next();
            List objects = this.getPropertyValues(pred, subj);
            if (objects.isEmpty()) continue;
            result.put(subj, objects);
        }
        return result;
    }

    private List retrieve(ATermAppl d) {
        this.ensureConsistency();
        ATermAppl c = ATermUtils.normalize(d);
        if (this.instances.containsKey(c)) {
            return (List)this.instances.get(c);
        }
        if (this.isRealized() && this.taxonomy.contains(c)) {
            return new ArrayList(this.getInstances(c));
        }
        Timer timer = this.timers.startTimer("retrieve");
        ATermAppl notC = ATermUtils.negate(c);
        ArrayList<ATermAppl> knowns = new ArrayList<ATermAppl>();
        if (!this.abox.isSatisfiable(notC)) {
            knowns.addAll(this.getIndividuals());
        } else if (this.abox.isSatisfiable(c)) {
            ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
            IndividualIterator i = this.abox.getIndIterator();
            while (i.hasNext()) {
                ATermAppl x = ((Individual)i.next()).getName();
                if (this.abox.isObviousType(x, c)) {
                    knowns.add(x);
                    continue;
                }
                if (!this.abox.isPossibleType(x, c)) continue;
                unknowns.add(x);
            }
            if (!unknowns.isEmpty() && this.abox.isType(unknowns, c)) {
                this.binaryInstanceRetrieval(c, unknowns, knowns);
            }
        }
        timer.stop();
        return knowns;
    }

    public List retrieveIndividualsWithProperty(ATermAppl r) {
        this.ensureConsistency();
        ArrayList<ATermAppl> knowns = new ArrayList<ATermAppl>();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            ATermAppl x = ((Individual)i.next()).getName();
            if (!this.abox.hasProperty(x, r)) continue;
            knowns.add(x);
        }
        return knowns;
    }

    private void binaryInstanceRetrieval(ATermAppl c, List candidates, Collection results) {
        if (candidates.isEmpty()) {
            return;
        }
        List[] partitions = this.partition(candidates);
        this.partitionInstanceRetrieval(c, partitions, results);
    }

    private void partitionInstanceRetrieval(ATermAppl c, List[] partitions, Collection results) {
        if (partitions[0].size() == 1) {
            ATermAppl i = (ATermAppl)partitions[0].get(0);
            this.binaryInstanceRetrieval(c, partitions[1], results);
            if (this.isType(i, c)) {
                results.add(i);
            }
        } else if (!this.abox.isType(partitions[0], c)) {
            this.binaryInstanceRetrieval(c, partitions[1], results);
        } else if (!this.abox.isType(partitions[1], c)) {
            this.binaryInstanceRetrieval(c, partitions[0], results);
        } else {
            this.binaryInstanceRetrieval(c, partitions[0], results);
            this.binaryInstanceRetrieval(c, partitions[1], results);
        }
    }

    private List[] partition(List candidates) {
        List[] partitions = new List[2];
        int n = candidates.size();
        if (n <= 1) {
            partitions[0] = candidates;
            partitions[1] = new ArrayList();
        } else {
            partitions[0] = candidates.subList(0, n / 2);
            partitions[1] = candidates.subList(n / 2, n);
        }
        return partitions;
    }

    public void printClassTree() {
        this.classify();
        this.taxonomy.print();
    }

    public void printClassTree(OutputFormatter out) {
        this.classify();
        this.taxonomy.print(out);
    }

    public boolean doExplanation() {
        return this.abox.doExplanation();
    }

    public void setDoExplanation(boolean doExplanation) {
        this.abox.setDoExplanation(doExplanation);
    }

    public String getExplanation() {
        return this.abox.getExplanation();
    }

    public void setDoDependencyAxioms(boolean doDepAxioms) {
        if (DEBUG) {
            System.out.println("Setting DoDependencyAxioms = " + doDepAxioms);
        }
    }

    public boolean getDoDependencyAxioms() {
        return false;
    }

    public Set getExplanationSet() {
        return SetUtils.EMPTY_SET;
    }

    public void setRBox(RBox rbox) {
        this.rbox = rbox;
    }

    public void setTBox(TBox tbox) {
        this.tbox = tbox;
    }

    CompletionStrategy chooseStrategy(ABox abox) {
        if (PelletOptions.DEFAULT_COMPLETION_STRATEGY != null) {
            Class[] types = new Class[]{ABox.class};
            Object[] args = new Object[]{abox};
            try {
                Constructor cons = PelletOptions.DEFAULT_COMPLETION_STRATEGY.getConstructor(types);
                return (CompletionStrategy)cons.newInstance(args);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InternalReasonerException("Failed to create the default completion strategy defined in PelletOptions!");
            }
        }
        if (PelletOptions.USE_COMPLETION_STRATEGY) {
            boolean emptyStrategy;
            Expressivity expressivity = this.getExpressivity();
            boolean bl = emptyStrategy = abox.size() == 1 && ((Individual)abox.getIndIterator().next()).getOutEdges().isEmpty();
            if (expressivity.hasNominal()) {
                if (expressivity.hasInverse()) {
                    return new SHOINStrategy(abox);
                }
                return new SHONStrategy(abox);
            }
            if (expressivity.hasInverse()) {
                return new SHINStrategy(abox);
            }
            if (emptyStrategy) {
                return new EmptySHNStrategy(abox);
            }
            return new SHNStrategy(abox);
        }
        return new SHOINStrategy(abox);
    }

    public String getOntology() {
        return this.ontology;
    }

    public void setOntology(String ontology) {
        this.ontology = ontology;
    }

    public void setTimeout(long timeout) {
        this.timers.mainTimer.setTimeout(timeout);
    }

    Role getRole(ATerm term) {
        return this.rbox.getRole(term);
    }

    public Taxonomy getTaxonomy() {
        this.classify();
        return this.taxonomy;
    }

    public Taxonomy getRoleTaxonomy() {
        this.prepare();
        return this.rbox.getTaxonomy();
    }
}

