/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.datatypes.RDFSLiteral;
import org.mindswap.pellet.datatypes.StringValue;
import org.mindswap.pellet.datatypes.UnionDatatype;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

public class Literal
extends Node {
    private ATermAppl atermValue;
    private Object value;
    private Datatype datatype;
    private Edge inEdge;
    private EdgeList inEdges;

    public Literal(ATermAppl name, ATermAppl atermValue, ABox abox) {
        super(name, abox);
        if (atermValue != null) {
            this.atermValue = ATermUtils.makeValue((ATerm)atermValue);
            this.value = abox.dtReasoner.getValue(atermValue);
        }
    }

    public Literal(Literal literal, ABox abox) {
        super(literal, abox);
        this.atermValue = literal.atermValue;
        this.value = literal.value;
        this.inEdge = literal.inEdge;
        this.inEdges = literal.inEdges;
    }

    public Node copyTo(ABox abox) {
        return new Literal(this, abox);
    }

    protected void updateNodeReferences() {
        super.updateNodeReferences();
        Individual ind = this.inEdge.getFrom();
        ATermAppl name = ind.getName();
        Individual from = this.abox.getIndividual((ATerm)name);
        this.inEdge = new Edge(this.inEdge.getRole(), from, this, this.inEdge.getDepends());
        this.inEdges = new EdgeList(this.inEdge);
        from.addOutEdge(this.inEdge);
    }

    public final boolean isLeaf() {
        return true;
    }

    public int getNominalLevel() {
        return this.isNominal() ? NOMINAL : BLOCKABLE;
    }

    public boolean isNominal() {
        return this.value != null;
    }

    public boolean isBlockable() {
        return this.value == null;
    }

    public boolean isLiteral() {
        return true;
    }

    public boolean isIndividual() {
        return false;
    }

    public boolean isDifferent(Node node) {
        if (super.isDifferent(node)) {
            return true;
        }
        Literal literal = (Literal)node;
        if (this.value != null && literal.value != null) {
            return !this.value.equals(literal.value);
        }
        return false;
    }

    public boolean hasType(ATerm type) {
        return super.hasType(type) || this.atermValue != null && this.atermValue.equals(type);
    }

    public DependencySet getDifferenceDependency(Node node) {
        DependencySet ds = null;
        if (this.isDifferent(node) && (ds = (DependencySet)this.differents.get(node)) == null) {
            ds = DependencySet.INDEPENDENT;
        }
        return ds;
    }

    public void addType(ATermAppl c, DependencySet d) {
        if (this.hasType((ATerm)c)) {
            return;
        }
        super.addType(c, d);
        this.checkClash();
    }

    public void addAllTypes(Map types) {
        Iterator i = types.keySet().iterator();
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            if (this.hasType((ATerm)c)) continue;
            DependencySet ds = (DependencySet)types.get(c);
            super.addType(c, ds);
        }
        this.checkClash();
    }

    public void addInEdge(Edge edge) {
        if (this.inEdge != null || !edge.getTo().equals(this)) {
            throw new InternalReasonerException("Trying to add another edge to a literal. Edge: " + edge);
        }
        if (edge == null) {
            throw new InternalReasonerException("Adding a null edge to a literal.");
        }
        this.inEdge = edge;
        this.inEdges = new EdgeList(edge);
    }

    public boolean removeInEdge(Edge edge) {
        if (this.inEdge == null || !this.inEdge.equals(edge)) {
            throw new InternalReasonerException("Trying to remove a non-existing edge from a literal. Literal ID:" + this + " Edge: " + edge);
        }
        this.inEdge = null;
        return true;
    }

    public void removeInEdges() {
        this.inEdge = null;
        this.inEdges = null;
    }

    public EdgeList getInEdges() {
        return this.inEdges;
    }

    public Edge getInEdge() {
        return this.inEdge;
    }

    public Individual getParent() {
        if (this.inEdge == null) {
            return null;
        }
        return this.inEdge.getFrom();
    }

    public boolean hasSuccessor(Node x) {
        return false;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public ATermAppl getTerm() {
        return (ATermAppl)this.atermValue.getArgument(0);
    }

    public String getDatatypeURI() {
        if (this.atermValue != null) {
            ATermAppl literal = this.getTerm();
            String datatypeURI = ((ATermAppl)literal.getArgument(2)).getName();
            if (datatypeURI.equals("")) {
                return null;
            }
            return datatypeURI;
        }
        if (this.datatype == null) {
            return null;
        }
        if (this.datatype instanceof UnionDatatype) {
            return null;
        }
        if (this.datatype.getURI() != null) {
            return this.datatype.getURI();
        }
        AtomicDatatype primitive = ((AtomicDatatype)this.datatype).getPrimitiveType();
        return primitive.getURI();
    }

    public String getLang() {
        if (this.value != null && this.value instanceof StringValue) {
            return ((StringValue)this.value).getLang();
        }
        return "";
    }

    public String getLexicalValue() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    private void checkClash() {
        Set types;
        if (this.value == null && this.atermValue != null) {
            this.abox.setClash(Clash.invalidLiteral(this, DependencySet.INDEPENDENT, this.getTerm()));
            return;
        }
        if (this.hasType((ATerm)ATermUtils.BOTTOM)) {
            this.abox.setClash(new Clash(this, 6, this.getDepends((ATerm)ATermUtils.BOTTOM)));
            if (this.abox.doExplanation()) {
                System.out.println("1) Literal clash dependency = " + this.abox.getClash());
            }
        }
        if ((types = this.getTypes()).size() == 1) {
            this.datatype = RDFSLiteral.instance;
            return;
        }
        DatatypeReasoner dtReasoner = this.abox.getDatatypeReasoner();
        ArrayList<ATermAppl> primitives = new ArrayList<ATermAppl>();
        Iterator i = types.iterator();
        while (i.hasNext()) {
            ATermAppl type = (ATermAppl)i.next();
            if (type.equals(RDFSLiteral.instance.getName()) || ATermUtils.isAnd(type)) continue;
            primitives.add(type);
        }
        if (primitives.isEmpty()) {
            this.datatype = RDFSLiteral.instance;
            return;
        }
        ATermAppl[] dt = primitives.toArray(new ATermAppl[primitives.size() - 1]);
        this.datatype = dtReasoner.intersection(dt);
        AtomicDatatype litDatatype = (AtomicDatatype)dtReasoner.getDatatype(this.getDatatypeURI());
        if (this.datatype.isEmpty()) {
            DependencySet ds = DependencySet.EMPTY;
            for (int i2 = 0; i2 < dt.length; ++i2) {
                ds = ds.union(this.getDepends((ATerm)dt[i2]));
            }
            String exp = null;
            if (this.abox.doExplanation()) {
                exp = "Types: " + this.getTypes().toString();
            }
            this.abox.setClash(new Clash((Node)this, 6, ds, exp));
        } else if (this.value != null && !this.datatype.contains(this.value, litDatatype)) {
            DependencySet ds = DependencySet.EMPTY;
            for (int i3 = 0; i3 < dt.length; ++i3) {
                ds = ds.union(this.getDepends((ATerm)dt[i3]));
            }
            if (this.value instanceof StringValue) {
                this.abox.setClash(Clash.missingDatatype(this, ds, this.getTerm(), dt[0]));
            } else {
                this.abox.setClash(Clash.valueDatatype(this, ds, this.getTerm(), dt[0]));
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String toTypedString() {
        String str = "\"" + this.value + "\"";
        String lang = this.getLang();
        if (!lang.equals("")) {
            return str + "@" + lang;
        }
        String datatypeURI = this.getDatatypeURI();
        if (datatypeURI != null) {
            return str + "^^" + datatypeURI;
        }
        return str;
    }

    public final void prune(DependencySet ds) {
        this.pruned = ds;
    }

    public void unprune(int branch) {
        this.pruned = null;
        DependencySet d = this.inEdge.getDepends();
        if (d.branch <= branch) {
            Role role;
            Individual pred = this.inEdge.getFrom();
            if (!pred.hasEdge(role = this.inEdge.getRole(), this)) {
                pred.addOutEdge(this.inEdge);
                if (DEBUG) {
                    System.out.println("RESTORE: " + this + " ADD reverse edge " + this.inEdge);
                }
            }
        } else {
            throw new InternalReasonerException("Trying to unprune a literal without any incoming edge");
        }
    }

    public String toString() {
        return this.toTypedString();
    }

    public String debugString() {
        return this.name + " = " + this.getTypes().toString();
    }
}

