/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import java.util.List;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;

class MaxBranch
extends Branch {
    List mergePairs;
    Role r;
    int n;

    MaxBranch(ABox abox, CompletionStrategy strategy, Individual x, Role r, int n, List mergePairs, DependencySet ds) {
        super(abox, strategy, x, ds, mergePairs.size());
        this.r = r;
        this.n = n;
        this.mergePairs = mergePairs;
    }

    protected Branch copyTo(ABox abox) {
        Individual x = abox.getIndividual((ATerm)this.node.getName());
        MaxBranch b = new MaxBranch(abox, null, x, this.r, this.n, this.mergePairs, this.termDepends);
        b.anonCount = this.anonCount;
        b.nodeCount = this.nodeCount;
        b.branch = this.branch;
        b.nodeName = this.node.getName();
        b.strategy = this.strategy;
        return b;
    }

    protected void tryBranch() {
        this.abox.incrementBranch();
        DependencySet ds = this.termDepends;
        while (this.tryNext < this.tryCount) {
            DependencySet clashDepends;
            NodeMerge nm = (NodeMerge)this.mergePairs.get(this.tryNext);
            Node y = this.abox.getNode((ATerm)nm.y);
            Node z = this.abox.getNode((ATerm)nm.z);
            if (ABox.DEBUG) {
                System.out.println("MAX : (" + (this.tryNext + 1) + "/" + this.mergePairs.size() + ") at branch (" + this.branch + ") to  " + this.node + " for prop " + this.r + " merge " + y + " -> " + z + " " + ds);
            }
            ds = ds.union(new DependencySet(this.branch));
            EdgeList rNeighbors = this.node.getRNeighborEdges(this.r);
            EdgeList yEdges = rNeighbors.getEdgesContaining(y);
            EdgeList zEdges = rNeighbors.getEdgesContaining(z);
            if (yEdges.isEmpty() || zEdges.isEmpty()) {
                throw new InternalReasonerException("An error occured related to the max cardinality restriction about " + this.r);
            }
            ds = ds.union(yEdges.edgeAt(0).getDepends());
            ds = ds.union(zEdges.edgeAt(0).getDepends());
            this.strategy.mergeTo(y, z, ds);
            boolean earlyClash = this.abox.isClosed();
            if (earlyClash) {
                if (ABox.DEBUG) {
                    System.out.println("CLASH: Branch " + this.branch + " " + this.abox.getClash() + "!");
                }
                if (!(clashDepends = this.abox.getClash().depends).contains(this.branch)) {
                    return;
                }
            } else {
                return;
            }
            this.strategy.restore(this);
            this.abox.incrementBranch();
            this.prevDS[this.tryNext] = clashDepends.copy();
            ++this.tryNext;
        }
        ds = DependencySet.EMPTY;
        for (int k = 0; k < this.tryCount; ++k) {
            ds = ds.union(this.prevDS[k]);
        }
        ds.remove(this.branch);
        if (this.abox.doExplanation()) {
            this.abox.setClash(Clash.maxCardinality(this.node, ds, this.r.getName(), this.n));
        } else {
            this.abox.setClash(Clash.maxCardinality(this.node, ds));
        }
    }

    public String toString() {
        if (this.tryNext < this.mergePairs.size()) {
            return "Branch " + this.branch + " max rule on " + this.node + " merged  " + this.mergePairs.get(this.tryNext);
        }
        return "Branch " + this.branch + " max rule on " + this.node + " exhausted merge possibilities";
    }
}

