/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.jena.OWLTestVocabulary;

public class OWLSpeciesTest {
    public static boolean DEBUG = false;
    static boolean useLocal = false;
    static String base = useLocal ? "file://C/Mindswap/owl-test/" : "http://www.w3.org/2002/03owlt/editors-draft/draft/";
    static final List TYPES = Arrays.asList(OWLTestVocabulary.NotOwlFeatureTest, OWLTestVocabulary.PositiveEntailmentTest, OWLTestVocabulary.NegativeEntailmentTest, OWLTestVocabulary.TrueTest, OWLTestVocabulary.OWLforOWLTest, OWLTestVocabulary.ConsistencyTest, OWLTestVocabulary.InconsistencyTest, OWLTestVocabulary.ImportEntailmentTest, OWLTestVocabulary.ImportLevelTest);
    static final List LEVELS = Arrays.asList(OWLTestVocabulary.Lite, OWLTestVocabulary.DL, OWLTestVocabulary.Full);
    static String allTests = base + "Manifest.rdf";
    private static final String[] AT_RISK = new String[]{"http://www.w3.org/2002/03owlt/disjointWith/Manifest006", "http://www.w3.org/2002/03owlt/disjointWith/Manifest009"};

    public static final void main(String[] args) {
        String manifestFile = allTests;
        OWLSpeciesTest owlTest = new OWLSpeciesTest();
        if (args.length == 0 || args[0].equals("-all")) {
            owlTest.testAll(manifestFile);
        } else if (args[0].equals("-list")) {
            owlTest.testList(AT_RISK);
        }
    }

    private void testList(String[] uris) {
        DEBUG = true;
        Vector<String> incorrectCases = new Vector<String>();
        int numIncorrect = 0;
        int numTests = 0;
        int testCount = 1;
        long start = System.currentTimeMillis();
        for (int i = 0; i < uris.length; ++i) {
            Statement statusStmt;
            RDFNode testStatus;
            Model m = ModelFactory.createDefaultModel();
            m.read(uris[i], "");
            StmtIterator sIter = m.listStatements(null, RDF.type, (RDFNode)((Resource)null));
            Resource testCase = null;
            while (sIter.hasNext()) {
                Statement stmt = sIter.nextStatement();
                if (!TYPES.contains(stmt.getObject())) continue;
                testCase = stmt.getSubject();
                break;
            }
            if ((testStatus = (statusStmt = testCase.getProperty(OWLTestVocabulary.status)).getObject()).equals(OWLTestVocabulary.Obsoleted)) continue;
            System.out.println("Test Case: " + testCount++);
            System.out.println("Name: " + testCase);
            System.out.println();
            Property[] docList = new Property[]{OWLTestVocabulary.premiseDocument, OWLTestVocabulary.inputDocument, OWLTestVocabulary.conclusionDocument};
            for (int j = 0; j < docList.length; ++j) {
                if (!testCase.hasProperty(docList[j])) continue;
                String inputFile = testCase.getProperty(docList[j]).getObject().toString();
                String inputLevel = testCase.getProperty(docList[j]).getProperty(OWLTestVocabulary.level).getObject().toString();
                System.out.println("Document: " + inputFile);
                System.out.println("Document Level: " + inputLevel.substring(inputLevel.lastIndexOf("#") + 1));
                ++numTests;
                try {
                    String aLevel = this.getFileLevel(inputFile);
                    System.out.print("Level : " + aLevel);
                    if (aLevel == null || !inputLevel.endsWith(aLevel)) {
                        System.out.print(" (WRONG)");
                        ++numIncorrect;
                        incorrectCases.addElement(testCount - 1 + ": " + inputFile);
                    }
                    System.out.println("\n");
                    continue;
                }
                catch (Exception ex) {
                    ++numIncorrect;
                    incorrectCases.addElement(testCount - 1 + ": " + inputFile);
                    System.out.println(" (WRONG)\n");
                    ex.printStackTrace(System.out);
                }
            }
        }
        long total = System.currentTimeMillis() - start;
        System.out.println("Final Statistics");
        System.out.println("Total Test Cases: " + (testCount - 1));
        System.out.println("Total Tests Conducted: " + numTests);
        System.out.println("Total Passed: " + (numTests - numIncorrect));
        System.out.println("Total Failed: " + numIncorrect);
        System.out.println("Percent: " + (float)(numTests - numIncorrect) / (float)numTests * 100.0f);
        System.out.println("Total Time (in seconds): " + total / 1000L);
        System.out.println();
        System.out.println("List of failed cases: ");
        for (int i = 0; i < incorrectCases.size(); ++i) {
            System.out.println(incorrectCases.elementAt(i).toString());
        }
    }

    private String getFileLevel(String inputFile) {
        inputFile = this.getFileName(inputFile);
        try {
            ModelReader reader = new ModelReader();
            OWLReasoner reasoner = new OWLReasoner();
            try {
                reasoner.load(reader.read(inputFile));
            }
            catch (Throwable e1) {
                // empty catch block
            }
            String aLevel = reasoner.getLevel();
            if (DEBUG) {
                reasoner.getSpecies().getReport().print();
            }
            return aLevel;
        }
        catch (UnsupportedFeatureException ufe) {
            System.err.println("File has unsupported features");
        }
        catch (StackOverflowError ufe) {
            System.err.println(ufe);
        }
        catch (Exception e) {
            System.err.println("Exception " + e);
            e.printStackTrace();
        }
        return "Unknown";
    }

    private String getRDFHead() {
        StringBuffer sb = new StringBuffer();
        sb.append("<rdf:RDF \n");
        sb.append("  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" \n");
        sb.append("  xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" \n");
        sb.append("  xmlns:results=\"http://www.w3.org/2002/03owlt/resultsOntology#\" \n");
        sb.append("  xmlns=\"http://www.w3.org/1999/xhtml\" \n");
        sb.append("  xml:base=\"http://www.mindswap.org/2003/pellet\">\n\n");
        sb.append("<rdf:Description rdf:about=\"#pellet\">\n");
        sb.append("\t<rdfs:label>Pellet</rdfs:label>\n");
        sb.append("</rdf:Description>\n");
        return sb.toString();
    }

    public void testAll(String manifestFile) {
        Vector<String> incorrectCases = new Vector<String>();
        int numIncorrect = 0;
        int numTests = 0;
        System.out.println("Reading manifest file " + manifestFile);
        System.out.println();
        Model manifestModel = ModelFactory.createDefaultModel();
        manifestModel.read(manifestFile, "");
        int testCount = 1;
        StmtIterator sIter = manifestModel.listStatements(null, RDF.type, (RDFNode)((Resource)null));
        long start = System.currentTimeMillis();
        StringBuffer rdf = new StringBuffer(this.getRDFHead());
        while (sIter.hasNext()) {
            String aLevel;
            String inputFile;
            Resource testCase;
            Statement statusStmt;
            RDFNode testStatus;
            Statement stmt = sIter.nextStatement();
            if (!TYPES.contains(stmt.getObject()) || (testStatus = (statusStmt = (testCase = stmt.getSubject()).getProperty(OWLTestVocabulary.status)).getObject()).equals(OWLTestVocabulary.Obsoleted)) continue;
            if (useLocal && (testCount == 81 || testCount == 140)) {
                ++testCount;
                continue;
            }
            System.out.println("Test Case: " + testCount++);
            System.out.println("Name: " + testCase);
            System.out.println();
            boolean ranATest = false;
            boolean passed = true;
            if (testCase.hasProperty(OWLTestVocabulary.premiseDocument)) {
                inputFile = testCase.getProperty(OWLTestVocabulary.premiseDocument).getObject().toString();
                try {
                    ranATest = true;
                    String premiseLevel = testCase.getProperty(OWLTestVocabulary.premiseDocument).getProperty(OWLTestVocabulary.level).getObject().toString();
                    System.out.println("Premise Document: " + inputFile);
                    System.out.println("Premise Level: " + premiseLevel.substring(premiseLevel.lastIndexOf("#") + 1));
                    ++numTests;
                    aLevel = this.getFileLevel(inputFile);
                    System.out.print("Level : " + aLevel);
                    if (aLevel == null || !premiseLevel.endsWith(aLevel)) {
                        System.out.print(" (WRONG)");
                        ++numIncorrect;
                        incorrectCases.addElement(testCount - 1 + ": " + inputFile);
                        passed = false;
                    }
                    System.out.println("\n");
                }
                catch (Exception ex) {
                    ++numIncorrect;
                    incorrectCases.addElement(testCount - 1 + ": " + inputFile);
                    System.out.println(" (WRONG)\n");
                    ex.printStackTrace(System.out);
                    passed = false;
                }
            }
            if (testCase.hasProperty(OWLTestVocabulary.inputDocument)) {
                ranATest = true;
                inputFile = testCase.getProperty(OWLTestVocabulary.inputDocument).getObject().toString();
                String inputLevel = testCase.getProperty(OWLTestVocabulary.inputDocument).getProperty(OWLTestVocabulary.level).getObject().toString();
                System.out.println("Input Document: " + inputFile);
                System.out.println("Input Level: " + inputLevel.substring(inputLevel.lastIndexOf("#") + 1));
                ++numTests;
                try {
                    aLevel = this.getFileLevel(inputFile);
                    System.out.print("Level : " + aLevel);
                    if (aLevel == null || !inputLevel.endsWith(aLevel)) {
                        System.out.print(" (WRONG)");
                        ++numIncorrect;
                        passed = false;
                        incorrectCases.addElement(testCount - 1 + ": " + inputFile);
                    }
                    System.out.println("\n");
                }
                catch (Exception ex) {
                    ++numIncorrect;
                    incorrectCases.addElement(testCount - 1 + ": " + inputFile);
                    System.out.println(" (WRONG)\n");
                    ex.printStackTrace(System.out);
                    passed = false;
                }
            }
            if (testCase.hasProperty(OWLTestVocabulary.conclusionDocument)) {
                ranATest = true;
                inputFile = testCase.getProperty(OWLTestVocabulary.conclusionDocument).getObject().toString();
                String conclusionLevel = testCase.getProperty(OWLTestVocabulary.conclusionDocument).getProperty(OWLTestVocabulary.level).getObject().toString();
                System.out.println("Conclusion Document: " + inputFile);
                System.out.println("Conclusion Level: " + conclusionLevel.substring(conclusionLevel.lastIndexOf("#") + 1));
                ++numTests;
                try {
                    aLevel = this.getFileLevel(inputFile);
                    System.out.print("Level : " + aLevel);
                    if (aLevel == null || !conclusionLevel.endsWith(aLevel)) {
                        System.out.print(" (WRONG)");
                        ++numIncorrect;
                        incorrectCases.addElement(testCount - 1 + ": " + inputFile);
                        passed = false;
                    }
                    System.out.println("\n");
                }
                catch (Exception ex) {
                    ++numIncorrect;
                    passed = false;
                    incorrectCases.addElement(testCount - 1 + ": " + inputFile);
                    System.out.println(" (WRONG)\n");
                    ex.printStackTrace(System.out);
                }
            }
            if (!ranATest) {
                System.out.println("No tests run for this case!");
            }
            System.out.println("-----------------------------");
            if (!passed) {
                rdf.append("<results:FailingRun>\n");
                rdf.append("\t<results:system rdf:resource=\"#pellet\"/>\n");
                rdf.append("\t<results:output rdf:resource=\"http://www.mindswap.org/2003/pellet/test.shtml\"/>\n");
                rdf.append("\t<results:test rdf:parseType=\"Resource\">\n");
                rdf.append("\t\t<results:syntacticLevelTestFrom rdf:resource=\"" + testCase.toString() + "\"/>\n");
                rdf.append("\t</results:test>\n");
                rdf.append("</results:FailingRun>\n\n");
                continue;
            }
            rdf.append("<results:PassingRun>\n");
            rdf.append("\t<results:system rdf:resource=\"#pellet\"/>\n");
            rdf.append("\t<results:output rdf:resource=\"http://www.mindswap.org/2003/pellet/test.shtml\"/>\n");
            rdf.append("\t<results:test rdf:parseType=\"Resource\">\n");
            rdf.append("\t\t<results:syntacticLevelTestFrom rdf:resource=\"" + testCase.toString() + "\"/>\n");
            rdf.append("\t</results:test>\n");
            rdf.append("</results:PassingRun>\n\n");
        }
        long total = System.currentTimeMillis() - start;
        rdf.append("</rdf:RDF>");
        System.out.println("Final Statistics");
        System.out.println("Total Test Cases: " + (testCount - 1));
        System.out.println("Total Tests Conducted: " + numTests);
        System.out.println("Total Passed: " + (numTests - numIncorrect));
        System.out.println("Total Failed: " + numIncorrect);
        System.out.println("Percent: " + (float)(numTests - numIncorrect) / (float)numTests * 100.0f);
        System.out.println("Total Time (in seconds): " + total / 1000L);
        System.out.println();
        System.out.println("List of failed cases: ");
        for (int i = 0; i < incorrectCases.size(); ++i) {
            System.out.println(incorrectCases.elementAt(i).toString());
        }
    }

    String getFileName(String fileName) {
        if (useLocal) {
            fileName = base + fileName.substring(1 + fileName.substring(1, fileName.lastIndexOf("/") - 1).lastIndexOf("/")) + ".rdf";
        }
        return fileName;
    }
}

