/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.ResultBinding;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.NodeFormatter;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletQueryEngine;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.utils.FileUtils;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.Timers;

public class PelletQuery {
    private boolean formatHTML = false;
    private boolean printTime = false;
    private boolean detailedTime;
    private boolean printOnlyNumbers = false;
    private boolean classify;
    private String data;

    public void setData(String data) {
        this.data = data;
    }

    public boolean isPrintTime() {
        return this.printTime;
    }

    public void setPrintTime(boolean printTime) {
        this.printTime = printTime;
    }

    public boolean isClassify() {
        return this.classify;
    }

    public void setClassify(boolean classify) {
        this.classify = classify;
    }

    public boolean isQuiet() {
        return this.printOnlyNumbers;
    }

    public void setQuiet(boolean quiet) {
        this.printOnlyNumbers = quiet;
    }

    public boolean isFormatHTML() {
        return this.formatHTML;
    }

    public void setFormatHTML(boolean formatHTML) {
        this.formatHTML = formatHTML;
    }

    public boolean isDetailedTime() {
        return this.detailedTime;
    }

    public void setDetailedTime(boolean detailedTime) {
        this.detailedTime = detailedTime;
    }

    public void run(String queryStr, boolean formatHTML) throws Exception {
        this.setFormatHTML(formatHTML);
        this.run(queryStr);
    }

    public void run(String input) throws Exception {
        String loadedOnt = "";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        String[] queries = Pattern.compile("SELECT", 2).split(input);
        if (queries.length <= 1) {
            System.err.println("Invalid RDQL query: " + input);
            PelletQuery.usage();
            System.exit(1);
        }
        for (int j = 1; j < queries.length; ++j) {
            String sourceURL;
            String queryStr = "SELECT " + queries[j];
            if (queries.length > 1) {
                System.out.println("Query (" + j + ")");
            }
            Timers timers = new Timers();
            timers.startTimer("total");
            Query query = new Query(queryStr);
            String string = sourceURL = this.data != null ? this.data : query.getSourceURL();
            if (sourceURL == null) {
                throw new UnsupportedFeatureException("RDQL query must have a FROM clause");
            }
            if (sourceURL.equals(loadedOnt)) {
                query.setSource((Model)model);
            } else {
                timers.startTimer("parse");
                model.read(sourceURL);
                timers.stopTimer("parse");
                query.setSource((Model)model);
                timers.startTimer("prepare");
                model.prepare();
                timers.stopTimer("prepare");
                if (this.classify) {
                    timers.startTimer("classify");
                    ((PelletInfGraph)model.getGraph()).classify();
                    timers.stopTimer("classify");
                }
            }
            loadedOnt = sourceURL;
            timers.startTimer("query");
            QueryResults results = new PelletQueryEngine(query).exec();
            timers.stopTimer("query");
            timers.stopTimer("total");
            int count = 0;
            if (this.printOnlyNumbers && query.getResultVars().containsAll(query.getBoundVars())) {
                while (results.hasNext()) {
                    results.next();
                    ++count;
                }
            } else {
                NodeFormatter formatter = null;
                if (!this.printOnlyNumbers) {
                    formatter = new NodeFormatter((Model)model, this.formatHTML);
                    PelletQuery.addDefaultQNames(formatter.getQNames());
                }
                List resultVars = query.getResultVars();
                LinkedHashSet data = new LinkedHashSet();
                while (results.hasNext()) {
                    ResultBinding binding = (ResultBinding)results.next();
                    ArrayList<Object> formattedBinding = new ArrayList<Object>();
                    for (int i = 0; i < resultVars.size(); ++i) {
                        String var = (String)resultVars.get(i);
                        RDFNode result = (RDFNode)binding.get(var);
                        if (this.printOnlyNumbers) {
                            formattedBinding.add(result);
                            continue;
                        }
                        formattedBinding.add(formatter.format(result));
                    }
                    if (!data.add(formattedBinding)) continue;
                    ++count;
                }
                if (!this.printOnlyNumbers) {
                    TableData table = new TableData(data, resultVars);
                    table.print(System.out, this.formatHTML);
                    System.out.println();
                }
            }
            System.out.println("Number of answers: " + count);
            if (this.printTime) {
                System.out.println();
                System.out.println("Total time       : " + timers.getTimer("total").getTotal());
                if (timers.getTimer("parse") != null) {
                    System.out.println("Parsing RDF file : " + timers.getTimer("parse").getTotal());
                    System.out.println("Preprocessing    : " + timers.getTimer("prepare").getTotal());
                    if (this.classify) {
                        System.out.println("Classify         : " + timers.getTimer("classify").getTotal());
                    }
                    System.out.println("Query time       : " + timers.getTimer("query").getTotal());
                }
                if (this.detailedTime) {
                    System.out.println();
                    System.out.println("Detailed timing about reasoner internals:");
                    ((PelletInfGraph)model.getGraph()).getKB().timers.print();
                }
            }
            System.out.println();
        }
    }

    private static void addDefaultQNames(QNameProvider qnames) {
        qnames.setMapping("tce-service", "http://www.flacp.fujitsulabs.com/tce/ontologies/2004/03/service.owl#");
        qnames.setMapping("tce-object", "http://www.flacp.fujitsulabs.com/tce/ontologies/2004/03/object.owl#");
        String owls = "http://www.daml.org/services/owl-s/";
        String[] versions = new String[]{"0.9", "1.0", "1.1"};
        String[] add = new String[]{"-0.9", "-1.0", ""};
        String[] files = new String[]{"Service", "Profile", "Process", "Grounding"};
        for (int version = 0; version < versions.length; ++version) {
            for (int file = 0; file < files.length; ++file) {
                String prefix = files[file].toLowerCase() + add[version];
                String uri = owls + versions[version] + "/" + files[file] + ".owl#";
                qnames.setMapping(prefix, uri);
            }
        }
    }

    public static void usage() {
        System.out.println("PelletQuery");
        System.out.println("");
        System.out.println("Reads one (or more) RDQL queries from a string or an input file and");
        System.out.println("runs each one separately. Multiple RDQL queries can be seprated by");
        System.out.println("one or more whitespce characters. If an ontology is queried more than");
        System.out.println("once it will be loaded only once and reused for subsequent queries.");
        System.out.println("");
        System.out.println("usage: java PelletQuery OPTIONS [<rdqlQuery> | -f <rdqlFile]");
        System.out.println("  -t            Print time about how long query answering takes. 'd'");
        System.out.println("                option causes a more detailed time information to be");
        System.out.println("                printed");
        System.out.println("  -c            Classify the KB before answering queries");
        System.out.println("  -q            Print only the number of answers not the bindings");
        System.out.println("  -d <dataURI>  Use the given URI as the data source (the FROM clause");
        System.out.println("                in the queries will be ignored)");
        System.out.println("  -h            Print this information");
    }

    public static void main(String[] args) throws Exception {
        PelletQuery pelletQuery = new PelletQuery();
        String query = "";
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-h")) {
                PelletQuery.usage();
                System.exit(0);
                continue;
            }
            if (arg.equals("-dt")) {
                pelletQuery.setPrintTime(true);
                pelletQuery.setDetailedTime(true);
                continue;
            }
            if (arg.equals("-t")) {
                pelletQuery.setPrintTime(true);
                continue;
            }
            if (arg.equals("-q")) {
                pelletQuery.setQuiet(true);
                continue;
            }
            if (arg.equals("-d")) {
                pelletQuery.setData(args[++i]);
                continue;
            }
            if (arg.equals("-c")) {
                pelletQuery.setClassify(true);
                continue;
            }
            if (arg.startsWith("-f")) {
                query = FileUtils.readFile(args[++i]);
                continue;
            }
            if (i == args.length - 1) {
                query = args[i];
                continue;
            }
            System.err.println("Unknown option; " + arg);
            PelletQuery.usage();
            System.exit(1);
        }
        if (query == null) {
            System.err.println("No query is given");
            PelletQuery.usage();
            System.exit(1);
        }
        pelletQuery.run(query);
    }
}

