/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class Role {
    public static final String[] TYPES = new String[]{"Undefined", "Object", "Datatype", "Annotation", "Ontology"};
    public static final int UNDEFINED = 0;
    public static final int OBJECT = 1;
    public static final int DATATYPE = 2;
    public static final int ANNOTATION = 3;
    public static final int ONTOLOGY = 4;
    public static final int LINK = 5;
    private String foreignOntology;
    private ATermAppl name;
    private int type = 0;
    private Role inverse = null;
    private Set subRoles = new HashSet();
    private Set superRoles = new HashSet();
    private Set functionalSupers = SetUtils.EMPTY_SET;
    private Set transitiveSubRoles = SetUtils.EMPTY_SET;
    private ATermAppl domain = null;
    private ATermAppl range = null;
    private boolean isTransitive = false;
    private boolean isFunctional = false;

    public Role(ATermAppl name) {
        this(name, 0);
    }

    public Role(ATermAppl name, int type) {
        this.name = name;
        this.type = type;
        this.addSubRole(this);
        this.addSuperRole(this);
    }

    public boolean equals(Object o) {
        if (o instanceof Role) {
            return this.name == ((Role)o).getName();
        }
        return false;
    }

    public String toString() {
        return this.name.getArity() == 0 ? this.name.getName() : this.name.toString();
    }

    public String debugString() {
        String str = "(" + TYPES[this.type] + "Role " + this.name;
        if (this.isTransitive) {
            str = str + " Transitive";
        }
        if (this.isSymmetric()) {
            str = str + " Symmetric";
        }
        if (this.isFunctional) {
            str = str + " Functional";
        }
        if (this.isInverseFunctional()) {
            str = str + " InverseFunctional";
        }
        if (this.type == 1 || this.type == 2) {
            if (this.domain != null) {
                str = str + " domain=" + this.domain;
            }
            if (this.range != null) {
                str = str + " range=" + this.range;
            }
            str = str + " superPropertyOf=" + this.subRoles;
            str = str + " subPropertyOf=" + this.superRoles;
        }
        str = str + ")";
        return str;
    }

    public void addSubRole(Role r) {
        this.subRoles.add(r);
    }

    public void addSuperRole(Role r) {
        this.superRoles.add(r);
    }

    public void addDomain(ATermAppl a) {
        this.domain = this.domain == null ? a : ATermUtils.makeAnd((ATerm)a, (ATerm)this.domain);
        this.domain = ATermUtils.normalize(this.domain);
    }

    public void addRange(ATermAppl a) {
        this.range = this.range == null ? a : ATermUtils.makeAnd((ATerm)a, (ATerm)this.range);
        this.range = ATermUtils.normalize(this.range);
    }

    public boolean isObjectRole() {
        return this.type == 1;
    }

    public boolean isLinkRole() {
        return this.type == 5;
    }

    public boolean isDatatypeRole() {
        return this.type == 2;
    }

    public boolean isOntologyRole() {
        return this.type == 4;
    }

    public boolean isAnnotationRole() {
        return this.type == 3;
    }

    public Role getInverse() {
        return this.inverse;
    }

    public boolean hasNamedInverse() {
        return this.inverse != null && !this.inverse.isAnon();
    }

    public boolean isFunctional() {
        return this.isFunctional;
    }

    public boolean isInverseFunctional() {
        return this.inverse != null && this.inverse.isFunctional();
    }

    public boolean isSymmetric() {
        return this.inverse != null && this.inverse.equals(this);
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    public boolean isAnon() {
        return this.name.getArity() != 0;
    }

    public ATermAppl getName() {
        return this.name;
    }

    public ATermAppl getDomain() {
        return this.domain;
    }

    public ATermAppl getRange() {
        return this.range;
    }

    public Set getSubRoles() {
        return this.subRoles;
    }

    public Set getSuperRoles() {
        return this.superRoles;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return TYPES[this.type];
    }

    public boolean isSubRoleOf(Role r) {
        return this.superRoles.contains(r);
    }

    public boolean isSuperRoleOf(Role r) {
        return this.subRoles.contains(r);
    }

    public void setInverse(Role term) {
        this.inverse = term;
    }

    public void setFunctional(boolean b) {
        this.isFunctional = b;
    }

    public void setTransitive(boolean b) {
        this.isTransitive = b;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setSubRoles(Set subRoles) {
        this.subRoles = subRoles;
    }

    public void setSuperRoles(Set superRoles) {
        this.superRoles = superRoles;
    }

    public Set getFunctionalSupers() {
        return this.functionalSupers;
    }

    public void addFunctionalSuper(Role r) {
        if (this.functionalSupers.isEmpty()) {
            this.functionalSupers = SetUtils.singleton(r);
        } else if (this.functionalSupers.size() == 1) {
            Role fs = (Role)this.functionalSupers.iterator().next();
            if (fs.isSubRoleOf(r)) {
                this.functionalSupers = SetUtils.singleton(r);
            } else if (!r.isSubRoleOf(fs)) {
                this.functionalSupers = new HashSet(2);
                this.functionalSupers.add(fs);
                this.functionalSupers.add(r);
            }
        } else {
            Iterator i = this.functionalSupers.iterator();
            while (i.hasNext()) {
                Role fs = (Role)i.next();
                if (fs.isSubRoleOf(r)) {
                    this.functionalSupers.remove(fs);
                    this.functionalSupers.add(r);
                    return;
                }
                if (!r.isSubRoleOf(fs)) continue;
                return;
            }
            this.functionalSupers.add(r);
        }
    }

    public boolean isSimple() {
        return !this.isTransitive && this.transitiveSubRoles.isEmpty();
    }

    public Set getTransitiveSubRoles() {
        return this.transitiveSubRoles;
    }

    public void addTransitiveSubRole(Role r) {
        if (this.transitiveSubRoles.isEmpty()) {
            this.transitiveSubRoles = SetUtils.singleton(r);
        } else if (this.transitiveSubRoles.size() == 1) {
            Role tsr = (Role)this.transitiveSubRoles.iterator().next();
            if (tsr.isSubRoleOf(r)) {
                this.transitiveSubRoles = SetUtils.singleton(r);
            } else if (!r.isSubRoleOf(tsr)) {
                this.transitiveSubRoles = new HashSet(2);
                this.transitiveSubRoles.add(tsr);
                this.transitiveSubRoles.add(r);
            }
        } else {
            Iterator i = this.transitiveSubRoles.iterator();
            while (i.hasNext()) {
                Role tsr = (Role)i.next();
                if (tsr.isSubRoleOf(r)) {
                    this.transitiveSubRoles.remove(tsr);
                    this.transitiveSubRoles.add(r);
                    return;
                }
                if (!r.isSubRoleOf(tsr)) continue;
                return;
            }
            this.transitiveSubRoles.add(r);
        }
    }

    public String getForeignOntology() {
        return this.foreignOntology;
    }

    public void setForeignOntology(String foreignOntology) {
        this.foreignOntology = foreignOntology;
    }
}

