/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import java.util.List;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.DoubleBlocking;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.GuessBranch;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;

public class SHOINStrategy
extends CompletionStrategy {
    public SHOINStrategy(ABox abox) {
        super(abox, new DoubleBlocking());
    }

    boolean supportsPseudoModelCompletion() {
        return true;
    }

    protected void applyGuessingRule(IndividualIterator i) {
        i.reset();
        block0: while (i.hasNext()) {
            Individual x = (Individual)i.next();
            if (x.isBlockable()) continue;
            List types = x.getTypes(Node.MAX);
            int size = types.size();
            for (int j = 0; j < size; ++j) {
                ATermAppl mc = (ATermAppl)types.get(j);
                ATermAppl max = (ATermAppl)mc.getArgument(0);
                Role r = this.abox.getRole(max.getArgument(0));
                int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
                if (r.isDatatypeRole()) continue;
                boolean apply = false;
                EdgeList edges = x.getRPredecessorEdges(r.getInverse());
                for (int e = 0; e < edges.size(); ++e) {
                    Edge edge = edges.edgeAt(e);
                    Individual pred = edge.getFrom();
                    if (!pred.isBlockable()) continue;
                    apply = true;
                    break;
                }
                if (!apply || x.getMaxCard(r) < n || x.hasDistinctRNeighborsForMin(r, n, true)) continue;
                int guessMin = x.getMinCard(r);
                if (guessMin == 0) {
                    guessMin = 1;
                }
                DependencySet ds = x.getDepends((ATerm)mc);
                edges = x.getRNeighborEdges(r);
                for (int e = 0; e < edges.size(); ++e) {
                    Edge edge = edges.edgeAt(e);
                    ds = ds.union(edge.getDepends());
                }
                GuessBranch newBranch = new GuessBranch(this.abox, this, x, r, guessMin, n, ds);
                this.addBranch(newBranch);
                if (!newBranch.tryNext()) {
                    return;
                }
                if (this.abox.isClosed()) {
                    return;
                }
                if (x.isPruned()) break block0;
            }
        }
    }

    protected boolean backtrack() {
        boolean branchFound = false;
        while (!branchFound) {
            this.completionTimer.check();
            int lastBranch = this.abox.getClash().depends.max();
            if (lastBranch <= 0) {
                return false;
            }
            if (lastBranch > this.abox.getBranches().size()) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to branch " + lastBranch + " but has only " + this.abox.getBranches().size() + " branches");
            }
            List branches = this.abox.getBranches();
            branches.subList(lastBranch, branches.size()).clear();
            Branch newBranch = (Branch)branches.get(lastBranch - 1);
            if (ABox.DEBUG) {
                System.out.println("JUMP: Branch " + lastBranch);
            }
            if (lastBranch != newBranch.branch) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to branch " + lastBranch + " but got " + newBranch.branch);
            }
            if (newBranch.tryNext < newBranch.tryCount) {
                newBranch.prevDS[newBranch.tryNext] = this.abox.getClash().depends.copy();
            }
            ++newBranch.tryNext;
            if (newBranch.tryNext < newBranch.tryCount) {
                this.restore(newBranch);
                branchFound = newBranch.tryNext();
            } else {
                this.abox.getClash().depends.remove(lastBranch);
            }
            if (branchFound || !ABox.DEBUG) continue;
            System.out.println("FAIL: Branch " + lastBranch);
        }
        return branchFound;
    }

    ABox complete() {
        this.completionTimer.start();
        this.initialize();
        while (!this.abox.isComplete()) {
            while (this.abox.changed && !this.abox.isClosed()) {
                this.completionTimer.check();
                this.abox.changed = false;
                if (ABox.DEBUG) {
                    System.out.println("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.treeDepth + ", Size: " + this.abox.getNodes().size() + ", Mem: " + Runtime.getRuntime().freeMemory() / 1000L + "kb");
                    this.abox.validate();
                    this.abox.printTree();
                }
                IndividualIterator i = this.abox.getIndIterator();
                if (!PelletOptions.USE_PSEUDO_NOMINALS) {
                    this.applyNominalRule(i);
                    if (this.abox.isClosed()) break;
                }
                this.applyGuessingRule(i);
                if (this.abox.isClosed()) break;
                this.applyMaxRule(i);
                if (this.abox.isClosed()) break;
                this.applyUnfoldingRule(i);
                if (this.abox.isClosed()) break;
                this.applyDisjunctionRule(i);
                if (this.abox.isClosed()) break;
                this.applySomeValuesRule(i);
                if (this.abox.isClosed()) break;
                this.applyMinRule(i);
                if (!this.abox.isClosed()) continue;
                break;
            }
            if (this.abox.isClosed()) {
                if (ABox.DEBUG) {
                    System.out.println("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    continue;
                }
                this.abox.setComplete(true);
                continue;
            }
            this.abox.setComplete(true);
        }
        this.completionTimer.stop();
        return this.abox;
    }
}

