/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.output.ATermAbstractSyntaxRenderer;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryUtils;
import org.mindswap.pellet.utils.ATermUtils;

public class SWRLTest {
    public Set firstVars = new HashSet();
    public Vector firstTriples = new Vector();
    public Set secondVars = new HashSet();
    public Vector secondTriples = new Vector();
    public KnowledgeBase kb;
    public ATermAppl firstClass;
    public ATermAppl secondClass;
    public HashMap usings = new HashMap();

    public void parseRule(String line) {
        try {
            Rule testRule = new Rule(line, this.usings, this.kb);
            StringWriter test = new StringWriter();
            System.out.println("Head Class (ATerm): " + testRule.getHeadClass());
            System.out.println("Tail Class (ATerm): " + testRule.getTailClass());
            ATermAppl subclass = ATermUtils.makeSub((ATerm)testRule.getTailClass(), (ATerm)testRule.getHeadClass());
            ATermAbstractSyntaxRenderer renderer = new ATermAbstractSyntaxRenderer();
            renderer.setWriter(new OutputFormatter(test, false));
            renderer.visit(subclass);
            System.out.println("Abstract Syntax SubClass: " + test.toString() + "\n\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseUsing(String line) {
        line = line.substring(line.indexOf("(") + 1, line.indexOf(")"));
        String shortForm = line.substring(0, line.indexOf(",")).trim();
        String longForm = line.substring(line.indexOf("\"") + 1, line.length() - 1).trim();
        this.usings.put(shortForm, longForm);
    }

    public void loadKB(String uri) {
        OWLReasoner reasoner = new OWLReasoner();
        this.kb = new KnowledgeBase();
        reasoner.load(new ModelReader().read(uri));
        if (!reasoner.isConsistent()) {
            // empty if block
        }
        this.kb = reasoner.getKB();
    }

    public static void main(String[] args) {
        try {
            SWRLTest test = new SWRLTest();
            HashMap usings = new HashMap();
            test.loadKB("file:" + args[1]);
            BufferedReader r = new BufferedReader(new FileReader(args[0]));
            String line = r.readLine();
            line = line.trim();
            while (line.indexOf("using") != -1) {
                test.parseUsing(line);
                line = r.readLine();
                line = line.trim();
            }
            while (line.trim().equals("")) {
                line = r.readLine();
                line = line.trim();
            }
            while (line != null) {
                if (!(line = line.trim()).equals("")) {
                    test.parseRule(line);
                }
                line = r.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Rule {
        KnowledgeBase kb;
        HashMap usings;
        public String head;
        public String tail;
        public Set firstVars = new HashSet();
        public Set secondVars = new HashSet();
        public Set sharedVars = new HashSet();
        public Vector firstTriples = new Vector();
        public Vector secondTriples = new Vector();
        public String firstQuery = new String();
        public String secondQuery = new String();
        public ATermAppl firstClass;
        public ATermAppl secondClass;

        public Rule(String line, HashMap usings, KnowledgeBase kb) throws IneligibleRuleException {
            this.kb = kb;
            this.usings = usings;
            int index = line.indexOf(":-");
            this.head = line.substring(0, index).trim();
            this.tail = line.substring(index + 2, line.length() - 1).trim();
            System.out.println("Rule: " + line);
            System.out.println("Head: " + this.head);
            this.parseIntoQuery(this.head, true);
            System.out.println("Tail: " + this.tail);
            this.parseIntoQuery(this.tail, false);
            this.sharedVars.addAll(this.firstVars);
            this.sharedVars.retainAll(this.secondVars);
            if (this.sharedVars.isEmpty()) {
                throw new IneligibleRuleException();
            }
            String var = this.sharedVars.iterator().next().toString();
            this.firstClass = this.generateRollup(var, true);
            this.secondClass = this.generateRollup(var, false);
        }

        public ATermAppl getHeadClass() {
            return this.firstClass;
        }

        public ATermAppl getTailClass() {
            return this.secondClass;
        }

        public void parseIntoQuery(String expression, boolean first) {
            String[] items = expression.split(",");
            Vector<String> test = new Vector<String>();
            for (int i = 0; i < items.length; ++i) {
                items[i] = items[i].trim();
                if (items[i].indexOf("(") != -1 && items[i].indexOf(")") == -1) {
                    test.add(items[i] + "," + items[i + 1].trim());
                    ++i;
                    continue;
                }
                test.add(items[i]);
            }
            Iterator i = test.iterator();
            while (i.hasNext()) {
                this.parsePredicate((String)i.next(), first);
            }
        }

        public boolean isVariable(String arg) {
            return arg.indexOf(":") == -1;
        }

        public ATermAppl generateRollup(String var, boolean first) {
            String query = null;
            Vector triples = null;
            if (first) {
                query = this.firstQuery;
                triples = this.firstTriples;
            } else {
                query = this.secondQuery;
                triples = this.secondTriples;
            }
            query = query.concat("SELECT " + var + "\n\nWHERE\n");
            Iterator<Object> i = triples.iterator();
            while (i.hasNext()) {
                query = query.concat((String)i.next());
                if (!i.hasNext()) continue;
                query = query.concat(",\n");
            }
            query = query.concat("\n\nUSING ");
            i = this.usings.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                query = query.concat(key.toString() + " FOR <" + this.usings.get(key.toString()) + ">");
                if (i.hasNext()) {
                    query = query.concat(",");
                }
                query = query.concat("\n");
            }
            System.out.println(query);
            Query q = QueryUtils.parse(query, this.kb);
            return q.rollUpTo((ATermAppl)q.getDistObjVars().iterator().next());
        }

        public void parsePredicate(String s, boolean first) {
            int open = s.indexOf("(");
            int closed = s.indexOf(")");
            String pred = s.trim().substring(0, open);
            String args = s.substring(open + 1, closed).trim();
            Set vars = null;
            Vector triples = null;
            if (first) {
                vars = this.firstVars;
                triples = this.firstTriples;
            } else {
                vars = this.secondVars;
                triples = this.secondTriples;
            }
            int comma = args.indexOf(",");
            if (comma != -1) {
                String subject = args.substring(0, comma).trim();
                String object = args.substring(comma + 1, args.length()).trim();
                if (this.isVariable(subject)) {
                    subject = "?".concat(subject);
                    vars.add(subject);
                }
                if (this.isVariable(object)) {
                    object = "?".concat(object);
                    vars.add(object);
                }
                triples.add("(" + subject + ", " + pred + ", " + object + ")");
            } else {
                if (this.isVariable(args)) {
                    args = "?".concat(args);
                    vars.add(args);
                }
                triples.add("(" + args + ", " + "<rdf:type>" + ", " + pred + ")");
            }
        }
    }

    public class IneligibleRuleException
    extends Exception {
        public String getMessage() {
            return "Could not convert rule to OWL.";
        }
    }
}

