/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.Taxonomy;
import org.mindswap.pellet.TaxonomyNode;
import org.mindswap.pellet.TermDefinition;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.URIUtils;

public class TaxonomyBuilder {
    private byte PROPOGATE_UP = 1;
    private byte NO_PROPOGATE = 0;
    private byte PROPOGATE_DOWN = (byte)-1;
    protected Collection classes;
    private Map toldDisjoints;
    private Map unionClasses;
    protected Taxonomy definitionOrder;
    protected Taxonomy taxonomy;
    protected KnowledgeBase kb;
    private int count;
    private ClassifyListener listener = null;

    public TaxonomyBuilder(KnowledgeBase kb) {
        this.kb = kb;
        this.classes = Collections.unmodifiableSet(kb.getClasses());
        this.taxonomy = new Taxonomy();
        this.toldDisjoints = new HashMap();
    }

    public void setListener(ClassifyListener listener) {
        this.listener = listener;
    }

    protected void notifyListener(String notification) {
        if (this.listener == null) {
            return;
        }
        if (notification.equals("satisfiabilityStarted")) {
            this.listener.setMaximum(2 * this.classes.size());
            this.listener.satisfiabilityStarted();
        } else if (notification.equals("classificationStarted")) {
            this.listener.classificationStarted();
        } else {
            this.listener.startClass(notification);
        }
    }

    public boolean isCanceled() {
        return this.listener != null && this.listener.isCanceled();
    }

    public Taxonomy classify() {
        if (Taxonomy.DEBUG) {
            this.kb.timers.createTimer("classifySub");
            System.out.println("Classes: " + (this.classes.size() + 2) + " Individuals: " + this.kb.getIndividuals().size());
        }
        this.init();
        this.notifyListener("satisfiabilityStarted");
        if (Taxonomy.DEBUG) {
            System.out.println("Starting classification...");
        }
        this.notifyListener("classificationStarted");
        Iterator i = this.classes.iterator();
        while (i.hasNext()) {
            if (this.isCanceled()) {
                return null;
            }
            ATermAppl c = (ATermAppl)i.next();
            this.notifyListener(c.getName());
            if (this.taxonomy.contains(c)) continue;
            this.classify(c);
        }
        if (Taxonomy.DEBUG) {
            System.out.println("Sub Count: " + this.kb.timers.getTimer("classifySub").getCount());
            System.out.println("Sat Count: " + (this.kb.abox.satisfiabilityCount - (long)(2 * this.kb.tbox.classes.size())));
        }
        return this.taxonomy;
    }

    private void init() {
        ATermAppl c;
        Timer timer = this.kb.timers.startTimer("classify.init");
        this.count = 0;
        this.unionClasses = new HashMap();
        this.definitionOrder = new Taxonomy();
        Iterator<Object> i = this.classes.iterator();
        while (i.hasNext()) {
            c = (ATermAppl)i.next();
            TaxonomyNode node = this.definitionOrder.addNode(c);
            this.definitionOrder.getTop().addSub(node);
            node.addSub(this.definitionOrder.getBottom());
        }
        i = this.classes.iterator();
        while (i.hasNext()) {
            c = (ATermAppl)i.next();
            TBox[] tbox = new TBox[]{this.kb.getTBox().Tu, this.kb.getTBox().Tg};
            for (int t = 0; t < tbox.length; ++t) {
                TermDefinition td = tbox[t].getTD((ATerm)c);
                if (td == null) continue;
                if (td.getSames() != null) {
                    Iterator j = td.getSames().iterator();
                    while (j.hasNext()) {
                        ATermAppl d = (ATermAppl)j.next();
                        d = (ATermAppl)d.getArgument(1);
                        this.preclassify(c, d, true);
                    }
                }
                if (td.getSub() == null) continue;
                ATermAppl term = (ATermAppl)td.getSub().getArgument(1);
                if (term.getAFun().equals(ATermUtils.ANDFUN)) {
                    ATermList subs = (ATermList)term.getArgument(0);
                    while (!subs.isEmpty()) {
                        ATermAppl d = (ATermAppl)subs.getFirst();
                        this.preclassify(c, d, false);
                        subs = subs.getNext();
                    }
                    continue;
                }
                this.preclassify(c, term, false);
            }
        }
        i = this.unionClasses.keySet().iterator();
        while (i.hasNext()) {
            c = (ATermAppl)i.next();
            ATermList disj = (ATermList)this.unionClasses.get(c);
            List lca = this.definitionOrder.computeLCA(disj);
            Iterator j = lca.iterator();
            while (j.hasNext()) {
                ATermAppl d = (ATermAppl)j.next();
                if (Taxonomy.DETAILED_DEBUG) {
                    System.out.println("Union subsumption " + this.getName(c) + " " + this.getName(d));
                }
                this.addToldSubsumer(c, d);
            }
        }
        this.unionClasses = null;
        this.classes = this.definitionOrder.topologocialSort();
        if (Taxonomy.DETAILED_DEBUG) {
            this.definitionOrder.print();
        }
        timer.stop();
    }

    private void preclassify(ATermAppl c, ATermAppl d, boolean isSame) {
        ATermAppl negation;
        if (ATermUtils.isPrimitive(d)) {
            if (d.getName().startsWith("bNode")) {
                return;
            }
            if (!isSame) {
                if (Taxonomy.DETAILED_DEBUG) {
                    System.out.println("Preclassify (1) " + this.getName(c) + " " + this.getName(d));
                }
                this.addToldSubsumer(c, d);
            } else {
                if (Taxonomy.DETAILED_DEBUG) {
                    System.out.println("Preclassify (2) " + this.getName(c) + " " + this.getName(d));
                }
                this.addToldEquivalent(c, d);
            }
        } else if (d.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList conj = (ATermList)d.getArgument(0);
            while (!conj.isEmpty()) {
                ATermAppl e = (ATermAppl)conj.getFirst();
                this.preclassify(c, e, false);
                conj = conj.getNext();
            }
        } else if (d.getAFun().equals(ATermUtils.SOMEFUN) || d.getAFun().equals(ATermUtils.MINFUN)) {
            ATermAppl p = (ATermAppl)d.getArgument(0);
            Set domains = this.kb.getDomains(p);
            Iterator i = domains.iterator();
            while (i.hasNext()) {
                ATermAppl e = (ATermAppl)i.next();
                this.preclassify(c, e, false);
            }
        } else if (d.getAFun().equals(ATermUtils.ORFUN)) {
            ATermList list;
            boolean allPrimitive = true;
            ATermList disj = list = (ATermList)d.getArgument(0);
            while (!disj.isEmpty()) {
                ATermAppl e = (ATermAppl)disj.getFirst();
                if (ATermUtils.isPrimitive(e)) {
                    if (isSame) {
                        if (Taxonomy.DETAILED_DEBUG) {
                            System.out.println("Preclassify (3) " + this.getName(c) + " " + this.getName(e));
                        }
                        this.addToldSubsumer(e, c);
                    }
                } else {
                    allPrimitive = false;
                }
                disj = disj.getNext();
            }
            if (allPrimitive) {
                this.unionClasses.put(c, list);
            }
        } else if (d.getAFun().equals(ATermUtils.NOTFUN) && ATermUtils.isPrimitive(negation = (ATermAppl)d.getArgument(0))) {
            if (Taxonomy.DETAILED_DEBUG) {
                System.out.println("Preclassify (4) " + this.getName(c) + " " + this.getName(negation));
            }
            this.addToldDisjoint(c, negation);
            this.addToldDisjoint(negation, c);
        }
    }

    private void addToldEquivalent(ATermAppl c, ATermAppl d) {
        TaxonomyNode cNode = this.definitionOrder.getNode(c);
        TaxonomyNode dNode = this.definitionOrder.getNode(d);
        this.definitionOrder.merge(cNode, dNode);
    }

    private void addToldSubsumer(ATermAppl c, ATermAppl d) {
        if (c.equals(d)) {
            return;
        }
        TaxonomyNode cNode = this.definitionOrder.getNode(c);
        TaxonomyNode dNode = this.definitionOrder.getNode(d);
        dNode.addSub(cNode);
        this.definitionOrder.removeCycles(cNode);
    }

    private void addToldDisjoint(ATermAppl c, ATermAppl d) {
        HashSet<ATermAppl> disjoints = (HashSet<ATermAppl>)this.toldDisjoints.get(c);
        if (disjoints == null) {
            disjoints = new HashSet<ATermAppl>();
            this.toldDisjoints.put(c, disjoints);
        }
        disjoints.add(d);
    }

    private void markToldSubsumers(ATermAppl c, Map marked) {
        TaxonomyNode node = this.taxonomy.getNode(c);
        if (node != null) {
            boolean newMark = this.mark(node, marked, Boolean.TRUE, this.PROPOGATE_UP);
            if (!newMark) {
                return;
            }
        } else if (Taxonomy.DEBUG && marked.size() > 2) {
            System.err.println("Told subsumer " + c + " is not classified yet");
        }
        if (this.definitionOrder.contains(c)) {
            Set supers = this.definitionOrder.getSupers(c, true, true);
            Iterator i = supers.iterator();
            while (i.hasNext()) {
                ATermAppl sup = (ATermAppl)i.next();
                this.markToldSubsumers(sup, marked);
            }
        }
    }

    private void markToldSubsumeds(ATermAppl c, Map marked) {
        TaxonomyNode node = this.taxonomy.getNode(c);
        if (node != null) {
            boolean newMark = this.mark(node, marked, Boolean.TRUE, this.PROPOGATE_DOWN);
            if (!newMark) {
                return;
            }
            Set subs = this.taxonomy.getSubs(c, true, true);
            Iterator i = subs.iterator();
            while (i.hasNext()) {
                ATermAppl sub = (ATermAppl)i.next();
                this.markToldSubsumeds(sub, marked);
            }
        }
        if (this.definitionOrder.contains(c)) {
            Set subs = this.definitionOrder.getSubs(c, true, true);
            Iterator i = subs.iterator();
            while (i.hasNext()) {
                ATermAppl sub = (ATermAppl)i.next();
                this.markToldSubsumeds(sub, marked);
            }
        }
    }

    private void markToldDisjoints(ATermAppl c, Map marked) {
        Set disjoints = (Set)this.toldDisjoints.get(c);
        if (disjoints != null) {
            Iterator i = disjoints.iterator();
            while (i.hasNext()) {
                ATermAppl sup = (ATermAppl)i.next();
                TaxonomyNode node = this.taxonomy.getNode(sup);
                if (node == null) continue;
                this.mark(node, marked, Boolean.FALSE, this.PROPOGATE_DOWN);
            }
        }
        Set supers = SetUtils.EMPTY_SET;
        if (this.taxonomy.contains(c)) {
            supers = this.taxonomy.getSupers(c, true, true);
        } else if (this.definitionOrder.contains(c)) {
            supers = this.definitionOrder.getSupers(c, true, true);
        }
        Iterator i = supers.iterator();
        while (i.hasNext()) {
            ATermAppl sup = (ATermAppl)i.next();
            this.markToldDisjoints(sup, marked);
        }
    }

    private TaxonomyNode checkSatisfiability(ATermAppl c) {
        if (Taxonomy.DEBUG) {
            System.out.print("Satisfiable ");
        }
        Timer t = this.kb.timers.startTimer("classifySat");
        boolean isSatisfiable = this.kb.isSatisfiable(c);
        t.stop();
        if (Taxonomy.DEBUG) {
            System.out.print((isSatisfiable ? "true" : "*****FALSE*****") + " (" + t.getLast() + "ms)");
        }
        if (!isSatisfiable) {
            this.taxonomy.addEquivalentNode(c, this.taxonomy.getBottom());
        }
        if (PelletOptions.USE_CACHING) {
            if (Taxonomy.DEBUG) {
                System.out.print("...negation ");
            }
            t.start();
            isSatisfiable = this.kb.isSatisfiable(ATermUtils.makeNot((ATerm)c));
            t.stop();
            if (!isSatisfiable) {
                this.taxonomy.addEquivalentNode(c, this.taxonomy.getTop());
            }
            if (Taxonomy.DEBUG) {
                System.out.println(isSatisfiable + " (" + t.getLast() + "ms)");
            }
        } else if (Taxonomy.DEBUG) {
            System.out.println();
        }
        return this.taxonomy.getNode(c);
    }

    public void classify(ATermAppl c) {
        TaxonomyNode node = this.classify(c, !ATermUtils.isPrimitive(c));
        if (this.definitionOrder.contains(c)) {
            TaxonomyNode defOrder = this.definitionOrder.getNode(c);
            Iterator i = defOrder.getEquivalents().iterator();
            while (i.hasNext()) {
                ATermAppl eq = (ATermAppl)i.next();
                this.taxonomy.addEquivalentNode(eq, node);
            }
        }
    }

    private TaxonomyNode classify(ATermAppl c, boolean hide) {
        TaxonomyNode sup;
        TaxonomyNode node;
        if (Taxonomy.DEBUG) {
            System.out.print("Classify (" + ++this.count + ") " + this.getName(c) + "...");
        }
        if ((node = this.checkSatisfiability(c)) != null) {
            return node;
        }
        HashMap marked = new HashMap();
        this.mark(this.taxonomy.getTop(), marked, Boolean.TRUE, this.NO_PROPOGATE);
        this.mark(this.taxonomy.getBottom(), marked, Boolean.FALSE, this.NO_PROPOGATE);
        this.markToldSubsumers(c, marked);
        this.markToldDisjoints(c, marked);
        Collection supers = this.search(true, c, this.taxonomy.getTop(), new HashSet(), new ArrayList(), marked);
        marked = new HashMap();
        this.mark(this.taxonomy.getTop(), marked, Boolean.FALSE, this.NO_PROPOGATE);
        this.mark(this.taxonomy.getBottom(), marked, Boolean.TRUE, this.NO_PROPOGATE);
        this.markToldSubsumeds(c, marked);
        this.markToldDisjoints(c, marked);
        if (supers.size() == 1 && this.subsumed(sup = (TaxonomyNode)supers.iterator().next(), c, marked)) {
            if (Taxonomy.DEBUG) {
                System.out.println(this.getName(c) + " = " + this.getName(sup.getName()));
            }
            this.taxonomy.addEquivalentNode(c, sup);
            return sup;
        }
        if (Taxonomy.DETAILED_DEBUG) {
            System.out.println("Bottom search...");
        }
        Collection subs = this.search(false, c, this.taxonomy.getBottom(), new HashSet(), new ArrayList(), marked);
        node = this.taxonomy.addNode(c, hide);
        node.addSupers(new ArrayList(supers));
        node.addSubs(new ArrayList(subs));
        node.removeMultiplePaths();
        if (Taxonomy.DETAILED_DEBUG) {
            System.out.println("Subsumption Count: " + this.kb.getABox().satisfiabilityCount);
        }
        return node;
    }

    private Collection search(boolean topSearch, ATermAppl c, TaxonomyNode x, Set visited, List result, Map marked) {
        ArrayList<TaxonomyNode> posSucc = new ArrayList<TaxonomyNode>();
        visited.add(x);
        List list = topSearch ? x.getSubs() : x.getSupers();
        for (int i = 0; i < list.size(); ++i) {
            TaxonomyNode next = (TaxonomyNode)list.get(i);
            if (topSearch) {
                if (!this.subsumes(next, c, marked)) continue;
                posSucc.add(next);
                continue;
            }
            if (!this.subsumed(next, c, marked)) continue;
            posSucc.add(next);
        }
        if (posSucc.isEmpty()) {
            result.add(x);
        } else {
            Iterator i = posSucc.iterator();
            while (i.hasNext()) {
                TaxonomyNode y = (TaxonomyNode)i.next();
                if (visited.contains(y)) continue;
                this.search(topSearch, c, y, visited, result, marked);
            }
        }
        return result;
    }

    private boolean subsumes(TaxonomyNode node, ATermAppl c, Map marked) {
        Boolean cached = (Boolean)marked.get(node);
        if (cached != null) {
            return cached;
        }
        boolean subsumes = this.subsumes(node.getName(), c);
        Boolean value = subsumes ? Boolean.TRUE : Boolean.FALSE;
        byte propogate = subsumes ? this.NO_PROPOGATE : this.PROPOGATE_DOWN;
        this.mark(node, marked, value, propogate);
        return subsumes;
    }

    private boolean subsumed(TaxonomyNode node, ATermAppl c, Map marked) {
        Boolean cached = (Boolean)marked.get(node);
        if (cached != null) {
            return cached;
        }
        boolean subsumed = this.subsumes(c, node.getName());
        Boolean value = subsumed ? Boolean.TRUE : Boolean.FALSE;
        byte propogate = subsumed ? this.NO_PROPOGATE : this.PROPOGATE_UP;
        this.mark(node, marked, value, propogate);
        return subsumed;
    }

    private boolean mark(TaxonomyNode node, Map marked, Boolean value, byte propogate) {
        if (node.getEquivalents().contains(ATermUtils.BOTTOM)) {
            return true;
        }
        Boolean exists = (Boolean)marked.get(node);
        if (exists != null) {
            if (exists != value) {
                throw new RuntimeException("Inconsistent classification result " + node.getName() + " " + exists + " " + value);
            }
            return false;
        }
        marked.put(node, value);
        if (propogate != this.NO_PROPOGATE) {
            List others = propogate == this.PROPOGATE_UP ? node.getSupers() : node.getSubs();
            Iterator i = others.iterator();
            while (i.hasNext()) {
                TaxonomyNode next = (TaxonomyNode)i.next();
                this.mark(next, marked, value, propogate);
            }
        }
        return true;
    }

    private boolean subsumes(ATermAppl sup, ATermAppl sub) {
        long time = 0L;
        long count = 0L;
        if (Taxonomy.DETAILED_DEBUG) {
            time = System.currentTimeMillis();
            count = this.kb.getABox().satisfiabilityCount;
            System.out.print("Subsumption testing for [" + this.getName(sub) + "," + this.getName(sup) + "]...");
        }
        Timer t = this.kb.timers.startTimer("classifySub");
        boolean result = this.kb.getABox().isSubClassOf(sub, sup);
        t.stop();
        if (Taxonomy.DETAILED_DEBUG) {
            String sign = this.kb.getABox().satisfiabilityCount > count ? "+" : "-";
            time = System.currentTimeMillis() - time;
            System.out.println(" done (" + (result ? "+" : "-") + ") (" + sign + time + "ms)");
        }
        return result;
    }

    private void mark(Set set, Map marked, Boolean value) {
        Iterator i = set.iterator();
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            marked.put(c, value);
        }
    }

    public Taxonomy realize() {
        IndividualIterator i = this.kb.getABox().getIndIterator();
        int count = 0;
        while (i.hasNext()) {
            ATermAppl c;
            if (this.isCanceled()) {
                return null;
            }
            Individual x = (Individual)i.next();
            if (Taxonomy.DEBUG) {
                System.out.println(count + ") Realizing " + this.getName(x.getName()) + " ");
            }
            HashMap marked = new HashMap();
            ArrayList obviousTypes = new ArrayList();
            ArrayList obviousNonTypes = new ArrayList();
            this.kb.getABox().getObviousTypes(x.getName(), obviousTypes, obviousNonTypes);
            Iterator j = obviousTypes.iterator();
            while (j.hasNext()) {
                c = (ATermAppl)j.next();
                if (!this.taxonomy.contains(c)) continue;
                this.mark(this.taxonomy.getAllEquivalents(c), marked, Boolean.TRUE);
                this.mark(this.taxonomy.getSupers(c, true, true), marked, Boolean.TRUE);
                this.markToldDisjoints(c, marked);
            }
            j = obviousNonTypes.iterator();
            while (j.hasNext()) {
                c = (ATermAppl)j.next();
                this.mark(this.taxonomy.getAllEquivalents(c), marked, Boolean.FALSE);
                this.mark(this.taxonomy.getSubs(c, true, true), marked, Boolean.FALSE);
            }
            this.realize(x.getName(), ATermUtils.TOP, marked);
            ++count;
        }
        return this.taxonomy;
    }

    private boolean realize(ATermAppl n, ATermAppl c, Map marked) {
        boolean isType;
        boolean realized = false;
        if (c.equals(ATermUtils.BOTTOM)) {
            return false;
        }
        if (marked.containsKey(c)) {
            isType = (Boolean)marked.get(c);
        } else {
            long time = 0L;
            long count = 0L;
            if (Taxonomy.DETAILED_DEBUG) {
                time = System.currentTimeMillis();
                count = this.kb.getABox().consistencyCount;
                System.out.print("Type checking for [" + this.getName(n) + ", " + this.getName(c) + "]...");
            }
            Timer t = this.kb.timers.startTimer("classifyType");
            isType = this.kb.isType(n, c);
            t.stop();
            marked.put(c, isType ? Boolean.TRUE : Boolean.FALSE);
            if (Taxonomy.DETAILED_DEBUG) {
                String sign = this.kb.getABox().consistencyCount > count ? "+" : "-";
                time = System.currentTimeMillis() - time;
                System.out.println(" done (" + (isType ? "+" : "-") + ") (" + sign + time + "ms)");
            }
        }
        if (isType) {
            TaxonomyNode node = this.taxonomy.getNode(c);
            Iterator subs = node.getSubs().iterator();
            while (subs.hasNext()) {
                TaxonomyNode sub = (TaxonomyNode)subs.next();
                ATermAppl d = sub.getName();
                realized = this.realize(n, d, marked) || realized;
            }
            if (!realized) {
                this.taxonomy.getNode(c).addInstance(n);
                realized = true;
            }
        }
        return realized;
    }

    public void printStats() {
        int numClasses = this.classes.size();
        System.out.println("Num of Classes: " + numClasses + " Pairs: " + numClasses * numClasses + " Subsumption Count: " + this.kb.getABox().satisfiabilityCount);
    }

    private String getName(ATermAppl c) {
        if (c.equals(ATermUtils.TOP)) {
            return "owl:Thing";
        }
        if (c.equals(ATermUtils.BOTTOM)) {
            return "owl:Nothing";
        }
        return URIUtils.getLocalName(c.getName());
    }

    public static interface ClassifyListener {
        public void satisfiabilityStarted();

        public void classificationStarted();

        public void startClass(String var1);

        public boolean isCanceled();

        public void cancel();

        public void setMaximum(int var1);
    }
}

