/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class TaxonomyNode {
    private ATermAppl name;
    private boolean hidden;
    private Set equivalents;
    private List supers;
    private List subs;
    private Set instances;

    public TaxonomyNode(ATermAppl name, boolean hidden) {
        this.name = name;
        this.hidden = hidden;
        this.equivalents = Collections.singleton(name);
        if (name.equals(ATermUtils.TOP)) {
            this.supers = Collections.EMPTY_LIST;
            this.subs = new ArrayList();
        } else if (name.equals(ATermUtils.BOTTOM)) {
            this.supers = new ArrayList();
            this.subs = Collections.EMPTY_LIST;
        } else {
            this.supers = new ArrayList(2);
            this.subs = new ArrayList();
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean contains(ATermAppl c) {
        return this.equivalents.contains(c);
    }

    public void addEquivalent(ATermAppl c) {
        if (this.equivalents.size() == 1) {
            this.equivalents = new HashSet(this.equivalents);
        }
        this.equivalents.add(c);
    }

    public void addSub(TaxonomyNode other) {
        if (this.equals(other) || this.subs.contains(other)) {
            return;
        }
        this.subs.add(other);
        if (!this.hidden) {
            other.supers.add(this);
        }
    }

    public void addSubs(Collection others) {
        this.subs.addAll(others);
        if (!this.hidden) {
            Iterator i = others.iterator();
            while (i.hasNext()) {
                TaxonomyNode other = (TaxonomyNode)i.next();
                other.supers.add(this);
            }
        }
    }

    public void addSupers(Collection others) {
        this.supers.addAll(others);
        if (!this.hidden) {
            Iterator i = others.iterator();
            while (i.hasNext()) {
                TaxonomyNode other = (TaxonomyNode)i.next();
                other.subs.add(this);
            }
        }
    }

    public void removeSub(TaxonomyNode other) {
        this.subs.remove(other);
        other.supers.remove(this);
    }

    public void disconnect() {
        Iterator j = this.subs.iterator();
        while (j.hasNext()) {
            TaxonomyNode sub = (TaxonomyNode)j.next();
            j.remove();
            sub.supers.remove(this);
        }
        j = this.supers.iterator();
        while (j.hasNext()) {
            TaxonomyNode sup = (TaxonomyNode)j.next();
            j.remove();
            sup.subs.remove(this);
        }
    }

    public void addInstance(ATermAppl ind) {
        if (this.instances == null) {
            this.instances = new HashSet();
        }
        this.instances.add(ind);
    }

    public ATermAppl getName() {
        return this.name;
    }

    public Set getEquivalents() {
        return this.equivalents;
    }

    public Set getInstances() {
        return this.instances == null ? SetUtils.EMPTY_SET : this.instances;
    }

    public List getSubs() {
        return this.subs;
    }

    public List getSupers() {
        return this.supers;
    }

    public void removeMultiplePaths() {
        if (!this.hidden) {
            Iterator i1 = this.supers.iterator();
            while (i1.hasNext()) {
                TaxonomyNode sup = (TaxonomyNode)i1.next();
                Iterator i2 = this.subs.iterator();
                while (i2.hasNext()) {
                    TaxonomyNode sub = (TaxonomyNode)i2.next();
                    sup.removeSub(sub);
                }
            }
        }
    }

    public String toString() {
        return this.name + " = " + this.equivalents;
    }
}

