/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import org.mindswap.pellet.ABox;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.FileUtils;

public class TestWine
extends PelletTestCase {
    public static final void main(String[] args) throws Exception {
        String[] files = new String[]{"wine-0w.owl", "wine-1w.owl", "wine-5w.owl", "wine-10w.owl", "wine-15w.owl", "wine-25w.owl", "wine-35w.owl", "wine-45w.owl", "wine.owl"};
        TestWine test = new TestWine();
        test.test(files);
    }

    public void test(String[] files) {
        String dir = "http://www.mindswap.org/ontologies/wine/";
        boolean loadImports = true;
        boolean doExplanation = false;
        boolean printTree = false;
        boolean printTimers = true;
        boolean classify = true;
        boolean realize = true;
        PelletOptions.USE_PSEUDO_NOMINALS = false;
        PelletOptions.USE_DISJUNCT_SORTING = true;
        PelletOptions.USE_DISJUNCTION_SORTING = "OLDEST_FIRST";
        PelletOptions.CHECK_NOMINAL_EDGES = true;
        PelletOptions.USE_SMART_RESTORE = true;
        PelletOptions.USE_NOMINAL_ABSORPTION = true;
        PelletOptions.COPY_ON_WRITE = true;
        PelletOptions.PRINT_SIZE = true;
        PelletOptions.USE_QNAME = true;
        dir = "file:/mindswap/pellet/files/wine/";
        files = new String[]{"wine-35w.owl"};
        for (int i = 0; i < files.length; ++i) {
            try {
                String file = FileUtils.toURI(dir + files[i]);
                System.out.print((classify ? "Classifying " : "Consistency ") + file);
                OWLReasoner reasoner = new OWLReasoner();
                reasoner.load(file, loadImports);
                System.out.println(" Triples: " + reasoner.getModel().size());
                KnowledgeBase kb = reasoner.getKB();
                kb.setDoExplanation(doExplanation);
                kb.timers.resetAll();
                kb.timers.mainTimer.start();
                boolean consistent = kb.isConsistent();
                System.out.println("Consistent: " + consistent + " (" + kb.timers.getTimer("consistency").getTotal() + ")");
                ABox.DEBUG = false;
                if (classify) {
                    kb.classify();
                }
                if (classify && realize) {
                    kb.realize();
                }
                kb.timers.mainTimer.stop();
                if (classify && printTree) {
                    kb.printClassTree();
                }
                if (printTimers) {
                    kb.timers.print();
                }
                System.out.println("Total time: " + kb.timers.mainTimer.getTotal() + " ms");
                System.out.println();
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
    }
}

