/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.TermDefinition;
import org.mindswap.pellet.TuBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;

public class TgBox
extends TBox {
    static int totalsizes = 0;
    private ATermList UC = null;

    public TgBox(KnowledgeBase kb) {
        super(kb);
    }

    public static void printStatistics() {
        System.out.println("\nTg Statistics:\nSize of Tg: " + totalsizes);
    }

    public void internalize() {
        if (this.isEmpty()) {
            return;
        }
        Timer timer = this.kb.timers.startTimer("internalize");
        ATermList conjuncts = ATermUtils.EMPTY_LIST;
        Iterator i = this.toList().iterator();
        while (i.hasNext()) {
            ATermAppl nota;
            ATermAppl b;
            ATermAppl a;
            ATermAppl def = (ATermAppl)i.next();
            if (def.getName().equals("same")) {
                a = (ATermAppl)def.getArgument(0);
                b = (ATermAppl)def.getArgument(1);
                nota = ATermUtils.makeNot((ATerm)a);
                ATermAppl notb = ATermUtils.makeNot((ATerm)b);
                ATermAppl ora = ATermUtils.makeOr(a, notb);
                ATermAppl orb = ATermUtils.makeOr(nota, b);
                conjuncts = conjuncts.insert((ATerm)ora);
                conjuncts = conjuncts.insert((ATerm)orb);
                continue;
            }
            if (def.getName().equals("sub")) {
                a = (ATermAppl)def.getArgument(0);
                b = (ATermAppl)def.getArgument(1);
                nota = ATermUtils.makeNot((ATerm)a);
                ATermAppl or = ATermUtils.makeOr(nota, b);
                conjuncts = conjuncts.insert((ATerm)or);
                continue;
            }
            timer.stop();
            throw new RuntimeException("Bad TBox - had term of unknown type (" + def.getName() + ")");
        }
        this.UC = conjuncts;
        if (this.UC.getLength() == 1) {
            this.UC = ATermUtils.normalize(this.UC);
        } else {
            ATermAppl and = ATermUtils.makeAnd(this.UC);
            this.UC = ATermUtils.isAnd(and = ATermUtils.normalize(and)) ? (ATermList)and.getArgument(0) : ATermUtils.makeList((ATerm)and);
        }
        timer.stop();
    }

    public void absorb(TuBox tu) {
        Timer timer = this.kb.timers.startTimer("absorb");
        this.Tu = tu;
        ATermList terms = ATermUtils.EMPTY_LIST;
        Iterator i = this.toList().iterator();
        while (i.hasNext()) {
            ATermAppl term = (ATermAppl)i.next();
            if (term.getName().equals("sub")) {
                terms = terms.insert((ATerm)term);
                continue;
            }
            if (term.getName().equals("same")) {
                ATermAppl sub1 = ATermUtils.makeSub(term.getArgument(0), term.getArgument(1));
                ATermAppl sub2 = ATermUtils.makeSub(term.getArgument(1), term.getArgument(0));
                terms = terms.insert((ATerm)sub1).insert((ATerm)sub2);
                continue;
            }
            throw new RuntimeException("Term list contains something not a SUB or a SAME: " + term);
        }
        if (DEBUG) {
            System.out.println("Tg was (" + this.size() + "): " + this);
            System.out.println("Tu was (" + this.Tu.size() + "): " + this.Tu);
        }
        this.termhash = new Hashtable();
        while (!terms.isEmpty()) {
            this.kb.timers.checkTimer("preprocessing");
            ATermAppl term = (ATermAppl)terms.getFirst();
            HashSet<ATermAppl> set = new HashSet<ATermAppl>();
            set.add(ATermUtils.nnf((ATermAppl)term.getArgument(0)));
            set.add(ATermUtils.nnf(ATermUtils.makeNot(term.getArgument(1))));
            this.absorbTerm(set);
            terms = terms.getNext();
        }
        if (DEBUG) {
            System.out.println("Tg is (" + this.size() + "): " + this);
            System.out.println("Tu is (" + this.Tu.size() + "): " + this.Tu);
            totalsizes += this.size();
        }
        timer.stop();
    }

    private boolean absorbTerm(HashSet set) {
        if (DEBUG) {
            System.out.println("Absorbing term " + set);
        }
        while (true) {
            if (DEBUG) {
                System.out.println("Absorb nominal");
            }
            if (PelletOptions.USE_NOMINAL_ABSORPTION && this.absorbNominal(set)) {
                if (DEBUG) {
                    System.out.println("Absorbed w/ Nominal: " + set);
                }
                return true;
            }
            if (DEBUG) {
                System.out.println("Absorb II");
            }
            if (this.absorbII(set)) {
                if (DEBUG) {
                    System.out.println("Absorbed");
                }
                return true;
            }
            if (DEBUG) {
                System.out.println("Absorb III");
            }
            if (this.absorbIII(set)) {
                if (!DEBUG) continue;
                System.out.println("Absorb III");
                continue;
            }
            if (DEBUG) {
                System.out.println("Absorb IV");
            }
            if (this.absorbIV(set)) {
                if (!DEBUG) continue;
                System.out.println("Absorb IV");
                continue;
            }
            if (DEBUG) {
                System.out.println("Absorb V");
            }
            if (!this.absorbV(set)) break;
            if (!DEBUG) continue;
            System.out.println("Absorb V");
        }
        if (DEBUG) {
            System.out.println("Absorb VI");
        }
        if (this.absorbVI(set)) {
            if (DEBUG) {
                System.out.println("Recursed on OR");
            }
            return true;
        }
        if (DEBUG) {
            System.out.println("Absorb role");
        }
        if (PelletOptions.USE_ROLE_ABSORPTION && this.absorbRole(set)) {
            if (DEBUG) {
                System.out.println("Absorbed w/ Role");
            }
            return true;
        }
        if (DEBUG) {
            System.out.println("Absorb VII");
        }
        this.absorbVII(set);
        if (DEBUG) {
            System.out.println("Finished Absorption");
        }
        return false;
    }

    private boolean absorbNominal(HashSet set) {
        Iterator i = set.iterator();
        while (i.hasNext()) {
            ATermAppl name = (ATermAppl)i.next();
            if (!ATermUtils.isOneOf(name) && !ATermUtils.isNominal(name)) continue;
            i.remove();
            ATermAppl c = ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(ATermUtils.makeList(set)));
            ATermList list = null;
            list = ATermUtils.isNominal(name) ? ATermUtils.makeList((ATerm)name) : (ATermList)name.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl nominal = (ATermAppl)list.getFirst();
                ATermAppl ind = (ATermAppl)nominal.getArgument(0);
                this.kb.addIndividual(ind);
                this.kb.addType(ind, c);
                list = list.getNext();
            }
            return true;
        }
        return false;
    }

    private boolean absorbRole(HashSet set) {
        Iterator i = ((HashSet)set.clone()).iterator();
        while (i.hasNext()) {
            ATerm r;
            ATermAppl name = (ATermAppl)i.next();
            if (ATermUtils.isSomeValues(name)) {
                r = name.getArgument(0);
                ATermAppl domain = ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(ATermUtils.makeList(set)));
                this.kb.addDomain(r, domain);
                return true;
            }
            if (!ATermUtils.isMin(name)) continue;
            r = name.getArgument(0);
            int n = ((ATermInt)name.getArgument(1)).getInt();
            if (n != 1) continue;
            i.remove();
            ATermAppl domain = ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(ATermUtils.makeList(set)));
            this.kb.addDomain(r, domain);
            return true;
        }
        return false;
    }

    private boolean absorbII(HashSet set) {
        Iterator i = ((HashSet)set.clone()).iterator();
        while (i.hasNext()) {
            ATermAppl term = (ATermAppl)i.next();
            if (this.Tu.contains((ATerm)term)) {
                TermDefinition td = this.Tu.getTD((ATerm)term);
                ATermAppl def = td.getDef(0);
                if (!def.getName().equals("sub")) continue;
                set.remove(term);
                ATermList setlist = ATermUtils.makeList(set);
                ATermAppl conjunct = ATermUtils.makeAnd(setlist);
                conjunct = ATermUtils.makeAnd(def.getArgument(1), (ATerm)ATermUtils.makeNot((ATerm)conjunct));
                ATermAppl sub = ATermUtils.makeSub((ATerm)term, (ATerm)ATermUtils.nnf(conjunct));
                td.replaceDef(0, sub);
                return true;
            }
            if (term.getArity() != 0 || set.size() <= 1) continue;
            set.remove(term);
            ATermList setlist = ATermUtils.makeList(set);
            ATermAppl conjunct = ATermUtils.makeAnd(setlist);
            conjunct = ATermUtils.makeNot((ATerm)conjunct);
            ATermAppl sub = ATermUtils.makeSub((ATerm)term, (ATerm)ATermUtils.nnf(conjunct));
            this.Tu.addDef(sub);
            return true;
        }
        return false;
    }

    private boolean absorbIII(HashSet set) {
        Iterator i = ((HashSet)set.clone()).iterator();
        while (i.hasNext()) {
            TermDefinition td;
            ATermAppl def;
            ATermAppl term = (ATermAppl)i.next();
            if (!this.Tu.contains((ATerm)term) || !(def = (td = this.Tu.getTD((ATerm)term)).getDef(0)).getName().equals("same")) continue;
            set.remove(term);
            set.add(def.getArgument(1));
            return true;
        }
        return false;
    }

    private boolean absorbIV(HashSet set) {
        Iterator i = ((HashSet)set.clone()).iterator();
        while (i.hasNext()) {
            ATermAppl def;
            ATermAppl term = (ATermAppl)i.next();
            ATermAppl negatedTerm = ATermUtils.nnf(ATermUtils.makeNot((ATerm)term));
            if (!this.Tu.contains((ATerm)negatedTerm) || !(def = this.Tu.getTD((ATerm)negatedTerm).getDef(0)).getName().equals("same")) continue;
            set.remove(term);
            set.add(ATermUtils.nnf(ATermUtils.makeNot(def.getArgument(1))));
        }
        return false;
    }

    private boolean absorbV(HashSet set) {
        Iterator iter = ((HashSet)set.clone()).iterator();
        while (iter.hasNext()) {
            ATermAppl term = (ATermAppl)iter.next();
            ATermAppl nnfterm = ATermUtils.nnf(term);
            if (!nnfterm.getName().equals("and")) continue;
            set.remove(term);
            ATermList andlist = (ATermList)nnfterm.getArgument(0);
            while (!andlist.isEmpty()) {
                set.add(andlist.getFirst());
                andlist = andlist.getNext();
            }
            return true;
        }
        return false;
    }

    private boolean absorbVI(HashSet set) {
        Iterator iter = ((HashSet)set.clone()).iterator();
        while (iter.hasNext()) {
            ATermAppl term = (ATermAppl)iter.next();
            ATermAppl nnfterm = ATermUtils.nnf(term);
            if (!nnfterm.getName().equals("or")) continue;
            set.remove(term);
            ATermList orlist = (ATermList)nnfterm.getArgument(0);
            while (!orlist.isEmpty()) {
                HashSet cloned = (HashSet)set.clone();
                cloned.add(orlist.getFirst());
                this.absorbTerm(cloned);
                orlist = orlist.getNext();
            }
            return true;
        }
        return false;
    }

    private boolean absorbVII(HashSet set) {
        ATermList list = ATermUtils.makeList(set);
        ATermAppl name = ATermUtils.nnf((ATermAppl)list.getFirst());
        if ((list = list.getNext()).isEmpty()) {
            this.addDef(ATermUtils.makeSub((ATerm)name, (ATerm)ATermUtils.nnf(ATermUtils.makeNot((ATerm)name))));
        } else {
            this.addDef(ATermUtils.makeSub((ATerm)name, (ATerm)ATermUtils.nnf(ATermUtils.makeNot((ATerm)ATermUtils.makeAnd(list)))));
        }
        return true;
    }

    public ATermList getUC() {
        return this.UC;
    }

    public void print() {
        if (this.UC != null) {
            ATermList list = ATermUtils.nnf(this.UC);
            while (!list.isEmpty()) {
                System.out.println(list.getFirst());
                list = list.getNext();
            }
        }
    }
}

