/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.mindswap.pellet.datatypes.BaseDatatype;
import org.mindswap.pellet.utils.GenericIntervalList;

public abstract class BaseDateTimeDatatype
extends BaseDatatype {
    protected GenericIntervalList values;
    protected GenericIntervalList.ExtendedComparator comparator;
    String strMinDate = "-9999-01-01T00:00:00";
    String strMaxDate = "9999-12-31T23:59:59";

    public BaseDateTimeDatatype(ATermAppl name) {
        super(name);
    }

    protected void setInterval(GenericIntervalList values) {
        this.values = values;
    }

    public boolean contains(Object value) {
        if (value instanceof Date) {
            return this.values.contains((Date)value);
        }
        return false;
    }

    public long size() {
        return this.values.count();
    }

    public boolean isDerived() {
        return false;
    }

    public Date getMinimumDate() {
        try {
            XSDatatype dt = DatatypeFactory.getTypeByName((String)"dateTime");
            Calendar cal = (Calendar)dt.createJavaObject(this.strMinDate, null);
            return cal.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Date getMaximumDate() {
        try {
            XSDatatype dt = DatatypeFactory.getTypeByName((String)"dateTime");
            Calendar cal = (Calendar)dt.createJavaObject(this.strMaxDate, null);
            return cal.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getValue(String value, String dataTypeName) {
        try {
            XSDatatype dt = DatatypeFactory.getTypeByName((String)dataTypeName);
            Calendar cal = (Calendar)dt.createJavaObject(value, null);
            return cal.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public GenericIntervalList restrictIntervalList(int facet, String value, String dataTypeName, int calendarField) {
        try {
            Date max;
            Date min;
            XSDatatype dt = DatatypeFactory.getTypeByName((String)dataTypeName);
            Calendar minCalendar = new GregorianCalendar();
            minCalendar.setLenient(true);
            Calendar maxCalendar = new GregorianCalendar();
            maxCalendar.setLenient(true);
            if (facet == 256) {
                minCalendar = (Calendar)dt.createJavaObject(value.trim(), null);
                min = minCalendar.getTime();
                maxCalendar = (Calendar)dt.createJavaObject(this.strMaxDate, null);
                max = maxCalendar.getTime();
            } else if (facet == 128) {
                minCalendar = (Calendar)dt.createJavaObject(value.trim(), null);
                minCalendar.add(calendarField, 1);
                min = minCalendar.getTime();
                maxCalendar = (Calendar)dt.createJavaObject(this.strMaxDate, null);
                max = maxCalendar.getTime();
            } else if (facet == 32) {
                minCalendar = (Calendar)dt.createJavaObject(this.strMinDate, null);
                min = minCalendar.getTime();
                maxCalendar = (Calendar)dt.createJavaObject(value.trim(), null);
                max = maxCalendar.getTime();
            } else if (facet == 64) {
                minCalendar = (Calendar)dt.createJavaObject(this.strMinDate, null);
                min = minCalendar.getTime();
                maxCalendar = (Calendar)dt.createJavaObject(value.trim(), null);
                maxCalendar.add(calendarField, -1);
                max = maxCalendar.getTime();
            } else {
                return null;
            }
            return new GenericIntervalList(min, max, this.comparator);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Value " + value + " is not valid for the facet " + facet);
        }
    }
}

