/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseAtomicDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDBoolean
extends BaseAtomicDatatype
implements AtomicDatatype {
    public static final XSDBoolean instance = new XSDBoolean();
    protected int NO_VALUES = 0;
    protected int ONLY_TRUE = 1;
    protected int ONLY_FALSE = 2;
    protected int BOTH_VALUES;
    protected int status = this.BOTH_VALUES = 3;

    XSDBoolean() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#boolean"));
    }

    public AtomicDatatype not() {
        return new XSDDerivedBooleanType(this.BOTH_VALUES - this.status);
    }

    public AtomicDatatype intersection(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        int result = this.NO_VALUES;
        if (dt instanceof XSDBoolean) {
            XSDBoolean other = (XSDBoolean)dt;
            result = this.status & other.status;
        }
        return new XSDDerivedBooleanType(result);
    }

    public AtomicDatatype union(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        int result = this.NO_VALUES;
        if (dt instanceof XSDBoolean) {
            XSDBoolean other = (XSDBoolean)dt;
            result = this.status | other.status;
        }
        return new XSDDerivedBooleanType(result);
    }

    public AtomicDatatype difference(AtomicDatatype dt) {
        return this.intersection(dt.not());
    }

    public long size() {
        if (this.status == this.NO_VALUES) {
            return 0L;
        }
        if (this.status == this.BOTH_VALUES) {
            return 2L;
        }
        return 1L;
    }

    public boolean contains(Object value) {
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return this.status == this.BOTH_VALUES || this.status == this.ONLY_TRUE && bool != false || this.status == this.ONLY_FALSE && bool == false;
        }
        return false;
    }

    public Datatype singleton(Object value) {
        if (value instanceof Boolean) {
            boolean bool = (Boolean)value;
            return new XSDDerivedBooleanType(bool ? this.ONLY_TRUE : this.ONLY_FALSE);
        }
        return null;
    }

    public Object getValue(String value, String datatypeURI) {
        String str = value.trim();
        if (str.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (str.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        return null;
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    public class XSDDerivedBooleanType
    extends XSDBoolean {
        protected XSDDerivedBooleanType(int status) {
            this.status = status;
        }

        public boolean isDerived() {
            return true;
        }
    }
}

