/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseAtomicDatatype;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDDouble
extends BaseAtomicDatatype
implements AtomicDatatype {
    public static XSDDouble instance = new XSDDouble();

    XSDDouble() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#double"));
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    public Object getValue(String value, String datatypeURI) {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            if (datatypeURI.equals(XSDDouble.instance.name.getName())) {
                System.err.println("Invalid xsd:double value: '" + value + "'");
                System.err.println(e);
            }
            return null;
        }
    }

    public boolean contains(Object value) {
        return value instanceof Double && super.contains(value);
    }
}

