/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseDateTimeDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.EmptyDatatype;
import org.mindswap.pellet.datatypes.XSDDerivableType;
import org.mindswap.pellet.datatypes.XSDDerivedMonthType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;

public class XSDMonth
extends BaseDateTimeDatatype
implements AtomicDatatype,
XSDDerivableType {
    public static XSDMonth instance = new XSDMonth();
    public static String dataTypeName = "gMonth";

    protected XSDMonth() {
        this(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#" + dataTypeName));
    }

    protected XSDMonth(ATermAppl name, GenericIntervalList interval) {
        super(name);
        this.comparator = new ExtendedComparatorImpl();
        this.setInterval(interval);
    }

    protected XSDMonth(ATermAppl name) {
        super(name);
        this.comparator = new ExtendedComparatorImpl();
        this.setInterval(new GenericIntervalList(this.getMinimumDate(), this.getMaximumDate(), this.comparator));
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    public Object getValue(String value, String datatypeURI) {
        return this.getValue(value, dataTypeName);
    }

    public AtomicDatatype not() {
        return instance.difference(this);
    }

    public AtomicDatatype intersection(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        GenericIntervalList result = new GenericIntervalList(this.comparator);
        if (dt instanceof XSDMonth) {
            XSDMonth other = (XSDMonth)dt;
            GenericIntervalList original = new GenericIntervalList(this.values, this.comparator);
            Iterator it = other.values.iterator();
            while (it.hasNext()) {
                GenericIntervalList.Interval interval = (GenericIntervalList.Interval)it.next();
                GenericIntervalList o = new GenericIntervalList(original, this.comparator);
                o.restrictToInterval(interval);
                result.addIntervalList(o);
            }
        }
        return new XSDDerivedMonthType(null, result);
    }

    public AtomicDatatype union(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        GenericIntervalList result = new GenericIntervalList(this.comparator);
        if (dt instanceof XSDMonth) {
            XSDMonth other = (XSDMonth)dt;
            result.addIntervalList(this.values);
            result.addIntervalList(other.values);
        }
        return new XSDDerivedMonthType(null, result);
    }

    public AtomicDatatype difference(AtomicDatatype dt) {
        if (this == dt) {
            return EmptyDatatype.instance;
        }
        GenericIntervalList result = new GenericIntervalList(this.comparator);
        if (dt instanceof XSDMonth) {
            XSDMonth other = (XSDMonth)dt;
            result.addIntervalList(this.values);
            result.removeIntervalList(other.values);
        }
        return new XSDDerivedMonthType(null, result);
    }

    public AtomicDatatype enumeration(Set enum_) {
        GenericIntervalList result = new GenericIntervalList(this.comparator);
        Iterator i = enum_.iterator();
        while (i.hasNext()) {
            Date date = (Date)i.next();
            result.addInterval(date, date);
        }
        return new XSDDerivedMonthType(null, result);
    }

    public Datatype singleton(Object value) {
        GenericIntervalList result = new GenericIntervalList(this.comparator);
        if (value instanceof Date) {
            Date date = (Date)value;
            result.addInterval(date, date);
        }
        return new XSDDerivedMonthType(null, result);
    }

    public Datatype deriveByRestriction(int facet, Object value) throws UnsupportedOperationException {
        GenericIntervalList interval = this.restrictIntervalList(facet, (String)value, dataTypeName, 2);
        if (interval != null) {
            XSDDerivedMonthType restriction = new XSDDerivedMonthType(null, interval);
            return this.intersection(restriction);
        }
        return this;
    }

    public class ExtendedComparatorImpl
    implements GenericIntervalList.ExtendedComparator {
        public int compare(Object a, Object b) {
            if (((Date)a).after((Date)b)) {
                return 1;
            }
            if (((Date)a).before((Date)b)) {
                return -1;
            }
            return 0;
        }

        public Object prev(Object value) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime((Date)value);
            if (calendar.get(2) > 0) {
                ((Calendar)calendar).add(2, -1);
            }
            return calendar.getTime();
        }

        public Object next(Object value) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime((Date)value);
            if (calendar.get(2) < 11) {
                ((Calendar)calendar).add(2, 1);
            }
            return calendar.getTime();
        }

        public long count(Object start, Object end) {
            GregorianCalendar calendarStart = new GregorianCalendar();
            calendarStart.setTime((Date)start);
            GregorianCalendar calendarEnd = new GregorianCalendar();
            calendarEnd.setTime((Date)end);
            return calendarEnd.get(2) - calendarStart.get(2) + 1;
        }
    }
}

