/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.xerces.xs.StringList;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.EmptyDatatype;
import org.mindswap.pellet.datatypes.XSDDerivableType;
import org.mindswap.pellet.datatypes.XSDDerivedTimeType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;

public class XSDTime
extends BaseDatatype
implements AtomicDatatype,
XSDDerivableType {
    public static XSDTime instance = new XSDTime();
    public static final String strMinTime = "00:00:00";
    public static final String strMaxTime = "23:59:59";
    protected GenericIntervalList values;
    protected GenericIntervalList.ExtendedComparator comparator = new ExtendedComparatorImpl();
    public SimpleDateFormat formatter;

    private XSDTime() {
        this(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#time"));
    }

    protected XSDTime(ATermAppl name, GenericIntervalList interval) {
        super(name);
        this.setInterval(interval);
    }

    protected XSDTime(ATermAppl name) {
        super(name);
        try {
            XSDatatype dt = DatatypeFactory.getTypeByName((String)"time");
            Calendar minCal = (Calendar)dt.createJavaObject(strMinTime, null);
            Calendar maxCal = (Calendar)dt.createJavaObject(strMaxTime, null);
            this.setInterval(new GenericIntervalList(minCal.getTime(), maxCal.getTime(), new ExtendedComparatorImpl()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setInterval(GenericIntervalList values) {
        this.values = values;
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    public Object getValue(String value, String datatypeURI) {
        try {
            return this.formatter.parse(value.trim());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public boolean contains(Object value) {
        if (value instanceof Date) {
            return this.values.contains((Date)value);
        }
        return false;
    }

    public AtomicDatatype not() {
        return instance.difference(this);
    }

    public AtomicDatatype intersection(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        GenericIntervalList result = new GenericIntervalList(this.comparator);
        if (dt instanceof XSDTime) {
            XSDTime other = (XSDTime)dt;
            GenericIntervalList original = new GenericIntervalList(this.values, this.comparator);
            Iterator it = other.values.iterator();
            while (it.hasNext()) {
                GenericIntervalList.Interval interval = (GenericIntervalList.Interval)it.next();
                GenericIntervalList o = new GenericIntervalList(original, this.comparator);
                o.restrictToInterval(interval);
                result.addIntervalList(o);
            }
        }
        return new XSDDerivedTimeType(null, result);
    }

    public AtomicDatatype union(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        GenericIntervalList result = new GenericIntervalList(this.comparator);
        if (dt instanceof XSDTime) {
            XSDTime other = (XSDTime)dt;
            result.addIntervalList(this.values);
            result.addIntervalList(other.values);
        }
        return new XSDDerivedTimeType(null, result);
    }

    public AtomicDatatype difference(AtomicDatatype dt) {
        if (this == dt) {
            return EmptyDatatype.instance;
        }
        GenericIntervalList result = new GenericIntervalList(this.comparator);
        if (dt instanceof XSDTime) {
            XSDTime other = (XSDTime)dt;
            result.addIntervalList(this.values);
            result.removeIntervalList(other.values);
        }
        return new XSDDerivedTimeType(null, result);
    }

    public AtomicDatatype enumeration(Set enum_) {
        GenericIntervalList result = new GenericIntervalList(this.comparator);
        Iterator i = enum_.iterator();
        while (i.hasNext()) {
            Date date = (Date)i.next();
            result.addInterval(date, date);
        }
        return new XSDDerivedTimeType(null, result);
    }

    public Datatype singleton(Object value) {
        GenericIntervalList result = new GenericIntervalList(this.comparator);
        if (value instanceof Date) {
            Date date = (Date)value;
            result.addInterval(date, date);
        }
        return new XSDDerivedTimeType(null, result);
    }

    public long size() {
        return this.values.count();
    }

    public Datatype deriveByRestriction(int facet, Object value) throws UnsupportedOperationException {
        try {
            Date max;
            Date min;
            XSDatatype dt = DatatypeFactory.getTypeByName((String)"time");
            Calendar minCalendar = new GregorianCalendar();
            minCalendar.setLenient(true);
            Calendar maxCalendar = new GregorianCalendar();
            maxCalendar.setLenient(true);
            if (facet == 256) {
                minCalendar = (Calendar)dt.createJavaObject((String)value, null);
                min = minCalendar.getTime();
                maxCalendar = (Calendar)dt.createJavaObject(strMaxTime, null);
                max = maxCalendar.getTime();
            } else if (facet == 128) {
                minCalendar = (Calendar)dt.createJavaObject((String)value, null);
                minCalendar.add(13, 1);
                min = minCalendar.getTime();
                maxCalendar = (Calendar)dt.createJavaObject(strMaxTime, null);
                max = maxCalendar.getTime();
            } else if (facet == 32) {
                minCalendar = (Calendar)dt.createJavaObject(strMinTime, null);
                min = minCalendar.getTime();
                maxCalendar = (Calendar)dt.createJavaObject((String)value, null);
                max = maxCalendar.getTime();
            } else if (facet == 64) {
                minCalendar = (Calendar)dt.createJavaObject(strMinTime, null);
                min = minCalendar.getTime();
                maxCalendar = (Calendar)dt.createJavaObject((String)value, null);
                maxCalendar.add(13, -1);
                max = maxCalendar.getTime();
            } else {
                if (facet == 2048) {
                    HashSet<Date> values = new HashSet<Date>();
                    Calendar cal = null;
                    Date min2 = minCalendar.getTime();
                    for (int i = 0; i < ((StringList)value).getLength(); ++i) {
                        cal = (Calendar)dt.createJavaObject(((StringList)value).item(i), null);
                        values.add(cal.getTime());
                    }
                    return this.intersection(this.enumeration(values));
                }
                return this;
            }
            GenericIntervalList interval = new GenericIntervalList(min, max, this.comparator);
            XSDDerivedTimeType restriction = new XSDDerivedTimeType(null, interval);
            return this.intersection(restriction);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Value " + value + " is not valid for the facet " + facet);
        }
    }

    public boolean isDerived() {
        return false;
    }

    public class ExtendedComparatorImpl
    implements GenericIntervalList.ExtendedComparator {
        public int compare(Object a, Object b) {
            if (((Date)a).after((Date)b)) {
                return 1;
            }
            if (((Date)a).before((Date)b)) {
                return -1;
            }
            return 0;
        }

        public Object prev(Object value) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setLenient(true);
            calendar.setTime((Date)value);
            ((Calendar)calendar).add(13, -1);
            return calendar.getTime();
        }

        public Object next(Object value) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setLenient(true);
            calendar.setTime((Date)value);
            ((Calendar)calendar).add(13, 1);
            return calendar.getTime();
        }

        public long count(Object start, Object end) {
            double milliElapsed = ((Date)end).getTime() - ((Date)start).getTime();
            return Math.round(milliElapsed / 1000.0);
        }
    }
}

