/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.EconnectedKB;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.FileUtils;
import org.mindswap.pellet.utils.QNameProvider;
import org.mindswap.pellet.utils.URIUtils;

public class OWLLoader {
    public static final List SKIP_PROPS = Arrays.asList(RDF.type.asNode(), RDF.first.asNode(), RDF.rest.asNode(), OWL.imports.asNode(), OWL.onProperty.asNode(), OWL.hasValue.asNode(), OWL.allValuesFrom.asNode(), OWL.someValuesFrom.asNode(), OWL.minCardinality.asNode(), OWL.maxCardinality.asNode(), OWL.cardinality.asNode());
    public static final List SKIP_TYPES = Arrays.asList(RDF.List.asNode(), OWL.Restriction.asNode(), OWL.AllDifferent.asNode(), OWL.Ontology.asNode());
    public static final Node OWL_ForeignOntology = Node.createURI((String)(OWL.NAMESPACE + "foreignOntology"));
    static final String[] TYPES = new String[]{"Class", "Individual", "Object Property", "Datatype Property", "Datatype"};
    static final int CLASS = 0;
    static final int INDIVIDUAL = 1;
    static final int OBJ_PROP = 2;
    static final int DT_PROP = 4;
    static final int ANT_PROP = 8;
    static final int ONT_PROP = 15;
    static final int DATATYPE = 16;
    static final int LINK_PROP = 18;
    public static QNameProvider qnames = new QNameProvider();
    private KnowledgeBase kb;
    private Graph graph;
    private Map terms;
    private Map lists;
    private Map restrictions;
    private Map resourceLinkTypes;
    private List linkedOntologies;

    public OWLLoader() {
        this.clear();
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void clear() {
        this.terms = new HashMap();
        this.terms.put(OWL.Thing.asNode(), ATermUtils.TOP);
        this.terms.put(OWL.Nothing.asNode(), ATermUtils.BOTTOM);
        this.lists = new HashMap();
        this.restrictions = new HashMap();
        this.resourceLinkTypes = new HashMap();
    }

    private Node getObject(Node subj, Node pred) {
        ExtendedIterator all = this.graph.find(subj, pred, null);
        if (all.hasNext()) {
            Triple triple = (Triple)all.next();
            return triple.getObject();
        }
        return null;
    }

    private boolean hasObject(Node subj, Node pred) {
        return this.graph.find(subj, pred, null).hasNext();
    }

    public ATermList createList(Node node) {
        if (node.equals((Object)RDF.nil.asNode())) {
            return ATermUtils.EMPTY_LIST;
        }
        if (this.lists.containsKey(node)) {
            return (ATermList)this.lists.get(node);
        }
        Node first = this.getObject(node, RDF.first.asNode());
        Node rest = this.getObject(node, RDF.rest.asNode());
        if (first == null || rest == null) {
            System.err.println("Invalid list structure: List " + node + " does not have a " + (first == null ? "rdf:first" : "rdf:rest") + " property. Ignoring rest of the list.");
            return ATermUtils.EMPTY_LIST;
        }
        ATermList list = ATermUtils.makeList((ATerm)this.node2term(first), this.createList(rest));
        this.lists.put(node, list);
        return list;
    }

    public ATermAppl createRestriction(Node node) throws UnsupportedFeatureException {
        ATermAppl aTerm = ATermUtils.TOP;
        Node p = this.getObject(node, OWL.onProperty.asNode());
        if (p == null) {
            return aTerm;
        }
        ATermAppl pt = this.node2term(p);
        Node o = null;
        o = this.getObject(node, OWL.hasValue.asNode());
        if (o != null) {
            ATermAppl ot = this.node2term(o);
            if (o.isLiteral()) {
                this.defineDatatypeProperty(pt);
            } else {
                this.defineObjectProperty(pt);
            }
            aTerm = ATermUtils.makeHasValue((ATerm)pt, (ATerm)ot);
        } else {
            o = this.getObject(node, OWL.allValuesFrom.asNode());
            if (o != null) {
                ATermAppl ot = this.node2term(o);
                if (this.kb.isClass((ATerm)ot)) {
                    this.defineObjectProperty(pt);
                } else if (this.kb.isDatatype(ot)) {
                    this.defineDatatypeProperty(pt);
                }
                aTerm = ATermUtils.makeAllValues((ATerm)pt, (ATerm)ot);
            } else {
                o = this.getObject(node, OWL.someValuesFrom.asNode());
                if (o != null) {
                    ATermAppl ot = this.node2term(o);
                    if (this.kb.isClass((ATerm)ot)) {
                        this.defineObjectProperty(pt);
                    } else if (this.kb.isDatatype(ot)) {
                        this.defineDatatypeProperty(pt);
                    }
                    aTerm = ATermUtils.makeSomeValues((ATerm)pt, (ATerm)ot);
                } else {
                    o = this.getObject(node, OWL.minCardinality.asNode());
                    if (o != null) {
                        try {
                            int cardinality = Integer.parseInt(o.getLiteral().getLexicalForm());
                            aTerm = ATermUtils.makeMin((ATerm)pt, cardinality);
                        }
                        catch (Exception ex) {}
                    } else {
                        o = this.getObject(node, OWL.maxCardinality.asNode());
                        if (o != null) {
                            try {
                                int cardinality = Integer.parseInt(o.getLiteral().getLexicalForm());
                                aTerm = ATermUtils.makeMax((ATerm)pt, cardinality);
                            }
                            catch (Exception ex) {}
                        } else {
                            o = this.getObject(node, OWL.cardinality.asNode());
                            if (o != null) {
                                try {
                                    int cardinality = Integer.parseInt(o.getLiteral().getLexicalForm());
                                    aTerm = ATermUtils.makeCard((ATerm)pt, cardinality);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
        }
        return aTerm;
    }

    public ATermAppl node2term(Node node) {
        ATermAppl aTerm = (ATermAppl)this.terms.get(node);
        if (aTerm == null) {
            if (node.isLiteral()) {
                LiteralLabel label = node.getLiteral();
                String value = label.getLexicalForm();
                String datatypeURI = label.getDatatypeURI();
                String lang = label.language();
                aTerm = datatypeURI != null ? ATermUtils.makeTypedLiteral(value, datatypeURI) : ATermUtils.makePlainLiteral(value, lang);
            } else if (this.hasObject(node, OWL.onProperty.asNode())) {
                aTerm = this.createRestriction(node);
                this.restrictions.put(node, aTerm);
            } else if (node.isBlank()) {
                Node o = null;
                o = this.getObject(node, OWL.intersectionOf.asNode());
                if (o != null) {
                    ATermList list = this.createList(o);
                    aTerm = ATermUtils.makeAnd(list);
                } else {
                    o = this.getObject(node, OWL.unionOf.asNode());
                    if (o != null) {
                        ATermList list = this.createList(o);
                        aTerm = ATermUtils.makeOr(list);
                    } else {
                        o = this.getObject(node, OWL.oneOf.asNode());
                        if (o != null) {
                            ATermList list = this.createList(o);
                            ATermList result = ATermUtils.EMPTY_LIST;
                            ATermList l = list;
                            while (!l.isEmpty()) {
                                ATermAppl c = (ATermAppl)l.getFirst();
                                ATermAppl nominal = ATermUtils.makeValue((ATerm)c);
                                result = result.insert((ATerm)nominal);
                                l = l.getNext();
                            }
                            aTerm = ATermUtils.makeOr(result);
                        } else {
                            o = this.getObject(node, OWL.complementOf.asNode());
                            if (o != null) {
                                ATermAppl complement = this.node2term(o);
                                aTerm = ATermUtils.makeNot((ATerm)complement);
                            } else {
                                String bNode = "bNode" + node.getBlankNodeId();
                                aTerm = ATermUtils.makeTermAppl(bNode);
                            }
                        }
                    }
                }
            } else {
                String uri = node.getURI();
                aTerm = PelletOptions.USE_LOCAL_NAME ? (uri.startsWith("http://www.w3.org/2001/XMLSchema#") ? ATermUtils.makeTermAppl(uri) : ATermUtils.makeTermAppl(URIUtils.getLocalName(uri))) : (PelletOptions.USE_QNAME ? (uri.startsWith("http://www.w3.org/2001/XMLSchema#") ? ATermUtils.makeTermAppl(uri) : ATermUtils.makeTermAppl(qnames.shortForm(uri))) : ATermUtils.makeTermAppl(uri));
            }
            this.terms.put(node, aTerm);
        }
        return aTerm;
    }

    private boolean defineClass(ATermAppl c) {
        if (ATermUtils.isPrimitive(c)) {
            this.kb.addClass((ATerm)c);
            return true;
        }
        return this.kb.isClass((ATerm)c);
    }

    private boolean defineForeignClass(ATermAppl c) {
        Integer type = (Integer)this.resourceLinkTypes.get(c);
        type = type == null ? new Integer(0) : new Integer(type | 0);
        this.resourceLinkTypes.put(c, type);
        if (this.kb.isClass((ATerm)c)) {
            return true;
        }
        return ATermUtils.isPrimitive(c);
    }

    private boolean defineForeignObjectProperty(ATermAppl c) {
        Integer type = (Integer)this.resourceLinkTypes.get(c);
        type = type == null ? new Integer(2) : new Integer(type | 2);
        this.resourceLinkTypes.put(c, type);
        if (((EconnectedKB)this.kb).isObjectProperty((ATerm)c)) {
            return true;
        }
        return ATermUtils.isPrimitive(c);
    }

    private boolean defineForeignLinkProperty(ATermAppl c) {
        Integer type = (Integer)this.resourceLinkTypes.get(c);
        type = type == null ? new Integer(2) : new Integer((int)(type | 0x12));
        this.resourceLinkTypes.put(c, type);
        if (((EconnectedKB)this.kb).isProperty((ATerm)c)) {
            return true;
        }
        return ATermUtils.isPrimitive(c);
    }

    private boolean defineForeignDatatypeProperty(ATermAppl c) {
        Integer type = (Integer)this.resourceLinkTypes.get(c);
        type = type == null ? new Integer(4) : new Integer(type | 4);
        this.resourceLinkTypes.put(c, type);
        if (((EconnectedKB)this.kb).isDatatypeProperty((ATerm)c)) {
            return true;
        }
        return ATermUtils.isPrimitive(c);
    }

    private boolean defineDatatype(ATermAppl datatypeURI) {
        this.kb.addDatatype((ATerm)datatypeURI);
        return true;
    }

    private boolean loadDatatype(ATermAppl datatypeURI) {
        this.kb.loadDatatype((ATerm)datatypeURI);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean defineProperties(ATermAppl p1, ATermAppl p2) {
        int type2;
        int type1 = this.kb.getPropertyType((ATerm)p1);
        if (type1 != (type2 = this.kb.getPropertyType((ATerm)p2))) {
            if (type1 == 0) {
                if (type2 == 1) {
                    this.defineObjectProperty(p1);
                    return true;
                } else {
                    if (type2 != 2) return true;
                    this.defineDatatypeProperty(p1);
                }
                return true;
            } else {
                if (type2 != 0) return false;
                if (type1 == 1) {
                    this.defineObjectProperty(p2);
                    return true;
                } else {
                    if (type1 != 2) return true;
                    this.defineDatatypeProperty(p2);
                }
            }
            return true;
        } else {
            if (type1 != 0) return true;
            this.defineProperty(p1);
            this.defineProperty(p2);
        }
        return true;
    }

    private boolean defineObjectProperty(ATermAppl c) {
        if (!ATermUtils.isPrimitive(c)) {
            return false;
        }
        return this.kb.addObjectProperty((ATerm)c);
    }

    private boolean defineDatatypeProperty(ATermAppl c) {
        if (!ATermUtils.isPrimitive(c)) {
            return false;
        }
        return this.kb.addDatatypeProperty((ATerm)c);
    }

    private boolean defineAnnotationProperty(ATermAppl c) {
        if (!ATermUtils.isPrimitive(c)) {
            return false;
        }
        this.kb.addAnnotationProperty(c);
        return true;
    }

    private boolean defineOntologyProperty(ATermAppl c) {
        if (!ATermUtils.isPrimitive(c)) {
            return false;
        }
        this.kb.addOntologyProperty(c);
        return true;
    }

    private boolean defineProperty(ATermAppl c) {
        if (!ATermUtils.isPrimitive(c)) {
            return false;
        }
        this.kb.addProperty(c);
        return true;
    }

    private boolean defineIndividual(ATermAppl c) {
        if (!ATermUtils.isPrimitive(c)) {
            return false;
        }
        this.kb.addIndividual(c);
        return true;
    }

    private void processTypes(Graph model) throws UnsupportedFeatureException {
        ExtendedIterator i = model.find(null, RDF.type.asNode(), null);
        while (i.hasNext()) {
            Triple stmt = (Triple)i.next();
            Node o = stmt.getObject();
            if (SKIP_TYPES.contains(o)) continue;
            Node s = stmt.getSubject();
            ATermAppl st = this.node2term(s);
            String nameSpace = "";
            String localName = null;
            if (o.isURI()) {
                nameSpace = o.getNameSpace();
                if (nameSpace == null) {
                    nameSpace = "";
                }
                localName = o.getLocalName();
            }
            if (o.equals((Object)RDF.Nodes.Property)) {
                this.defineProperty(st);
                continue;
            }
            if (nameSpace.equals("http://www.w3.org/2000/01/rdf-schema#")) {
                if (localName.equals("Class")) {
                    this.defineClass(st);
                    continue;
                }
                if (localName.equals("Datatype")) {
                    this.loadDatatype(st);
                    continue;
                }
                System.err.println("Warning skipping invalid RDF-S term " + o);
                continue;
            }
            if (nameSpace.equals("http://www.w3.org/2002/07/owl#")) {
                if (localName.equals("Class")) {
                    this.defineClass(st);
                    continue;
                }
                if (localName.equals("Thing")) {
                    this.defineIndividual(st);
                    continue;
                }
                if (localName.equals("Nothing")) {
                    this.defineIndividual(st);
                    this.kb.addType(st, ATermUtils.BOTTOM);
                    continue;
                }
                if (localName.equals("ObjectProperty")) {
                    this.defineObjectProperty(st);
                    continue;
                }
                if (localName.equals("DatatypeProperty")) {
                    this.defineDatatypeProperty(st);
                    continue;
                }
                if (localName.equals("FunctionalProperty")) {
                    this.defineProperty(st);
                    this.kb.addFunctionalProperty(st);
                    continue;
                }
                if (localName.equals("InverseFunctionalProperty")) {
                    if (this.defineObjectProperty(st)) {
                        this.kb.addInverseFunctionalProperty((ATerm)st);
                        continue;
                    }
                    System.err.println("Ignoring InverseFunctionalProperty axiom for " + st + " (" + Role.TYPES[this.kb.getPropertyType((ATerm)st)] + "Property)");
                    continue;
                }
                if (localName.equals("TransitiveProperty")) {
                    if (this.defineObjectProperty(st)) {
                        this.kb.addTransitiveProperty(st);
                        if (!(this.kb instanceof EconnectedKB)) continue;
                        ((EconnectedKB)this.kb).getEconnExpressivity().setHasTransitivity(this.kb.getOntology());
                        continue;
                    }
                    System.err.println("Ignoring TransitiveProperty axiom for " + st + " (" + Role.TYPES[this.kb.getPropertyType((ATerm)st)] + "Property)");
                    continue;
                }
                if (localName.equals("SymmetricProperty")) {
                    if (this.defineObjectProperty(st)) {
                        this.kb.addSymmetricProperty(st);
                        continue;
                    }
                    System.err.println("Ignoring SymmetricProperty axiom for " + st + " (" + Role.TYPES[this.kb.getPropertyType((ATerm)st)] + "Property)");
                    continue;
                }
                if (localName.equals("AnnotationProperty")) {
                    this.kb.addAnnotationProperty(st);
                    continue;
                }
                if (localName.equals("DataRange")) {
                    Node dataValuesR = this.getObject(s, OWL.oneOf.asNode());
                    ATermList list = this.createList(dataValuesR);
                    if (s.isBlank()) {
                        this.kb.addDataRange("bNode" + s.toString(), list);
                        continue;
                    }
                    this.kb.addDataRange(s.toString(), list);
                    continue;
                }
                if (this.kb instanceof EconnectedKB) {
                    EconnectedKB econnKB = (EconnectedKB)this.kb;
                    if (localName.equals("LinkProperty")) {
                        econnKB.addLinkProperty((ATerm)st);
                        continue;
                    }
                    if (localName.equals("ForeignIndividual")) {
                        econnKB.addIndividual(st);
                        continue;
                    }
                    if (localName.equals("ForeignClass")) {
                        this.defineForeignClass(st);
                        continue;
                    }
                    if (localName.equals("ForeignObjectProperty")) {
                        this.defineForeignObjectProperty(st);
                        continue;
                    }
                    if (localName.equals("ForeignDatatypeProperty")) {
                        this.defineForeignDatatypeProperty(st);
                        continue;
                    }
                    if (!localName.equals("ForeignLinkProperty")) continue;
                    this.defineForeignLinkProperty(st);
                    continue;
                }
                System.err.println("Warning skipping invalid OWL term " + o);
                continue;
            }
            ATermAppl ot = this.node2term(o);
            this.defineIndividual(st);
            this.defineClass(ot);
            this.kb.addType(st, ot);
        }
    }

    private void processLinkTriples(Graph graph) throws UnsupportedFeatureException {
        ExtendedIterator i = graph.find((TripleMatch)Triple.ANY);
        while (i.hasNext()) {
            Triple stmt = (Triple)i.next();
            Node s = stmt.getSubject();
            Node p = stmt.getPredicate();
            Node o = stmt.getObject();
            ATermAppl st = this.node2term(s);
            if (p.equals((Object)RDF.type.asNode()) || !p.equals((Object)OWL_ForeignOntology)) continue;
            String foreignOnt = o.getURI();
            String ont = ((EconnectedKB)this.kb).getOntology();
            if (!(this.kb instanceof EconnectedKB)) continue;
            Role r = this.kb.getProperty((ATerm)st);
            if (r != null) {
                r.setForeignOntology(foreignOnt);
                if (this.linkedOntologies.contains(foreignOnt)) continue;
                this.linkedOntologies.add(foreignOnt);
                continue;
            }
            if (this.resourceLinkTypes.containsKey(st)) {
                if (!((EconnectedKB)this.kb).getTBoxes().keySet().contains(foreignOnt)) {
                    ((EconnectedKB)this.kb).addOntology(foreignOnt);
                }
                ((EconnectedKB)this.kb).setOntology(foreignOnt);
                if (!((EconnectedKB)this.kb).isClass((ATerm)st) && ATermUtils.isPrimitive(st) && (Integer)this.resourceLinkTypes.get(st) == 0) {
                    this.kb.addClass((ATerm)st);
                    if (KnowledgeBase.DEBUG) {
                        System.out.println("Added Foreign Class" + st + "To ontology" + this.kb.getOntology());
                    }
                }
                if (!((EconnectedKB)this.kb).isProperty((ATerm)st) && ATermUtils.isPrimitive(st)) {
                    if ((Integer)this.resourceLinkTypes.get(st) == 2) {
                        this.kb.addObjectProperty((ATerm)st);
                        if (KnowledgeBase.DEBUG) {
                            System.out.println("Added Foreign Object Property" + st + "To ontology" + this.kb.getOntology());
                        }
                    }
                    if ((Integer)this.resourceLinkTypes.get(st) == 4) {
                        this.kb.addDatatypeProperty((ATerm)st);
                        if (KnowledgeBase.DEBUG) {
                            System.out.println("Added Foreign Datatype Property" + st + "To ontology" + this.kb.getOntology());
                        }
                    }
                    if ((Integer)this.resourceLinkTypes.get(st) == 18) {
                        ((EconnectedKB)this.kb).addLinkProperty((ATerm)st);
                        if (KnowledgeBase.DEBUG) {
                            System.out.println("Added Foreign Link Property" + st + "To ontology" + this.kb.getOntology());
                        }
                    }
                }
                ((EconnectedKB)this.kb).setOntology(ont);
                continue;
            }
            Individual aux = this.kb.getABox().getIndividual((ATerm)st);
            aux.setOntology(foreignOnt);
            ((EconnectedKB)this.kb).getEconnExpressivity().setHasNominal(foreignOnt);
        }
    }

    private void processTriples(Graph graph) throws UnsupportedFeatureException {
        ExtendedIterator i = graph.find((TripleMatch)Triple.ANY);
        while (i.hasNext()) {
            Triple triple = (Triple)i.next();
            Node p = triple.getPredicate();
            if (SKIP_PROPS.contains(p)) continue;
            Node s = triple.getSubject();
            Node o = triple.getObject();
            String nameSpace = p.getNameSpace();
            String localName = p.getLocalName();
            if (nameSpace == null) {
                nameSpace = "";
            }
            ATermAppl st = this.node2term(s);
            ATermAppl ot = this.node2term(o);
            if (nameSpace.equals("http://www.w3.org/2000/01/rdf-schema#")) {
                if (localName.equals("subClassOf")) {
                    this.defineClass(st);
                    this.defineClass(ot);
                    this.kb.addSubClass(st, ot);
                    continue;
                }
                if (localName.equals("subPropertyOf")) {
                    if (this.defineProperties(st, ot)) {
                        this.kb.addSubProperty(st, ot);
                        continue;
                    }
                    System.err.println("Ignoring subproperty axiom between " + st + " (" + Role.TYPES[this.kb.getPropertyType((ATerm)st)] + "Property) and " + ot + " (" + Role.TYPES[this.kb.getPropertyType((ATerm)ot)] + "Property)");
                    continue;
                }
                if (localName.equals("domain")) {
                    this.defineProperty(st);
                    this.defineClass(ot);
                    this.kb.addDomain((ATerm)st, ot);
                    continue;
                }
                if (!localName.equals("range")) continue;
                if (this.kb.isDatatype(ot)) {
                    this.defineDatatypeProperty(st);
                } else if (this.kb.isClass((ATerm)ot)) {
                    this.defineObjectProperty(st);
                } else {
                    this.defineProperty(st);
                }
                if (this.kb.isDatatypeProperty((ATerm)st)) {
                    this.defineDatatype(ot);
                } else if (this.kb.isObjectProperty((ATerm)st)) {
                    this.defineClass(ot);
                }
                this.kb.addRange((ATerm)st, ot);
                continue;
            }
            if (nameSpace.equals("http://www.w3.org/2002/07/owl#")) {
                ATermList result;
                ATermAppl disjunction;
                ATermList l;
                ATermList list;
                if (localName.equals("intersectionOf")) {
                    l = list = this.createList(o);
                    while (!l.isEmpty()) {
                        ATermAppl c = (ATermAppl)l.getFirst();
                        if (!this.resourceLinkTypes.containsKey(c)) {
                            this.defineClass(c);
                        }
                        l = l.getNext();
                    }
                    this.defineClass(st);
                    ATermAppl conjunction = ATermUtils.makeAnd(list);
                    this.kb.addSameClass(st, conjunction);
                    continue;
                }
                if (localName.equals("unionOf")) {
                    l = list = this.createList(o);
                    while (!l.isEmpty()) {
                        ATermAppl c = (ATermAppl)l.getFirst();
                        if (!this.resourceLinkTypes.containsKey(c)) {
                            this.defineClass(c);
                        }
                        l = l.getNext();
                    }
                    this.defineClass(st);
                    disjunction = ATermUtils.makeOr(list);
                    this.kb.addSameClass(st, disjunction);
                    if (!(this.kb instanceof EconnectedKB)) continue;
                    ((EconnectedKB)this.kb).getEconnExpressivity().setHasUnion(this.kb.getOntology());
                    continue;
                }
                if (localName.equals("complementOf")) {
                    if (!this.resourceLinkTypes.containsKey(st)) {
                        this.defineClass(st);
                    }
                    if (!this.resourceLinkTypes.containsKey(st)) {
                        this.defineClass(ot);
                    }
                    if (this.kb instanceof EconnectedKB) {
                        ((EconnectedKB)this.kb).getEconnExpressivity().setHasNegation(this.kb.getOntology());
                    }
                    this.kb.addComplementClass((ATerm)st, (ATerm)ot);
                    continue;
                }
                if (localName.equals("equivalentClass")) {
                    this.defineClass(st);
                    this.defineClass(ot);
                    this.kb.addSameClass(st, ot);
                    continue;
                }
                if (localName.equals("disjointWith")) {
                    this.defineClass(st);
                    this.defineClass(ot);
                    this.kb.addDisjointClass((ATerm)st, (ATerm)ot);
                    if (!(this.kb instanceof EconnectedKB)) continue;
                    ((EconnectedKB)this.kb).getEconnExpressivity().setHasNegation(this.kb.getOntology());
                    continue;
                }
                if (localName.equals("equivalentProperty")) {
                    if (this.defineProperties(st, ot)) {
                        this.kb.addSameProperty(st, ot);
                        continue;
                    }
                    System.err.println("Ignoring equivalent property axiom between " + st + " (" + Role.TYPES[this.kb.getPropertyType((ATerm)st)] + "Property) and " + ot + " (" + Role.TYPES[this.kb.getPropertyType((ATerm)ot)] + "Property)");
                    continue;
                }
                if (localName.equals("inverseOf")) {
                    if (this.kb instanceof EconnectedKB) {
                        Role r;
                        EconnectedKB econnKB = (EconnectedKB)this.kb;
                        if (!econnKB.isLinkProperty((ATerm)st)) continue;
                        Role ro = this.kb.getProperty((ATerm)st);
                        String ont = econnKB.getOntology();
                        String foreign = ro.getForeignOntology();
                        if (!econnKB.getTBoxes().keySet().contains(foreign)) {
                            econnKB.addOntology(foreign);
                        }
                        econnKB.setOntology(foreign);
                        if (!econnKB.getRBox().isRole((ATerm)ot)) {
                            econnKB.addLinkProperty((ATerm)ot);
                        }
                        if ((r = this.kb.getProperty((ATerm)ot)) != null) {
                            r.setForeignOntology(ont);
                        }
                        econnKB.setOntology(ont);
                        econnKB.addInverseLink(ro, r);
                        continue;
                    }
                    if (this.defineObjectProperty(st) && this.defineObjectProperty(ot)) {
                        this.kb.addInverseProperty(st, ot);
                        continue;
                    }
                    System.err.println("Ignoring inverseOf axiom between " + st + " (" + Role.TYPES[this.kb.getPropertyType((ATerm)st)] + "Property) and " + ot + " (" + Role.TYPES[this.kb.getPropertyType((ATerm)ot)] + "Property)");
                    continue;
                }
                if (localName.equals("sameAs")) {
                    if (this.defineIndividual(st) && this.defineIndividual(ot)) {
                        this.kb.addSame(st, ot);
                        continue;
                    }
                    System.err.println("Ignoring sameAs axiom between " + st + " and " + ot);
                    continue;
                }
                if (localName.equals("differentFrom")) {
                    if (this.defineIndividual(st) && this.defineIndividual(ot)) {
                        this.kb.addDifferent(st, ot);
                        continue;
                    }
                    System.err.println("Ignoring differentFrom axiom between " + st + " and " + ot);
                    continue;
                }
                if (localName.equals("distinctMembers")) {
                    ATermList list2;
                    result = new ArrayList();
                    ATermList l2 = list2 = this.createList(o);
                    while (!l2.isEmpty()) {
                        ATermAppl c = (ATermAppl)l2.getFirst();
                        this.defineIndividual(c);
                        result.add(c);
                        l2 = l2.getNext();
                    }
                    for (int k = 0; k < result.size(); ++k) {
                        for (int j = k + 1; j < result.size(); ++j) {
                            this.kb.addDifferent((ATermAppl)result.get(k), (ATermAppl)result.get(j));
                        }
                    }
                    continue;
                }
                if (!localName.equals("oneOf")) continue;
                result = ATermUtils.EMPTY_LIST;
                if (this.kb.isDatatype(st)) continue;
                this.defineClass(st);
                disjunction = null;
                ATermList list3 = this.createList(o);
                if (o.equals((Object)RDF.nil) || list3 == null) {
                    disjunction = ATermUtils.BOTTOM;
                } else {
                    ATermList l3 = list3;
                    while (!l3.isEmpty()) {
                        ATermAppl c = (ATermAppl)l3.getFirst();
                        this.defineIndividual(c);
                        if (this.kb instanceof EconnectedKB) {
                            ((EconnectedKB)this.kb).getEconnExpressivity().allNominals.add(ot);
                        }
                        result = result.insert((ATerm)ATermUtils.makeValue((ATerm)c));
                        l3 = l3.getNext();
                    }
                    disjunction = ATermUtils.makeOr(result);
                }
                this.kb.addSameClass(st, disjunction);
                continue;
            }
            ATermAppl pt = this.node2term(p);
            Role role = this.kb.getProperty((ATerm)pt);
            int type = role == null ? 0 : role.getType();
            if (type == 3) continue;
            if (o.isLiteral()) {
                if (this.defineDatatypeProperty(pt)) {
                    String datatypeURI = ((ATermAppl)ot.getArgument(2)).getName();
                    this.defineIndividual(st);
                    this.defineDatatypeProperty(pt);
                    if (!datatypeURI.equals("")) {
                        this.defineDatatype(ATermUtils.makeTermAppl(datatypeURI));
                    }
                    this.kb.addPropertyValue(pt, st, ot);
                    continue;
                }
                System.err.println("Ignoring literal value used with ObjectProperty : " + triple);
                continue;
            }
            if (this.defineObjectProperty(pt)) {
                this.defineIndividual(st);
                this.defineIndividual(ot);
                this.kb.addPropertyValue(pt, st, ot);
                continue;
            }
            System.err.println("Ignoring object value used with DatatypeProperty: " + triple);
        }
    }

    private void processUntypedResources() {
        Iterator<Object> i = this.restrictions.keySet().iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            Node o = null;
            o = this.getObject(node, OWL.onProperty.asNode());
            if (o != null) {
                ATermAppl prop = this.node2term(o);
                this.defineProperty(prop);
                if (this.kb.isDatatypeProperty((ATerm)prop)) {
                    o = this.getObject(node, OWL.someValuesFrom.asNode());
                    if (o != null) {
                        this.defineDatatype(this.node2term(o));
                    } else {
                        o = this.getObject(node, OWL.allValuesFrom.asNode());
                        if (o != null) {
                            this.defineDatatype(this.node2term(o));
                        }
                    }
                }
            }
            if ((o = this.getObject(node, OWL.hasValue.asNode())) != null && !o.isLiteral()) {
                this.defineIndividual(this.node2term(o));
            }
            if (!(this.kb instanceof EconnectedKB)) continue;
            EconnectedKB econnKB = (EconnectedKB)this.kb;
            if (!this.hasObject(node, OWL.minCardinality.asNode()) && !this.hasObject(node, OWL.maxCardinality.asNode()) && !this.hasObject(node, OWL.cardinality.asNode())) continue;
            econnKB.getNumberRestrictions().add(this.restrictions.get(node));
        }
        i = new ArrayList(this.kb.getProperties()).iterator();
        while (i.hasNext()) {
            ATermAppl r = (ATermAppl)i.next();
            if (this.kb.getPropertyType((ATerm)r) != 0) continue;
            this.defineObjectProperty(r);
        }
    }

    public void load(String ont, EconnectedKB kb) {
        this.load(ont, kb, new ModelReader());
    }

    public void load(String ont, EconnectedKB kb, ModelReader reader) {
        this.linkedOntologies = new ArrayList();
        this.linkedOntologies.add(ont);
        for (int i = 0; i < this.linkedOntologies.size(); ++i) {
            String currOnt = (String)this.linkedOntologies.get(i);
            currOnt = FileUtils.toURI(currOnt);
            Graph graph = reader.read(currOnt).getGraph();
            if (!kb.getTBoxes().keySet().contains(currOnt)) {
                kb.addOntology(currOnt);
            }
            kb.setOntology(currOnt);
            this.load(graph, (KnowledgeBase)kb);
        }
    }

    private void setKB(KnowledgeBase kb) {
        this.kb = kb;
    }

    public void load(Graph graph, KnowledgeBase kb) throws UnsupportedFeatureException {
        this.clear();
        this.setGraph(graph);
        this.setKB(kb);
        this.resourceLinkTypes = new HashMap();
        this.defineAnnotationProperty(this.node2term(RDFS.label.asNode()));
        this.defineAnnotationProperty(this.node2term(RDFS.comment.asNode()));
        this.defineAnnotationProperty(this.node2term(RDFS.seeAlso.asNode()));
        this.defineAnnotationProperty(this.node2term(RDFS.isDefinedBy.asNode()));
        this.defineAnnotationProperty(this.node2term(OWL.versionInfo.asNode()));
        this.defineAnnotationProperty(this.node2term(DC.title.asNode()));
        this.defineAnnotationProperty(this.node2term(DC.description.asNode()));
        this.defineOntologyProperty(this.node2term(OWL.backwardCompatibleWith.asNode()));
        this.defineOntologyProperty(this.node2term(OWL.priorVersion.asNode()));
        this.defineOntologyProperty(this.node2term(OWL.incompatibleWith.asNode()));
        this.processTypes(graph);
        if (kb instanceof EconnectedKB) {
            this.processLinkTriples(graph);
        }
        this.processTriples(graph);
        this.processUntypedResources();
    }
}

